/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ikv;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jetbrains.ikv.RecSplitSettings;
import org.jetbrains.ikv.UniversalHash;

public final class RecSplitEvaluator<T> {
    private final RecSplitSettings settings;
    private final UniversalHash<T> hash;
    private final long[] indexes;
    private final int bucketCount;
    private final int[] indexStarts;
    private final int[] entryOffsets;

    public RecSplitEvaluator(ByteBuffer buffer, UniversalHash<T> hash) {
        this(buffer, hash, RecSplitSettings.DEFAULT_SETTINGS);
    }

    public RecSplitEvaluator(ByteBuffer buffer, UniversalHash<T> hash, RecSplitSettings settings) {
        this.settings = settings;
        this.hash = hash;
        int averageBucketSize = buffer.getShort() & 0xFFFF;
        IntBuffer intBuffer = buffer.asIntBuffer();
        this.indexStarts = new int[intBuffer.get()];
        this.entryOffsets = new int[this.indexStarts.length + 1];
        int indexTotalCount = intBuffer.get();
        intBuffer.get(this.indexStarts);
        intBuffer.get(this.entryOffsets);
        buffer.position(buffer.position() + intBuffer.position() * 4);
        this.indexes = new long[indexTotalCount];
        buffer.asLongBuffer().get(this.indexes);
        buffer.position(buffer.position() + this.indexes.length * 8);
        assert (!buffer.hasRemaining());
        this.bucketCount = RecSplitSettings.getBucketCount(this.entryOffsets[this.entryOffsets.length - 1], averageBucketSize);
    }

    public int evaluate(T obj) {
        return this.evaluate(obj, this.hash.universalHash(obj, 0L), this.hash);
    }

    public <K> int evaluate(K obj, long hashCode, UniversalHash<K> hash) {
        int bucketIndex = this.bucketCount == 1 ? 0 : RecSplitSettings.reduce(hashCode, this.bucketCount);
        int offset = this.entryOffsets[bucketIndex];
        int offsetNext = this.entryOffsets[bucketIndex + 1];
        int bucketSize = offsetNext - offset;
        int startPos = this.indexStarts[bucketIndex];
        return this.evaluate(startPos, obj, hashCode, offset, bucketSize, hash);
    }

    private int skip(int indexPosition, int keyCount) {
        int otherPart;
        int firstPart;
        if (keyCount < 2) {
            return indexPosition;
        }
        if (keyCount <= this.settings.getLeafSize()) {
            return indexPosition + 1;
        }
        ++indexPosition;
        int split = this.settings.getSplit(keyCount);
        if (split < 0) {
            firstPart = -split;
            otherPart = keyCount - firstPart;
            split = 2;
        } else {
            otherPart = firstPart = keyCount / split;
        }
        int s = firstPart;
        for (int i = 0; i < split; ++i) {
            indexPosition = this.skip(indexPosition, s);
            s = otherPart;
        }
        return indexPosition;
    }

    private <K> int evaluate(int indexPosition, K obj, long hashCode, int add, int size, UniversalHash<K> hash) {
        long prevIndex = -1L;
        while (size >= 2) {
            int otherPart;
            int firstPart;
            long currentIndex = this.indexes[indexPosition];
            if (prevIndex == -1L) {
                prevIndex = currentIndex;
            } else {
                long oldX = RecSplitSettings.getUniversalHashIndex(prevIndex);
                prevIndex = currentIndex;
                long x = RecSplitSettings.getUniversalHashIndex(currentIndex);
                if (x != oldX) {
                    hashCode = hash.universalHash(obj, x);
                }
            }
            if (size <= this.settings.getLeafSize()) {
                int h = RecSplitSettings.reduce(RecSplitSettings.supplementalHash(hashCode, prevIndex), size);
                return add + h;
            }
            int split = this.settings.getSplit(size);
            if (split < 0) {
                firstPart = -split;
                otherPart = size - firstPart;
                split = 2;
            } else {
                otherPart = firstPart = size / split;
            }
            long sH = RecSplitSettings.supplementalHash(hashCode, prevIndex);
            if (firstPart != otherPart) {
                if (RecSplitSettings.reduce(sH, size) < firstPart) {
                    size = firstPart;
                    ++indexPosition;
                    continue;
                }
                indexPosition = this.skip(indexPosition, firstPart);
                ++indexPosition;
                add += firstPart;
                size = otherPart;
                continue;
            }
            int h = RecSplitSettings.reduce(sH, split);
            for (int i = 0; i < h; ++i) {
                indexPosition = this.skip(indexPosition, firstPart);
                add += firstPart;
            }
            ++indexPosition;
            size = firstPart;
        }
        return add;
    }
}

