/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.CancellationCallable;
import com.intellij.openapi.progress.CancellationFutureTask;
import com.intellij.openapi.progress.CancellationRunnable;
import com.intellij.openapi.progress.PeriodicCancellationRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.SchedulingWrapper;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class Propagation {
    @TestOnly
    static void runTestWithPropagationEnabled(@NotNull Runnable runnable) {
        if (runnable == null) {
            Propagation.$$$reportNull$$$0(0);
        }
        boolean propagateThreadContext = Holder.propagateThreadContext;
        boolean propagateThreadCancellation = Holder.propagateThreadCancellation;
        Holder.propagateThreadContext = true;
        Holder.propagateThreadCancellation = true;
        try {
            runnable.run();
        }
        finally {
            Holder.propagateThreadContext = propagateThreadContext;
            Holder.propagateThreadCancellation = propagateThreadCancellation;
        }
    }

    private Propagation() {
    }

    static boolean propagateThreadContext() {
        return Holder.propagateThreadContext;
    }

    public static boolean propagateCancellation() {
        return Holder.propagateThreadCancellation;
    }

    @NotNull
    static Runnable handleCommand(@NotNull Runnable command) {
        if (command == null) {
            Propagation.$$$reportNull$$$0(1);
        }
        if (Propagation.propagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableJob childJob = JobKt.Job((Job)currentJob);
            return Propagation.handleContext(new CancellationRunnable(childJob, command));
        }
        return Propagation.handleContext(command);
    }

    @NotNull
    static <V> FutureTask<V> handleTask(@NotNull Callable<V> callable) {
        if (callable == null) {
            Propagation.$$$reportNull$$$0(2);
        }
        if (Propagation.propagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableDeferred childDeferred = CompletableDeferredKt.CompletableDeferred((Job)currentJob);
            CancellationCallable<V> cancellationCallable = new CancellationCallable<V>(childDeferred, callable);
            return new CancellationFutureTask<V>((Job)childDeferred, Propagation.handleContext(cancellationCallable));
        }
        return new FutureTask<V>(Propagation.handleContext(callable));
    }

    @NotNull
    static <V> SchedulingWrapper.MyScheduledFutureTask<V> handleScheduledFutureTask(@NotNull SchedulingWrapper wrapper, @NotNull Callable<V> callable, long ns) {
        if (wrapper == null) {
            Propagation.$$$reportNull$$$0(3);
        }
        if (callable == null) {
            Propagation.$$$reportNull$$$0(4);
        }
        if (Propagation.propagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableDeferred childDeferred = CompletableDeferredKt.CompletableDeferred((Job)currentJob);
            CancellationCallable<V> cancellationCallable = new CancellationCallable<V>(childDeferred, callable);
            SchedulingWrapper schedulingWrapper = wrapper;
            Objects.requireNonNull(schedulingWrapper);
            return schedulingWrapper.new SchedulingWrapper.CancellationScheduledFutureTask<V>((Job)childDeferred, Propagation.handleContext(cancellationCallable), ns);
        }
        SchedulingWrapper schedulingWrapper = wrapper;
        Objects.requireNonNull(schedulingWrapper);
        return schedulingWrapper.new SchedulingWrapper.MyScheduledFutureTask<V>(Propagation.handleContext(callable), ns);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    static SchedulingWrapper.MyScheduledFutureTask<?> handlePeriodicScheduledFutureTask(@NotNull SchedulingWrapper wrapper, @NotNull Runnable runnable, long ns, long l) {
        void period;
        if (wrapper == null) {
            Propagation.$$$reportNull$$$0(5);
        }
        if (runnable == null) {
            Propagation.$$$reportNull$$$0(6);
        }
        if (Propagation.propagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableJob childJob = JobKt.Job((Job)currentJob);
            PeriodicCancellationRunnable cancellationRunnable = new PeriodicCancellationRunnable(childJob, runnable);
            SchedulingWrapper schedulingWrapper = wrapper;
            Objects.requireNonNull(schedulingWrapper);
            return schedulingWrapper.new SchedulingWrapper.CancellationScheduledFutureTask((Job)childJob, Propagation.handleContext(cancellationRunnable), ns, (long)period);
        }
        SchedulingWrapper schedulingWrapper = wrapper;
        Objects.requireNonNull(schedulingWrapper);
        return schedulingWrapper.new SchedulingWrapper.MyScheduledFutureTask<Object>(Propagation.handleContext(runnable), null, ns, (long)period);
    }

    @NotNull
    public static Runnable handleContext(@NotNull Runnable runnable) {
        if (runnable == null) {
            Propagation.$$$reportNull$$$0(7);
        }
        if (Propagation.propagateThreadContext()) {
            Runnable runnable2 = ThreadContext.captureThreadContext(runnable);
            if (runnable2 == null) {
                Propagation.$$$reportNull$$$0(8);
            }
            return runnable2;
        }
        Runnable runnable3 = runnable;
        if (runnable3 == null) {
            Propagation.$$$reportNull$$$0(9);
        }
        return runnable3;
    }

    @NotNull
    private static <V> Callable<V> handleContext(@NotNull Callable<V> callable) {
        if (callable == null) {
            Propagation.$$$reportNull$$$0(10);
        }
        if (Propagation.propagateThreadContext()) {
            Callable<V> callable2 = ThreadContext.captureThreadContext(callable);
            if (callable2 == null) {
                Propagation.$$$reportNull$$$0(11);
            }
            return callable2;
        }
        Callable<V> callable3 = callable;
        if (callable3 == null) {
            Propagation.$$$reportNull$$$0(12);
        }
        return callable3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/Propagation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/Propagation";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "handleContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runTestWithPropagationEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleCommand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleScheduledFutureTask";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handlePeriodicScheduledFutureTask";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleContext";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class Holder {
        private static boolean propagateThreadContext = Registry.is("ide.propagate.context");
        private static boolean propagateThreadCancellation = Registry.is("ide.propagate.cancellation");

        Holder() {
        }
    }
}

