/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionDescriptor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ImplementationClassResolver;
import com.intellij.openapi.extensions.impl.XmlExtensionAdapter;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J+\u0010\u0012\u001a\u0015\u0012\f\u0012\n \u0014*\u0004\u0018\u00018\u00008\u00000\u0013\u00a2\u0006\u0002\b\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J8\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001a2\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/extensions/impl/BeanExtensionPoint;", "T", "Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;", "Lcom/intellij/openapi/extensions/impl/ImplementationClassResolver;", "name", "", "className", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "dynamic", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/extensions/PluginDescriptor;Lcom/intellij/openapi/components/ComponentManager;Z)V", "createAdapter", "Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "descriptor", "Lcom/intellij/openapi/extensions/ExtensionDescriptor;", "resolveImplementationClass", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "adapter", "unregisterExtensions", "", "priorityListenerCallbacks", "", "Ljava/lang/Runnable;", "listenerCallbacks", "intellij.platform.extensions"})
public final class BeanExtensionPoint<T>
extends ExtensionPointImpl<T>
implements ImplementationClassResolver {
    @NotNull
    public Class<T> resolveImplementationClass(@NotNull ComponentManager componentManager, @NotNull ExtensionComponentAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Class clazz = this.getExtensionClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"extensionClass");
        return clazz;
    }

    @Override
    @NotNull
    protected ExtensionComponentAdapter createAdapter(@NotNull ExtensionDescriptor descriptor, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager) {
        ExtensionComponentAdapter extensionComponentAdapter;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        if (componentManager.isInjectionForExtensionSupported()) {
            String string2 = this.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className");
            extensionComponentAdapter = new XmlExtensionAdapter.SimpleConstructorInjectionAdapter(string2, pluginDescriptor, descriptor, this);
        } else {
            String string3 = this.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"className");
            extensionComponentAdapter = new XmlExtensionAdapter(string3, pluginDescriptor, descriptor.orderId, descriptor.order, descriptor.element, this);
        }
        return extensionComponentAdapter;
    }

    @Override
    protected void unregisterExtensions(@NotNull ComponentManager componentManager, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<? super Runnable> priorityListenerCallbacks, @NotNull List<? super Runnable> listenerCallbacks) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter(priorityListenerCallbacks, (String)"priorityListenerCallbacks");
        Intrinsics.checkNotNullParameter(listenerCallbacks, (String)"listenerCallbacks");
        this.unregisterExtensions(false, priorityListenerCallbacks, listenerCallbacks, new Predicate(pluginDescriptor){
            final /* synthetic */ PluginDescriptor $pluginDescriptor;

            public final boolean test(ExtensionComponentAdapter it) {
                return it.pluginDescriptor != this.$pluginDescriptor;
            }
            {
                this.$pluginDescriptor = pluginDescriptor;
            }
        });
    }

    public BeanExtensionPoint(@NotNull String name, @NotNull String className, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, boolean dynamic) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        super(name, className, pluginDescriptor, componentManager, null, dynamic);
    }
}

