/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.name.JvmNames;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/VolatileAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class VolatileAnnotationChecker
implements DeclarationChecker {
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        AnnotationDescriptor delegateAnnotation;
        FieldDescriptor fieldDescriptor;
        AnnotationDescriptor fieldAnnotation;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return;
        }
        FieldDescriptor fieldDescriptor2 = ((PropertyDescriptor)descriptor2).getBackingField();
        AnnotationDescriptor annotationDescriptor = fieldDescriptor2 != null && (fieldDescriptor2 = fieldDescriptor2.getAnnotations()) != null ? fieldDescriptor2.findAnnotation(JvmNames.VOLATILE_ANNOTATION_FQ_NAME) : (fieldAnnotation = null);
        if (fieldAnnotation != null && !((PropertyDescriptor)descriptor2).isVar()) {
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation((AnnotationDescriptor)fieldAnnotation);
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            context.getTrace().report((Diagnostic)ErrorsJvm.VOLATILE_ON_VALUE.on((PsiElement)annotationEntry));
        }
        AnnotationDescriptor annotationDescriptor2 = (fieldDescriptor = ((PropertyDescriptor)descriptor2).getDelegateField()) != null && (fieldDescriptor = fieldDescriptor.getAnnotations()) != null ? fieldDescriptor.findAnnotation(JvmNames.VOLATILE_ANNOTATION_FQ_NAME) : (delegateAnnotation = null);
        if (delegateAnnotation != null) {
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation((AnnotationDescriptor)delegateAnnotation);
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            context.getTrace().report((Diagnostic)ErrorsJvm.VOLATILE_ON_DELEGATE.on((PsiElement)annotationEntry));
        }
    }
}

