/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.BuiltInsPackageFragment;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/MissingBuiltInDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "diagnosticFor", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "ClassifierUsage", "frontend.java"})
public final class MissingBuiltInDeclarationChecker
implements CallChecker {
    @NotNull
    public static final MissingBuiltInDeclarationChecker INSTANCE = new MissingBuiltInDeclarationChecker();

    private MissingBuiltInDeclarationChecker() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
                Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (context.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getSuppressMissingBuiltinsError()).booleanValue()) {
                    return;
                }
                descriptor = resolvedCall.getResultingDescriptor();
                v0 = this.diagnosticFor((DeclarationDescriptor)descriptor, reportOn);
                if (v0 != null) break block3;
                v1 = this;
                v2 /* !! */  = descriptor.getReturnType();
                if (v2 /* !! */  == null) ** GOTO lbl-1000
                var10_7 = var9_5 = v2 /* !! */ ;
                var12_8 = v1;
                $i$a$-takeUnless-MissingBuiltInDeclarationChecker$check$error$1 = false;
                var13_10 = CallCheckerKt.isComputingDeferredType((CallChecker)this, (KotlinType)p0);
                v1 = var12_8;
                v2 /* !! */  = var13_10 == false ? var9_5 : null;
                if (v2 /* !! */  != null && (v2 /* !! */  = v2 /* !! */ .getConstructor()) != null) {
                    v3 = v2 /* !! */ .getDeclarationDescriptor();
                } else lbl-1000:
                // 2 sources

                {
                    v3 = null;
                }
                v0 = v1.diagnosticFor((DeclarationDescriptor)v3, reportOn);
            }
            v4 = error = v0;
            if (v4 == null) break block4;
            var6_12 = v4;
            var7_13 = context.getTrace();
            p0 = var6_12;
            $i$a$-let-MissingBuiltInDeclarationChecker$check$1 = false;
            var7_13.report(p0);
        }
    }

    private final Diagnostic diagnosticFor(DeclarationDescriptor descriptor2, PsiElement reportOn) {
        if (descriptor2 == null) {
            return null;
        }
        ClassOrPackageFragmentDescriptor containingClassOrPackage = (ClassOrPackageFragmentDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)descriptor2, ClassOrPackageFragmentDescriptor.class);
        if (containingClassOrPackage instanceof ClassDescriptor) {
            PackageFragmentDescriptor containingPackage = (PackageFragmentDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)descriptor2, PackageFragmentDescriptor.class);
            BuiltInsPackageFragment builtInsPackageFragment = containingPackage instanceof BuiltInsPackageFragment ? (BuiltInsPackageFragment)containingPackage : null;
            boolean bl = builtInsPackageFragment != null ? builtInsPackageFragment.isFallback() : false;
            if (bl) {
                return (Diagnostic)Errors.MISSING_BUILT_IN_DECLARATION.on(reportOn, (Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)containingClassOrPackage)));
            }
        } else if (containingClassOrPackage instanceof BuiltInsPackageFragment && ((BuiltInsPackageFragment)containingClassOrPackage).isFallback()) {
            return (Diagnostic)Errors.MISSING_BUILT_IN_DECLARATION.on(reportOn, (Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)descriptor2));
        }
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/MissingBuiltInDeclarationChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend.java"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        @NotNull
        public static final ClassifierUsage INSTANCE = new ClassifierUsage();

        private ClassifierUsage() {
        }

        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)targetDescriptor, (String)"targetDescriptor");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (context.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getSuppressMissingBuiltinsError()).booleanValue()) {
                    return;
                }
                Diagnostic diagnostic = INSTANCE.diagnosticFor((DeclarationDescriptor)targetDescriptor, element);
                if (diagnostic == null) break block1;
                Diagnostic diagnostic2 = diagnostic;
                BindingTrace bindingTrace = context.getTrace();
                Diagnostic p0 = diagnostic2;
                boolean bl = false;
                bindingTrace.report(p0);
            }
        }
    }
}

