/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.ManifestImporter;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

public class ManifestBuilder {
    private static final Map<String, String> PACKAGING_PLUGINS = Map.of("jar", "maven-jar-plugin", "ejb", "maven-ejb-plugin", "ejb-client", "maven-ejb-plugin", "war", "maven-war-plugin", "ear", "maven-ear-plugin");
    @NotNull
    private final MavenProject myMavenProject;
    @Nullable
    private String myJdkVersion;

    public ManifestBuilder(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            ManifestBuilder.$$$reportNull$$$0(0);
        }
        this.myMavenProject = mavenProject2;
    }

    public ManifestBuilder withJdkVersion(String jdkVersion) {
        this.myJdkVersion = jdkVersion;
        return this;
    }

    @NotNull
    public Manifest build() throws ManifestBuilderException {
        org.codehaus.plexus.archiver.jar.Manifest manifest;
        try {
            Element mavenArchiveConfiguration;
            Element mavenPackagingPluginConfiguration = ManifestBuilder.getMavenPackagingPluginConfiguration(this.myMavenProject);
            Element element = mavenArchiveConfiguration = mavenPackagingPluginConfiguration != null ? mavenPackagingPluginConfiguration.getChild("archive") : null;
            if (mavenArchiveConfiguration == null) {
                return this.getDefaultManifest(Collections.emptyMap());
            }
            Element manifestEntries = mavenArchiveConfiguration.getChild("manifestEntries");
            Map<String, String> entries = ManifestBuilder.getManifestEntries(manifestEntries);
            Element manifestConfiguration = mavenArchiveConfiguration.getChild("manifest");
            org.codehaus.plexus.archiver.jar.Manifest configuredManifest = ManifestBuilder.getConfiguredManifest(this.myMavenProject, manifestConfiguration, entries);
            if (!entries.isEmpty()) {
                ManifestBuilder.addManifestEntries(configuredManifest, entries);
            }
            ManifestBuilder.addCustomManifestSections(configuredManifest, mavenArchiveConfiguration);
            org.codehaus.plexus.archiver.jar.Manifest finalManifest = this.getDefaultManifest(entries);
            ManifestBuilder.merge(finalManifest, configuredManifest);
            org.codehaus.plexus.archiver.jar.Manifest userSuppliedManifest = this.getUserSuppliedManifest(mavenArchiveConfiguration);
            ManifestBuilder.merge(finalManifest, userSuppliedManifest);
            manifest = finalManifest;
        }
        catch (ManifestException e) {
            throw new ManifestBuilderException(e);
        }
        if (manifest == null) {
            ManifestBuilder.$$$reportNull$$$0(1);
        }
        return manifest;
    }

    @NotNull
    public static String getClasspath(@NotNull MavenProject mavenProject2) {
        Element mavenPackagingPluginConfiguration;
        if (mavenProject2 == null) {
            ManifestBuilder.$$$reportNull$$$0(2);
        }
        Element mavenArchiveConfiguration = (mavenPackagingPluginConfiguration = ManifestBuilder.getMavenPackagingPluginConfiguration(mavenProject2)) != null ? mavenPackagingPluginConfiguration.getChild("archive") : null;
        Element manifestConfiguration = mavenArchiveConfiguration != null ? mavenArchiveConfiguration.getChild("manifest") : null;
        ManifestImporter manifestImporter = ManifestImporter.getManifestImporter(mavenProject2.getPackaging());
        String string = manifestImporter.getClasspath(mavenProject2, manifestConfiguration);
        if (string == null) {
            ManifestBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getClasspathPrefix(@Nullable Element manifestConfiguration) {
        Object classpathPrefix = MavenJDOMUtil.findChildValueByPath(manifestConfiguration, "classpathPrefix", "").replaceAll("\\\\", "/");
        if (((String)classpathPrefix).length() != 0 && !((String)classpathPrefix).endsWith("/")) {
            classpathPrefix = (String)classpathPrefix + "/";
        }
        String string = classpathPrefix;
        if (string == null) {
            ManifestBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static Element getMavenPackagingPluginConfiguration(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            ManifestBuilder.$$$reportNull$$$0(5);
        }
        Element mavenPackagingPluginConfiguration = null;
        String packaging = mavenProject2.getPackaging();
        if (StringUtil.isEmpty((String)packaging)) {
            mavenPackagingPluginConfiguration = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-jar-plugin");
        } else {
            String pluginArtifactId = PACKAGING_PLUGINS.get(StringUtil.toLowerCase((String)packaging));
            if (pluginArtifactId != null) {
                mavenPackagingPluginConfiguration = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", pluginArtifactId);
            }
        }
        return mavenPackagingPluginConfiguration;
    }

    private static Map<String, String> getManifestEntries(Element manifestEntries) {
        LinkedHashMap<String, String> entries;
        boolean hasManifestEntries = manifestEntries != null && manifestEntries.getContentSize() > 0;
        LinkedHashMap<String, String> linkedHashMap = entries = hasManifestEntries ? new LinkedHashMap<String, String>(manifestEntries.getContentSize()) : Collections.emptyMap();
        if (hasManifestEntries) {
            for (Element element : manifestEntries.getChildren()) {
                entries.put(element.getName(), element.getTextTrim());
            }
        }
        return entries;
    }

    private static void addCustomManifestSections(@NotNull org.codehaus.plexus.archiver.jar.Manifest manifest, @NotNull Element mavenArchiveConfiguration) throws ManifestException {
        if (manifest == null) {
            ManifestBuilder.$$$reportNull$$$0(6);
        }
        if (mavenArchiveConfiguration == null) {
            ManifestBuilder.$$$reportNull$$$0(7);
        }
        for (Element section : MavenJDOMUtil.findChildrenByPath(mavenArchiveConfiguration, "manifestSections", "manifestSection")) {
            Manifest.Section theSection = new Manifest.Section();
            String sectionName = MavenJDOMUtil.findChildValueByPath(section, "name");
            theSection.setName(sectionName);
            Element manifestEntries = section.getChild("manifestEntries");
            Map<String, String> entries = ManifestBuilder.getManifestEntries(manifestEntries);
            if (!entries.isEmpty()) {
                for (Map.Entry<String, String> entry : entries.entrySet()) {
                    Manifest.Attribute attr = new Manifest.Attribute(entry.getKey(), entry.getValue());
                    theSection.addConfiguredAttribute(attr);
                }
            }
            manifest.addConfiguredSection(theSection);
        }
    }

    @NotNull
    private org.codehaus.plexus.archiver.jar.Manifest getDefaultManifest(@NotNull Map<String, String> entries) throws ManifestException {
        if (entries == null) {
            ManifestBuilder.$$$reportNull$$$0(8);
        }
        org.codehaus.plexus.archiver.jar.Manifest finalManifest = new org.codehaus.plexus.archiver.jar.Manifest();
        ManifestBuilder.addManifestAttribute(finalManifest, entries, "Created-By", ApplicationNamesInfo.getInstance().getFullProductName());
        ManifestBuilder.addManifestAttribute(finalManifest, entries, "Built-By", System.getProperty("user.name"));
        if (!StringUtil.isEmpty((String)this.myJdkVersion)) {
            ManifestBuilder.addManifestAttribute(finalManifest, entries, "Build-Jdk", this.myJdkVersion);
        }
        org.codehaus.plexus.archiver.jar.Manifest manifest = finalManifest;
        if (manifest == null) {
            ManifestBuilder.$$$reportNull$$$0(9);
        }
        return manifest;
    }

    private static void addManifestEntries(@NotNull org.codehaus.plexus.archiver.jar.Manifest manifest, @NotNull Map<String, String> entries) throws ManifestException {
        if (manifest == null) {
            ManifestBuilder.$$$reportNull$$$0(10);
        }
        if (entries == null) {
            ManifestBuilder.$$$reportNull$$$0(11);
        }
        if (!entries.isEmpty()) {
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                Manifest.ExistingAttribute attr = manifest.getMainSection().getAttribute(entry.getKey());
                if ("Class-Path".equals(entry.getKey()) && attr != null) {
                    ((Manifest.Attribute)attr).setValue(entry.getValue() + " " + ((Manifest.Attribute)attr).getValue());
                    continue;
                }
                ManifestBuilder.addManifestAttribute(manifest, entry.getKey(), entry.getValue());
            }
        }
    }

    @Nullable
    private org.codehaus.plexus.archiver.jar.Manifest getUserSuppliedManifest(@Nullable Element mavenArchiveConfiguration) {
        String manifestPath = MavenJDOMUtil.findChildValueByPath(mavenArchiveConfiguration, "manifestFile");
        if (manifestPath != null) {
            File manifestFile = new File(manifestPath);
            if (!manifestFile.isAbsolute()) {
                manifestFile = new File(this.myMavenProject.getDirectory(), manifestPath);
            }
            if (manifestFile.isFile()) {
                org.codehaus.plexus.archiver.jar.Manifest manifest;
                FileInputStream fis = new FileInputStream(manifestFile);
                try {
                    manifest = new org.codehaus.plexus.archiver.jar.Manifest(fis);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                fis.close();
                return manifest;
            }
        }
        return null;
    }

    @NotNull
    private static org.codehaus.plexus.archiver.jar.Manifest getConfiguredManifest(@NotNull MavenProject mavenProject2, @Nullable Element manifestConfiguration, @NotNull Map<String, String> entries) throws ManifestException {
        ManifestImporter manifestImporter;
        String classpath;
        boolean isAddClasspath;
        String mainClass;
        String packageName;
        boolean isAddDefaultImplementationEntries;
        if (mavenProject2 == null) {
            ManifestBuilder.$$$reportNull$$$0(12);
        }
        if (entries == null) {
            ManifestBuilder.$$$reportNull$$$0(13);
        }
        org.codehaus.plexus.archiver.jar.Manifest manifest = new org.codehaus.plexus.archiver.jar.Manifest();
        boolean isAddDefaultSpecificationEntries = Boolean.parseBoolean(MavenJDOMUtil.findChildValueByPath(manifestConfiguration, "addDefaultSpecificationEntries", "false"));
        if (isAddDefaultSpecificationEntries) {
            ManifestBuilder.addManifestAttribute(manifest, entries, "Specification-Title", mavenProject2.getName());
            ManifestBuilder.addManifestAttribute(manifest, entries, "Specification-Version", mavenProject2.getMavenId().getVersion());
        }
        if (isAddDefaultImplementationEntries = Boolean.parseBoolean(MavenJDOMUtil.findChildValueByPath(manifestConfiguration, "addDefaultImplementationEntries", "false"))) {
            ManifestBuilder.addManifestAttribute(manifest, entries, "Implementation-Title", mavenProject2.getName());
            ManifestBuilder.addManifestAttribute(manifest, entries, "Implementation-Version", mavenProject2.getMavenId().getVersion());
            ManifestBuilder.addManifestAttribute(manifest, entries, "Implementation-Vendor-Id", mavenProject2.getMavenId().getGroupId());
        }
        if ((packageName = MavenJDOMUtil.findChildValueByPath(manifestConfiguration, "packageName")) != null) {
            ManifestBuilder.addManifestAttribute(manifest, entries, "Package", packageName);
        }
        if (!StringUtil.isEmpty((String)(mainClass = MavenJDOMUtil.findChildValueByPath(manifestConfiguration, "mainClass")))) {
            ManifestBuilder.addManifestAttribute(manifest, entries, "Main-Class", mainClass);
        }
        if ((isAddClasspath = Boolean.parseBoolean(MavenJDOMUtil.findChildValueByPath(manifestConfiguration, "addClasspath", "false"))) && !(classpath = (manifestImporter = ManifestImporter.getManifestImporter(mavenProject2.getPackaging())).getClasspath(mavenProject2, manifestConfiguration)).isEmpty()) {
            ManifestBuilder.addManifestAttribute(manifest, "Class-Path", classpath);
        }
        org.codehaus.plexus.archiver.jar.Manifest manifest2 = manifest;
        if (manifest2 == null) {
            ManifestBuilder.$$$reportNull$$$0(14);
        }
        return manifest2;
    }

    private static void addManifestAttribute(@NotNull org.codehaus.plexus.archiver.jar.Manifest manifest, @NotNull Map<String, String> map2, String key, String value) throws ManifestException {
        if (manifest == null) {
            ManifestBuilder.$$$reportNull$$$0(15);
        }
        if (map2 == null) {
            ManifestBuilder.$$$reportNull$$$0(16);
        }
        if (map2.containsKey(key)) {
            return;
        }
        ManifestBuilder.addManifestAttribute(manifest, key, value);
    }

    private static void addManifestAttribute(@NotNull org.codehaus.plexus.archiver.jar.Manifest manifest, String key, String value) throws ManifestException {
        if (manifest == null) {
            ManifestBuilder.$$$reportNull$$$0(17);
        }
        if (!StringUtil.isEmpty((String)value)) {
            Manifest.Attribute attr = new Manifest.Attribute(key, value);
            manifest.addConfiguredAttribute(attr);
        }
    }

    private static void merge(@NotNull Manifest target, @Nullable Manifest other) {
        if (target == null) {
            ManifestBuilder.$$$reportNull$$$0(18);
        }
        if (other != null) {
            ManifestBuilder.mergeAttributes(target.getMainAttributes(), other.getMainAttributes());
            for (Map.Entry<String, Attributes> o : other.getEntries().entrySet()) {
                Attributes ourSection = target.getAttributes(o.getKey());
                Attributes otherSection = o.getValue();
                if (ourSection == null) {
                    if (otherSection == null) continue;
                    target.getEntries().put(o.getKey(), (Attributes)otherSection.clone());
                    continue;
                }
                ManifestBuilder.mergeAttributes(ourSection, otherSection);
            }
        }
    }

    private static void mergeAttributes(@NotNull Attributes target, @NotNull Attributes section) {
        if (target == null) {
            ManifestBuilder.$$$reportNull$$$0(19);
        }
        if (section == null) {
            ManifestBuilder.$$$reportNull$$$0(20);
        }
        for (Object o : section.keySet()) {
            Attributes.Name key = (Attributes.Name)o;
            Object value = section.get(o);
            target.put(key, value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/utils/ManifestBuilder";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenArchiveConfiguration";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/utils/ManifestBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathPrefix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultManifest";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredManifest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClasspath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMavenPackagingPluginConfiguration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCustomManifestSections";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultManifest";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addManifestEntries";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredManifest";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addManifestAttribute";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "mergeAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ManifestBuilderException
    extends Exception {
        public ManifestBuilderException(Throwable cause) {
            super(cause);
        }
    }
}

