/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.execution.BeforeRunTask;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTasksProvider;

public class MavenBeforeRunTask
extends BeforeRunTask<MavenBeforeRunTask> {
    private String myProjectPath;
    private String myGoal;

    public MavenBeforeRunTask() {
        super(MavenBeforeRunTasksProvider.ID);
    }

    public String getProjectPath() {
        return this.myProjectPath;
    }

    public void setProjectPath(String projectPath) {
        this.myProjectPath = projectPath;
    }

    public String getGoal() {
        return this.myGoal;
    }

    public void setGoal(String goal) {
        this.myGoal = goal;
    }

    public boolean isFor(MavenProject project2, String goal) {
        if (this.myProjectPath == null || this.myGoal == null) {
            return false;
        }
        return VfsUtilCore.pathEqualsTo((VirtualFile)project2.getFile(), (String)this.myProjectPath) && goal.equals(this.myGoal);
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            MavenBeforeRunTask.$$$reportNull$$$0(0);
        }
        super.writeExternal(element);
        if (this.myProjectPath != null) {
            element.setAttribute("file", this.myProjectPath);
        }
        if (this.myGoal != null) {
            element.setAttribute("goal", this.myGoal);
        }
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            MavenBeforeRunTask.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        this.myProjectPath = element.getAttributeValue("file");
        this.myGoal = element.getAttributeValue("goal");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MavenBeforeRunTask that = (MavenBeforeRunTask)((Object)o);
        if (this.myGoal != null ? !this.myGoal.equals(that.myGoal) : that.myGoal != null) {
            return false;
        }
        return !(this.myProjectPath != null ? !this.myProjectPath.equals(that.myProjectPath) : that.myProjectPath != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myProjectPath != null ? this.myProjectPath.hashCode() : 0);
        result = 31 * result + (this.myGoal != null ? this.myGoal.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "org/jetbrains/idea/maven/tasks/MavenBeforeRunTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

