/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAArtifact;
import com.intellij.openapi.externalSystem.dependency.analyzer.DADependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAModule;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAOmitted;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAProject;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAScope;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAWarning;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerContributor;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerProject;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\b2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u001e\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/idea/maven/project/MavenDependencyAnalyzerContributor;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerContributor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "collectDependency", "", "nodes", "", "Lorg/jetbrains/idea/maven/model/MavenArtifactNode;", "parentDependency", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", "result", "", "createDependencyList", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "getDependencies", "externalProject", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerProject;", "getDependencyData", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "mavenArtifactNode", "getDependencyScopes", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Scope;", "getProjects", "getStatus", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Status;", "whenDataChanged", "listener", "Lkotlin/Function0;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "Companion", "intellij.maven"})
public final class MavenDependencyAnalyzerContributor
implements DependencyAnalyzerContributor {
    private final Project project;
    @NotNull
    private static final Key<MavenId> MAVEN_ARTIFACT_ID;
    @NotNull
    public static final Companion Companion;

    public void whenDataChanged(@NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.project);
        projectsManager.addProjectsTreeListener(new MavenProjectsTree.Listener(listener2){
            final /* synthetic */ Function0 $listener;

            public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
                Intrinsics.checkNotNullParameter(projectWithChanges, (String)"projectWithChanges");
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        }, parentDisposable);
    }

    @NotNull
    public List<DependencyAnalyzerProject> getProjects() {
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.project);
        ArrayList<DAProject> externalProjects2 = new ArrayList<DAProject>();
        MavenProjectsManager mavenProjectsManager2 = mavenProjectsManager;
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager2, (String)"mavenProjectsManager");
        for (MavenProject mavenProject2 : mavenProjectsManager2.getProjects()) {
            Module module;
            if (mavenProjectsManager.findModule(mavenProject2) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"mavenProjectsManager.fin\u2026mavenProject) ?: continue");
            MavenProject mavenProject3 = mavenProject2;
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject3, (String)"mavenProject");
            String string = mavenProject3.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mavenProject.displayName");
            externalProjects2.add(new DAProject(module, string));
        }
        return externalProjects2;
    }

    @NotNull
    public List<DependencyAnalyzerDependency.Scope> getDependencyScopes(@NotNull DependencyAnalyzerProject externalProject) {
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        return CollectionsKt.listOf((Object[])new DAScope[]{Companion.scope("compile"), Companion.scope("provided"), Companion.scope("runtime"), Companion.scope("system"), Companion.scope("import"), Companion.scope("test")});
    }

    @NotNull
    public List<DependencyAnalyzerDependency> getDependencies(@NotNull DependencyAnalyzerProject externalProject) {
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.project);
        MavenProject mavenProject2 = projectsManager.findProject(externalProject.getModule());
        if (mavenProject2 == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenProject2, (String)"projectsManager.findProj\u2026le) ?: return emptyList()");
        MavenProject mavenProject3 = mavenProject2;
        return this.createDependencyList(mavenProject3);
    }

    private final List<DependencyAnalyzerDependency> createDependencyList(MavenProject mavenProject2) {
        String string = mavenProject2.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mavenProject.displayName");
        DAModule root = new DAModule(string);
        MavenId mavenId = mavenProject2.getMavenId();
        Intrinsics.checkNotNullExpressionValue((Object)mavenId, (String)"mavenProject.mavenId");
        MavenId mavenId2 = mavenId;
        root.putUserData(MAVEN_ARTIFACT_ID, (Object)new MavenId(mavenId2.getGroupId(), mavenId2.getArtifactId(), mavenId2.getVersion()));
        DADependency rootDependency = new DADependency((DependencyAnalyzerDependency.Data)root, (DependencyAnalyzerDependency.Scope)Companion.scope("compile"), null, CollectionsKt.emptyList());
        List result = new ArrayList();
        List<MavenArtifactNode> list = mavenProject2.getDependencyTree();
        Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.dependencyTree");
        this.collectDependency(list, (DependencyAnalyzerDependency)rootDependency, result);
        return result;
    }

    private final void collectDependency(List<? extends MavenArtifactNode> nodes, DependencyAnalyzerDependency parentDependency, List<DependencyAnalyzerDependency> result) {
        for (MavenArtifactNode mavenArtifactNode : nodes) {
            DependencyAnalyzerDependency.Data data = this.getDependencyData(mavenArtifactNode);
            String string = mavenArtifactNode.getOriginalScope();
            if (string == null) {
                string = "compile";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mavenArtifactNode.origin\u2026enConstants.SCOPE_COMPILE");
            DADependency dependency = new DADependency(data, (DependencyAnalyzerDependency.Scope)Companion.scope(string), parentDependency, this.getStatus(mavenArtifactNode));
            result.add((DependencyAnalyzerDependency)dependency);
            if (mavenArtifactNode.getDependencies() == null) continue;
            List list = mavenArtifactNode.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mavenArtifactNode.dependencies");
            this.collectDependency(list, (DependencyAnalyzerDependency)dependency, result);
        }
    }

    private final DependencyAnalyzerDependency.Data getDependencyData(MavenArtifactNode mavenArtifactNode) {
        MavenProject mavenProject2 = MavenProjectsManager.getInstance(this.project).findProject(mavenArtifactNode.getArtifact());
        MavenArtifact mavenArtifact = mavenArtifactNode.getArtifact();
        Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"mavenArtifactNode.artifact");
        String string = mavenArtifact.getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mavenArtifactNode.artifact.groupId");
        MavenArtifact mavenArtifact2 = mavenArtifactNode.getArtifact();
        Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact2, (String)"mavenArtifactNode.artifact");
        String string2 = mavenArtifact2.getArtifactId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mavenArtifactNode.artifact.artifactId");
        MavenArtifact mavenArtifact3 = mavenArtifactNode.getArtifact();
        Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact3, (String)"mavenArtifactNode.artifact");
        String string3 = mavenArtifact3.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"mavenArtifactNode.artifact.version");
        DAArtifact daArtifact = new DAArtifact(string, string2, string3);
        if (mavenProject2 != null) {
            String string4 = mavenProject2.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"mavenProject.displayName");
            DAModule daModule = new DAModule(string4);
            daModule.putUserData(MAVEN_ARTIFACT_ID, (Object)new MavenId(daArtifact.getGroupId(), daArtifact.getArtifactId(), daArtifact.getVersion()));
            return (DependencyAnalyzerDependency.Data)daModule;
        }
        return (DependencyAnalyzerDependency.Data)daArtifact;
    }

    private final List<DependencyAnalyzerDependency.Status> getStatus(MavenArtifactNode mavenArtifactNode) {
        List status = new ArrayList();
        if (mavenArtifactNode.getState() == MavenArtifactState.CONFLICT) {
            status.add(DAOmitted.INSTANCE);
            Object object = mavenArtifactNode.getRelatedArtifact();
            if (object != null && (object = object.getVersion()) != null) {
                String message;
                Object object2;
                Object it = object2 = object;
                boolean bl = false;
                String string = message = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.version.conflict", (Object[])new Object[]{it});
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message");
                status.add(new DAWarning(string));
            }
        } else if (mavenArtifactNode.getState() == MavenArtifactState.DUPLICATE) {
            status.add(DAOmitted.INSTANCE);
        }
        MavenArtifact mavenArtifact = mavenArtifactNode.getArtifact();
        Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"mavenArtifactNode.artifact");
        if (!mavenArtifact.isResolvedArtifact()) {
            String string = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.unresolved", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"external.system\u2026yzer.warning.unresolved\")");
            status.add(new DAWarning(string));
        }
        return status;
    }

    public MavenDependencyAnalyzerContributor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"MavenDependencyAnalyzerContributor.MavenId");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<MavenId>(\"Mav\u2026yzerContributor.MavenId\")");
        MAVEN_ARTIFACT_ID = key;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\n\u001a\u00020\u000b2\u000b\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eR$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/project/MavenDependencyAnalyzerContributor$Companion;", "", "()V", "MAVEN_ARTIFACT_ID", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/idea/maven/model/MavenId;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getMAVEN_ARTIFACT_ID", "()Lcom/intellij/openapi/util/Key;", "scope", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DAScope;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.maven"})
    public static final class Companion {
        @NotNull
        public final DAScope scope(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = StringUtil.toTitleCase((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.toTitleCase(name)");
            return new DAScope(name, string);
        }

        @NotNull
        public final Key<MavenId> getMAVEN_ARTIFACT_ID() {
            return MAVEN_ARTIFACT_ID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

