/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenModuleNameMapper;
import org.jetbrains.idea.maven.importing.ModuleModelProxy;
import org.jetbrains.idea.maven.importing.tree.LegacyModuleData;
import org.jetbrains.idea.maven.importing.tree.MavenJavaVersionHolder;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportData;
import org.jetbrains.idea.maven.importing.tree.MavenModuleType;
import org.jetbrains.idea.maven.importing.tree.MavenProjectImportContextProvider;
import org.jetbrains.idea.maven.importing.tree.ModuleData;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class LegacyMavenProjectImportContextProvider
extends MavenProjectImportContextProvider {
    @NotNull
    private final ModuleModelProxy myModuleModel;

    public LegacyMavenProjectImportContextProvider(@NotNull Project project2, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, MavenProjectChanges> changes, @NotNull ModuleModelProxy moduleModel, @NotNull MavenImportingSettings importingSettings) {
        if (project2 == null) {
            LegacyMavenProjectImportContextProvider.$$$reportNull$$$0(0);
        }
        if (projectsTree == null) {
            LegacyMavenProjectImportContextProvider.$$$reportNull$$$0(1);
        }
        if (changes == null) {
            LegacyMavenProjectImportContextProvider.$$$reportNull$$$0(2);
        }
        if (moduleModel == null) {
            LegacyMavenProjectImportContextProvider.$$$reportNull$$$0(3);
        }
        if (importingSettings == null) {
            LegacyMavenProjectImportContextProvider.$$$reportNull$$$0(4);
        }
        super(project2, projectsTree, changes, importingSettings);
        this.myModuleModel = moduleModel;
    }

    @Override
    @NotNull
    protected Map<String, Module> buildModuleByNameMap() {
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        Map<String, Module> map2 = Arrays.stream(this.myModuleModel.getModules()).filter(m -> projectsManager.isMavenizedModule((Module)m)).collect(Collectors.toMap(m -> m.getName(), Function.identity()));
        if (map2 == null) {
            LegacyMavenProjectImportContextProvider.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @Override
    protected void addLegacyCreatedModule(List<Module> createdModules, MavenModuleImportData moduleImportData) {
        if (moduleImportData.getLegacyModuleData().isNewModule()) {
            createdModules.add(moduleImportData.getLegacyModuleData().getModule());
        }
    }

    @Override
    protected ModuleData getModuleData(MavenProject project2, String moduleName, MavenModuleType type2, MavenJavaVersionHolder javaVersionHolder, Map<String, Module> legacyModuleByName) {
        boolean newModule2;
        Module module = legacyModuleByName.remove(moduleName);
        if (module != null && !ModuleType.get((Module)module).equals(project2.getModuleType())) {
            this.myModuleModel.disposeModule(module);
            module = null;
        }
        boolean bl = newModule2 = module == null;
        if (newModule2) {
            String modulePath = MavenModuleNameMapper.generateModulePath(LegacyMavenProjectImportContextProvider.getModuleDirPath(project2, type2), moduleName, this.myImportingSettings.getDedicatedModuleDir());
            this.deleteExistingFiles(moduleName, modulePath);
            module = this.myModuleModel.newModule(modulePath, project2.getModuleType().getId());
        }
        return new LegacyModuleData(module, type2, javaVersionHolder, newModule2);
    }

    private static String getModuleDirPath(MavenProject project2, MavenModuleType type2) {
        if (type2 == MavenModuleType.TEST) {
            return Path.of(project2.getDirectory(), "src", "test").toString();
        }
        if (type2 == MavenModuleType.MAIN) {
            return Path.of(project2.getDirectory(), "src", "main").toString();
        }
        return project2.getDirectory();
    }

    private void deleteExistingFiles(String moduleName, String modulePath) {
        this.deleteExistingImlFile(modulePath);
        this.deleteExistingModuleByName(moduleName);
    }

    private void deleteExistingModuleByName(String name) {
        Module module = this.myModuleModel.findModuleByName(name);
        if (module != null) {
            this.myModuleModel.disposeModule(module);
        }
    }

    private void deleteExistingImlFile(final String path) {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, new Runnable(){

            @Override
            public void run() {
                try {
                    VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                    if (file != null) {
                        file.delete((Object)this);
                    }
                }
                catch (IOException e) {
                    MavenLog.LOG.warn("Cannot delete existing iml file: " + path, (Throwable)e);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importingSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/tree/LegacyMavenProjectImportContextProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/tree/LegacyMavenProjectImportContextProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModuleByNameMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

