/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenModelUtil;
import org.jetbrains.idea.maven.importing.MavenPomPathModuleService;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterLegacyImpl;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxy;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxyWrapper;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportData;
import org.jetbrains.idea.maven.importing.tree.MavenModuleType;
import org.jetbrains.idea.maven.importing.tree.dependency.BaseDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.LibraryDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.MavenImportDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.ModuleDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.SystemDependency;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenModuleImporter {
    public static final String SUREFIRE_PLUGIN_LIBRARY_NAME = "maven-surefire-plugin urls";
    public static final Set<String> IMPORTED_CLASSIFIERS = Set.of("client");
    private static final Map<String, LanguageLevel> MAVEN_IDEA_PLUGIN_LEVELS = ImmutableMap.of((Object)"JDK_1_3", (Object)LanguageLevel.JDK_1_3, (Object)"JDK_1_4", (Object)LanguageLevel.JDK_1_4, (Object)"JDK_1_5", (Object)LanguageLevel.JDK_1_5, (Object)"JDK_1_6", (Object)LanguageLevel.JDK_1_6, (Object)"JDK_1_7", (Object)LanguageLevel.JDK_1_7);
    private final Module myModule;
    private final MavenProjectsTree myMavenTree;
    private final MavenProject myMavenProject;
    @Nullable
    private final MavenProjectChanges myMavenProjectChanges;
    private final Map<MavenProject, String> myMavenProjectToModuleName;
    private final MavenImportingSettings mySettings;
    private final ModifiableModelsProviderProxy myModifiableModelsProvider;
    @Nullable
    private final MavenModuleType myModuleType;
    private MavenRootModelAdapter myRootModelAdapter;
    private IdeModifiableModelsProvider myProviderForExtensions;

    public MavenModuleImporter(Module module, MavenProjectsTree mavenTree, MavenProject mavenProject2, @Nullable MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, MavenImportingSettings settings, ModifiableModelsProviderProxy modifiableModelsProvider, @Nullable MavenModuleType moduleType) {
        this.myModule = module;
        this.myMavenTree = mavenTree;
        this.myMavenProject = mavenProject2;
        this.myMavenProjectChanges = changes;
        this.myMavenProjectToModuleName = mavenProjectToModuleName;
        this.mySettings = settings;
        this.myModifiableModelsProvider = modifiableModelsProvider;
        this.myModuleType = moduleType;
        VirtualFile pomFile = mavenProject2.getFile();
        if (!FileUtil.namesEqual((String)"pom", (String)pomFile.getNameWithoutExtension())) {
            MavenPomPathModuleService.getInstance(module).setPomFileUrl(pomFile.getUrl());
        }
    }

    public MavenModuleImporter(Module module, MavenProjectsTree mavenTree, MavenProject mavenProject2, @Nullable MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, MavenImportingSettings settings, ModifiableModelsProviderProxy modifiableModelsProvider) {
        this(module, mavenTree, mavenProject2, changes, mavenProjectToModuleName, settings, modifiableModelsProvider, null);
    }

    public ModifiableRootModel getRootModel() {
        return this.myRootModelAdapter.getRootModel();
    }

    void setRootModelAdapter(MavenRootModelAdapter mavenRootModelAdapter) {
        this.myRootModelAdapter = mavenRootModelAdapter;
    }

    public void config(MavenRootModelAdapter mavenRootModelAdapter) {
        this.myRootModelAdapter = mavenRootModelAdapter;
        this.configFolders();
        this.configDependencies();
        this.configLanguageLevel();
    }

    public void config(MavenRootModelAdapter mavenRootModelAdapter, MavenModuleImportData importData) {
        this.myRootModelAdapter = mavenRootModelAdapter;
        this.configFolders();
        this.configDependencies(importData.getDependencies());
        LanguageLevel level = MavenModelUtil.getLanguageLevel(this.myMavenProject, () -> importData.getModuleData().getSourceLanguageLevel());
        this.configLanguageLevel(level);
    }

    public void configMainAndTestAggregator(MavenRootModelAdapter mavenRootModelAdapter, MavenModuleImportData importData) {
        assert (importData.getModuleData().getType() == MavenModuleType.AGGREGATOR_MAIN_TEST);
        this.myRootModelAdapter = mavenRootModelAdapter;
        new MavenFoldersImporter(this.myMavenProject, this.mySettings, this.myRootModelAdapter).configMainAndTestAggregator();
        this.configDependencies(importData.getDependencies());
        LanguageLevel level = MavenModelUtil.getLanguageLevel(this.myMavenProject, () -> importData.getModuleData().getSourceLanguageLevel());
        this.configLanguageLevel(level);
    }

    public void configMainAndTest(MavenRootModelAdapter mavenRootModelAdapter, MavenModuleImportData importData) {
        MavenModuleType type2 = importData.getModuleData().getType();
        assert (type2 == MavenModuleType.MAIN || type2 == MavenModuleType.TEST);
        this.myRootModelAdapter = mavenRootModelAdapter;
        new MavenFoldersImporter(this.myMavenProject, this.mySettings, this.myRootModelAdapter).configMainAndTest(type2);
        this.configDependencies(importData.getDependencies());
        LanguageLevel level = MavenModelUtil.getLanguageLevel(this.myMavenProject, () -> importData.getModuleData().getSourceLanguageLevel());
        this.configLanguageLevel(level);
    }

    public void preConfigFacets(Map<Class<? extends MavenImporter>, CountAndTime> counters) {
        MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), () -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            for (MavenImporter importer : this.getSuitableImporters()) {
                try {
                    MavenProjectChanges changes;
                    if (this.myMavenProjectChanges == null) {
                        if (importer.processChangedModulesOnly()) continue;
                        changes = MavenProjectChanges.NONE;
                    } else {
                        changes = this.myMavenProjectChanges;
                    }
                    if (importer.getModuleType() != moduleType) continue;
                    MavenModuleImporter.measureImporterTime(importer, counters, true, () -> importer.preProcess(this.myModule, this.myMavenProject, changes, this.myProviderForExtensions));
                }
                catch (Exception e) {
                    MavenLog.LOG.error((Throwable)e);
                }
            }
        });
    }

    public void configFacets(List<MavenProjectsProcessorTask> postTasks, Map<Class<? extends MavenImporter>, CountAndTime> counters) {
        MavenUtil.smartInvokeAndWait(this.myModule.getProject(), ModalityState.defaultModalityState(), () -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (MavenImporter importer : this.getSuitableImporters()) {
                    MavenProjectChanges changes;
                    if (this.myMavenProjectChanges == null) {
                        if (importer.processChangedModulesOnly()) continue;
                        changes = MavenProjectChanges.NONE;
                    } else {
                        changes = this.myMavenProjectChanges;
                    }
                    if (importer.getModuleType() != moduleType) continue;
                    try {
                        MavenModuleImporter.measureImporterTime(importer, counters, false, () -> importer.process(this.myProviderForExtensions, this.myModule, this.myRootModelAdapter, this.myMavenTree, this.myMavenProject, changes, this.myMavenProjectToModuleName, postTasks));
                    }
                    catch (Exception e) {
                        MavenLog.LOG.error((Throwable)e);
                    }
                }
            });
        });
    }

    public void postConfigFacets(Map<Class<? extends MavenImporter>, CountAndTime> counters) {
        MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), () -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            for (MavenImporter importer : this.getSuitableImporters()) {
                try {
                    MavenProjectChanges changes;
                    if (this.myMavenProjectChanges == null) {
                        if (importer.processChangedModulesOnly()) continue;
                        changes = MavenProjectChanges.NONE;
                    } else {
                        changes = this.myMavenProjectChanges;
                    }
                    if (importer.getModuleType() != moduleType) continue;
                    MavenModuleImporter.measureImporterTime(importer, counters, false, () -> importer.postProcess(this.myModule, this.myMavenProject, changes, this.myProviderForExtensions));
                }
                catch (Exception e) {
                    MavenLog.LOG.error((Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void measureImporterTime(MavenImporter importer, Map<Class<? extends MavenImporter>, CountAndTime> counters, boolean increaseModuleCounter, Runnable r) {
        long before;
        block3: {
            before = System.nanoTime();
            try {
                r.run();
                CountAndTime countAndTime = counters.computeIfAbsent(importer.getClass(), __ -> new CountAndTime());
                if (!increaseModuleCounter) break block3;
                ++countAndTime.count;
            }
            catch (Throwable throwable) {
                CountAndTime countAndTime = counters.computeIfAbsent(importer.getClass(), __ -> new CountAndTime());
                if (increaseModuleCounter) {
                    ++countAndTime.count;
                }
                countAndTime.timeNano += System.nanoTime() - before;
                throw throwable;
            }
        }
        countAndTime.timeNano += System.nanoTime() - before;
    }

    private List<MavenImporter> getSuitableImporters() {
        return this.myMavenProject.getSuitableImporters();
    }

    private void configFolders() {
        new MavenFoldersImporter(this.myMavenProject, this.mySettings, this.myRootModelAdapter).config();
    }

    private void configDependencies() {
        HashSet dependencyTypesFromSettings = new HashSet();
        if (!((Boolean)ReadAction.compute(() -> {
            if (this.myModule.getProject().isDisposed()) {
                return false;
            }
            dependencyTypesFromSettings.addAll(MavenProjectsManager.getInstance(this.myModule.getProject()).getImportingSettings().getDependencyTypesAsSet());
            return true;
        })).booleanValue()) {
            return;
        }
        for (MavenArtifact artifact : this.myMavenProject.getDependencies()) {
            String dependencyType = artifact.getType();
            if (!dependencyTypesFromSettings.contains(dependencyType) && !this.myMavenProject.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT).contains(dependencyType)) continue;
            DependencyScope scope = MavenModuleImporter.selectScope(artifact.getScope());
            MavenProject depProject = this.myMavenTree.findProject(artifact.getMavenId());
            if (depProject != null) {
                String classifier;
                if (depProject == this.myMavenProject) continue;
                String moduleName = this.myMavenProjectToModuleName.get(depProject);
                if (moduleName == null || this.myMavenTree.isIgnored(depProject)) {
                    MavenArtifact projectsArtifactInRepository = MavenModuleImporter.createCopyForLocalRepo(artifact, this.myMavenProject);
                    this.myRootModelAdapter.addLibraryDependency(projectsArtifactInRepository, scope, this.myModifiableModelsProvider, this.myMavenProject);
                    continue;
                }
                boolean isTestJar = "test-jar".equals(dependencyType) || "tests".equals(artifact.getClassifier());
                this.myRootModelAdapter.addModuleDependency(moduleName, scope, isTestJar);
                Element buildHelperCfg = depProject.getPluginGoalConfiguration("org.codehaus.mojo", "build-helper-maven-plugin", "attach-artifact");
                if (buildHelperCfg != null) {
                    this.addAttachArtifactDependency(buildHelperCfg, scope, depProject, artifact);
                }
                if ((classifier = artifact.getClassifier()) == null || !IMPORTED_CLASSIFIERS.contains(classifier) || isTestJar || "system".equals(artifact.getScope()) || "false".equals(System.getProperty("idea.maven.classifier.dep"))) continue;
                MavenArtifact a = MavenModuleImporter.createCopyForLocalRepo(artifact, this.myMavenProject);
                this.myRootModelAdapter.addLibraryDependency(a, scope, this.myModifiableModelsProvider, this.myMavenProject);
                continue;
            }
            if ("system".equals(artifact.getScope())) {
                this.myRootModelAdapter.addSystemDependency(artifact, scope);
                continue;
            }
            if ("bundle".equals(dependencyType)) {
                artifact = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), "jar", artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), "jar", null, this.myMavenProject.getLocalRepository(), false, false);
            }
            LibraryOrderEntry libraryOrderEntry = this.myRootModelAdapter.addLibraryDependency(artifact, scope, this.myModifiableModelsProvider, this.myMavenProject);
            this.myModifiableModelsProvider.trySubstitute(this.myModule, libraryOrderEntry, new ProjectId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        }
        this.configSurefirePlugin();
    }

    public void configDependencies(@NotNull List<MavenImportDependency<?>> dependencies) {
        if (dependencies == null) {
            MavenModuleImporter.$$$reportNull$$$0(0);
        }
        for (MavenImportDependency<?> dependency : dependencies) {
            if (dependency instanceof SystemDependency) {
                this.myRootModelAdapter.addSystemDependency((MavenArtifact)((SystemDependency)dependency).getArtifact(), dependency.getScope());
                continue;
            }
            if (dependency instanceof LibraryDependency) {
                this.myRootModelAdapter.addLibraryDependency((MavenArtifact)((LibraryDependency)dependency).getArtifact(), dependency.getScope(), this.myModifiableModelsProvider, this.myMavenProject);
                continue;
            }
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                this.myRootModelAdapter.addModuleDependency((String)moduleDependency.getArtifact(), dependency.getScope(), moduleDependency.isTestJar());
                if (moduleDependency.getLibraryDependency() == null) continue;
                this.myRootModelAdapter.addLibraryDependency((MavenArtifact)moduleDependency.getLibraryDependency().getArtifact(), dependency.getScope(), this.myModifiableModelsProvider, this.myMavenProject);
                continue;
            }
            if (!(dependency instanceof BaseDependency)) continue;
            MavenArtifact artifact = (MavenArtifact)((BaseDependency)dependency).getArtifact();
            LibraryOrderEntry libraryOrderEntry = this.myRootModelAdapter.addLibraryDependency(artifact, dependency.getScope(), this.myModifiableModelsProvider, this.myMavenProject);
            this.myModifiableModelsProvider.trySubstitute(this.myModule, libraryOrderEntry, new ProjectId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        }
    }

    @NotNull
    public static MavenArtifact createCopyForLocalRepo(@NotNull MavenArtifact artifact, @NotNull MavenProject project2) {
        if (artifact == null) {
            MavenModuleImporter.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            MavenModuleImporter.$$$reportNull$$$0(2);
        }
        return new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), artifact.getExtension(), null, project2.getLocalRepository(), false, false);
    }

    private void configSurefirePlugin() {
        LibraryTable moduleLibraryTable = this.myRootModelAdapter.getRootModel().getModuleLibraryTable();
        Library library = moduleLibraryTable.getLibraryByName(SUREFIRE_PLUGIN_LIBRARY_NAME);
        if (library != null) {
            moduleLibraryTable.removeLibrary(library);
        }
    }

    private void addAttachArtifactDependency(@NotNull Element buildHelperCfg, @NotNull DependencyScope scope, @NotNull MavenProject mavenProject2, @NotNull MavenArtifact artifact) {
        if (buildHelperCfg == null) {
            MavenModuleImporter.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            MavenModuleImporter.$$$reportNull$$$0(4);
        }
        if (mavenProject2 == null) {
            MavenModuleImporter.$$$reportNull$$$0(5);
        }
        if (artifact == null) {
            MavenModuleImporter.$$$reportNull$$$0(6);
        }
        Library.ModifiableModel libraryModel = null;
        for (Element artifactsElement : buildHelperCfg.getChildren("artifacts")) {
            for (Element artifactElement : artifactsElement.getChildren("artifact")) {
                VirtualFile file;
                String filePath;
                String typeString = artifactElement.getChildTextTrim("type");
                if (typeString != null && !typeString.equals("jar")) continue;
                OrderRootType rootType = OrderRootType.CLASSES;
                String classifier = artifactElement.getChildTextTrim("classifier");
                if ("sources".equals(classifier)) {
                    rootType = OrderRootType.SOURCES;
                } else if ("javadoc".equals(classifier)) {
                    rootType = JavadocOrderRootType.getInstance();
                }
                if (StringUtil.isEmpty((String)(filePath = artifactElement.getChildTextTrim("file"))) || (file = VfsUtil.findRelativeFile((String)filePath, (VirtualFile)mavenProject2.getDirectoryFile())) == null || (file = JarFileSystem.getInstance().getJarRootForLocalFile(file)) == null) continue;
                if (libraryModel == null) {
                    String libraryName = MavenModuleImporter.getAttachedJarsLibName(artifact);
                    Library library = this.myModifiableModelsProvider.getLibraryByName(libraryName);
                    if (library == null) {
                        library = this.myModifiableModelsProvider.createLibrary(libraryName, MavenRootModelAdapter.getMavenExternalSource());
                    }
                    libraryModel = this.myModifiableModelsProvider.getModifiableLibraryModel(library);
                    LibraryOrderEntry entry = this.myRootModelAdapter.getRootModel().addLibraryEntry(library);
                    entry.setScope(scope);
                }
                if (libraryModel == null) continue;
                libraryModel.addRoot(file, rootType);
            }
        }
    }

    public IdeModifiableModelsProvider getModifiableModelsProvider() {
        return this.myProviderForExtensions;
    }

    public void setModifiableModelsProvider(IdeModifiableModelsProvider providerForExtensions) {
        this.myProviderForExtensions = providerForExtensions;
        MavenRootModelAdapter mavenRootModelAdapter = new MavenRootModelAdapter(new MavenRootModelAdapterLegacyImpl(this.myMavenProject, this.myModule, new ModifiableModelsProviderProxyWrapper(this.myProviderForExtensions)));
        this.setRootModelAdapter(mavenRootModelAdapter);
    }

    @NotNull
    public static String getAttachedJarsLibName(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenModuleImporter.$$$reportNull$$$0(7);
        }
        Object libraryName = artifact.getLibraryName();
        assert (((String)libraryName).startsWith("Maven: "));
        Object object = libraryName = "Maven: ATTACHED-JAR: " + ((String)libraryName).substring("Maven: ".length());
        if (object == null) {
            MavenModuleImporter.$$$reportNull$$$0(8);
        }
        return object;
    }

    @NotNull
    public static DependencyScope selectScope(String mavenScope) {
        if ("runtime".equals(mavenScope)) {
            DependencyScope dependencyScope = DependencyScope.RUNTIME;
            if (dependencyScope == null) {
                MavenModuleImporter.$$$reportNull$$$0(9);
            }
            return dependencyScope;
        }
        if ("test".equals(mavenScope)) {
            DependencyScope dependencyScope = DependencyScope.TEST;
            if (dependencyScope == null) {
                MavenModuleImporter.$$$reportNull$$$0(10);
            }
            return dependencyScope;
        }
        if ("provided".equals(mavenScope)) {
            DependencyScope dependencyScope = DependencyScope.PROVIDED;
            if (dependencyScope == null) {
                MavenModuleImporter.$$$reportNull$$$0(11);
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = DependencyScope.COMPILE;
        if (dependencyScope == null) {
            MavenModuleImporter.$$$reportNull$$$0(12);
        }
        return dependencyScope;
    }

    private void configLanguageLevel() {
        if ("false".equalsIgnoreCase(System.getProperty("idea.maven.configure.language.level"))) {
            return;
        }
        LanguageLevel level = MavenModuleImporter.getLanguageLevel(this.myMavenProject);
        this.myRootModelAdapter.setLanguageLevel(level);
    }

    private void configLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            MavenModuleImporter.$$$reportNull$$$0(13);
        }
        if ("false".equalsIgnoreCase(System.getProperty("idea.maven.configure.language.level"))) {
            return;
        }
        this.myRootModelAdapter.setLanguageLevel(level);
    }

    @Deprecated
    @NotNull
    public static LanguageLevel getLanguageLevel(MavenProject mavenProject2) {
        LanguageLevel languageLevel2 = MavenModelUtil.getSourceLanguageLevel(mavenProject2);
        if (languageLevel2 == null) {
            MavenModuleImporter.$$$reportNull$$$0(14);
        }
        return languageLevel2;
    }

    @Deprecated
    @NotNull
    public static LanguageLevel getDefaultLevel(MavenProject mavenProject2) {
        LanguageLevel languageLevel2 = MavenModelUtil.getDefaultLevel(mavenProject2);
        if (languageLevel2 == null) {
            MavenModuleImporter.$$$reportNull$$$0(15);
        }
        return languageLevel2;
    }

    public boolean isModuleDisposed() {
        return this.myModule.isDisposed();
    }

    public boolean isAggregatorMainTestModule() {
        return this.myModuleType == MavenModuleType.AGGREGATOR_MAIN_TEST;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildHelperCfg";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenModuleImporter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenModuleImporter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedJarsLibName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "selectScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configDependencies";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCopyForLocalRepo";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAttachArtifactDependency";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedJarsLibName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "configLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CountAndTime {
        int count = 0;
        long timeNano = 0L;

        CountAndTime() {
        }
    }
}

