/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigEncodingCache;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigEncodingInspection
extends LocalInspectionTool {
    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            EditorConfigEncodingInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            EditorConfigEncodingInspection.$$$reportNull$$$0(1);
        }
        if (!file.equals(EditorConfigEncodingInspection.getMainPsi(file))) {
            return null;
        }
        Project project = manager.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && Utils.isEnabled(CodeStyle.getSettings((Project)project)) && virtualFile.isWritable()) {
            if (EditorConfigEncodingInspection.isHardcodedCharsetOrFailed(virtualFile)) {
                return null;
            }
            EditorConfigEncodingCache encodingCache = EditorConfigEncodingCache.getInstance();
            if (encodingCache.isIgnored(virtualFile)) {
                return null;
            }
            EditorConfigEncodingCache.CharsetData charsetData = encodingCache.getCharsetData(file.getProject(), file.getVirtualFile(), false);
            if (charsetData != null && !virtualFile.getCharset().equals(charsetData.getCharset())) {
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)file, EditorConfigBundle.message("inspection.file.encoding.mismatch.descriptor", charsetData.getCharset().displayName()), new LocalQuickFix[]{new ApplyEditorConfigEncodingQuickFix(), new IgnoreFileQuickFix()}, ProblemHighlightType.WARNING, isOnTheFly, false)};
            }
        }
        return null;
    }

    private static boolean isHardcodedCharsetOrFailed(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EditorConfigEncodingInspection.$$$reportNull$$$0(2);
        }
        FileType fileType = virtualFile.getFileType();
        try {
            String charsetName = fileType.getCharset(virtualFile, virtualFile.contentsToByteArray());
            return charsetName != null;
        }
        catch (IOException e) {
            return true;
        }
    }

    @NotNull
    private static PsiFile getMainPsi(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            EditorConfigEncodingInspection.$$$reportNull$$$0(3);
        }
        Language baseLanguage = psiFile.getViewProvider().getBaseLanguage();
        PsiFile psiFile2 = psiFile.getViewProvider().getPsi(baseLanguage);
        if (psiFile2 == null) {
            EditorConfigEncodingInspection.$$$reportNull$$$0(4);
        }
        return psiFile2;
    }

    private static void showError(@NotNull Project project, @Nls @NotNull String title, @Nls @NotNull String message2) {
        if (project == null) {
            EditorConfigEncodingInspection.$$$reportNull$$$0(5);
        }
        if (title == null) {
            EditorConfigEncodingInspection.$$$reportNull$$$0(6);
        }
        if (message2 == null) {
            EditorConfigEncodingInspection.$$$reportNull$$$0(7);
        }
        NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup("editorconfig");
        Notifications.Bus.notify((Notification)group.createNotification(title, message2, NotificationType.ERROR), (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/EditorConfigEncodingInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigEncodingInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isHardcodedCharsetOrFailed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMainPsi";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IgnoreFileQuickFix
    implements LocalQuickFix {
        private IgnoreFileQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = EditorConfigBundle.message("inspection.file.encoding.ignore");
            if (string == null) {
                IgnoreFileQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                IgnoreFileQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                IgnoreFileQuickFix.$$$reportNull$$$0(2);
            }
            VirtualFile file = descriptor.getPsiElement().getContainingFile().getVirtualFile();
            EditorConfigEncodingCache.getInstance().setIgnored(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/editorconfig/configmanagement/EditorConfigEncodingInspection$IgnoreFileQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigEncodingInspection$IgnoreFileQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ApplyEditorConfigEncodingQuickFix
    implements LocalQuickFix {
        private ApplyEditorConfigEncodingQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = EditorConfigBundle.message("inspection.file.encoding.apply");
            if (string == null) {
                ApplyEditorConfigEncodingQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ApplyEditorConfigEncodingQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ApplyEditorConfigEncodingQuickFix.$$$reportNull$$$0(2);
            }
            VirtualFile file = descriptor.getPsiElement().getContainingFile().getVirtualFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file);
            if (document != null) {
                EditorConfigEncodingCache.getInstance().computeAndCacheEncoding(project, file);
                try {
                    LoadTextUtil.write((Project)project, (VirtualFile)file, (Object)file, (String)document.getText(), (long)document.getModificationStamp());
                }
                catch (IOException e) {
                    EditorConfigEncodingInspection.showError(project, EditorConfigBundle.message("inspection.file.encoding.save.error"), e.getLocalizedMessage());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/editorconfig/configmanagement/EditorConfigEncodingInspection$ApplyEditorConfigEncodingQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigEncodingInspection$ApplyEditorConfigEncodingQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

