/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast.api;

import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javac.ast.api.JavacNameTable;

public interface JavacRef {
    public static final JavacRef[] EMPTY_ARRAY = new JavacRef[0];

    @NotNull
    public String getName();

    public Set<Modifier> getModifiers();

    @NotNull
    public String getOwnerName();

    @Nullable
    public ImportProperties getImportProperties();

    public static class JavacElementFieldImpl
    extends JavacElementRefBase
    implements JavacField {
        @Nullable
        private final String myContainingClass;

        public JavacElementFieldImpl(@Nullable String containingClass, @NotNull Element element, @Nullable Element qualifier, JavacNameTable nameTableCache, ImportProperties importProps) {
            if (element == null) {
                JavacElementFieldImpl.$$$reportNull$$$0(0);
            }
            super(element, qualifier, nameTableCache, importProps);
            this.myContainingClass = containingClass != null && !containingClass.isEmpty() ? containingClass : null;
        }

        @Override
        @Nullable
        public String getContainingClass() {
            return this.myContainingClass;
        }

        @Override
        @Nullable
        public String getDescriptor() {
            return this.calcDescriptor(this.myOriginalElement.asType());
        }

        private String calcDescriptor(TypeMirror type) {
            return (String)new SimpleTypeVisitor6<String, Void>(null){

                @Override
                public String visitPrimitive(PrimitiveType t, Void aVoid) {
                    switch (t.getKind()) {
                        case BYTE: {
                            return "B";
                        }
                        case CHAR: {
                            return "C";
                        }
                        case DOUBLE: {
                            return "D";
                        }
                        case FLOAT: {
                            return "F";
                        }
                        case INT: {
                            return "I";
                        }
                        case LONG: {
                            return "J";
                        }
                        case SHORT: {
                            return "S";
                        }
                        case BOOLEAN: {
                            return "Z";
                        }
                    }
                    return null;
                }

                @Override
                public String visitArray(ArrayType t, Void aVoid) {
                    return "[" + (String)this.visit(t.getComponentType());
                }

                @Override
                public String visitDeclared(DeclaredType t, Void aVoid) {
                    return "L" + JavacElementFieldImpl.this.myNameTableCache.parseBinaryName(t.asElement()).replace('.', '/') + ";";
                }

                @Override
                public String visitUnknown(TypeMirror t, Void param) {
                    return null;
                }
            }.visit(type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/javac/ast/api/JavacRef$JavacElementFieldImpl", "<init>"));
        }
    }

    public static class JavacElementMethodImpl
    extends JavacElementRefBase
    implements JavacMethod {
        @Nullable
        private final String myContainingClass;

        public JavacElementMethodImpl(@Nullable String containingClass, @NotNull Element element, @Nullable Element qualifier, JavacNameTable nameTableCache, ImportProperties importProps) {
            if (element == null) {
                JavacElementMethodImpl.$$$reportNull$$$0(0);
            }
            super(element, qualifier, nameTableCache, importProps);
            this.myContainingClass = containingClass != null && !containingClass.isEmpty() ? containingClass : null;
        }

        @Override
        @Nullable
        public String getContainingClass() {
            return this.myContainingClass;
        }

        @Override
        public byte getParamCount() {
            return (byte)((ExecutableElement)this.myOriginalElement).getParameters().size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/javac/ast/api/JavacRef$JavacElementMethodImpl", "<init>"));
        }
    }

    public static class JavacElementClassImpl
    extends JavacElementRefBase
    implements JavacClass {
        public JavacElementClassImpl(@NotNull Element element, @Nullable Element qualifier, JavacNameTable nameTableCache, ImportProperties importProps) {
            if (element == null) {
                JavacElementClassImpl.$$$reportNull$$$0(0);
            }
            super(element, qualifier, nameTableCache, importProps);
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myNameTableCache.parseBinaryName(this.myOriginalElement);
            if (string == null) {
                JavacElementClassImpl.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isAnonymous() {
            return this.myOriginalElement.getSimpleName().contentEquals("");
        }

        @Override
        public boolean isPackageInfo() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javac/ast/api/JavacRef$JavacElementClassImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javac/ast/api/JavacRef$JavacElementClassImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class JavacElementRefBase
    implements JavacRef {
        @NotNull
        protected final Element myOriginalElement;
        @Nullable
        private final Element myQualifier;
        protected final JavacNameTable myNameTableCache;
        private final ImportProperties myImportProps;

        protected JavacElementRefBase(@NotNull Element element, @Nullable Element qualifier, JavacNameTable nameTableCache, ImportProperties importProps) {
            if (element == null) {
                JavacElementRefBase.$$$reportNull$$$0(0);
            }
            this.myOriginalElement = element;
            this.myQualifier = qualifier;
            this.myNameTableCache = nameTableCache;
            this.myImportProps = importProps;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myNameTableCache.parseName(this.myOriginalElement.getSimpleName());
            if (string == null) {
                JavacElementRefBase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.myOriginalElement.getModifiers();
        }

        @Override
        @NotNull
        public String getOwnerName() {
            String string = this.myNameTableCache.parseBinaryName(this.myQualifier != null ? this.myQualifier : this.myOriginalElement.getEnclosingElement());
            if (string == null) {
                JavacElementRefBase.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        public ImportProperties getImportProperties() {
            return this.myImportProps;
        }

        @Nullable
        public static JavacElementRefBase fromElement(@Nullable String containingClass, Element element, Element qualifier, JavacNameTable nameTableCache) {
            return JavacElementRefBase.fromElement(containingClass, element, qualifier, nameTableCache, null);
        }

        @Nullable
        public static JavacElementRefBase fromElement(@Nullable String containigClass, Element element, Element qualifier, JavacNameTable nameTableCache, @Nullable ImportProperties importProps) {
            TypeMirror type;
            if (qualifier != null && !JavacElementRefBase.isValidType(type = qualifier.asType())) {
                return null;
            }
            if (element instanceof TypeElement) {
                return new JavacElementClassImpl(element, qualifier, nameTableCache, importProps);
            }
            if (element instanceof VariableElement) {
                if (qualifier == null && !JavacElementRefBase.checkEnclosingElement(element)) {
                    return null;
                }
                return new JavacElementFieldImpl(containigClass, element, qualifier, nameTableCache, importProps);
            }
            if (element instanceof ExecutableElement) {
                if (qualifier == null && !JavacElementRefBase.checkEnclosingElement(element)) {
                    return null;
                }
                return new JavacElementMethodImpl(containigClass, element, qualifier, nameTableCache, importProps);
            }
            if (element == null || element.getKind() == ElementKind.OTHER || element.getKind() == ElementKind.TYPE_PARAMETER) {
                return null;
            }
            throw new AssertionError((Object)("unexpected element: " + element + " class: " + element.getClass()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavacElementRefBase base = (JavacElementRefBase)o;
            return this.myOriginalElement == base.myOriginalElement && this.myQualifier == base.myQualifier;
        }

        public int hashCode() {
            int hashCode = this.myOriginalElement.hashCode();
            if (this.myQualifier != null) {
                hashCode += this.myQualifier.hashCode();
            }
            return hashCode;
        }

        private static boolean checkEnclosingElement(Element element) {
            Element enclosingElement = element.getEnclosingElement();
            if (enclosingElement == null) {
                return false;
            }
            TypeMirror type = enclosingElement.asType();
            return JavacElementRefBase.isValidType(type);
        }

        private static boolean isValidType(TypeMirror type) {
            return type != null && type.getKind() != TypeKind.NONE && type.getKind() != TypeKind.OTHER;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javac/ast/api/JavacRef$JavacElementRefBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javac/ast/api/JavacRef$JavacElementRefBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnerName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class JavacFieldImpl
    extends JavacRefBase
    implements JavacField {
        @Nullable
        private final String myContainingClass;
        private final String myOwnerName;
        private final String myDescriptor;

        public JavacFieldImpl(@Nullable String containingClass, String ownerName, Set<Modifier> modifiers, String name, String descriptor) {
            super(name, modifiers);
            this.myContainingClass = containingClass != null && !containingClass.isEmpty() ? containingClass : null;
            this.myOwnerName = ownerName;
            this.myDescriptor = descriptor != null && !descriptor.isEmpty() ? descriptor : null;
        }

        @Override
        @Nullable
        public String getContainingClass() {
            return this.myContainingClass;
        }

        @Override
        @NotNull
        public String getOwnerName() {
            String string = this.myOwnerName;
            if (string == null) {
                JavacFieldImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public String getDescriptor() {
            return this.myDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacRef$JavacFieldImpl", "getOwnerName"));
        }
    }

    public static class JavacMethodImpl
    extends JavacRefBase
    implements JavacMethod {
        @Nullable
        private final String myContainingClass;
        private final String myOwnerName;
        private final byte myParamCount;

        public JavacMethodImpl(@Nullable String containingClass, String ownerName, byte paramCount, Set<Modifier> modifiers, String name) {
            super(name, modifiers);
            this.myContainingClass = containingClass != null && !containingClass.isEmpty() ? containingClass : null;
            this.myOwnerName = ownerName;
            this.myParamCount = paramCount;
        }

        @Override
        @Nullable
        public String getContainingClass() {
            return this.myContainingClass;
        }

        @Override
        public byte getParamCount() {
            return this.myParamCount;
        }

        @Override
        @NotNull
        public String getOwnerName() {
            String string = this.myOwnerName;
            if (string == null) {
                JavacMethodImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacRef$JavacMethodImpl", "getOwnerName"));
        }
    }

    public static class JavacClassImpl
    extends JavacRefBase
    implements JavacClass {
        private final boolean myAnonymous;

        public JavacClassImpl(boolean anonymous, Set<Modifier> modifiers, String name) {
            super(name, modifiers);
            this.myAnonymous = anonymous;
        }

        @Override
        @NotNull
        public String getOwnerName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAnonymous() {
            return this.myAnonymous;
        }

        @Override
        public boolean isPackageInfo() {
            String name = this.getName();
            return name.endsWith(".package-info") || "package-info".equals(name);
        }
    }

    public static abstract class JavacRefBase
    implements JavacRef {
        private final String myName;
        private final Set<Modifier> myModifiers;

        protected JavacRefBase(String name, Set<Modifier> modifiers) {
            this.myName = name;
            this.myModifiers = modifiers;
        }

        @Override
        @NotNull
        public final String getName() {
            String string = this.myName;
            if (string == null) {
                JavacRefBase.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public final Set<Modifier> getModifiers() {
            return this.myModifiers;
        }

        @Override
        @Nullable
        public ImportProperties getImportProperties() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacRef$JavacRefBase", "getName"));
        }
    }

    public static interface JavacField
    extends JavacRef {
        @Nullable
        public String getDescriptor();

        @Nullable
        public String getContainingClass();
    }

    public static interface JavacMethod
    extends JavacRef {
        public byte getParamCount();

        @Nullable
        public String getContainingClass();
    }

    public static interface JavacClass
    extends JavacRef {
        public boolean isAnonymous();

        public boolean isPackageInfo();
    }

    public static abstract class ImportProperties {
        public abstract boolean isStatic();

        public abstract boolean isOnDemand();

        public static ImportProperties create(final boolean isStatic, final boolean isOnDemand) {
            return new ImportProperties(){

                @Override
                public boolean isStatic() {
                    return isStatic;
                }

                @Override
                public boolean isOnDemand() {
                    return isOnDemand;
                }
            };
        }
    }
}

