/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.ide.common.util.PathString;
import com.android.ide.common.util.PathStringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u001a4\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0018\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\f0\u000b\u001a.\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\r\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0007\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0002\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u0019"}, d2={"RESOURCE_PROTOCOLS", "", "", "[Ljava/lang/String;", "fileNameToResourceName", "fileName", "findUnusedResources", "", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "resources", "rootsConsumer", "Lkotlin/Function1;", "", "Ljava/util/function/Consumer;", "isInvalidResourceFieldNameCharacter", "", "c", "", "resourceNameToFieldName", "resourceName", "stripPrefixFromId", "id", "toFileResourcePathString", "Lcom/android/ide/common/util/PathString;", "resourcePath", "android.sdktools.sdk-common"})
@JvmName(name="ResourcesUtil")
public final class ResourcesUtil {
    @NotNull
    private static final String[] RESOURCE_PROTOCOLS;

    @NotNull
    public static final String resourceNameToFieldName(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        int i = 0;
        int n = resourceName.length();
        while (i < n) {
            char c = resourceName.charAt(i);
            if (ResourcesUtil.isInvalidResourceFieldNameCharacter(c)) {
                char[] buffer = new char[resourceName.length()];
                String string = resourceName;
                int n2 = 0;
                int n3 = 0;
                boolean bl = false;
                string.getChars(n3, i, buffer, n2);
                buffer[i] = 95;
                int n4 = i + 1;
                if (n4 < n) {
                    do {
                        int j;
                        int n5 = buffer[j] = ResourcesUtil.isInvalidResourceFieldNameCharacter(c = resourceName.charAt(j = n4++)) ? 95 : (int)c;
                    } while (n4 < n);
                }
                n4 = 0;
                return new String(buffer);
            }
            int n6 = i;
            i = n6 + 1;
        }
        return resourceName;
    }

    public static final boolean isInvalidResourceFieldNameCharacter(char c) {
        return c == ':' || c == '.' || c == '-';
    }

    @NotNull
    public static final String fileNameToResourceName(@NotNull String fileName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        int lastExtension = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (lastExtension <= 0) {
            string = fileName;
        } else if (StringsKt.endsWith((String)fileName, (String)".9.png", (boolean)true)) {
            if (fileName.length() > ".9.png".length()) {
                String string2 = fileName;
                int n = 0;
                int n2 = fileName.length() - ".9.png".length();
                boolean bl = false;
                String string3 = string2.substring(n, n2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = fileName;
            }
        } else {
            String string4 = fileName;
            int n = 0;
            boolean bl = false;
            String string5 = string4.substring(n, lastExtension);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    @NotNull
    public static final List<ResourceUsageModel.Resource> findUnusedResources(@NotNull List<? extends ResourceUsageModel.Resource> resources, @NotNull Consumer<List<ResourceUsageModel.Resource>> rootsConsumer) {
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        Intrinsics.checkNotNullParameter(rootsConsumer, (String)"rootsConsumer");
        return ResourcesUtil.findUnusedResources(resources, (Function1<? super List<? extends ResourceUsageModel.Resource>, Unit>)((Function1)new Function1<List<? extends ResourceUsageModel.Resource>, Unit>(rootsConsumer){
            final /* synthetic */ Consumer<List<ResourceUsageModel.Resource>> $rootsConsumer;
            {
                this.$rootsConsumer = $rootsConsumer;
                super(1);
            }

            public final void invoke(@NotNull List<? extends ResourceUsageModel.Resource> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$rootsConsumer.accept(it);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ResourceUsageModel.Resource> findUnusedResources(@NotNull List<? extends ResourceUsageModel.Resource> resources, @NotNull Function1<? super List<? extends ResourceUsageModel.Resource>, Unit> rootsConsumer) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        Intrinsics.checkNotNullParameter(rootsConsumer, (String)"rootsConsumer");
        Set<ResourceUsageModel.Resource> seen = Collections.newSetFromMap(new IdentityHashMap());
        Iterable $this$filter$iv = resources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv$iv;
            boolean bl = false;
            if (!(it.isReachable() || it.isKeep() || it.isPublic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List roots = (List)destination$iv$iv;
        rootsConsumer.invoke((Object)roots);
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv;
            boolean bl = false;
            ResourcesUtil.findUnusedResources$visit(seen, it);
        }
        return SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)resources), (Function1)findUnusedResources.3.INSTANCE), (Function1)findUnusedResources.4.INSTANCE), (Function1)findUnusedResources.5.INSTANCE), (Function1)findUnusedResources.6.INSTANCE));
    }

    @Nullable
    public static final PathString toFileResourcePathString(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        for (String protocol : RESOURCE_PROTOCOLS) {
            if (!StringsKt.startsWith$default((String)resourcePath, (String)protocol, (boolean)false, (int)2, null) || resourcePath.length() <= protocol.length() || resourcePath.charAt(protocol.length()) != ':') continue;
            int prefixLength = protocol.length() + 1;
            if (StringsKt.startsWith$default((String)resourcePath, (String)"//", (int)prefixLength, (boolean)false, (int)4, null)) {
                prefixLength += "//".length();
            }
            String string = resourcePath;
            boolean bl = false;
            String string2 = string.substring(prefixLength);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            return new PathString(protocol, string2);
        }
        File file = new File(resourcePath);
        return file.isFile() ? PathStringUtil.toPathString(file) : null;
    }

    @Deprecated(message="Use `ResourceUrl.parse` instead and handle wrong resource type, invalid name, trailing whitespace etc.", replaceWith=@ReplaceWith(expression="ResourceUrl.parse(id)?.name ?: id", imports={"com.android.resources.ResourceUrl"}))
    @NotNull
    public static final String stripPrefixFromId(@NotNull String id) {
        String string;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (StringsKt.startsWith$default((String)id, (String)"@+id/", (boolean)false, (int)2, null)) {
            String string2 = id;
            int n = "@+id/".length();
            boolean bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default((String)id, (String)"@id/", (boolean)false, (int)2, null)) {
            String string4 = id;
            int n = "@id/".length();
            boolean bl = false;
            String string5 = string4.substring(n);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = id;
        }
        return string;
    }

    private static final void findUnusedResources$visit(Set<ResourceUsageModel.Resource> seen, ResourceUsageModel.Resource resource) {
        if (seen.contains(resource)) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue(seen, (String)"seen");
        List<ResourceUsageModel.Resource> list = (List<ResourceUsageModel.Resource>)((Object)seen);
        boolean bl = false;
        list.add(resource);
        resource.setReachable(true);
        list = resource.references;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                ResourcesUtil.findUnusedResources$visit(seen, it);
            }
        }
    }

    static {
        String[] stringArray = new String[]{"apk", "jar", "file"};
        RESOURCE_PROTOCOLS = stringArray;
    }
}

