/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.KnownNamespacesMap;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.google.common.base.Supplier;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\t*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0002\u00a8\u0006\u0011"}, d2={"getConfiguredResources", "Lcom/android/ide/common/resources/ResourceValueMap;", "Lcom/android/ide/common/resources/ResourceRepository;", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "type", "Lcom/android/resources/ResourceType;", "referenceConfig", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "Lcom/google/common/collect/Table;", "getConfiguredValue", "Lcom/android/ide/common/rendering/api/ResourceValue;", "name", "", "getLocales", "Ljava/util/SortedSet;", "Lcom/android/ide/common/resources/configuration/LocaleQualifier;", "android.sdktools.sdk-common"})
@JvmName(name="ResourceRepositoryUtil")
public final class ResourceRepositoryUtil {
    @NotNull
    public static final Table<ResourceNamespace, ResourceType, ResourceValueMap> getConfiguredResources(@NotNull ResourceRepository $this$getConfiguredResources, @NotNull FolderConfiguration referenceConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$getConfiguredResources, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)referenceConfig, (String)"referenceConfig");
        Set<ResourceNamespace> set = $this$getConfiguredResources.getNamespaces();
        Intrinsics.checkNotNullExpressionValue(set, (String)"namespaces");
        Map backingMap = KnownNamespacesMap.Companion.canContainAll((Collection<? extends ResourceNamespace>)set) ? (Map)new KnownNamespacesMap() : (Map)new HashMap();
        Table result2 = Tables.newCustomTable((Map)backingMap, (Supplier)getConfiguredResources.result.1.INSTANCE);
        for (ResourceNamespace namespace : $this$getConfiguredResources.getNamespaces()) {
            boolean bl = $this$getConfiguredResources.getNamespaces().size() == 1 || namespace != ResourceNamespace.ANDROID;
            int n = 0;
            int n2 = 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            for (ResourceType type : ResourceType.values()) {
                Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"namespace");
                result2.put((Object)namespace, (Object)type, (Object)ResourceRepositoryUtil.getConfiguredResources($this$getConfiguredResources, namespace, type, referenceConfig));
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
        return result2;
    }

    @NotNull
    public static final ResourceValueMap getConfiguredResources(@NotNull ResourceRepository $this$getConfiguredResources, @NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull FolderConfiguration referenceConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$getConfiguredResources, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)referenceConfig, (String)"referenceConfig");
        Map itemsByName = $this$getConfiguredResources.getResources(namespace, type).asMap();
        ResourceValueMap resourceValueMap = ResourceValueMap.createWithExpectedSize(itemsByName.size());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)resourceValueMap), (String)"createWithExpectedSize(itemsByName.size)");
        ResourceValueMap result2 = resourceValueMap;
        for (Collection itemGroup : itemsByName.values()) {
            ResourceValue value;
            ResourceItem match2 = (ResourceItem)referenceConfig.findMatchingConfigurable(itemGroup);
            if (match2 == null || (value = match2.getResourceValue()) == null) continue;
            Map map = (Map)((Object)result2);
            String string = match2.getName();
            boolean bl = false;
            map.put(string, value);
        }
        return result2;
    }

    @Nullable
    public static final ResourceValue getConfiguredValue(@NotNull ResourceRepository $this$getConfiguredValue, @NotNull ResourceType type, @NotNull String name, @NotNull FolderConfiguration referenceConfig) {
        ResourceItem match2;
        Intrinsics.checkNotNullParameter((Object)$this$getConfiguredValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)referenceConfig, (String)"referenceConfig");
        List<ResourceItem> list = $this$getConfiguredValue.getResources(ResourceNamespace.TODO(), type, name);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getResources(ResourceNamespace.TODO(), type, name)");
        List<ResourceItem> items = list;
        ResourceItem resourceItem = match2 = (ResourceItem)referenceConfig.findMatchingConfigurable((Collection)items);
        return resourceItem == null ? null : resourceItem.getResourceValue();
    }

    @NotNull
    public static final SortedSet<LocaleQualifier> getLocales(@NotNull ResourceRepository $this$getLocales) {
        Intrinsics.checkNotNullParameter((Object)$this$getLocales, (String)"<this>");
        TreeSet<LocaleQualifier> locales = new TreeSet<LocaleQualifier>();
        for (SingleNamespaceResourceRepository repository : $this$getLocales.getLeafResourceRepositories()) {
            repository.accept(new ResourceVisitor(locales){
                final /* synthetic */ TreeSet<LocaleQualifier> $locales;
                {
                    this.$locales = $locales;
                }

                @NotNull
                public final ResourceVisitor.VisitResult visit(@NotNull ResourceItem it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    LocaleQualifier locale = it.getConfiguration().getLocaleQualifier();
                    if (locale != null) {
                        this.$locales.add(locale);
                    }
                    return ResourceVisitor.VisitResult.CONTINUE;
                }
            });
        }
        return locales;
    }
}

