/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.utils.ILogger;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ(\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/ide/common/build/ListingFileRedirect;", "", "()V", "REDIRECT_FILE_NAME", "", "REDIRECT_MARKER", "REDIRECT_PROPERTY_NAME", "getListingFile", "Ljava/io/File;", "inputFile", "logger", "Lcom/android/utils/ILogger;", "maybeExtractRedirectedFile", "redirectFile", "redirectFileContent", "writeRedirect", "", "listingFile", "into", "android.sdktools.sdk-common"})
public final class ListingFileRedirect {
    @NotNull
    public static final ListingFileRedirect INSTANCE = new ListingFileRedirect();
    @NotNull
    public static final String REDIRECT_MARKER = "#- File Locator -";
    @NotNull
    public static final String REDIRECT_PROPERTY_NAME = "listingFile";
    @NotNull
    public static final String REDIRECT_FILE_NAME = "redirect.txt";

    private ListingFileRedirect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeRedirect(@NotNull File listingFile, @NotNull File into) {
        Intrinsics.checkNotNullParameter((Object)listingFile, (String)REDIRECT_PROPERTY_NAME);
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        Closeable closeable = new PrintWriter(into);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl3 = false;
            it.println(REDIRECT_MARKER);
            File file = into.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"into.parentFile");
            String string = FilesKt.relativeTo((File)listingFile, (File)file).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"listingFile.relativeTo(into.parentFile).path");
            it.println(Intrinsics.stringPlus((String)"listingFile=", (Object)StringsKt.replace$default((String)string, (String)"\\", (String)"/", (boolean)false, (int)4, null)));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public final File maybeExtractRedirectedFile(@NotNull File redirectFile, @Nullable String redirectFileContent, @Nullable ILogger logger) {
        File file;
        String fileContent;
        Intrinsics.checkNotNullParameter((Object)redirectFile, (String)"redirectFile");
        String string = redirectFileContent;
        String string2 = fileContent = string == null ? FilesKt.readText$default((File)redirectFile, null, (int)1, null) : string;
        if (StringsKt.startsWith$default((String)fileContent, (String)REDIRECT_MARKER, (boolean)false, (int)2, null)) {
            string = logger;
            if (string != null) {
                string.info("Redirect file detected", new Object[0]);
            }
            Object object = new Properties();
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            ((Properties)it).load(new StringReader(fileContent));
            Properties fileLocator = object;
            object = fileLocator.getProperty(REDIRECT_PROPERTY_NAME);
            bl = false;
            bl2 = false;
            it = object;
            boolean bl4 = false;
            Object object2 = logger;
            if (object2 != null) {
                Object[] objectArray = new Object[]{it};
                object2.info("Redirect file pointing to %s", objectArray);
            }
            object2 = redirectFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"redirectFile.parentFile");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            file = FilesKt.resolve((File)object2, (String)it);
        } else {
            string = logger;
            if (string != null) {
                string.info("No redirect file present, should be output.json", new Object[0]);
            }
            file = null;
        }
        return file;
    }

    public static /* synthetic */ File maybeExtractRedirectedFile$default(ListingFileRedirect listingFileRedirect, File file, String string, ILogger iLogger, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            iLogger = null;
        }
        return listingFileRedirect.maybeExtractRedirectedFile(file, string, iLogger);
    }

    @NotNull
    public final File getListingFile(@NotNull File inputFile, @Nullable ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        File file = ListingFileRedirect.maybeExtractRedirectedFile$default(this, inputFile, null, logger, 2, null);
        return file == null ? inputFile : file;
    }

    public static /* synthetic */ File getListingFile$default(ListingFileRedirect listingFileRedirect, File file, ILogger iLogger, int n, Object object) {
        if ((n & 2) != 0) {
            iLogger = null;
        }
        return listingFileRedirect.getListingFile(file, iLogger);
    }
}

