/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.parcel.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.parcel.ParcelableDeclarationCheckerKt;
import org.jetbrains.kotlin.android.parcel.quickfixes.AbstractParcelableQuickFix;
import org.jetbrains.kotlin.android.parcel.quickfixes.ParcelMigrateToParcelizeQuickFix;
import org.jetbrains.kotlin.android.parcel.quickfixes.ParcelMigrateToParcelizeQuickFix$Companion$findCreatorClass$;
import org.jetbrains.kotlin.android.parcel.quickfixes.ParcelMigrateToParcelizeQuickFix$Companion$findFunction$;
import org.jetbrains.kotlin.android.parcel.quickfixes.ParcelMigrateToParcelizeQuickFix$invoke$;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\f\r\u000eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/android/parcel/quickfixes/ParcelMigrateToParcelizeQuickFix;", "Lorg/jetbrains/kotlin/android/parcel/quickfixes/AbstractParcelableQuickFix;", "Lorg/jetbrains/kotlin/psi/KtClass;", "function", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "getText", "", "invoke", "", "ktPsiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "parcelableClass", "Companion", "FactoryForCREATOR", "FactoryForWrite", "intellij.android.kotlin.extensions.common"})
public final class ParcelMigrateToParcelizeQuickFix
extends AbstractParcelableQuickFix<KtClass> {
    private static final FqName PARCELER_FQNAME;
    private static final Name PARCELER_WRITE_FUNCTION_NAME;
    private static final Name PARCELER_CREATE_FUNCTION_NAME;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getText() {
        return "Migrate to ''Parceler'' companion object";
    }

    @Override
    public void invoke(@NotNull KtPsiFactory ktPsiFactory, @NotNull KtClass parcelableClass) {
        Object createFunction;
        Object anchor$iv;
        KtClassOrObject this_$iv;
        Object object;
        KtFunction newFunction;
        boolean $i$f$any;
        KtNamedFunction ktNamedFunction;
        KtParameterList it;
        boolean bl;
        KtParameterList ktParameterList2;
        String parcelerTypeArg;
        BindingContext bindingContext;
        Pair parcelerObject;
        block53: {
            Intrinsics.checkNotNullParameter((Object)ktPsiFactory, (String)"ktPsiFactory");
            Intrinsics.checkNotNullParameter((Object)parcelableClass, (String)"parcelableClass");
            Pair pair = ParcelMigrateToParcelizeQuickFix.Companion.findParcelerCompanionObject(parcelableClass);
            if (pair == null || (pair = (KtObjectDeclaration)pair.getFirst()) == null) {
                pair = PsiModificationUtilsKt.getOrCreateCompanionObject((KtClass)parcelableClass);
            }
            parcelerObject = pair;
            bindingContext = ResolutionUtils.analyze((KtElement)((KtElement)parcelerObject), (BodyResolveMode)BodyResolveMode.PARTIAL);
            String string = parcelableClass.getName();
            if (string == null) {
                ParcelMigrateToParcelizeQuickFix parcelMigrateToParcelizeQuickFix;
                ParcelMigrateToParcelizeQuickFix $this$run = parcelMigrateToParcelizeQuickFix = this;
                boolean bl2 = false;
                LOG.error("Parceler class should not be an anonymous class");
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parcelableClass.name ?: \u2026         return\n        }");
            parcelerTypeArg = string;
            ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.CLASS, (Object)parcelerObject);
            if (classDescriptor == null) {
                ParcelMigrateToParcelizeQuickFix $this$run;
                ParcelMigrateToParcelizeQuickFix $this$run2 = $this$run = this;
                boolean ktParameterList2 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Unable to resolve parceler object for ");
                String string2 = parcelableClass.getName();
                if (string2 == null) {
                    string2 = "<unnamed Parcelable class>";
                }
                LOG.error(stringBuilder.append(string2).toString());
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"bindingContext[BindingCo\u2026         return\n        }");
            ClassDescriptor parcelerObjectDescriptor = classDescriptor;
            Sequence $this$any$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)((ClassifierDescriptor)parcelerObjectDescriptor));
            boolean $i$f$any2 = false;
            ktParameterList2 = $this$any$iv.iterator();
            while (ktParameterList2.hasNext()) {
                Object element$iv = ktParameterList2.next();
                ClassifierDescriptor it2 = (ClassifierDescriptor)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it2)), (Object)PARCELER_FQNAME)) continue;
                bl = true;
                break block53;
            }
            bl = false;
        }
        if (!bl) {
            String entryText = PARCELER_FQNAME.asString() + "<" + parcelerTypeArg + ">";
            AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)parcelerObject.addSuperTypeListEntry((KtSuperTypeListEntry)ktPsiFactory.createSuperTypeEntry(entryText)));
        }
        KtNamedFunction oldWriteToParcelFunction = ParcelMigrateToParcelizeQuickFix.Companion.findWriteToParcelOverride(parcelableClass);
        KtClassOrObject ktClassOrObject = ParcelMigrateToParcelizeQuickFix.Companion.findCreatorClass(parcelableClass);
        if (ktClassOrObject != null) {
            it = ktParameterList2 = ktClassOrObject;
            boolean bl4 = false;
            ktNamedFunction = ParcelMigrateToParcelizeQuickFix.Companion.findCreateFromParcel(it);
        } else {
            ktNamedFunction = null;
        }
        KtNamedFunction oldCreateFromParcelFunction = ktNamedFunction;
        it = parcelerObject.getSuperTypeListEntries().iterator();
        while (it.hasNext()) {
            boolean bl5;
            KtSuperTypeListEntry superTypeEntry;
            block54: {
                superTypeEntry = (KtSuperTypeListEntry)it.next();
                KotlinType kotlinType = (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.TYPE, (Object)superTypeEntry.getTypeReference());
                if (kotlinType == null || (kotlinType = kotlinType.getConstructor()) == null || (kotlinType = kotlinType.getDeclarationDescriptor()) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"bindingContext[BindingCo\u2026ionDescriptor ?: continue");
                KotlinType superClass = kotlinType;
                Sequence $this$any$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)superClass);
                $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ClassifierDescriptor it3 = (ClassifierDescriptor)element$iv;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it3)), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCELABLE_CREATOR_CLASS_FQNAME())) continue;
                    bl5 = true;
                    break block54;
                }
                bl5 = false;
            }
            if (!bl5) continue;
            parcelerObject.removeSuperTypeListEntry(superTypeEntry);
        }
        if (Intrinsics.areEqual((Object)parcelerObject.getName(), (Object)"CREATOR")) {
            PsiElement psiElement = parcelerObject.getNameIdentifier();
            if (psiElement != null) {
                psiElement.delete();
            }
        }
        if (oldWriteToParcelFunction != null) {
            KtNamedFunction ktNamedFunction2 = ParcelMigrateToParcelizeQuickFix.Companion.findWriteImplementation((KtObjectDeclaration)parcelerObject);
            if (ktNamedFunction2 != null) {
                ktNamedFunction2.delete();
            }
            PsiElement psiElement = oldWriteToParcelFunction.copy();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            newFunction = (KtFunction)psiElement;
            oldWriteToParcelFunction.delete();
            newFunction.setName(PARCELER_WRITE_FUNCTION_NAME.asString());
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)newFunction;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.OVERRIDE_KEYWORD");
            AddRemoveModifierKt.setModifierList((KtModifierListOwner)ktModifierListOwner, (KtModifierList)ktPsiFactory.createModifierList(ktModifierKeywordToken));
            TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)((KtCallableDeclaration)newFunction), (KtTypeReference)ktPsiFactory.createType(parcelerTypeArg));
            KtParameterList ktParameterList3 = newFunction.getValueParameterList();
            if (ktParameterList3 != null) {
                KtParameterList $this$apply = it = ktParameterList3;
                boolean bl7 = false;
                boolean bl8 = $i$f$any = $this$apply.getParameters().size() == 2;
                if (_Assertions.ENABLED && !$i$f$any) {
                    object = "Assertion failed";
                    throw new AssertionError(object);
                }
                Object e = $this$apply.getParameters().get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"parameters[0]");
                String string = ((KtParameter)e).getName();
                if (string == null) {
                    string = "parcel";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters[0].name ?: \"parcel\"");
                String parcelParameterName = string;
                Object e2 = $this$apply.getParameters().get(1);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"parameters[1]");
                String string3 = ((KtParameter)e2).getName();
                if (string3 == null) {
                    string3 = "flags";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters[1].name ?: \"flags\"");
                String flagsParameterName = string3;
                int element$iv = $this$apply.getParameters().size();
                int n = 0;
                while (n < element$iv) {
                    int it4 = n++;
                    boolean bl9 = false;
                    $this$apply.removeParameter(0);
                }
                $this$apply.addParameter(ktPsiFactory.createParameter(parcelParameterName + " : " + ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString()));
                $this$apply.addParameter(ktPsiFactory.createParameter(flagsParameterName + " : Int"));
            }
            this_$iv = (KtClassOrObject)parcelerObject;
            boolean $i$f$addDeclaration = false;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement2 = body$iv.getRBrace();
            if (psiElement2 == null) {
                PsiElement psiElement3 = body$iv.getLastChild();
                psiElement2 = psiElement3;
                Intrinsics.checkNotNull((Object)psiElement3);
            }
            Class[] parcelParameterName = new Class[]{PsiWhiteSpace.class};
            anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement2, (Class[])parcelParameterName);
            PsiElement psiElement4 = body$iv.addAfter((PsiElement)((KtDeclaration)newFunction), anchor$iv);
            if (psiElement4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            KtParameterList ktParameterList4 = ((KtFunction)((KtDeclaration)((KtFunction)psiElement4))).getValueParameterList();
            if (ktParameterList4 != null) {
                AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)ktParameterList4);
            }
        } else if (ParcelMigrateToParcelizeQuickFix.Companion.findWriteImplementation((KtObjectDeclaration)parcelerObject) == null) {
            String writeFunction = "fun " + parcelerTypeArg + ".write(parcel: " + ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString() + ", flags: Int) = TODO()";
            this_$iv = (KtClassOrObject)parcelerObject;
            KtDeclaration declaration$iv = (KtDeclaration)ktPsiFactory.createFunction(writeFunction);
            boolean $i$f$addDeclaration = false;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement = body$iv.getRBrace();
            if (psiElement == null) {
                PsiElement psiElement5 = body$iv.getLastChild();
                psiElement = psiElement5;
                Intrinsics.checkNotNull((Object)psiElement5);
            }
            anchor$iv = new Class[]{PsiWhiteSpace.class};
            PsiElement anchor$iv2 = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement, (Class[])anchor$iv);
            PsiElement psiElement6 = body$iv.addAfter((PsiElement)declaration$iv, anchor$iv2);
            if (psiElement6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            KtParameterList ktParameterList5 = ((KtNamedFunction)((KtDeclaration)((KtNamedFunction)psiElement6))).getValueParameterList();
            if (ktParameterList5 != null) {
                AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)ktParameterList5);
            }
        }
        if (oldCreateFromParcelFunction != null) {
            KtNamedFunction ktNamedFunction3 = ParcelMigrateToParcelizeQuickFix.Companion.findCreateImplementation((KtObjectDeclaration)parcelerObject);
            if (ktNamedFunction3 != null) {
                ktNamedFunction3.delete();
            }
            PsiElement psiElement = oldCreateFromParcelFunction.copy();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            newFunction = (KtFunction)psiElement;
            if (Intrinsics.areEqual((Object)KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)oldCreateFromParcelFunction)), (Object)parcelerObject)) {
                oldCreateFromParcelFunction.delete();
            }
            newFunction.setName(PARCELER_CREATE_FUNCTION_NAME.asString());
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)newFunction;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.OVERRIDE_KEYWORD");
            AddRemoveModifierKt.setModifierList((KtModifierListOwner)ktModifierListOwner, (KtModifierList)ktPsiFactory.createModifierList(ktModifierKeywordToken));
            TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)((KtCallableDeclaration)newFunction), null);
            KtParameterList ktParameterList6 = newFunction.getValueParameterList();
            if (ktParameterList6 != null) {
                boolean body$iv;
                KtClassOrObject $this$apply = this_$iv = ktParameterList6;
                boolean bl10 = false;
                boolean bl11 = body$iv = $this$apply.getParameters().size() == 1;
                if (_Assertions.ENABLED && !body$iv) {
                    anchor$iv = "Assertion failed";
                    throw new AssertionError(anchor$iv);
                }
                Object e = $this$apply.getParameters().get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"parameters[0]");
                String string = ((KtParameter)e).getName();
                if (string == null) {
                    string = "parcel";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters[0].name ?: \"parcel\"");
                String parcelParameterName = string;
                $this$apply.removeParameter(0);
                $this$apply.addParameter(ktPsiFactory.createParameter(parcelParameterName + " : " + ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString()));
            }
            this_$iv = (KtClassOrObject)parcelerObject;
            boolean $i$f$addDeclaration = false;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement7 = body$iv.getRBrace();
            if (psiElement7 == null) {
                PsiElement psiElement8 = body$iv.getLastChild();
                psiElement7 = psiElement8;
                Intrinsics.checkNotNull((Object)psiElement8);
            }
            Class[] parcelParameterName = new Class[]{PsiWhiteSpace.class};
            anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement7, (Class[])parcelParameterName);
            PsiElement psiElement9 = body$iv.addAfter((PsiElement)((KtDeclaration)newFunction), anchor$iv);
            if (psiElement9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            KtParameterList ktParameterList7 = ((KtFunction)((KtDeclaration)((KtFunction)psiElement9))).getValueParameterList();
            if (ktParameterList7 != null) {
                AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)ktParameterList7);
            }
        } else if (ParcelMigrateToParcelizeQuickFix.Companion.findCreateImplementation((KtObjectDeclaration)parcelerObject) == null) {
            createFunction = "override fun create(parcel: " + ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString() + "): " + parcelerTypeArg + " = TODO()";
            this_$iv = (KtClassOrObject)parcelerObject;
            KtDeclaration declaration$iv = (KtDeclaration)ktPsiFactory.createFunction((String)createFunction);
            boolean $i$f$addDeclaration = false;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement = body$iv.getRBrace();
            if (psiElement == null) {
                PsiElement psiElement10 = body$iv.getLastChild();
                psiElement = psiElement10;
                Intrinsics.checkNotNull((Object)psiElement10);
            }
            object = new Class[]{PsiWhiteSpace.class};
            PsiElement anchor$iv3 = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement, (Class[])object);
            PsiElement psiElement11 = body$iv.addAfter((PsiElement)declaration$iv, anchor$iv3);
            if (psiElement11 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            KtParameterList ktParameterList8 = ((KtNamedFunction)((KtDeclaration)((KtNamedFunction)psiElement11))).getValueParameterList();
            if (ktParameterList8 != null) {
                AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)ktParameterList8);
            }
        }
        KtNamedFunction ktNamedFunction4 = ParcelMigrateToParcelizeQuickFix.Companion.findNewArrayOverride((KtObjectDeclaration)parcelerObject);
        if (ktNamedFunction4 != null) {
            ktNamedFunction4.delete();
        }
        KtNamedFunction ktNamedFunction5 = ParcelMigrateToParcelizeQuickFix.Companion.findDescribeContentsOverride(parcelableClass);
        if (ktNamedFunction5 != null) {
            KtExpression returnExpr;
            KtNamedFunction describeContentsFunction = createFunction = ktNamedFunction5;
            boolean bl12 = false;
            KtExpression ktExpression = describeContentsFunction.getBodyExpression();
            Object object2 = returnExpr = ktExpression != null ? IfThenUtilsKt.unwrapBlockOrParenthesis((KtExpression)ktExpression) : null;
            if (returnExpr instanceof KtReturnExpression && ((KtReturnExpression)returnExpr).getTargetLabel() == null) {
                Object returnValue;
                Object object3;
                CompileTimeConstant compileTimeConstant = (CompileTimeConstant)ResolutionUtils.analyze$default((KtElement)((KtElement)returnExpr), null, (int)1, null).get((ReadOnlySlice)BindingContext.COMPILE_TIME_VALUE, (Object)((KtReturnExpression)returnExpr).getReturnedExpression());
                if (compileTimeConstant != null) {
                    SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"TypeUtils.NO_EXPECTED_TYPE");
                    object3 = compileTimeConstant.getValue((KotlinType)simpleType);
                } else {
                    object3 = returnValue = null;
                }
                if (Intrinsics.areEqual((Object)returnValue, (Object)0)) {
                    Object object4 = (SimpleFunctionDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)describeContentsFunction);
                    if (object4 != null && (object4 = object4.getOverriddenDescriptors()) != null) {
                        if (object4.size() == 1) {
                            describeContentsFunction.delete();
                        }
                    }
                }
            }
        }
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)parcelerObject.getDeclarations());
        boolean $i$f$filterIsInstance = false;
        for (KtProperty property : SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)invoke$$inlined$filterIsInstance$1.INSTANCE), (Function1)invoke.6.INSTANCE)) {
            if (ModifierListModifactorKt.findAnnotation((KtAnnotated)((KtAnnotated)property), (FqName)JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME) == null) continue;
            property.delete();
        }
    }

    public ParcelMigrateToParcelizeQuickFix(@NotNull KtClass function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super((KtElement)function);
    }

    static {
        Companion = new Companion(null);
        PARCELER_FQNAME = new FqName("kotlinx.parcelize.Parceler");
        Name name = Name.identifier((String)"write");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"write\")");
        PARCELER_WRITE_FUNCTION_NAME = name;
        Name name2 = Name.identifier((String)"create");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(\"create\")");
        PARCELER_CREATE_FUNCTION_NAME = name2;
        Logger logger = Logger.getInstance(ParcelMigrateToParcelizeQuickFix.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Parce\u2026lizeQuickFix::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/android/parcel/quickfixes/ParcelMigrateToParcelizeQuickFix$FactoryForWrite;", "Lorg/jetbrains/kotlin/android/parcel/quickfixes/AbstractParcelableQuickFix$AbstractFactory;", "()V", "intellij.android.kotlin.extensions.common"})
    public static final class FactoryForWrite
    extends AbstractParcelableQuickFix.AbstractFactory {
        @NotNull
        public static final FactoryForWrite INSTANCE;

        private FactoryForWrite() {
            super((Function1<? super Diagnostic, ? extends IntentionAction>)((Function1)1.INSTANCE));
        }

        static {
            FactoryForWrite factoryForWrite;
            INSTANCE = factoryForWrite = new FactoryForWrite();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/android/parcel/quickfixes/ParcelMigrateToParcelizeQuickFix$FactoryForCREATOR;", "Lorg/jetbrains/kotlin/android/parcel/quickfixes/AbstractParcelableQuickFix$AbstractFactory;", "()V", "intellij.android.kotlin.extensions.common"})
    public static final class FactoryForCREATOR
    extends AbstractParcelableQuickFix.AbstractFactory {
        @NotNull
        public static final FactoryForCREATOR INSTANCE;

        private FactoryForCREATOR() {
            super((Function1<? super Diagnostic, ? extends IntentionAction>)((Function1)1.INSTANCE));
        }

        static {
            FactoryForCREATOR factoryForCREATOR;
            INSTANCE = factoryForCREATOR = new FactoryForCREATOR();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0011\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0012\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0013\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0014\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0015\u001a\u00020\u0010*\u00020\fH\u0002J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\f*\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u000e*\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\f*\u00020\u0019H\u0002J'\u0010\u001b\u001a\u0004\u0018\u00010\f*\u00020\u000e2\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u001d\u00a2\u0006\u0002\b\u001eH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\f*\u00020\u0017H\u0002J\u001a\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\"\u0018\u00010!*\u00020\u0019H\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010\f*\u00020\u0017H\u0002J\u000e\u0010$\u001a\u0004\u0018\u00010\f*\u00020\u0019H\u0002J\u000e\u0010%\u001a\u0004\u0018\u00010&*\u00020'H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/android/parcel/quickfixes/ParcelMigrateToParcelizeQuickFix$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PARCELER_CREATE_FUNCTION_NAME", "Lorg/jetbrains/kotlin/name/Name;", "PARCELER_FQNAME", "Lorg/jetbrains/kotlin/name/FqName;", "PARCELER_WRITE_FUNCTION_NAME", "findCreateFromParcel", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "creator", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "doesLookLikeCreateFromParcelOverride", "", "doesLookLikeCreateImplementation", "doesLookLikeDescribeContentsOverride", "doesLookLikeNewArrayOverride", "doesLookLikeWriteImplementation", "doesLookLikeWriteToParcelOverride", "findCreateImplementation", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "findCreatorClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "findDescribeContentsOverride", "findFunction", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "findNewArrayOverride", "findParcelerCompanionObject", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "findWriteImplementation", "findWriteToParcelOverride", "getFqName", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "intellij.android.kotlin.extensions.common"})
    public static final class Companion {
        private final Pair<KtObjectDeclaration, ClassDescriptor> findParcelerCompanionObject(KtClass $this$findParcelerCompanionObject) {
            for (KtObjectDeclaration obj : $this$findParcelerCompanionObject.getCompanionObjects()) {
                ClassDescriptor objDescriptor;
                if (ResolutionUtils.resolveToDescriptorIfAny$default((KtClassOrObject)((KtClassOrObject)obj), null, (int)1, null) == null) {
                    continue;
                }
                for (ClassifierDescriptor superClassifier : DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)((ClassifierDescriptor)objDescriptor))) {
                    ClassDescriptor superClass;
                    ClassifierDescriptor classifierDescriptor = superClassifier;
                    if (!(classifierDescriptor instanceof ClassDescriptor)) {
                        classifierDescriptor = null;
                    }
                    if ((ClassDescriptor)classifierDescriptor == null) {
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)superClass)), (Object)PARCELER_FQNAME)) continue;
                    return new Pair((Object)obj, (Object)objDescriptor);
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeWriteToParcelOverride(KtNamedFunction $this$doesLookLikeWriteToParcelOverride) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeWriteToParcelOverride.getName(), (Object)"writeToParcel")) return false;
            if (!$this$doesLookLikeWriteToParcelOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeWriteToParcelOverride.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeWriteToParcelOverride.getValueParameters().size() != 2) return false;
            if ($this$doesLookLikeWriteToParcelOverride.getTypeParameters().size() != 0) return false;
            Object e = $this$doesLookLikeWriteToParcelOverride.getValueParameters().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            Object e2 = $this$doesLookLikeWriteToParcelOverride.getValueParameters().get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"valueParameters[1]");
            KtTypeReference ktTypeReference2 = ((KtParameter)e2).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference2 != null ? this.getFqName(ktTypeReference2) : null), (Object)StandardNames.FqNames._int.asString())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeNewArrayOverride(KtNamedFunction $this$doesLookLikeNewArrayOverride) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeNewArrayOverride.getName(), (Object)"newArray")) return false;
            if (!$this$doesLookLikeNewArrayOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeNewArrayOverride.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeNewArrayOverride.getValueParameters().size() != 1) return false;
            if ($this$doesLookLikeNewArrayOverride.getTypeParameters().size() != 0) return false;
            Object e = $this$doesLookLikeNewArrayOverride.getValueParameters().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)StandardNames.FqNames._int.asString())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeDescribeContentsOverride(KtNamedFunction $this$doesLookLikeDescribeContentsOverride) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeDescribeContentsOverride.getName(), (Object)"describeContents")) return false;
            if (!$this$doesLookLikeDescribeContentsOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeDescribeContentsOverride.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeDescribeContentsOverride.getValueParameters().size() != 0) return false;
            if ($this$doesLookLikeDescribeContentsOverride.getTypeParameters().size() != 0) return false;
            KtTypeReference ktTypeReference = $this$doesLookLikeDescribeContentsOverride.getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)StandardNames.FqNames._int.asString())) return false;
            return true;
        }

        private final KtNamedFunction findWriteToParcelOverride(KtClass $this$findWriteToParcelOverride) {
            return this.findFunction((KtClassOrObject)$this$findWriteToParcelOverride, (Function1<? super KtNamedFunction, Boolean>)((Function1)findWriteToParcelOverride.1.INSTANCE));
        }

        private final KtNamedFunction findDescribeContentsOverride(KtClass $this$findDescribeContentsOverride) {
            return this.findFunction((KtClassOrObject)$this$findDescribeContentsOverride, (Function1<? super KtNamedFunction, Boolean>)((Function1)findDescribeContentsOverride.1.INSTANCE));
        }

        private final KtNamedFunction findNewArrayOverride(KtObjectDeclaration $this$findNewArrayOverride) {
            return this.findFunction((KtClassOrObject)$this$findNewArrayOverride, (Function1<? super KtNamedFunction, Boolean>)((Function1)findNewArrayOverride.1.INSTANCE));
        }

        /*
         * WARNING - void declaration
         */
        private final KtClassOrObject findCreatorClass(KtClass $this$findCreatorClass) {
            for (KtObjectDeclaration companion : $this$findCreatorClass.getCompanionObjects()) {
                KtClassOrObject ktClassOrObject;
                KotlinSourceElement sourceElement;
                KtExpression initializer;
                KtProperty creatorProperty;
                Object v0;
                block10: {
                    void $this$firstOrNull$iv;
                    Sequence $this$filterIsInstance$iv;
                    if (Intrinsics.areEqual((Object)companion.getName(), (Object)"CREATOR")) {
                        return (KtClassOrObject)companion;
                    }
                    Sequence sequence = CollectionsKt.asSequence((Iterable)companion.getDeclarations());
                    boolean $i$f$filterIsInstance = false;
                    $this$filterIsInstance$iv = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Companion$findCreatorClass$$inlined$filterIsInstance$1.INSTANCE);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtProperty it = (KtProperty)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"CREATOR")) continue;
                        v0 = element$iv;
                        break block10;
                    }
                    v0 = null;
                }
                if ((KtProperty)v0 == null) {
                    continue;
                }
                if (ModifierListModifactorKt.findAnnotation((KtAnnotated)((KtAnnotated)creatorProperty), (FqName)JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME) == null) {
                    continue;
                }
                if (creatorProperty.getInitializer() == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)initializer, (String)"creatorProperty.initializer ?: continue");
                KtExpression ktExpression = initializer;
                if (ktExpression instanceof KtObjectLiteralExpression) {
                    return (KtClassOrObject)((KtObjectLiteralExpression)initializer).getObjectDeclaration();
                }
                if (!(ktExpression instanceof KtCallExpression)) continue;
                ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)initializer), null, (int)1, null);
                Object object = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
                if (!(object instanceof ConstructorDescriptor)) {
                    object = null;
                }
                ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)object;
                Object constructedClass = constructorDescriptor != null ? constructorDescriptor.getConstructedClass() : null;
                if (constructedClass == null) continue;
                SourceElement sourceElement2 = constructedClass.getSource();
                if (!(sourceElement2 instanceof KotlinSourceElement)) {
                    sourceElement2 = null;
                }
                KotlinSourceElement kotlinSourceElement = sourceElement = (KotlinSourceElement)sourceElement2;
                Object object2 = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
                if (!(object2 instanceof KtClassOrObject)) {
                    object2 = null;
                }
                KtClassOrObject ktClassOrObject2 = (KtClassOrObject)object2;
                if (ktClassOrObject2 == null) continue;
                KtClassOrObject it = ktClassOrObject = ktClassOrObject2;
                boolean bl = false;
                return it;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeCreateFromParcelOverride(KtNamedFunction $this$doesLookLikeCreateFromParcelOverride) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeCreateFromParcelOverride.getName(), (Object)"createFromParcel")) return false;
            if (!$this$doesLookLikeCreateFromParcelOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeCreateFromParcelOverride.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeCreateFromParcelOverride.getValueParameters().size() != 1) return false;
            if ($this$doesLookLikeCreateFromParcelOverride.getTypeParameters().size() != 0) return false;
            Object e = $this$doesLookLikeCreateFromParcelOverride.getValueParameters().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            return true;
        }

        private final KtNamedFunction findCreateFromParcel(KtClassOrObject creator) {
            return this.findFunction(creator, (Function1<? super KtNamedFunction, Boolean>)((Function1)findCreateFromParcel.1.INSTANCE));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeWriteImplementation(KtNamedFunction $this$doesLookLikeWriteImplementation) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$doesLookLikeWriteImplementation));
            String containingParcelableClassFqName = ktClassOrObject != null && (ktClassOrObject = KtPsiUtilKt.containingClass((KtElement)((KtElement)ktClassOrObject))) != null && (ktClassOrObject = ktClassOrObject.getFqName()) != null ? ktClassOrObject.asString() : null;
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeWriteImplementation.getName(), (Object)PARCELER_WRITE_FUNCTION_NAME.asString())) return false;
            if (!$this$doesLookLikeWriteImplementation.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            KtTypeReference ktTypeReference = $this$doesLookLikeWriteImplementation.getReceiverTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)containingParcelableClassFqName)) return false;
            if ($this$doesLookLikeWriteImplementation.getValueParameters().size() != 2) return false;
            if ($this$doesLookLikeWriteImplementation.getTypeParameters().size() != 0) return false;
            Object e = $this$doesLookLikeWriteImplementation.getValueParameters().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference2 = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference2 != null ? this.getFqName(ktTypeReference2) : null), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            Object e2 = $this$doesLookLikeWriteImplementation.getValueParameters().get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"valueParameters[1]");
            KtTypeReference ktTypeReference3 = ((KtParameter)e2).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference3 != null ? this.getFqName(ktTypeReference3) : null), (Object)StandardNames.FqNames._int.asString())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeCreateImplementation(KtNamedFunction $this$doesLookLikeCreateImplementation) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeCreateImplementation.getName(), (Object)PARCELER_CREATE_FUNCTION_NAME.asString())) return false;
            if (!$this$doesLookLikeCreateImplementation.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeCreateImplementation.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeCreateImplementation.getValueParameters().size() != 1) return false;
            if ($this$doesLookLikeCreateImplementation.getTypeParameters().size() != 0) return false;
            Object e = $this$doesLookLikeCreateImplementation.getValueParameters().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            return true;
        }

        private final KtNamedFunction findCreateImplementation(KtObjectDeclaration $this$findCreateImplementation) {
            return this.findFunction((KtClassOrObject)$this$findCreateImplementation, (Function1<? super KtNamedFunction, Boolean>)((Function1)findCreateImplementation.1.INSTANCE));
        }

        private final KtNamedFunction findWriteImplementation(KtObjectDeclaration $this$findWriteImplementation) {
            return this.findFunction((KtClassOrObject)$this$findWriteImplementation, (Function1<? super KtNamedFunction, Boolean>)((Function1)findWriteImplementation.1.INSTANCE));
        }

        private final KtNamedFunction findFunction(KtClassOrObject $this$findFunction, Function1<? super KtNamedFunction, Boolean> f) {
            Object v0;
            block1: {
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)$this$findFunction.getDeclarations());
                boolean $i$f$filterIsInstance = false;
                Sequence $this$firstOrNull$iv = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Companion$findFunction$$inlined$filterIsInstance$1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    if (!((Boolean)f.invoke(element$iv)).booleanValue()) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final String getFqName(KtTypeReference $this$getFqName) {
            KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)((KtElement)$this$getFqName), (BodyResolveMode)BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)$this$getFqName);
            return kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null && (kotlinType = kotlinType.getDeclarationDescriptor()) != null && (kotlinType = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)kotlinType))) != null ? kotlinType.asString() : null;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$doesLookLikeWriteToParcelOverride(Companion $this, KtNamedFunction $this$access_u24doesLookLikeWriteToParcelOverride) {
            return $this.doesLookLikeWriteToParcelOverride($this$access_u24doesLookLikeWriteToParcelOverride);
        }

        public static final /* synthetic */ boolean access$doesLookLikeDescribeContentsOverride(Companion $this, KtNamedFunction $this$access_u24doesLookLikeDescribeContentsOverride) {
            return $this.doesLookLikeDescribeContentsOverride($this$access_u24doesLookLikeDescribeContentsOverride);
        }

        public static final /* synthetic */ boolean access$doesLookLikeNewArrayOverride(Companion $this, KtNamedFunction $this$access_u24doesLookLikeNewArrayOverride) {
            return $this.doesLookLikeNewArrayOverride($this$access_u24doesLookLikeNewArrayOverride);
        }

        public static final /* synthetic */ boolean access$doesLookLikeCreateFromParcelOverride(Companion $this, KtNamedFunction $this$access_u24doesLookLikeCreateFromParcelOverride) {
            return $this.doesLookLikeCreateFromParcelOverride($this$access_u24doesLookLikeCreateFromParcelOverride);
        }

        public static final /* synthetic */ boolean access$doesLookLikeCreateImplementation(Companion $this, KtNamedFunction $this$access_u24doesLookLikeCreateImplementation) {
            return $this.doesLookLikeCreateImplementation($this$access_u24doesLookLikeCreateImplementation);
        }

        public static final /* synthetic */ boolean access$doesLookLikeWriteImplementation(Companion $this, KtNamedFunction $this$access_u24doesLookLikeWriteImplementation) {
            return $this.doesLookLikeWriteImplementation($this$access_u24doesLookLikeWriteImplementation);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

