/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetAttributeQuickFix
extends DefaultLintQuickFix {
    private final String myAttributeName;
    private final String myValue;
    private final String myNamespace;
    private final int myDot;
    private final int myMark;

    public SetAttributeQuickFix(@NotNull String name, @Nullable String familyName, @NotNull String attributeName, @Nullable String namespace, @Nullable String value) {
        if (name == null) {
            SetAttributeQuickFix.$$$reportNull$$$0(0);
        }
        if (attributeName == null) {
            SetAttributeQuickFix.$$$reportNull$$$0(1);
        }
        this(name, familyName, attributeName, namespace, value, value != null ? 0 : Integer.MIN_VALUE, value != null ? value.length() : Integer.MIN_VALUE);
    }

    public SetAttributeQuickFix(@NotNull String name, @Nullable String familyName, @NotNull String attributeName, @Nullable String namespace, @Nullable String value, int dot, int mark) {
        if (name == null) {
            SetAttributeQuickFix.$$$reportNull$$$0(2);
        }
        if (attributeName == null) {
            SetAttributeQuickFix.$$$reportNull$$$0(3);
        }
        super(name, familyName);
        this.myAttributeName = attributeName;
        this.myValue = value;
        this.myNamespace = namespace;
        this.myDot = dot;
        this.myMark = mark;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SetAttributeQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlAttribute attribute;
        XmlFile file;
        XmlTag tag;
        if (startElement == null) {
            SetAttributeQuickFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            SetAttributeQuickFix.$$$reportNull$$$0(6);
        }
        if (context == null) {
            SetAttributeQuickFix.$$$reportNull$$$0(7);
        }
        if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false)) == null) {
            return;
        }
        String value = this.myValue;
        if (value == null && context instanceof AndroidQuickfixContexts.DesignerContext && (value = LintIdeSupport.get().askForAttributeValue(this.myAttributeName, (PsiElement)tag)) == null) {
            return;
        }
        if (this.myNamespace != null && (file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlFile.class)) != null) {
            LintIdeSupport.get().ensureNamespaceImported(file, this.myNamespace, null);
        }
        if ((attribute = (XmlAttribute)ApplicationManager.getApplication().runWriteAction(() -> this.myNamespace != null ? tag.setAttribute(this.myAttributeName, this.myNamespace, "") : tag.setAttribute(this.myAttributeName, ""))) != null) {
            if (value != null && !value.isEmpty()) {
                String finalValue = value;
                ApplicationManager.getApplication().runWriteAction(() -> attribute.setValue(finalValue));
            }
            if (context instanceof AndroidQuickfixContexts.EditorContext) {
                Editor editor = ((AndroidQuickfixContexts.EditorContext)context).getEditor();
                XmlAttributeValue valueElement = attribute.getValueElement();
                TextRange valueTextRange = attribute.getValueTextRange();
                if (valueElement != null) {
                    int valueElementStart = valueElement.getTextRange().getStartOffset();
                    if (this.myDot != Integer.MIN_VALUE) {
                        int end = valueElementStart + valueTextRange.getStartOffset() + this.myDot;
                        if (this.myMark != Integer.MIN_VALUE && this.myMark != this.myDot) {
                            int start = valueElementStart + valueTextRange.getStartOffset() + this.myMark;
                            editor.getCaretModel().moveToOffset(end);
                            editor.getSelectionModel().setSelection(start, end);
                        } else {
                            editor.getCaretModel().moveToOffset(end);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            SetAttributeQuickFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            SetAttributeQuickFix.$$$reportNull$$$0(9);
        }
        if (contextType == null) {
            SetAttributeQuickFix.$$$reportNull$$$0(10);
        }
        if (this.myValue == null && contextType == AndroidQuickfixContexts.BatchContext.TYPE) {
            return false;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return false;
        }
        XmlAttribute attribute = this.myNamespace != null ? tag.getAttribute(this.myAttributeName, this.myNamespace) : tag.getAttribute(this.myAttributeName);
        return attribute == null || !StringUtil.notNullize((String)this.myValue).equals(StringUtil.notNullize((String)attribute.getValue()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/SetAttributeQuickFix";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/SetAttributeQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

