/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.lint.common.LintBatchResult;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeIssueRegistry;
import com.android.tools.idea.lint.common.LintIdeProject;
import com.android.tools.idea.lint.common.LintIdeSupportKt;
import com.android.tools.idea.lint.common.LintIgnoredResult;
import com.android.tools.idea.lint.common.LintResult;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Project;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.gradle.config.GradleFileTypeKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 H2\u00020\u0001:\u0001HB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J?\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00132\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001b2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100!\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\"J.\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0$2\u0006\u0010\u001d\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010%\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0004H\u0016J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0016J\u001e\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000202\u0018\u0001012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\"\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020>2\u0006\u0010;\u001a\u00020<H\u0016J\u001a\u0010?\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010C\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010D\u001a\u0002042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010E\u001a\u0002042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020\u0007H\u0016J\u0018\u0010G\u001a\u0002042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010@\u001a\u00020AH\u0016\u00a8\u0006I"}, d2={"Lcom/android/tools/idea/lint/common/LintIdeSupport;", "", "()V", "askForAttributeValue", "", "attributeName", "context", "Lcom/intellij/psi/PsiElement;", "canAnalyze", "", "project", "Lcom/intellij/openapi/project/Project;", "canAnnotate", "file", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "canRequestFeedback", "createBatchClient", "Lcom/android/tools/idea/lint/common/LintIdeClient;", "lintResult", "Lcom/android/tools/idea/lint/common/LintBatchResult;", "createClient", "Lcom/android/tools/idea/lint/common/LintResult;", "createEditorClient", "Lcom/android/tools/idea/lint/common/LintEditorResult;", "createProject", "", "Lcom/android/tools/lint/detector/api/Project;", "client", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "modules", "", "(Lcom/android/tools/idea/lint/common/LintIdeClient;Ljava/util/List;[Lcom/intellij/openapi/module/Module;)Ljava/util/List;", "createProjectForSingleFile", "Lcom/intellij/openapi/util/Pair;", "ensureNamespaceImported", "Lcom/intellij/psi/xml/XmlFile;", "namespaceUri", "suggestedPrefix", "getBaselineFile", "Ljava/io/File;", "getIssueRegistry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "getPlatforms", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Platform;", "getSeverityOverrides", "", "", "logSession", "", "lint", "Lcom/android/tools/lint/client/api/LintDriver;", "recommendedAgpVersion", "Lcom/android/ide/common/repository/GradleVersion;", "requestFeedbackFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "requestFeedbackIntentionAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "resolveDynamic", "gc", "Lcom/android/ide/common/repository/GradleCoordinate;", "shouldOfferUpgradeAssistantForDeprecatedConfigurations", "shouldRecommendUpdateAgpToLatest", "updateAgpToLatest", "updateDeprecatedConfigurations", "element", "updateToLatest", "Companion", "intellij.android.lint.common"})
public abstract class LintIdeSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public IssueRegistry getIssueRegistry() {
        return (IssueRegistry)new LintIdeIssueRegistry();
    }

    @Nullable
    public File getBaselineFile(@NotNull LintIdeClient client, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        File file = LintIdeSupportKt.getModuleDir(module);
        if (file == null) {
            return null;
        }
        File dir = file;
        Object object = client.getConfiguration(dir);
        if (object != null && (object = object.getBaselineFile()) != null) {
            Object object2;
            Object baseline = object2 = object;
            boolean bl = false;
            return baseline;
        }
        File lintBaseline = new File(dir, "lint_baseline.xml");
        if (lintBaseline.exists()) {
            return lintBaseline;
        }
        File baseline = new File(dir, "baseline.xml");
        if (baseline.exists()) {
            return baseline;
        }
        return null;
    }

    @NotNull
    public EnumSet<Platform> getPlatforms() {
        return Platform.JDK_SET;
    }

    @Nullable
    public Map<String, Integer> getSeverityOverrides(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return null;
    }

    @Nullable
    public String askForAttributeValue(@NotNull String attributeName, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return null;
    }

    public boolean canAnnotate(@NotNull PsiFile file, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"file.fileType");
        FileType fileType2 = fileType;
        if (fileType2 == JavaFileType.INSTANCE || fileType2 == KotlinFileType.INSTANCE || fileType2 == PropertiesFileType.INSTANCE) {
            return true;
        }
        if (fileType2 == XmlFileType.INSTANCE) {
            return true;
        }
        if (fileType2 == FileTypes.PLAIN_TEXT) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            String name = string;
            return Intrinsics.areEqual((Object)name, (Object)"proguard-project.txt") || Intrinsics.areEqual((Object)name, (Object)"proguard-android.txt") || Intrinsics.areEqual((Object)name, (Object)"proguard.cfg");
        }
        return GradleFileTypeKt.isGradleFile((PsiFile)file);
    }

    public boolean canAnalyze(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    @NotNull
    public List<Project> createProject(@NotNull LintIdeClient client, @Nullable List<? extends VirtualFile> files, Module ... modules) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        List<Project> list = LintIdeProject.create(client, files, Arrays.copyOf(modules, modules.length));
        Intrinsics.checkNotNullExpressionValue(list, (String)"LintIdeProject.create(client, files, *modules)");
        return list;
    }

    @NotNull
    public Pair<Project, Project> createProjectForSingleFile(@NotNull LintIdeClient client, @Nullable VirtualFile file, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Pair<Project, Project> pair = LintIdeProject.createForSingleFile(client, file, module);
        Intrinsics.checkNotNullExpressionValue(pair, (String)"LintIdeProject.createFor\u2026ile(client, file, module)");
        return pair;
    }

    @NotNull
    public LintIdeClient createClient(@NotNull com.intellij.openapi.project.Project project, @NotNull LintResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        return new LintIdeClient(project, lintResult);
    }

    public static /* synthetic */ LintIdeClient createClient$default(LintIdeSupport lintIdeSupport, com.intellij.openapi.project.Project project, LintResult lintResult, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createClient");
        }
        if ((n & 2) != 0) {
            lintResult = new LintIgnoredResult();
        }
        return lintIdeSupport.createClient(project, lintResult);
    }

    @NotNull
    public LintIdeClient createBatchClient(@NotNull LintBatchResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        return new LintIdeClient(lintResult.getProject(), lintResult);
    }

    @NotNull
    public LintIdeClient createEditorClient(@NotNull LintEditorResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        return new LintIdeClient(lintResult.getModule().getProject(), lintResult);
    }

    public void updateToLatest(@NotNull Module module, @NotNull GradleCoordinate gc) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
    }

    @Nullable
    public GradleVersion recommendedAgpVersion(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    public boolean shouldRecommendUpdateAgpToLatest(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    public void updateAgpToLatest(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    public boolean shouldOfferUpgradeAssistantForDeprecatedConfigurations(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    public void updateDeprecatedConfigurations(@NotNull com.intellij.openapi.project.Project project, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    @Nullable
    public String resolveDynamic(@NotNull com.intellij.openapi.project.Project project, @NotNull GradleCoordinate gc) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        return null;
    }

    public boolean canRequestFeedback() {
        return false;
    }

    @NotNull
    public LocalQuickFix requestFeedbackFix(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        String string = "Not supported";
        throw new IllegalStateException(string.toString());
    }

    @NotNull
    public IntentionAction requestFeedbackIntentionAction(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        String string = "Not supported";
        throw new IllegalStateException(string.toString());
    }

    public void logSession(@NotNull LintDriver lint, @NotNull LintEditorResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lint, (String)"lint");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
    }

    public void logSession(@NotNull LintDriver lint, @Nullable Module module, @NotNull LintBatchResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lint, (String)"lint");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
    }

    @NotNull
    public String ensureNamespaceImported(@NotNull XmlFile file, @NotNull String namespaceUri, @Nullable String suggestedPrefix) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)namespaceUri, (String)"namespaceUri");
        return "";
    }

    public LintIdeSupport() {
        LintClient.Companion.setClientName("studio");
    }

    @JvmStatic
    @NotNull
    public static final LintIdeSupport get() {
        return Companion.get();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/lint/common/LintIdeSupport$Companion;", "", "()V", "get", "Lcom/android/tools/idea/lint/common/LintIdeSupport;", "intellij.android.lint.common"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final LintIdeSupport get() {
            LintIdeSupport lintIdeSupport = (LintIdeSupport)ApplicationManager.getApplication().getService(LintIdeSupport.class);
            if (lintIdeSupport == null) {
                lintIdeSupport = new LintIdeSupport(){};
            }
            return lintIdeSupport;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

