/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeIssueRegistry;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFixProvider;
import com.android.tools.idea.lint.common.LintIdeRequest;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.idea.lint.common.SuppressLintIntentionAction;
import com.android.tools.lint.checks.DeprecationDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.WrongIdDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.collect.Sets;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.CustomEditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlStringUtil;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.gradle.config.GradleFileType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00142\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/lint/common/LintExternalAnnotator;", "Lcom/intellij/lang/annotation/ExternalAnnotator;", "Lcom/android/tools/idea/lint/common/LintEditorResult;", "()V", "apply", "", "file", "Lcom/intellij/psi/PsiFile;", "lintResult", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "collectInformation", "editor", "Lcom/intellij/openapi/editor/Editor;", "hasErrors", "", "module", "Lcom/intellij/openapi/module/Module;", "doAnnotate", "isRelevant", "Companion", "MyDisableInspectionFix", "MyEditInspectionToolsSettingsAction", "MyFixingIntention", "intellij.android.lint.common"})
public final class LintExternalAnnotator
extends ExternalAnnotator<LintEditorResult, LintEditorResult> {
    @NotNull
    public static final String LINK_PREFIX = "#lint/";
    public static final boolean INCLUDE_IDEA_SUPPRESS_ACTIONS = false;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public LintEditorResult collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.collectInformation(file);
    }

    @Nullable
    public LintEditorResult collectInformation(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
        if (module == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026ment(file) ?: return null");
        Module module2 = module;
        return this.collectInformation(file, module2);
    }

    private final boolean isRelevant(PsiFile file, Module module) {
        return LintIdeSupport.Companion.get().canAnnotate(file, module);
    }

    private final LintEditorResult collectInformation(PsiFile file, Module module) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        if (!this.isRelevant(file, module)) {
            return null;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        Set<Issue> issues = Companion.getIssuesFromInspections(project, (PsiElement)file);
        String string = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.text");
        return new LintEditorResult(module, vFile, string, issues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public LintEditorResult doAnnotate(@NotNull LintEditorResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        long startTime = System.currentTimeMillis();
        LintIdeClient client = LintIdeSupport.Companion.get().createEditorClient(lintResult);
        try {
            EnumSet scope = null;
            VirtualFile mainFile = lintResult.getMainFile();
            FileType fileType = mainFile.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"mainFile.fileType");
            FileType fileType2 = fileType;
            String string = mainFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mainFile.name");
            String name = string;
            if (fileType2 == XmlFileType.INSTANCE) {
                if (Intrinsics.areEqual((Object)name, (Object)"AndroidManifest.xml")) {
                    scope = Scope.MANIFEST_SCOPE;
                } else {
                    if (!StringsKt.endsWith$default((String)name, (String)".xml", (boolean)false, (int)2, null)) {
                        LintEditorResult lintEditorResult = lintResult;
                        return lintEditorResult;
                    }
                    scope = Scope.RESOURCE_FILE_SCOPE;
                }
            } else if (fileType2 == JavaFileType.INSTANCE || fileType2 == KotlinFileType.INSTANCE) {
                scope = Scope.JAVA_FILE_SCOPE;
                if (StringsKt.endsWith$default((String)name, (String)".kts", (boolean)false, (int)2, null)) {
                    EnumSet enumSet = EnumSet.of((Enum)Scope.GRADLE_FILE, (Enum)Scope.JAVA_FILE);
                    Intrinsics.checkNotNullExpressionValue(enumSet, (String)"EnumSet.of(Scope.GRADLE_FILE, Scope.JAVA_FILE)");
                    scope = enumSet;
                }
            } else if (Intrinsics.areEqual((Object)name, (Object)"proguard.cfg") || Intrinsics.areEqual((Object)name, (Object)"proguard-project.txt")) {
                EnumSet enumSet = EnumSet.of((Enum)Scope.PROGUARD_FILE);
                Intrinsics.checkNotNullExpressionValue(enumSet, (String)"EnumSet.of(Scope.PROGUARD_FILE)");
                scope = enumSet;
            } else if (GradleFileType.isGradleFile((VirtualFile)mainFile)) {
                scope = Scope.GRADLE_SCOPE;
            } else if (fileType2 == PropertiesFileType.INSTANCE) {
                scope = Scope.PROPERTY_SCOPE;
            } else {
                boolean bl = false;
                if (_Assertions.ENABLED) {
                    boolean $i$a$-assert-LintExternalAnnotator$doAnnotate$22 = false;
                    FileType $i$a$-assert-LintExternalAnnotator$doAnnotate$22 = fileType2;
                    throw new AssertionError($i$a$-assert-LintExternalAnnotator$doAnnotate$22);
                }
                LintEditorResult lintEditorResult = lintResult;
                return lintEditorResult;
            }
            Project project = lintResult.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"lintResult.getModule().project");
            Project project2 = project;
            if (project2.isDisposed()) {
                LintEditorResult $i$a$-assert-LintExternalAnnotator$doAnnotate$22 = lintResult;
                return $i$a$-assert-LintExternalAnnotator$doAnnotate$22;
            }
            if (DumbService.isDumb((Project)project2)) {
                LintEditorResult $i$a$-assert-LintExternalAnnotator$doAnnotate$22 = lintResult;
                return $i$a$-assert-LintExternalAnnotator$doAnnotate$22;
            }
            List files = CollectionsKt.listOf((Object)mainFile);
            LintRequest request = new LintIdeRequest(client, project2, files, CollectionsKt.listOf((Object)lintResult.getModule()), true);
            request.setScope(scope);
            LintDriver lint = client.createDriver(request);
            lint.analyze();
            lint.setAnalysisStartTime(startTime);
            LintIdeSupport lintIdeSupport = LintIdeSupport.Companion.get();
            LintDriver lintDriver = lint;
            Intrinsics.checkNotNullExpressionValue((Object)lintDriver, (String)"lint");
            lintIdeSupport.logSession(lintDriver, lintResult);
            return lintResult;
        }
        finally {
            Disposer.dispose((Disposable)client);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull PsiFile file, @NotNull LintEditorResult lintResult, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (lintResult.isDirty()) {
            return;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        Project project2 = project;
        if (DumbService.isDumb((Project)project2)) {
            return;
        }
        ExtensionPointName<LintIdeQuickFixProvider> extensionPointName = LintIdeQuickFixProvider.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"LintIdeQuickFixProvider.EP_NAME");
        LintIdeQuickFixProvider[] fixProviders = (LintIdeQuickFixProvider[])extensionPointName.getExtensions();
        LintIdeSupport ideSupport = LintIdeSupport.Companion.get();
        for (LintProblemData problemData : lintResult.getProblems()) {
            String string;
            HighlightDisplayKey key;
            LintIdeQuickFix[] fixes;
            String tooltip;
            String rawMessage;
            HighlightSeverity severity;
            ProblemHighlightType problemHighlightType;
            HighlightDisplayLevel configuredLevel;
            void inspection;
            Pair<AndroidLintInspectionBase, HighlightDisplayLevel> pair;
            Issue issue;
            TextRange range;
            Intrinsics.checkNotNullExpressionValue((Object)problemData.getIssue(), (String)"problemData.issue");
            Intrinsics.checkNotNullExpressionValue((Object)problemData.getMessage(), (String)"problemData.message");
            Intrinsics.checkNotNullExpressionValue((Object)problemData.getTextRange(), (String)"problemData.textRange");
            LintFix quickfixData = problemData.getQuickfixData();
            if (range.getStartOffset() == range.getEndOffset()) continue;
            if (Companion.getHighlightLevelAndInspection(project2, issue, (PsiElement)file) == null) {
                continue;
            }
            AndroidLintInspectionBase androidLintInspectionBase = (AndroidLintInspectionBase)((Object)pair.component1());
            HighlightDisplayLevel displayLevel = (HighlightDisplayLevel)pair.component2();
            if (HighlightDisplayKey.find((String)inspection.getShortName()) == null) {
                continue;
            }
            PsiElement startElement = file.findElementAt(range.getStartOffset());
            PsiElement endElement = file.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || inspection.isSuppressedFor(startElement)) continue;
            Severity configuredSeverity = problemData.getConfiguredSeverity();
            if (configuredSeverity != null && (configuredLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(configuredSeverity)) != null) {
                displayLevel = configuredLevel;
            }
            Intrinsics.checkNotNullExpressionValue((Object)displayLevel.getSeverity(), (String)"displayLevel.severity");
            if (issue == DeprecationDetector.ISSUE || issue == GradleDetector.DEPRECATED || issue == GradleDetector.DEPRECATED_CONFIGURATION) {
                problemHighlightType = ProblemHighlightType.LIKE_DEPRECATED;
            } else if (issue == WrongIdDetector.UNKNOWN_ID || issue == WrongIdDetector.UNKNOWN_ID_LAYOUT) {
                problemHighlightType = ProblemHighlightType.ERROR;
            } else if (severity == HighlightSeverity.ERROR) {
                problemHighlightType = ProblemHighlightType.GENERIC_ERROR;
            } else {
                ProblemHighlightType problemHighlightType2 = HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)severity);
                problemHighlightType = problemHighlightType2;
                Intrinsics.checkNotNullExpressionValue((Object)problemHighlightType2, (String)"HighlightInfo.convertSev\u2026roblemHighlight(severity)");
            }
            ProblemHighlightType type = problemHighlightType;
            String message = rawMessage.length() <= 1000 ? rawMessage : StringsKt.take((String)rawMessage, (int)1000) + "... [truncated]";
            String descriptionLink = "<a href=\"#lint/" + issue.getId() + "\"></a>";
            Intrinsics.checkNotNullExpressionValue((Object)XmlStringUtil.wrapInHtml((CharSequence)(descriptionLink + TextFormat.RAW.convertTo(message, TextFormat.HTML))), (String)"XmlStringUtil.wrapInHtml\u2026convertTo(message, HTML))");
            AnnotationBuilder annotationBuilder = holder.newAnnotation(severity, message).highlightType(type).range(range).tooltip(tooltip);
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"holder\n        .newAnnot\u2026        .tooltip(tooltip)");
            AnnotationBuilder builder = annotationBuilder;
            Intrinsics.checkNotNullExpressionValue((Object)inspection.getAllFixes(startElement, endElement, message, quickfixData, fixProviders, issue), (String)"inspection.getAllFixes(s\u2026ata, fixProviders, issue)");
            for (LintIdeQuickFix lintIdeQuickFix : fixes) {
                if (!lintIdeQuickFix.isApplicable(startElement, endElement, AndroidQuickfixContexts.EditorContext.TYPE)) continue;
                LintIdeQuickFix lintIdeQuickFix2 = lintIdeQuickFix;
                Intrinsics.checkNotNullExpressionValue((Object)lintIdeQuickFix2, (String)"fix");
                Intrinsics.checkNotNullExpressionValue((Object)builder.withFix((IntentionAction)new MyFixingIntention(lintIdeQuickFix2, startElement, endElement)), (String)"builder.withFix(MyFixing\u2026tartElement, endElement))");
            }
            for (LintIdeQuickFix lintIdeQuickFix : inspection.getIntentions(startElement, endElement)) {
                Intrinsics.checkNotNullExpressionValue((Object)builder.withFix((IntentionAction)lintIdeQuickFix), (String)"builder.withFix(intention)");
            }
            if (ideSupport.canRequestFeedback()) {
                AnnotationBuilder annotationBuilder2 = builder.withFix(ideSupport.requestFeedbackIntentionAction(issue));
                Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder2, (String)"builder.withFix(ideSuppo\u2026ckIntentionAction(issue))");
                builder = annotationBuilder2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)key.getID(), (String)"key.id");
            AnnotationBuilder annotationBuilder3 = builder.withFix((IntentionAction)new SuppressLintIntentionAction(string, startElement));
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder3, (String)"builder.withFix(Suppress\u2026Action(id, startElement))");
            builder = annotationBuilder3;
            builder.create();
        }
    }

    static {
        LintClient.Companion.setClientName("studio");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J!\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/lint/common/LintExternalAnnotator$MyDisableInspectionFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "key", "Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;", "(Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;)V", "myDisableInspectionToolAction", "Lcom/intellij/codeInspection/ex/DisableInspectionToolAction;", "getElementToMakeWritable", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "startInWriteAction", "intellij.android.lint.common"})
    private static final class MyDisableInspectionFix
    implements IntentionAction,
    Iconable {
        private final DisableInspectionToolAction myDisableInspectionToolAction;

        @NotNull
        public String getText() {
            return "Disable inspection";
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return true;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.myDisableInspectionToolAction.invoke(project, editor, file);
        }

        public boolean startInWriteAction() {
            return this.myDisableInspectionToolAction.startInWriteAction();
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.myDisableInspectionToolAction.getElementToMakeWritable(file);
        }

        @NotNull
        public Icon getIcon(@Iconable.IconFlags int flags) {
            Icon icon = this.myDisableInspectionToolAction.getIcon(flags);
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"myDisableInspectionToolAction.getIcon(flags)");
            return icon;
        }

        public MyDisableInspectionFix(@NotNull HighlightDisplayKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.myDisableInspectionToolAction = new DisableInspectionToolAction(key);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/lint/common/LintExternalAnnotator$MyFixingIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "myQuickFix", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "myStartElement", "Lcom/intellij/psi/PsiElement;", "myEndElement", "(Lcom/android/tools/idea/lint/common/LintIdeQuickFix;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "toString", "intellij.android.lint.common"})
    public static final class MyFixingIntention
    implements IntentionAction,
    HighPriorityAction {
        private final LintIdeQuickFix myQuickFix;
        private final PsiElement myStartElement;
        private final PsiElement myEndElement;

        @NotNull
        public String getText() {
            String string = this.myQuickFix.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myQuickFix.name");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            return LintBundle.Companion.message("android.lint.quickfixes.family", new Object[0]);
        }

        public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return true;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.myQuickFix.apply(this.myStartElement, this.myEndElement, AndroidQuickfixContexts.EditorContext.getInstance(editor));
        }

        public boolean startInWriteAction() {
            return this.myQuickFix.startInWriteAction();
        }

        @NotNull
        public String toString() {
            return this.getText();
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = this.myQuickFix.getPriority();
            Intrinsics.checkNotNullExpressionValue((Object)priority, (String)"myQuickFix.priority");
            return priority;
        }

        public MyFixingIntention(@NotNull LintIdeQuickFix myQuickFix, @NotNull PsiElement myStartElement, @NotNull PsiElement myEndElement) {
            Intrinsics.checkNotNullParameter((Object)myQuickFix, (String)"myQuickFix");
            Intrinsics.checkNotNullParameter((Object)myStartElement, (String)"myStartElement");
            Intrinsics.checkNotNullParameter((Object)myEndElement, (String)"myEndElement");
            this.myQuickFix = myQuickFix;
            this.myStartElement = myStartElement;
            this.myEndElement = myEndElement;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/lint/common/LintExternalAnnotator$MyEditInspectionToolsSettingsAction;", "Lcom/intellij/codeInspection/ex/CustomEditInspectionToolsSettingsAction;", "key", "Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;", "inspection", "Lcom/android/tools/idea/lint/common/AndroidLintInspectionBase;", "(Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;Lcom/android/tools/idea/lint/common/AndroidLintInspectionBase;)V", "intellij.android.lint.common"})
    private static final class MyEditInspectionToolsSettingsAction
    extends CustomEditInspectionToolsSettingsAction {
        public MyEditInspectionToolsSettingsAction(@NotNull HighlightDisplayKey key, final @NotNull AndroidLintInspectionBase inspection) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)inspection), (String)"inspection");
            super(key, new Computable(){

                public final String compute() {
                    return "Edit '" + inspection.getDisplayName() + "' inspection settings";
                }
            });
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/lint/common/LintExternalAnnotator$Companion;", "", "()V", "INCLUDE_IDEA_SUPPRESS_ACTIONS", "", "LINK_PREFIX", "", "getHighlightLevelAndInspection", "Lkotlin/Pair;", "Lcom/android/tools/idea/lint/common/AndroidLintInspectionBase;", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "project", "Lcom/intellij/openapi/project/Project;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "context", "Lcom/intellij/psi/PsiElement;", "getIssuesFromInspections", "", "intellij.android.lint.common"})
    public static final class Companion {
        @NotNull
        public final Set<Issue> getIssuesFromInspections(@NotNull Project project, @Nullable PsiElement context) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            IssueRegistry fullRegistry = LintIdeIssueRegistry.get();
            List issueList = fullRegistry.getIssues();
            HashSet result = Sets.newHashSetWithExpectedSize((int)(issueList.size() + 10));
            for (Issue issue : issueList) {
                HighlightDisplayKey key;
                String inspectionShortName;
                if (AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue) == null) {
                    continue;
                }
                if (HighlightDisplayKey.find((String)inspectionShortName) == null) {
                    continue;
                }
                InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)inspectionProjectProfileManager, (String)"InspectionProjectProfile\u2026ager.getInstance(project)");
                InspectionProfileImpl inspectionProfileImpl = inspectionProjectProfileManager.getCurrentProfile();
                Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"InspectionProjectProfile\u2026e(project).currentProfile");
                InspectionProfile profile = (InspectionProfile)inspectionProfileImpl;
                boolean enabled = context != null ? profile.isToolEnabled(key, context) : profile.isToolEnabled(key);
                if (!enabled) continue;
                if (!issue.isEnabledByDefault()) {
                    issue.setEnabledByDefault(true);
                }
                result.add(issue);
            }
            HashSet hashSet = result;
            Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"result");
            return hashSet;
        }

        @Nullable
        public final Pair<AndroidLintInspectionBase, HighlightDisplayLevel> getHighlightLevelAndInspection(@NotNull Project project, @NotNull Issue issue, @NotNull PsiElement context) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String string = AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue);
            if (string == null) {
                return null;
            }
            String inspectionShortName = string;
            HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.find((String)inspectionShortName);
            if (highlightDisplayKey == null) {
                return null;
            }
            HighlightDisplayKey key = highlightDisplayKey;
            InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)context.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)inspectionProjectProfileManager, (String)"InspectionProjectProfile\u2026Instance(context.project)");
            InspectionProfileImpl inspectionProfileImpl = inspectionProjectProfileManager.getCurrentProfile();
            Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"InspectionProjectProfile\u2026t.project).currentProfile");
            InspectionProfile profile = (InspectionProfile)inspectionProfileImpl;
            if (!profile.isToolEnabled(key, context) && issue.isEnabledByDefault()) {
                return null;
            }
            AndroidLintInspectionBase androidLintInspectionBase = (AndroidLintInspectionBase)profile.getUnwrappedTool(inspectionShortName, context);
            if (androidLintInspectionBase == null) {
                return null;
            }
            AndroidLintInspectionBase inspection = androidLintInspectionBase;
            HighlightDisplayLevel highlightDisplayLevel = profile.getErrorLevel(key, context);
            Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"profile.getErrorLevel(key, context)");
            HighlightDisplayLevel errorLevel = highlightDisplayLevel;
            return new Pair((Object)inspection, (Object)errorLevel);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

