/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.AnnotateQuickFixKt;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/lint/common/AnnotateQuickFix;", "Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;", "displayName", "", "familyName", "annotationSource", "replace", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "apply", "", "element", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "findContainer", "isApplicable", "startElement", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "intellij.android.lint.common"})
public final class AnnotateQuickFix
extends DefaultLintQuickFix {
    private final String annotationSource;
    private final boolean replace;

    private final PsiElement findContainer(PsiElement element) {
        Language language = element.getLanguage();
        return Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE) ? (PsiElement)AnnotateQuickFixKt.findJavaAnnotationTarget(element) : (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) ? AnnotateQuickFixKt.access$findKotlinAnnotationTarget(element) : null);
    }

    @Override
    public void apply(@NotNull PsiElement element, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        block10: {
            Language language;
            PsiElement container;
            block9: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Language language2 = element.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"element.language");
                Language language3 = language2;
                PsiElement psiElement = this.findContainer(element);
                if (psiElement == null) {
                    return;
                }
                container = psiElement;
                if (!FileModificationService.getInstance().preparePsiElementForWrite(container)) {
                    return;
                }
                language = language3;
                if (!Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) break block9;
                PsiElement psiElement2 = container;
                if (psiElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiModifierListOwner");
                }
                PsiModifierListOwner owner = (PsiModifierListOwner)psiElement2;
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
                Project project2 = project;
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project2);
                Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade, (String)"JavaPsiFacade.getInstance(project)");
                PsiElementFactory psiElementFactory = javaPsiFacade.getElementFactory();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"JavaPsiFacade.getInstance(project).elementFactory");
                PsiElementFactory factory = psiElementFactory;
                PsiAnnotation psiAnnotation = factory.createAnnotationFromText(this.annotationSource, element);
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"factory.createAnnotation\u2026nnotationSource, element)");
                PsiAnnotation newAnnotation = psiAnnotation;
                String string = newAnnotation.getQualifiedName();
                if (string == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newAnnotation.qualifiedName ?: return");
                String annotationName = string;
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{annotationName});
                if (annotation != null && annotation.isPhysical() && this.replace) {
                    annotation.replace((PsiElement)newAnnotation);
                } else {
                    PsiAnnotationParameterList psiAnnotationParameterList = newAnnotation.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationParameterList, (String)"newAnnotation.parameterList");
                    PsiNameValuePair[] attributes = psiAnnotationParameterList.getAttributes();
                    new AddAnnotationFix(annotationName, (PsiModifierListOwner)container, attributes, new String[0]).invoke(project2, null, element.getContainingFile());
                }
                break block10;
            }
            if (!Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) break block10;
            int args = StringsKt.indexOf$default((CharSequence)this.annotationSource, (char)'(', (int)0, (boolean)false, (int)6, null);
            String string = this.annotationSource;
            int n = 0;
            int n2 = args == -1 ? this.annotationSource.length() : args;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String className = StringsKt.removePrefix((String)string2, (CharSequence)"@");
            string = container;
            if (string instanceof KtModifierListOwner) {
                String string3;
                KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)container;
                FqName fqName = new FqName(className);
                if (args == -1) {
                    string3 = null;
                } else {
                    String string4 = this.annotationSource;
                    n2 = args + 1;
                    int n3 = this.annotationSource.length() - 1;
                    String string5 = string4.substring(n2, n3);
                    string3 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                }
                ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)ktModifierListOwner, (FqName)fqName, string3, (String)(AnnotateQuickFixKt.isNewLineNeededForAnnotation((KtElement)container) ? "\n" : " "), null, (int)8, null);
            }
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        return this.findContainer(startElement) != null;
    }

    public AnnotateQuickFix(@Nullable String displayName, @Nullable String familyName, @NotNull String annotationSource, boolean replace) {
        Intrinsics.checkNotNullParameter((Object)annotationSource, (String)"annotationSource");
        String string = displayName;
        if (string == null) {
            string = "Annotate";
        }
        super(string, familyName);
        this.annotationSource = annotationSource;
        this.replace = replace;
    }
}

