/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.AnnotateQuickFix;
import com.android.tools.idea.lint.common.CreateFileQuickFix;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintGlobalInspectionContext;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFixProvider;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.idea.lint.common.ReplaceStringQuickFix;
import com.android.tools.idea.lint.common.SetAttributeQuickFix;
import com.android.tools.idea.lint.common.ShowUrlQuickFix;
import com.android.tools.idea.lint.common.SuppressLintQuickFix;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.siyeh.ig.InspectionGadgetsFix;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.KotlinFileType;

public abstract class AndroidLintInspectionBase
extends GlobalInspectionTool {
    public static final String LINT_INSPECTION_PREFIX = "AndroidLint";
    private static final Logger LOG;
    private static final Object ISSUE_MAP_LOCK;
    private static final Key<Map<Issue, String>> ISSUE_MAP_KEY;
    private static final Key<List<Tools>> DYNAMIC_TOOLS_KEY;
    private static boolean ourRegisterDynamicToolsFromTests;
    protected final Issue myIssue;
    private String[] myGroupPath;
    private final String myDisplayName;

    protected AndroidLintInspectionBase(@NotNull String displayName, @NotNull Issue issue) {
        if (displayName == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(0);
        }
        if (issue == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(1);
        }
        this.myIssue = issue;
        this.myDisplayName = displayName;
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(3);
        }
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(4);
        }
        LintIdeQuickFix[] fixes = this.getQuickFixes(startElement, endElement, message);
        if (fixData != null && fixes.length == 0) {
            LintIdeQuickFix[] lintIdeQuickFixArray = AndroidLintInspectionBase.createFixes(startElement.getContainingFile(), fixData);
            if (lintIdeQuickFixArray == null) {
                AndroidLintInspectionBase.$$$reportNull$$$0(5);
            }
            return lintIdeQuickFixArray;
        }
        if (fixes == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(6);
        }
        return fixes;
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(8);
        }
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(9);
        }
        LintIdeQuickFix[] lintIdeQuickFixArray = this.getQuickFixes(message);
        if (lintIdeQuickFixArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(10);
        }
        return lintIdeQuickFixArray;
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull String message) {
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(11);
        }
        if (LintIdeQuickFix.EMPTY_ARRAY == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(12);
        }
        return LintIdeQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public IntentionAction[] getIntentions(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(13);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(14);
        }
        if (IntentionAction.EMPTY_ARRAY == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(15);
        }
        return IntentionAction.EMPTY_ARRAY;
    }

    public boolean isGraphNeeded() {
        return false;
    }

    @NotNull
    public LintIdeQuickFix[] getAllFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData, @NotNull LintIdeQuickFixProvider[] fixProviders, @NotNull Issue issue) {
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(16);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(17);
        }
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(18);
        }
        if (issue == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(19);
        }
        if (fixProviders == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(20);
        }
        ArrayList result = new ArrayList(4);
        PsiFile file = startElement.getContainingFile();
        if (file != null && file.getFileType() == KotlinFileType.INSTANCE) {
            for (LintIdeQuickFixProvider provider : fixProviders) {
                LintIdeQuickFix[] fixes = provider.getQuickFixes(issue, startElement, endElement, message, fixData);
                Collections.addAll(result, fixes);
            }
        }
        LintIdeQuickFix[] fixes = this.getQuickFixes(startElement, endElement, message, fixData);
        Collections.addAll(result, fixes);
        LintIdeQuickFix[] lintIdeQuickFixArray = result.toArray(LintIdeQuickFix.EMPTY_ARRAY);
        if (lintIdeQuickFixArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(21);
        }
        return lintIdeQuickFixArray;
    }

    @NotNull
    public LocalQuickFix[] getLocalQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData, @NotNull LintIdeQuickFixProvider[] fixProviders, @NotNull Issue issue) {
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(22);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(23);
        }
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(24);
        }
        if (issue == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(25);
        }
        if (fixProviders == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(26);
        }
        LintIdeSupport ideSupport = LintIdeSupport.get();
        boolean includeFeedbackFix = ideSupport.canRequestFeedback();
        LintIdeQuickFix[] fixes = this.getAllFixes(startElement, endElement, message, fixData, fixProviders, issue);
        if (fixes.length == 0) {
            if (includeFeedbackFix) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{ideSupport.requestFeedbackFix(issue)};
                if (localQuickFixArray == null) {
                    AndroidLintInspectionBase.$$$reportNull$$$0(27);
                }
                return localQuickFixArray;
            }
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                AndroidLintInspectionBase.$$$reportNull$$$0(28);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<MyLocalQuickFix> result = new ArrayList<MyLocalQuickFix>(fixes.length);
        for (LintIdeQuickFix fix : fixes) {
            if (!fix.isApplicable(startElement, endElement, AndroidQuickfixContexts.BatchContext.TYPE)) continue;
            result.add(new MyLocalQuickFix(fix));
        }
        if (includeFeedbackFix) {
            result.add((MyLocalQuickFix)ideSupport.requestFeedbackFix(issue));
        }
        LocalQuickFix[] localQuickFixArray = result.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(29);
        }
        return localQuickFixArray;
    }

    public void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        LintGlobalInspectionContext androidLintContext;
        if (scope == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(30);
        }
        if (manager == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(31);
        }
        if (globalContext == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(32);
        }
        if (problemDescriptionsProcessor == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(33);
        }
        if ((androidLintContext = (LintGlobalInspectionContext)globalContext.getExtension(LintGlobalInspectionContext.ID)) == null) {
            return;
        }
        Map<Issue, Map<File, List<LintProblemData>>> problemMap = androidLintContext.getResults();
        if (problemMap == null) {
            return;
        }
        Map<File, List<LintProblemData>> file2ProblemList = problemMap.get(this.myIssue);
        if (file2ProblemList == null) {
            return;
        }
        for (Map.Entry<File, List<LintProblemData>> entry : file2ProblemList.entrySet()) {
            File file = entry.getKey();
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile == null) continue;
            ApplicationManager.getApplication().runReadAction(() -> {
                ProblemDescriptor[] descriptors;
                PsiDirectory psiDirectory;
                PsiManager psiManager = PsiManager.getInstance((Project)globalContext.getProject());
                PsiFile psiFile = psiManager.findFile(vFile);
                if (psiFile != null) {
                    ProblemDescriptor[] descriptors2 = this.computeProblemDescriptors((PsiElement)psiFile, manager, (List)entry.getValue());
                    if (descriptors2.length > 0) {
                        problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiFile), (CommonProblemDescriptor[])descriptors2);
                    }
                } else if (vFile.isDirectory() && (psiDirectory = psiManager.findDirectory(vFile)) != null && (descriptors = this.computeProblemDescriptors((PsiElement)psiDirectory, manager, (List)entry.getValue())).length > 0) {
                    problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiDirectory), (CommonProblemDescriptor[])descriptors);
                }
            });
        }
    }

    @NotNull
    private ProblemDescriptor[] computeProblemDescriptors(@NotNull PsiElement psiFile, @NotNull InspectionManager manager, @NotNull List<LintProblemData> problems) {
        if (psiFile == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(34);
        }
        if (manager == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(35);
        }
        if (problems == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(36);
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        LintIdeQuickFixProvider[] fixProviders = (LintIdeQuickFixProvider[])LintIdeQuickFixProvider.EP_NAME.getExtensions();
        for (LintProblemData problemData : problems) {
            String originalMessage = problemData.getMessage();
            String formattedMessage = "<html>" + TextFormat.RAW.convertTo(originalMessage, TextFormat.HTML_WITH_UNICODE) + "</html>";
            LintFix quickfixData = problemData.getQuickfixData();
            TextRange range = problemData.getTextRange();
            Issue issue = problemData.getIssue();
            if (range.getStartOffset() == range.getEndOffset()) {
                if (psiFile instanceof PsiBinaryFile || psiFile instanceof PsiDirectory) {
                    LocalQuickFix[] fixes = this.getLocalQuickFixes(psiFile, psiFile, originalMessage, quickfixData, fixProviders, issue);
                    result.add(new NonTextFileProblemDescriptor((PsiFileSystemItem)psiFile, formattedMessage, fixes));
                    continue;
                }
                if (this.isSuppressedFor(psiFile)) continue;
                result.add(manager.createProblemDescriptor(psiFile, formattedMessage, false, this.getLocalQuickFixes(psiFile, psiFile, originalMessage, quickfixData, fixProviders, issue), ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            PsiElement startElement = psiFile.findElementAt(range.getStartOffset());
            PsiElement endElement = psiFile.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || this.isSuppressedFor(startElement)) continue;
            result.add(manager.createProblemDescriptor(startElement, endElement, formattedMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, this.getLocalQuickFixes(startElement, endElement, originalMessage, quickfixData, fixProviders, issue)));
        }
        ProblemDescriptor[] problemDescriptorArray = result.toArray(ProblemDescriptor.EMPTY_ARRAY);
        if (problemDescriptorArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(37);
        }
        return problemDescriptorArray;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressLintQuickFix suppressLintQuickFix = new SuppressLintQuickFix(this.myIssue.getId(), element);
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{suppressLintQuickFix};
        if (suppressQuickFixArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(38);
        }
        return suppressQuickFixArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void setRegisterDynamicToolsFromTests(boolean registerDynamicToolsFromTests) {
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            ourRegisterDynamicToolsFromTests = registerDynamicToolsFromTests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static List<Tools> getDynamicTools(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            List tools = (List)project.getUserData(DYNAMIC_TOOLS_KEY);
            return tools != null ? Collections.unmodifiableList(tools) : null;
        }
    }

    @Nullable
    public static Issue findIssueByShortName(@Nullable Project project, @NotNull String name) {
        if (name == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(39);
        }
        Object inspectionName = name.startsWith(LINT_INSPECTION_PREFIX) ? name : LINT_INSPECTION_PREFIX + name;
        Issue issue = null;
        List<Tools> tools = AndroidLintInspectionBase.getDynamicTools(project);
        if (tools != null) {
            for (Tools tools2 : tools) {
                InspectionProfileEntry e;
                if (!((String)inspectionName).equals(tools2.getShortName()) || !((e = tools2.getTool().getTool()) instanceof AndroidLintInspectionBase)) continue;
                issue = ((AndroidLintInspectionBase)e).getIssue();
                break;
            }
        }
        if (issue == null && project != null) {
            for (InspectionToolWrapper inspectionToolWrapper : AndroidLintInspectionBase.getInspectionTools(project)) {
                InspectionProfileEntry entry;
                if (!((String)inspectionName).equals(inspectionToolWrapper.getShortName()) || !((entry = inspectionToolWrapper.getTool()) instanceof AndroidLintInspectionBase)) continue;
                issue = ((AndroidLintInspectionBase)entry).getIssue();
            }
        }
        return issue;
    }

    @NotNull
    private static List<InspectionToolWrapper<?, ?>> getInspectionTools(@NotNull Project project) {
        List list;
        if (project == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(40);
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        try {
            list = profile.getInspectionTools(null);
        }
        catch (Throwable t) {
            LOG.warn("Couldn't look up inspection tools", t);
            List<InspectionToolWrapper<?, ?>> list2 = Collections.emptyList();
            if (list2 == null) {
                AndroidLintInspectionBase.$$$reportNull$$$0(42);
            }
            return list2;
        }
        if (list == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(41);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInspectionShortNameByIssue(@NotNull Project project, @NotNull Issue issue) {
        if (project == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(43);
        }
        if (issue == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(44);
        }
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            String name;
            HashMap<Issue, String> issue2InspectionShortName = (HashMap<Issue, String>)project.getUserData(ISSUE_MAP_KEY);
            if (issue2InspectionShortName == null) {
                issue2InspectionShortName = new HashMap<Issue, String>();
                project.putUserData(ISSUE_MAP_KEY, issue2InspectionShortName);
                for (InspectionToolWrapper<?, ?> e : AndroidLintInspectionBase.getInspectionTools(project)) {
                    InspectionProfileEntry entry;
                    String shortName = e.getShortName();
                    if (!shortName.startsWith(LINT_INSPECTION_PREFIX) || !((entry = e.getTool()) instanceof AndroidLintInspectionBase)) continue;
                    Issue s = ((AndroidLintInspectionBase)entry).getIssue();
                    issue2InspectionShortName.put(s, shortName);
                }
            }
            if ((name = (String)issue2InspectionShortName.get(issue)) == null && (!ApplicationManager.getApplication().isUnitTestMode() || ourRegisterDynamicToolsFromTests && !new BuiltinIssueRegistry().getIssues().contains(issue))) {
                AndroidLintInspectionBase tool = AndroidLintInspectionBase.createInspection(issue);
                LintInspectionFactory factory = new LintInspectionFactory(tool);
                InspectionProfileImpl base = InspectionProfileKt.getBASE_PROFILE();
                InspectionProfileImpl current = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
                base.addTool(project, (InspectionToolWrapper)factory, (Map)new THashMap());
                current.addTool(project, (InspectionToolWrapper)factory, (Map)new THashMap());
                name = tool.getShortName();
                issue2InspectionShortName.put(issue, name);
                ToolsImpl tools = current.getToolsOrNull(name, project);
                if (tools != null) {
                    ArrayList<ToolsImpl> ourDynamicTools = (ArrayList<ToolsImpl>)project.getUserData(DYNAMIC_TOOLS_KEY);
                    if (ourDynamicTools == null) {
                        ourDynamicTools = new ArrayList<ToolsImpl>();
                        project.putUserData(DYNAMIC_TOOLS_KEY, ourDynamicTools);
                    }
                    ourDynamicTools.add(tools);
                }
            }
            return name;
        }
    }

    private static AndroidLintInspectionBase createInspection(Issue issue) {
        return new AndroidLintInspectionBase(issue.getBriefDescription(TextFormat.TEXT), issue){};
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        Category category = this.myIssue.getCategory();
        while (category.getParent() != null) {
            category = category.getParent();
        }
        String string = LintBundle.message("android.lint.inspections.group.name", new Object[0]) + ": " + category.getName();
        if (string == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public String[] getGroupPath() {
        if (this.myGroupPath == null) {
            Category category = this.myIssue.getCategory();
            int count = 2;
            for (Category curr = category; curr != null; curr = curr.getParent()) {
                ++count;
            }
            String[] path = new String[count];
            while (category != null) {
                path[--count] = category.getName();
                category = category.getParent();
            }
            assert (count == 2);
            path[0] = LintBundle.message("android.inspections.group.name", new Object[0]);
            path[1] = LintBundle.message("android.lint.inspections.subgroup.name", new Object[0]);
            this.myGroupPath = path;
        }
        if (this.myGroupPath == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(46);
        }
        return this.myGroupPath;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(47);
        }
        return string;
    }

    public String getStaticDescription() {
        List urls;
        StringBuilder sb = new StringBuilder(1000);
        sb.append("<html><body>");
        sb.append(this.myIssue.getBriefDescription(TextFormat.HTML));
        sb.append("<br><br>");
        sb.append(this.myIssue.getExplanation(TextFormat.HTML));
        sb.append("<br><br>Issue id: ").append(this.myIssue.getId());
        List options = this.myIssue.getOptions();
        if (!options.isEmpty()) {
            sb.append("<br><br>");
            String optionsHtml = Option.Companion.describe(options, TextFormat.HTML, true);
            sb.append(optionsHtml);
        }
        if (!(urls = this.myIssue.getMoreInfo()).isEmpty()) {
            boolean separated = false;
            for (String url : urls) {
                if (this.myIssue.getExplanation(TextFormat.RAW).contains(url)) continue;
                if (!separated) {
                    sb.append("<br><br>");
                    separated = true;
                } else {
                    sb.append("<br>");
                }
                sb.append("<a href=\"");
                sb.append(url);
                sb.append("\">");
                sb.append(url);
                sb.append("</a>");
            }
        }
        Vendor vendor = this.myIssue.getVendor();
        IssueRegistry registry = this.myIssue.getRegistry();
        if (vendor == null && registry != null) {
            vendor = registry.getVendor();
        }
        if (vendor != null && vendor != IssueRegistry.Companion.getAOSP_VENDOR()) {
            sb.append("<br/><br/>\n");
            vendor.describeInto(sb, TextFormat.HTML, "");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public boolean isEnabledByDefault() {
        return this.myIssue.isEnabledByDefault();
    }

    @NotNull
    public String getShortName() {
        String string = LINT_INSPECTION_PREFIX + this.myIssue.getId();
        if (string == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        Severity defaultSeverity = this.myIssue.getDefaultSeverity();
        HighlightDisplayLevel displayLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(defaultSeverity);
        HighlightDisplayLevel highlightDisplayLevel = displayLevel != null ? displayLevel : HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(49);
        }
        return highlightDisplayLevel;
    }

    @Nullable
    static HighlightDisplayLevel toHighlightDisplayLevel(@NotNull Severity severity) {
        if (severity == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(50);
        }
        switch (severity) {
            case ERROR: 
            case FATAL: {
                return HighlightDisplayLevel.ERROR;
            }
            case WARNING: {
                return HighlightDisplayLevel.WARNING;
            }
            case INFORMATIONAL: {
                return HighlightDisplayLevel.WEAK_WARNING;
            }
            case IGNORE: {
                return null;
            }
        }
        LOG.error("Unknown severity " + severity);
        return null;
    }

    private static boolean isSingleFileScope(EnumSet<Scope> scopes) {
        if (scopes.size() != 1) {
            return false;
        }
        Scope scope = (Scope)scopes.iterator().next();
        return scope == Scope.JAVA_FILE || scope == Scope.RESOURCE_FILE || scope == Scope.MANIFEST || scope == Scope.PROGUARD_FILE || scope == Scope.OTHER;
    }

    public boolean worksInBatchModeOnly() {
        Implementation implementation = this.myIssue.getImplementation();
        if (AndroidLintInspectionBase.isSingleFileScope(implementation.getScope())) {
            return false;
        }
        for (EnumSet scopes : implementation.getAnalysisScopes()) {
            if (!AndroidLintInspectionBase.isSingleFileScope(scopes)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Issue getIssue() {
        Issue issue = this.myIssue;
        if (issue == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(51);
        }
        return issue;
    }

    public static LintIdeQuickFix[] createFixes(@Nullable PsiFile file, @Nullable LintFix lintFix) {
        if (lintFix instanceof LintFix.ReplaceString) {
            LintFix.ReplaceString data = (LintFix.ReplaceString)lintFix;
            String pattern = data.getOldPattern();
            String oldString = data.getOldString();
            Object regexp = pattern != null ? pattern : (oldString != null ? ("_lint_insert_begin_".equals(oldString) || "_lint_insert_end_".equals(oldString) ? oldString : "(" + Pattern.quote(oldString) + ")") : null);
            String displayName = data.getDisplayName();
            String familyName = data.getFamilyName();
            String replacement = data.getReplacement();
            boolean shortenNames = data.getShortenNames();
            boolean reformat = data.getReformat();
            String selectPattern = data.getSelectPattern();
            Location range = data.getRange();
            ReplaceStringQuickFix fix = new ReplaceStringQuickFix(displayName, familyName, (String)regexp, replacement);
            if (shortenNames) {
                fix.setShortenNames(true);
            }
            if (reformat) {
                fix.setFormat(true);
            }
            if (selectPattern != null) {
                fix.setSelectPattern(selectPattern);
            }
            if (range != null && file != null) {
                PsiFile rangeFile = file;
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)range.getFile(), (boolean)false);
                if (virtualFile != null) {
                    PsiFile psiFile = file.getManager().findFile(virtualFile);
                    if (psiFile != null) {
                        rangeFile = psiFile;
                    }
                } else {
                    File path = range.getFile();
                    CreateFileQuickFix createFix = new CreateFileQuickFix(path, replacement, null, null, false, data.getDisplayName(), familyName);
                    return new LintIdeQuickFix[]{createFix};
                }
                Position start = range.getStart();
                Position end = range.getEnd();
                if (start != null && end != null) {
                    SmartPointerManager manager = SmartPointerManager.getInstance((Project)rangeFile.getProject());
                    int startOffset = start.getOffset();
                    int endOffset = end.getOffset();
                    if (endOffset > startOffset) {
                        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
                        SmartPsiFileRange smartRange = manager.createSmartPsiFileRangePointer(rangeFile, textRange);
                        fix.setRange(smartRange);
                    }
                }
            }
            return new LintIdeQuickFix[]{fix};
        }
        if (lintFix instanceof LintFix.SetAttribute) {
            LintFix.SetAttribute data = (LintFix.SetAttribute)lintFix;
            if (data.getValue() == null) {
                return new LintIdeQuickFix[]{new RemoteAttributeFix(data)};
            }
            return new LintIdeQuickFix[]{new SetAttributeQuickFix(data.getDisplayName(), data.getFamilyName(), data.getAttribute(), data.getNamespace(), data.getValue(), data.getDot(), data.getMark())};
        }
        if (lintFix instanceof LintFix.CreateFileFix) {
            LintFix.CreateFileFix fix = (LintFix.CreateFileFix)lintFix;
            return new LintIdeQuickFix[]{new CreateFileQuickFix(fix.getFile(), fix.getText(), fix.getBinary(), fix.getSelectPattern(), fix.getReformat(), fix.getDisplayName(), fix.getFamilyName())};
        }
        if (lintFix instanceof LintFix.AnnotateFix) {
            LintFix.AnnotateFix fix = (LintFix.AnnotateFix)lintFix;
            return new LintIdeQuickFix[]{new AnnotateQuickFix(fix.getDisplayName(), fix.getFamilyName(), fix.getAnnotation(), fix.getReplace())};
        }
        if (lintFix instanceof LintFix.LintFixGroup) {
            LintFix.LintFixGroup group = (LintFix.LintFixGroup)lintFix;
            ArrayList fixList = new ArrayList();
            for (LintFix fix : group.getFixes()) {
                Collections.addAll(fixList, AndroidLintInspectionBase.createFixes(file, fix));
            }
            LintIdeQuickFix[] fixes = fixList.toArray(LintIdeQuickFix.EMPTY_ARRAY);
            switch (group.getType()) {
                case COMPOSITE: {
                    return new LintIdeQuickFix[]{new CompositeLintFix(lintFix.getDisplayName(), lintFix.getFamilyName(), fixes)};
                }
                case ALTERNATIVES: {
                    if (fixes.length > 1) {
                        fixes[0].setPriority(PriorityAction.Priority.TOP);
                    }
                    return fixes;
                }
            }
        } else if (lintFix instanceof LintFix.ShowUrl) {
            return new LintIdeQuickFix[]{new ShowUrlQuickFix((LintFix.ShowUrl)lintFix)};
        }
        return LintIdeQuickFix.EMPTY_ARRAY;
    }

    static {
        LintClient.setClientName((String)"studio");
        LOG = Logger.getInstance((String)"#com.android.tools.idea.lint.common.AndroidLintInspectionBase");
        ISSUE_MAP_LOCK = new Object();
        ISSUE_MAP_KEY = Key.create((String)(AndroidLintInspectionBase.class.getName() + ".ISSUE_MAP"));
        DYNAMIC_TOOLS_KEY = Key.create((String)(AndroidLintInspectionBase.class.getName() + ".DYNAMIC_TOOLS"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 19: 
            case 25: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/AndroidLintInspectionBase";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixProviders";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/AndroidLintInspectionBase";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFixes";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalQuickFixes";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "computeProblemDescriptors";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionTools";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIntentions";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAllFixes";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLocalQuickFixes";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "runInspection";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "computeProblemDescriptors";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findIssueByShortName";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionTools";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionShortNameByIssue";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "toHighlightDisplayLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonTextFileProblemDescriptor
    implements ProblemDescriptor {
        private final PsiFileSystemItem myFile;
        private final String myMessage;
        private final LocalQuickFix[] myFixes;
        private ProblemGroup myGroup;

        private NonTextFileProblemDescriptor(@NotNull PsiFileSystemItem file, @NotNull String message, @NotNull LocalQuickFix[] fixes) {
            if (file == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(0);
            }
            if (message == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(1);
            }
            if (fixes == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(2);
            }
            this.myFile = file;
            this.myMessage = message;
            this.myFixes = fixes;
        }

        public PsiElement getPsiElement() {
            return this.myFile;
        }

        public PsiElement getStartElement() {
            return this.myFile;
        }

        public PsiElement getEndElement() {
            return this.myFile;
        }

        public TextRange getTextRangeInElement() {
            return new TextRange(0, 0);
        }

        public int getLineNumber() {
            return 0;
        }

        @NotNull
        public ProblemHighlightType getHighlightType() {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (problemHighlightType == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(3);
            }
            return problemHighlightType;
        }

        public boolean isAfterEndOfLine() {
            return false;
        }

        public void setTextAttributes(TextAttributesKey key) {
        }

        @Nullable
        public ProblemGroup getProblemGroup() {
            return this.myGroup;
        }

        public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
            this.myGroup = problemGroup;
        }

        public boolean showTooltip() {
            return false;
        }

        @NotNull
        public String getDescriptionTemplate() {
            String string = this.myMessage;
            if (string == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public QuickFix[] getFixes() {
            return this.myFixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/AndroidLintInspectionBase$NonTextFileProblemDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/AndroidLintInspectionBase$NonTextFileProblemDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptionTemplate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class MyLocalQuickFix
    extends InspectionGadgetsFix {
        private final LintIdeQuickFix myLintQuickFix;

        MyLocalQuickFix(@NotNull LintIdeQuickFix lintQuickFix) {
            if (lintQuickFix == null) {
                MyLocalQuickFix.$$$reportNull$$$0(0);
            }
            this.myLintQuickFix = lintQuickFix;
        }

        @NotNull
        public String getName() {
            String string = this.myLintQuickFix.getName();
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String familyName = this.myLintQuickFix.getFamilyName();
            if (familyName != null) {
                String string = familyName;
                if (string == null) {
                    MyLocalQuickFix.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = this.myLintQuickFix.getName();
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected void doFix(Project project, ProblemDescriptor descriptor) {
            this.myLintQuickFix.apply(descriptor.getStartElement(), descriptor.getEndElement(), AndroidQuickfixContexts.BatchContext.getInstance());
        }

        public boolean startInWriteAction() {
            return this.myLintQuickFix.startInWriteAction();
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                MyLocalQuickFix.$$$reportNull$$$0(4);
            }
            return currentFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lintQuickFix";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/AndroidLintInspectionBase$MyLocalQuickFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/AndroidLintInspectionBase$MyLocalQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RemoteAttributeFix
    extends DefaultLintQuickFix {
        private final LintFix.SetAttribute myData;

        RemoteAttributeFix(LintFix.SetAttribute data) {
            super(data.getDisplayName(), data.getFamilyName());
            this.myData = data;
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            XmlAttribute attribute;
            if (startElement == null) {
                RemoteAttributeFix.$$$reportNull$$$0(0);
            }
            if (endElement == null) {
                RemoteAttributeFix.$$$reportNull$$$0(1);
            }
            if (context == null) {
                RemoteAttributeFix.$$$reportNull$$$0(2);
            }
            if ((attribute = this.findAttribute(startElement)) != null && attribute.isValid()) {
                attribute.delete();
            }
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            XmlAttribute attribute;
            if (startElement == null) {
                RemoteAttributeFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                RemoteAttributeFix.$$$reportNull$$$0(4);
            }
            if (contextType == null) {
                RemoteAttributeFix.$$$reportNull$$$0(5);
            }
            return (attribute = this.findAttribute(startElement)) != null && attribute.isValid();
        }

        @Nullable
        private XmlAttribute findAttribute(@NotNull PsiElement startElement) {
            XmlTag tag;
            if (startElement == null) {
                RemoteAttributeFix.$$$reportNull$$$0(6);
            }
            if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false)) == null) {
                return null;
            }
            return this.myData.getNamespace() != null ? tag.getAttribute(this.myData.getAttribute(), this.myData.getNamespace()) : tag.getAttribute(this.myData.getAttribute());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextType";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/lint/common/AndroidLintInspectionBase$RemoteAttributeFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicable";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findAttribute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CompositeLintFix
    extends DefaultLintQuickFix {
        private final LintIdeQuickFix[] myFixes;

        CompositeLintFix(String displayName, String familyName, LintIdeQuickFix[] myFixes) {
            super(displayName != null ? displayName : "Fix", familyName);
            this.myFixes = myFixes;
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            if (startElement == null) {
                CompositeLintFix.$$$reportNull$$$0(0);
            }
            if (endElement == null) {
                CompositeLintFix.$$$reportNull$$$0(1);
            }
            if (context == null) {
                CompositeLintFix.$$$reportNull$$$0(2);
            }
            for (LintIdeQuickFix fix : this.myFixes) {
                fix.apply(startElement, endElement, context);
            }
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            if (startElement == null) {
                CompositeLintFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                CompositeLintFix.$$$reportNull$$$0(4);
            }
            if (contextType == null) {
                CompositeLintFix.$$$reportNull$$$0(5);
            }
            for (LintIdeQuickFix fix : this.myFixes) {
                if (fix.isApplicable(startElement, endElement, contextType)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextType";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/lint/common/AndroidLintInspectionBase$CompositeLintFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LintInspectionFactory
    extends GlobalInspectionToolWrapper {
        private final AndroidLintInspectionBase myInspection;

        private LintInspectionFactory(AndroidLintInspectionBase inspection) {
            super((GlobalInspectionTool)inspection);
            this.myInspection = inspection;
        }

        public boolean isEnabledByDefault() {
            return this.myInspection.isEnabledByDefault();
        }

        @NotNull
        public GlobalInspectionToolWrapper createCopy() {
            return new LintInspectionFactory(AndroidLintInspectionBase.createInspection(this.myInspection.myIssue));
        }
    }
}

