/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.io;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.io.BufferProducer;
import trebuchet.io.DataSlice;
import trebuchet.io.GenericByteBuffer;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0002J\u001e\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005J\u0011\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0005H\u0096\u0002J\u000e\u0010-\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u0005R \u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR(\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00168F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\nR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00061"}, d2={"Ltrebuchet/io/StreamingReader;", "Ltrebuchet/io/GenericByteBuffer;", "source", "Ltrebuchet/io/BufferProducer;", "keepLoadedSize", "", "(Ltrebuchet/io/BufferProducer;I)V", "<set-?>", "endIndex", "getEndIndex", "()I", "getKeepLoadedSize", "length", "getLength", "onWindowReleased", "Lkotlin/Function1;", "Ltrebuchet/io/StreamingReader$Window;", "", "getOnWindowReleased", "()Lkotlin/jvm/functions/Function1;", "setOnWindowReleased", "(Lkotlin/jvm/functions/Function1;)V", "", "reachedEof", "getReachedEof", "()Z", "getSource", "()Ltrebuchet/io/BufferProducer;", "startIndex", "getStartIndex", "windows", "", "getWindows", "()Ljava/util/List;", "addBuffer", "buffer", "Ltrebuchet/io/DataSlice;", "copyTo", "tmpBuffer", "", "lineStartIndex", "lineEndIndex", "get", "", "index", "loadIndex", "windowFor", "i", "Window", "intellij.android.profilers.atrace"})
public final class StreamingReader
implements GenericByteBuffer {
    @NotNull
    private final List<Window> windows;
    @Nullable
    private Function1<? super Window, Unit> onWindowReleased;
    private int startIndex;
    private int endIndex;
    private boolean reachedEof;
    @NotNull
    private final BufferProducer source;
    private final int keepLoadedSize;

    @NotNull
    public final List<Window> getWindows() {
        return this.windows;
    }

    @Nullable
    public final Function1<Window, Unit> getOnWindowReleased() {
        return this.onWindowReleased;
    }

    public final void setOnWindowReleased(@Nullable Function1<? super Window, Unit> function1) {
        this.onWindowReleased = function1;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    public final int getEndIndex() {
        return this.endIndex;
    }

    public final boolean getReachedEof() {
        return this.reachedEof;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte get(int index) {
        void this_$iv$iv;
        Window this_$iv = this.windowFor(index);
        boolean $i$f$get = false;
        DataSlice dataSlice = this_$iv.getSlice();
        int i$iv$iv = index - this_$iv.getGlobalStartIndex();
        boolean $i$f$get2 = false;
        return this_$iv$iv.getBuffer()[this_$iv$iv.getStartIndex() + i$iv$iv];
    }

    @Override
    public int getLength() {
        return this.endIndex - this.startIndex + 1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Window windowFor(int i) {
        int n = 0;
        int n2 = this.windows.size() - 1;
        if (n <= n2) {
            while (true) {
                void wi;
                Window window;
                if ((window = this.windows.get((int)wi)).getGlobalStartIndex() <= i && window.getGlobalEndIndex() >= i) {
                    return window;
                }
                if (wi == n2) break;
                ++wi;
            }
        }
        throw (Throwable)new IndexOutOfBoundsException(i + " not in range " + this.startIndex + ".." + this.endIndex);
    }

    public final boolean loadIndex(int index) {
        while (this.endIndex < index && !this.reachedEof) {
            DataSlice nextBuffer = this.source.next();
            if (nextBuffer == null) {
                this.reachedEof = true;
                return false;
            }
            this.addBuffer(nextBuffer);
        }
        return index <= this.endIndex;
    }

    private final void addBuffer(DataSlice buffer) {
        DataSlice this_$iv = buffer;
        boolean $i$f$getLength = false;
        this.windows.add(new Window(buffer, this.endIndex + 1, this.endIndex + (this_$iv.getEndIndex() - this_$iv.getStartIndex())));
        this_$iv = buffer;
        $i$f$getLength = false;
        this.endIndex += this_$iv.getEndIndex() - this_$iv.getStartIndex();
        if (this.windows.size() > 2 && this.endIndex - this.windows.get(1).getGlobalStartIndex() > this.keepLoadedSize) {
            Window temp = this.windows.get(0);
            this.windows.remove(0);
            this.startIndex = this.windows.get(0).getGlobalStartIndex();
            if (this.onWindowReleased != null) {
                Function1<? super Window, Unit> function1 = this.onWindowReleased;
                Intrinsics.checkNotNull(function1);
                function1.invoke((Object)temp);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void copyTo(@NotNull byte[] tmpBuffer, int lineStartIndex, int lineEndIndex) {
        Intrinsics.checkNotNullParameter((Object)tmpBuffer, (String)"tmpBuffer");
        int srcIndex = lineStartIndex;
        int dstIndex = 0;
        while (srcIndex <= lineEndIndex && dstIndex < tmpBuffer.length) {
            Window window = this.windowFor(srcIndex);
            while (srcIndex <= window.getGlobalEndIndex() && dstIndex < tmpBuffer.length) {
                void this_$iv$iv;
                void this_$iv;
                int n = dstIndex++;
                Window window2 = window;
                int i$iv = srcIndex++;
                boolean $i$f$get = false;
                DataSlice dataSlice = this_$iv.getSlice();
                int i$iv$iv = i$iv - this_$iv.getGlobalStartIndex();
                boolean $i$f$get2 = false;
                tmpBuffer[n] = this_$iv$iv.getBuffer()[this_$iv$iv.getStartIndex() + i$iv$iv];
            }
        }
    }

    @NotNull
    public final BufferProducer getSource() {
        return this.source;
    }

    public final int getKeepLoadedSize() {
        return this.keepLoadedSize;
    }

    public StreamingReader(@NotNull BufferProducer source, int keepLoadedSize) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.keepLoadedSize = keepLoadedSize;
        this.windows = new ArrayList();
        this.endIndex = -1;
    }

    public /* synthetic */ StreamingReader(BufferProducer bufferProducer, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 8096;
        }
        this(bufferProducer, n);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0086\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Ltrebuchet/io/StreamingReader$Window;", "", "slice", "Ltrebuchet/io/DataSlice;", "globalStartIndex", "", "globalEndIndex", "(Ltrebuchet/io/DataSlice;II)V", "getGlobalEndIndex", "()I", "getGlobalStartIndex", "getSlice", "()Ltrebuchet/io/DataSlice;", "get", "", "i", "intellij.android.profilers.atrace"})
    public static final class Window {
        @NotNull
        private final DataSlice slice;
        private final int globalStartIndex;
        private final int globalEndIndex;

        /*
         * WARNING - void declaration
         */
        public final byte get(int i) {
            void this_$iv;
            int $i$f$get = 0;
            DataSlice dataSlice = this.getSlice();
            int i$iv = i - this.getGlobalStartIndex();
            boolean $i$f$get2 = false;
            return this_$iv.getBuffer()[this_$iv.getStartIndex() + i$iv];
        }

        @NotNull
        public final DataSlice getSlice() {
            return this.slice;
        }

        public final int getGlobalStartIndex() {
            return this.globalStartIndex;
        }

        public final int getGlobalEndIndex() {
            return this.globalEndIndex;
        }

        public Window(@NotNull DataSlice slice, int globalStartIndex, int globalEndIndex) {
            Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
            this.slice = slice;
            this.globalStartIndex = globalStartIndex;
            this.globalEndIndex = globalEndIndex;
        }
    }
}

