/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.perfetto;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.MainProcessSelector;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.systemtrace.AtraceParser;
import com.android.tools.profilers.cpu.systemtrace.ProcessListSorter;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceCpuCaptureBuilder;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorService;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import perfetto.protos.PerfettoTrace;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/perfetto/PerfettoParser;", "Lcom/android/tools/profilers/cpu/TraceParser;", "mainProcessSelector", "Lcom/android/tools/profilers/cpu/MainProcessSelector;", "ideProfilerServices", "Lcom/android/tools/profilers/IdeProfilerServices;", "(Lcom/android/tools/profilers/cpu/MainProcessSelector;Lcom/android/tools/profilers/IdeProfilerServices;)V", "parse", "Lcom/android/tools/profilers/cpu/CpuCapture;", "file", "Ljava/io/File;", "traceId", "", "parseUsingTraceProcessor", "parseUsingTrebuchet", "Companion", "intellij.android.profilers"})
public final class PerfettoParser
implements TraceParser {
    private final MainProcessSelector mainProcessSelector;
    private final IdeProfilerServices ideProfilerServices;
    private static final Logger LOGGER;
    @NotNull
    private static final Object TPD_LOCK;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public CpuCapture parse(@NotNull File file, long traceId) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FeatureConfig featureConfig = this.ideProfilerServices.getFeatureConfig();
        Intrinsics.checkNotNullExpressionValue((Object)featureConfig, (String)"ideProfilerServices.featureConfig");
        if (featureConfig.isUseTraceProcessor()) {
            return this.parseUsingTraceProcessor(file, traceId);
        }
        return this.parseUsingTrebuchet(file, traceId);
    }

    private final CpuCapture parseUsingTrebuchet(File file, long traceId) {
        AtraceParser atraceParser = new AtraceParser(Cpu.CpuTraceType.PERFETTO, this.mainProcessSelector);
        CpuCapture cpuCapture = atraceParser.parse(file, traceId);
        Intrinsics.checkNotNullExpressionValue((Object)cpuCapture, (String)"atraceParser.parse(file, traceId)");
        return cpuCapture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CpuCapture parseUsingTraceProcessor(File file, long traceId) {
        Object object;
        Object object2 = object = TPD_LOCK;
        synchronized (object2) {
            Object v8;
            Collection collection;
            ProcessModel selectedProcess;
            Integer userSelectedProcess;
            Range initialViewRange;
            TraceProcessorService traceProcessor;
            block20: {
                Object element$iv2;
                Object object32;
                List<ProcessModel> processList;
                block19: {
                    ProcessListSorter processListSorter;
                    boolean bl;
                    boolean bl2 = false;
                    TraceProcessorService traceProcessorService = this.ideProfilerServices.getTraceProcessorService();
                    Intrinsics.checkNotNullExpressionValue((Object)traceProcessorService, (String)"ideProfilerServices.traceProcessorService");
                    traceProcessor = traceProcessorService;
                    boolean traceLoaded = traceProcessor.loadTrace(traceId, file, this.ideProfilerServices);
                    if (!traceLoaded) {
                        String string = "Unable to load trace with TPD.";
                        throw new IllegalStateException(string.toString());
                    }
                    processList = traceProcessor.getProcessMetadata(traceId, this.ideProfilerServices);
                    Collection collection2 = processList;
                    boolean bl3 = bl = !collection2.isEmpty();
                    if (!bl) {
                        boolean $i$a$-check-PerfettoParser$parseUsingTraceProcessor$1$22 = false;
                        String $i$a$-check-PerfettoParser$parseUsingTraceProcessor$1$22 = "Invalid trace without any process information.";
                        throw new IllegalStateException($i$a$-check-PerfettoParser$parseUsingTraceProcessor$1$22.toString());
                    }
                    List<String> traceUIMetadata = traceProcessor.getTraceMetadata(traceId, "ui_state", this.ideProfilerServices);
                    Object processHint = this.mainProcessSelector.getNameHint();
                    initialViewRange = new Range();
                    Collection collection3 = traceUIMetadata;
                    if (!collection3.isEmpty()) {
                        try {
                            PerfettoTrace.UiState uiState;
                            PerfettoTrace.UiState uiState2 = uiState = PerfettoTrace.UiState.parseFrom((byte[])Base64.getDecoder().decode((String)CollectionsKt.last(traceUIMetadata)));
                            Intrinsics.checkNotNullExpressionValue((Object)uiState2, (String)"uiState");
                            if (uiState2.getHighlightProcess().hasPid()) {
                                Object object4;
                                Iterator iterator;
                                block18: {
                                    Iterable iterable;
                                    int wantedProcessId = uiState.getHighlightProcess().getPid();
                                    Iterable iterable2 = iterable = (Iterable)processList;
                                    for (Object object32 : iterable2) {
                                        ProcessModel it = (ProcessModel)object32;
                                        boolean bl4 = false;
                                        if (!(it.getId() == wantedProcessId)) continue;
                                        iterator = object32;
                                        break block18;
                                    }
                                    iterator = null;
                                }
                                if ((object4 = (ProcessModel)((Object)iterator)) == null || (object4 = ((ProcessModel)object4).getSafeProcessName()) == null) {
                                    object4 = this.mainProcessSelector.getNameHint();
                                }
                                processHint = object4;
                            } else if (uiState.getHighlightProcess().hasCmdline()) {
                                PerfettoTrace.UiState.HighlightProcess highlightProcess = uiState.getHighlightProcess();
                                Intrinsics.checkNotNullExpressionValue((Object)highlightProcess, (String)"uiState.highlightProcess");
                                String string = highlightProcess.getCmdline();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uiState.highlightProcess.cmdline");
                                processHint = string;
                            }
                            if (uiState.getTimelineStartTs() != 0L && uiState.getTimelineEndTs() != 0L) {
                                initialViewRange.set((double)TimeUnit.NANOSECONDS.toMicros(uiState.getTimelineStartTs()), (double)TimeUnit.NANOSECONDS.toMicros(uiState.getTimelineEndTs()));
                            }
                        }
                        catch (Throwable throwable) {
                            LOGGER.warn("Trace contained ui-state, however it failed to parse correctly. Ui state will not be loaded", throwable);
                        }
                    }
                    if ((userSelectedProcess = this.mainProcessSelector.apply((processListSorter = new ProcessListSorter((String)processHint)).sort(processList))) == null) {
                        boolean $i$a$-checkNotNull-PerfettoParser$parseUsingTraceProcessor$1$42 = false;
                        String $i$a$-checkNotNull-PerfettoParser$parseUsingTraceProcessor$1$42 = "It was not possible to select a process for this trace.";
                        throw new IllegalStateException($i$a$-checkNotNull-PerfettoParser$parseUsingTraceProcessor$1$42.toString());
                    }
                    Iterable $this$first$iv = processList;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        ProcessModel processModel = (ProcessModel)element$iv2;
                        boolean bl5 = false;
                        Integer n = userSelectedProcess;
                        if (!(n != null && processModel.getId() == n.intValue())) continue;
                        break block19;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                selectedProcess = (ProcessModel)element$iv2;
                Iterable $i$f$first = processList;
                collection = CollectionsKt.listOf((Object)selectedProcess);
                object32 = $i$f$first;
                Iterator iterator = object32.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    ProcessModel it = (ProcessModel)t;
                    boolean bl = false;
                    if (!StringsKt.endsWith$default((String)it.getSafeProcessName(), (String)"surfaceflinger", (boolean)false, (int)2, null)) continue;
                    v8 = t;
                    break block20;
                }
                v8 = null;
            }
            Object var24_37 = v8;
            List processesToQuery = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOfNotNull(var24_37)));
            SystemTraceModelAdapter model = traceProcessor.loadCpuData(traceId, processesToQuery, selectedProcess, this.ideProfilerServices);
            SystemTraceCpuCaptureBuilder builder = new SystemTraceCpuCaptureBuilder(model);
            if (initialViewRange.isEmpty()) {
                initialViewRange.set((double)model.getCaptureStartTimestampUs(), (double)model.getCaptureEndTimestampUs());
            }
            CpuCapture cpuCapture = builder.build(traceId, userSelectedProcess, initialViewRange);
            return cpuCapture;
        }
    }

    public PerfettoParser(@NotNull MainProcessSelector mainProcessSelector, @NotNull IdeProfilerServices ideProfilerServices) {
        Intrinsics.checkNotNullParameter((Object)mainProcessSelector, (String)"mainProcessSelector");
        Intrinsics.checkNotNullParameter((Object)ideProfilerServices, (String)"ideProfilerServices");
        this.mainProcessSelector = mainProcessSelector;
        this.ideProfilerServices = ideProfilerServices;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(PerfettoParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(PerfettoParser::class.java)");
        LOGGER = logger;
        TPD_LOCK = new Object();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/profilers/perfetto/PerfettoParser$Companion;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TPD_LOCK", "getTPD_LOCK", "()Ljava/lang/Object;", "intellij.android.profilers"})
    public static final class Companion {
        @NotNull
        public final Object getTPD_LOCK() {
            return TPD_LOCK;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

