/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.httpdata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedMap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class HttpData {
    private final long myId;
    private final long myRequestStartTimeUs;
    private final long myRequestCompleteTimeUs;
    private final long myResponseStartTimeUs;
    private final long myResponseCompleteTimeUs;
    private final long myConnectionEndTimeUs;
    @NotNull
    private final String myUrl;
    @NotNull
    private final String myMethod;
    @NotNull
    private final String myTrace;
    @NotNull
    private final List<JavaThread> myThreads;
    @NotNull
    private final RequestHeader myRequestHeader;
    @NotNull
    private final ResponseHeader myResponseHeader;
    @NotNull
    private final String myRequestPayloadId;
    @NotNull
    private final String myResponsePayloadId;
    private final int myResponsePayloadSize;

    private HttpData(@NotNull Builder builder) {
        if (builder == null) {
            HttpData.$$$reportNull$$$0(0);
        }
        this.myId = builder.myId;
        this.myRequestStartTimeUs = builder.myRequestStartTimeUs;
        this.myRequestCompleteTimeUs = builder.myRequestCompleteTimeUs;
        this.myResponseStartTimeUs = builder.myResponseStartTimeUs;
        this.myResponseCompleteTimeUs = builder.myResponseCompleteTimeUs;
        this.myConnectionEndTimeUs = builder.myConnectionEndTimeUs;
        this.myUrl = builder.myUrl;
        this.myMethod = builder.myMethod;
        this.myTrace = builder.myTrace;
        this.myThreads = builder.myThreads;
        this.myResponsePayloadSize = builder.myResponsePayloadSize;
        this.myRequestPayloadId = builder.myRequestPayloadId;
        this.myResponsePayloadId = builder.myResponsePayloadId;
        this.myRequestHeader = new RequestHeader(builder.myRequestFields);
        this.myResponseHeader = new ResponseHeader(builder.myResponseFields);
    }

    public long getId() {
        return this.myId;
    }

    public long getRequestStartTimeUs() {
        return this.myRequestStartTimeUs;
    }

    public long getRequestCompleteTimeUs() {
        return this.myRequestCompleteTimeUs;
    }

    public long getResponseStartTimeUs() {
        return this.myResponseStartTimeUs;
    }

    public long getResponseCompleteTimeUs() {
        return this.myResponseCompleteTimeUs;
    }

    public long getConnectionEndTimeUs() {
        return this.myConnectionEndTimeUs;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            HttpData.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getMethod() {
        String string = this.myMethod;
        if (string == null) {
            HttpData.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getTrace() {
        String string = this.myTrace;
        if (string == null) {
            HttpData.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public List<JavaThread> getJavaThreads() {
        List<JavaThread> list = this.myThreads;
        if (list == null) {
            HttpData.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public String getRequestPayloadId() {
        String string = this.myRequestPayloadId;
        if (string == null) {
            HttpData.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getResponsePayloadId() {
        String string = this.myResponsePayloadId;
        if (string == null) {
            HttpData.$$$reportNull$$$0(6);
        }
        return string;
    }

    public int getResponsePayloadSize() {
        return this.myResponsePayloadSize;
    }

    @NotNull
    public RequestHeader getRequestHeader() {
        RequestHeader requestHeader = this.myRequestHeader;
        if (requestHeader == null) {
            HttpData.$$$reportNull$$$0(7);
        }
        return requestHeader;
    }

    @NotNull
    public ResponseHeader getResponseHeader() {
        ResponseHeader responseHeader = this.myResponseHeader;
        if (responseHeader == null) {
            HttpData.$$$reportNull$$$0(8);
        }
        return responseHeader;
    }

    @NotNull
    public static String getUrlName(@NotNull String url) {
        Object object;
        Object name;
        URI uri;
        block11: {
            if (url == null) {
                HttpData.$$$reportNull$$$0(9);
            }
            uri = URI.create(URLEncoder.encode(url, "UTF-8"));
            Object object2 = name = uri.getPath() != null ? StringUtil.trimTrailing((String)uri.getPath(), (char)'/') : "";
            if (!((String)name).isEmpty()) break block11;
            String string = uri.getHost();
            if (string == null) {
                HttpData.$$$reportNull$$$0(10);
            }
            return string;
        }
        try {
            String lastName;
            Object object3 = name = ((String)name).lastIndexOf(47) != -1 ? ((String)name).substring(((String)name).lastIndexOf(47) + 1) : name;
            if (uri.getQuery() != null) {
                name = (String)name + "?" + uri.getQuery();
            }
            do {
                lastName = name;
            } while (!((String)(name = URLUtil.decode((String)name))).equals(lastName));
            object = name;
        }
        catch (UnsupportedEncodingException | IllegalArgumentException ignored) {
            int lastSlash = url.lastIndexOf(47, url.length() - 2);
            if (lastSlash >= 0) {
                String string = url.substring(lastSlash + 1);
                if (string == null) {
                    HttpData.$$$reportNull$$$0(12);
                }
                return string;
            }
            String string = url;
            if (string == null) {
                HttpData.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (object == null) {
            HttpData.$$$reportNull$$$0(11);
        }
        return object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpData data = (HttpData)o;
        return this.myId == data.myId;
    }

    public int hashCode() {
        return Objects.hash(this.myId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/httpdata/HttpData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/httpdata/HttpData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaThreads";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestPayloadId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponsePayloadId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestHeader";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseHeader";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUrlName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        private final long myId;
        private final long myRequestStartTimeUs;
        private final long myRequestCompleteTimeUs;
        private final long myResponseStartTimeUs;
        private final long myResponseCompleteTimeUs;
        private final long myConnectionEndTimeUs;
        private String myUrl;
        private String myMethod;
        private String myResponseFields;
        private String myRequestFields;
        private String myResponsePayloadId;
        private String myRequestPayloadId;
        private int myResponsePayloadSize;
        private String myTrace;
        private List<JavaThread> myThreads;

        public Builder(long id, long requestStartTimeUs, long requestCompleteTimeUs, long responseStartTimeUs, long responseCompleteTimeUs, long connectionEndTimeUs, List<JavaThread> threads) {
            this.myUrl = "";
            this.myMethod = "";
            this.myResponseFields = "";
            this.myRequestFields = "";
            this.myResponsePayloadId = "";
            this.myRequestPayloadId = "";
            this.myTrace = "";
            this.myThreads = new ArrayList<JavaThread>();
            this.myId = id;
            this.myRequestStartTimeUs = requestStartTimeUs;
            this.myRequestCompleteTimeUs = requestCompleteTimeUs;
            this.myResponseStartTimeUs = responseStartTimeUs;
            this.myResponseCompleteTimeUs = responseCompleteTimeUs;
            this.myConnectionEndTimeUs = connectionEndTimeUs;
            assert (!threads.isEmpty()) : "HttpData.Builder must be initialized with at least one thread";
            threads.forEach(this::addJavaThread);
        }

        @VisibleForTesting
        public Builder(@NotNull HttpData template) {
            if (template == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this(template.getId(), template.getRequestStartTimeUs(), template.getRequestCompleteTimeUs(), template.getResponseStartTimeUs(), template.getResponseCompleteTimeUs(), template.getConnectionEndTimeUs(), template.getJavaThreads());
            this.setUrl(template.getUrl());
            this.setMethod(template.getMethod());
            this.setTrace(template.getTrace());
        }

        @NotNull
        public Builder setUrl(@NotNull String url) {
            if (url == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myUrl = url;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setMethod(@NotNull String method) {
            if (method == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myMethod = method;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setTrace(@NotNull String trace) {
            if (trace == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myTrace = trace;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder addJavaThread(@NotNull JavaThread thread2) {
            if (thread2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            if (this.myThreads.stream().noneMatch(t -> t.getId() == thread2.getId())) {
                this.myThreads.add(thread2);
            }
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder setResponseFields(@NotNull String responseFields) {
            if (responseFields == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myResponseFields = responseFields;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public Builder setResponsePayloadId(@NotNull String payloadId) {
            if (payloadId == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myResponsePayloadId = payloadId;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder setResponsePayloadSize(int payloadSize) {
            this.myResponsePayloadSize = payloadSize;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public Builder setRequestPayloadId(@NotNull String payloadId) {
            if (payloadId == null) {
                Builder.$$$reportNull$$$0(14);
            }
            this.myRequestPayloadId = payloadId;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(15);
            }
            return builder;
        }

        @NotNull
        public Builder setRequestFields(@NotNull String requestFields) {
            if (requestFields == null) {
                Builder.$$$reportNull$$$0(16);
            }
            this.myRequestFields = requestFields;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(17);
            }
            return builder;
        }

        @NotNull
        public HttpData build() {
            return new HttpData(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/httpdata/HttpData$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thread";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "responseFields";
                    break;
                }
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "payloadId";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestFields";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/httpdata/HttpData$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setUrl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMethod";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTrace";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addJavaThread";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setResponseFields";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setResponsePayloadId";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setResponsePayloadSize";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRequestPayloadId";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRequestFields";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setUrl";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setMethod";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setTrace";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addJavaThread";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setResponseFields";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setResponsePayloadId";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "setRequestPayloadId";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "setRequestFields";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class JavaThread {
        private final long myId;
        @NotNull
        private final String myName;

        /*
         * WARNING - void declaration
         */
        public JavaThread(long id, @NotNull String string) {
            void name;
            if (string == null) {
                JavaThread.$$$reportNull$$$0(0);
            }
            this.myId = id;
            this.myName = name;
        }

        public long getId() {
            return this.myId;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                JavaThread.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/httpdata/HttpData$JavaThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/httpdata/HttpData$JavaThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class RequestHeader
    extends Header {
        @NotNull
        private final String myRawFields;
        @NotNull
        private final ImmutableSortedMap<String, String> myFields;

        RequestHeader(String fields) {
            this.myRawFields = fields;
            this.myFields = new ImmutableSortedMap.Builder(String.CASE_INSENSITIVE_ORDER).putAll(RequestHeader.parseHeaderFields(fields)).build();
        }

        @TestOnly
        @NotNull
        public String getRawFields() {
            String string = this.myRawFields;
            if (string == null) {
                RequestHeader.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public ImmutableSortedMap<String, String> getFields() {
            ImmutableSortedMap<String, String> immutableSortedMap = this.myFields;
            if (immutableSortedMap == null) {
                RequestHeader.$$$reportNull$$$0(1);
            }
            return immutableSortedMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/profilers/network/httpdata/HttpData$RequestHeader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRawFields";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFields";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static final class ResponseHeader
    extends Header {
        private static final String STATUS_CODE_NAME = "response-status-code";
        public static final int NO_STATUS_CODE = -1;
        @NotNull
        private final String myRawFields;
        @NotNull
        private final ImmutableSortedMap<String, String> myFields;
        private int myStatusCode = -1;

        ResponseHeader(String fields) {
            Map<String, String> fieldsMap;
            String[] tokens;
            this.myRawFields = fields;
            fields = fields.trim();
            if (fields.isEmpty()) {
                this.myFields = new ImmutableSortedMap.Builder(String.CASE_INSENSITIVE_ORDER).build();
                return;
            }
            String[] firstLineSplit = fields.split("\\n", 2);
            String status = firstLineSplit[0].trim();
            if (!status.isEmpty() && (status = (tokens = status.split("=", 2))[tokens.length - 1].trim()).startsWith("HTTP/1.")) {
                this.myStatusCode = Integer.parseInt(status.split(" ")[1]);
                String string = fields = firstLineSplit.length > 1 ? firstLineSplit[1] : "";
            }
            if ((fieldsMap = ResponseHeader.parseHeaderFields(fields)).containsKey(STATUS_CODE_NAME)) {
                String statusCode = fieldsMap.remove(STATUS_CODE_NAME);
                this.myStatusCode = Integer.parseInt(statusCode);
            }
            assert (this.myStatusCode != -1) : String.format("Unexpected http response (%s)", fields);
            this.myFields = new ImmutableSortedMap.Builder(String.CASE_INSENSITIVE_ORDER).putAll(fieldsMap).build();
        }

        public int getStatusCode() {
            return this.myStatusCode;
        }

        @TestOnly
        @NotNull
        public String getRawFields() {
            String string = this.myRawFields;
            if (string == null) {
                ResponseHeader.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public ImmutableSortedMap<String, String> getFields() {
            ImmutableSortedMap<String, String> immutableSortedMap = this.myFields;
            if (immutableSortedMap == null) {
                ResponseHeader.$$$reportNull$$$0(1);
            }
            return immutableSortedMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/profilers/network/httpdata/HttpData$ResponseHeader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRawFields";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFields";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static abstract class Header {
        private static final String FIELD_CONTENT_ENCODING = "content-encoding";
        private static final String FIELD_CONTENT_TYPE = "content-type";
        public static final String FIELD_CONTENT_LENGTH = "content-length";

        @NotNull
        public abstract ImmutableSortedMap<String, String> getFields();

        @NotNull
        public String getField(@NotNull String key) {
            if (key == null) {
                Header.$$$reportNull$$$0(0);
            }
            String string = (String)this.getFields().getOrDefault((Object)key, (Object)"");
            if (string == null) {
                Header.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getContentEncoding() {
            String string = this.getField(FIELD_CONTENT_ENCODING);
            if (string == null) {
                Header.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public ContentType getContentType() {
            return new ContentType(this.getField(FIELD_CONTENT_TYPE));
        }

        public int getContentLength() {
            String contentLength = this.getField(FIELD_CONTENT_LENGTH);
            return contentLength.isEmpty() ? -1 : Integer.parseInt(contentLength);
        }

        @NotNull
        protected static Map<String, String> parseHeaderFields(@NotNull String fields) {
            if (fields == null) {
                Header.$$$reportNull$$$0(3);
            }
            HashMap<String, String> fieldsMap = new HashMap<String, String>();
            Arrays.stream(fields.split("\\n")).filter(line -> !line.trim().isEmpty()).forEach(line -> {
                String[] keyAndValue = line.split("=", 2);
                assert (keyAndValue.length == 2) : String.format("Unexpected http header field (%s)", line);
                String key = keyAndValue[0].trim();
                String value = StringUtil.trimEnd((String)keyAndValue[1].trim(), (char)';');
                fieldsMap.compute(key, (k, v) -> {
                    if (v == null) {
                        return value;
                    }
                    return v + ";" + value;
                });
            });
            HashMap<String, String> hashMap = fieldsMap;
            if (hashMap == null) {
                Header.$$$reportNull$$$0(4);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/httpdata/HttpData$Header";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fields";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/httpdata/HttpData$Header";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getField";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentEncoding";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseHeaderFields";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getField";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "parseHeaderFields";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ContentType {
        public static final String APPLICATION_FORM_MIME_TYPE = "application/x-www-form-urlencoded";
        @NotNull
        private final String myContentType;

        public ContentType(@NotNull String contentType) {
            if (contentType == null) {
                ContentType.$$$reportNull$$$0(0);
            }
            this.myContentType = contentType;
        }

        public boolean isEmpty() {
            return this.myContentType.isEmpty();
        }

        @NotNull
        public String getMimeType() {
            String string = this.myContentType.split(";")[0];
            if (string == null) {
                ContentType.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getContentType() {
            String string = this.myContentType;
            if (string == null) {
                ContentType.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String toString() {
            return this.getContentType();
        }

        public boolean isFormData() {
            return this.getMimeType().equalsIgnoreCase(APPLICATION_FORM_MIME_TYPE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/httpdata/HttpData$ContentType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/httpdata/HttpData$ContentType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMimeType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

