/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.common.EnumColors;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.network.NetworkState;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class ConnectionsStateChart {
    @NotNull
    private final EnumColors<NetworkState> myColors;
    @NotNull
    private final StateChart<NetworkState> myChart;

    public ConnectionsStateChart(@NotNull List<HttpData> dataList, @NotNull Range range) {
        if (dataList == null) {
            ConnectionsStateChart.$$$reportNull$$$0(0);
        }
        if (range == null) {
            ConnectionsStateChart.$$$reportNull$$$0(1);
        }
        this.myColors = new EnumColors.Builder(2).add((Enum)NetworkState.SENDING, new Color[]{ProfilerColors.NETWORK_SENDING_COLOR, ProfilerColors.NETWORK_SENDING_COLOR}).add((Enum)NetworkState.RECEIVING, new Color[]{ProfilerColors.NETWORK_RECEIVING_COLOR, ProfilerColors.NETWORK_RECEIVING_SELECTED_COLOR}).add((Enum)NetworkState.WAITING, new Color[]{ProfilerColors.NETWORK_WAITING_COLOR, ProfilerColors.NETWORK_WAITING_COLOR}).add((Enum)NetworkState.NONE, new Color[]{UIUtil.TRANSPARENT_COLOR, UIUtil.TRANSPARENT_COLOR}).build();
        this.myChart = this.createChart(dataList, range);
    }

    public ConnectionsStateChart(@NotNull HttpData data, @NotNull Range range) {
        if (data == null) {
            ConnectionsStateChart.$$$reportNull$$$0(2);
        }
        if (range == null) {
            ConnectionsStateChart.$$$reportNull$$$0(3);
        }
        this(Collections.singletonList(data), range);
    }

    @NotNull
    public EnumColors<NetworkState> getColors() {
        EnumColors<NetworkState> enumColors = this.myColors;
        if (enumColors == null) {
            ConnectionsStateChart.$$$reportNull$$$0(4);
        }
        return enumColors;
    }

    public void setHeightGap(float gap) {
        this.myChart.setHeightGap(gap);
    }

    @NotNull
    public JComponent getComponent() {
        StateChart<NetworkState> stateChart = this.myChart;
        if (stateChart == null) {
            ConnectionsStateChart.$$$reportNull$$$0(5);
        }
        return stateChart;
    }

    @NotNull
    private StateChart<NetworkState> createChart(@NotNull Collection<HttpData> dataList, @NotNull Range range) {
        if (dataList == null) {
            ConnectionsStateChart.$$$reportNull$$$0(6);
        }
        if (range == null) {
            ConnectionsStateChart.$$$reportNull$$$0(7);
        }
        DefaultDataSeries series = new DefaultDataSeries();
        series.add(0L, (Object)NetworkState.NONE);
        for (HttpData data : dataList) {
            if (data.getConnectionEndTimeUs() == 0L) continue;
            series.add(data.getRequestStartTimeUs(), (Object)NetworkState.SENDING);
            if (data.getResponseStartTimeUs() > 0L) {
                series.add(data.getResponseStartTimeUs(), (Object)NetworkState.RECEIVING);
            }
            series.add(data.getConnectionEndTimeUs(), (Object)NetworkState.NONE);
        }
        StateChartModel stateModel = new StateChartModel();
        StateChart chart = new StateChart(stateModel, (StateChartColorProvider)new StateChartColorProvider<NetworkState>(){

            @NotNull
            public Color getColor(boolean isMouseOver, @NotNull NetworkState value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                Color color = ConnectionsStateChart.this.myColors.getColor((Enum)value);
                if (color == null) {
                    1.$$$reportNull$$$0(1);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/profilers/network/ConnectionsStateChart$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/profilers/network/ConnectionsStateChart$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getColor";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        stateModel.addSeries(new RangedSeries(range, (DataSeries)series));
        StateChart stateChart = chart;
        if (stateChart == null) {
            ConnectionsStateChart.$$$reportNull$$$0(8);
        }
        return stateChart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataList";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/ConnectionsStateChart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/ConnectionsStateChart";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createChart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createChart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

