/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassSet;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    private final int myPackageNameIndex;

    @NotNull
    public static Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        if (captureObject == null) {
            PackageSet.$$$reportNull$$$0(0);
        }
        return new PackageClassifier(captureObject, 0);
    }

    public PackageSet(@NotNull CaptureObject captureObject, @NotNull String packageElementName, int packageNameIndex) {
        if (captureObject == null) {
            PackageSet.$$$reportNull$$$0(1);
        }
        if (packageElementName == null) {
            PackageSet.$$$reportNull$$$0(2);
        }
        super(packageElementName);
        this.myCaptureObject = captureObject;
        this.myPackageNameIndex = packageNameIndex;
    }

    @Override
    @NotNull
    public Classifier createSubClassifier() {
        return new PackageClassifier(this.myCaptureObject, this.myPackageNameIndex + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageElementName";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/memory/adapters/classifiers/PackageSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDefaultClassifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PackageClassifier
    extends Classifier {
        @NotNull
        private final Map<String, PackageSet> myPackageElements;
        @NotNull
        private final Map<ClassDb.ClassEntry, ClassSet> myClassMap;
        @NotNull
        private final CaptureObject myCaptureObject;
        private final int myPackageNameIndex;

        private PackageClassifier(@NotNull CaptureObject captureObject, int packageNameIndex) {
            if (captureObject == null) {
                PackageClassifier.$$$reportNull$$$0(0);
            }
            this.myPackageElements = new LinkedHashMap<String, PackageSet>();
            this.myClassMap = new LinkedHashMap<ClassDb.ClassEntry, ClassSet>();
            this.myCaptureObject = captureObject;
            this.myPackageNameIndex = packageNameIndex;
        }

        @Override
        @Nullable
        public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
            if (instance == null) {
                PackageClassifier.$$$reportNull$$$0(1);
            }
            if (this.myPackageNameIndex >= instance.getClassEntry().getSplitPackageName().length) {
                ClassDb.ClassEntry classEntry = instance.getClassEntry();
                ClassSet classSet = this.myClassMap.get(classEntry);
                if (classSet == null && createIfAbsent) {
                    classSet = new ClassSet(classEntry);
                    this.myClassMap.put(classEntry, classSet);
                }
                return classSet;
            }
            String subPackageName = instance.getClassEntry().getSplitPackageName()[this.myPackageNameIndex];
            PackageSet packageSet = this.myPackageElements.get(subPackageName);
            if (packageSet == null && createIfAbsent) {
                packageSet = new PackageSet(this.myCaptureObject, subPackageName, this.myPackageNameIndex);
                this.myPackageElements.put(subPackageName, packageSet);
            }
            return packageSet;
        }

        @Override
        @NotNull
        public List<ClassifierSet> getFilteredClassifierSets() {
            List<ClassifierSet> list = Stream.concat(this.myPackageElements.values().stream(), this.myClassMap.values().stream()).filter(child -> !child.getIsFiltered()).collect(Collectors.toList());
            if (list == null) {
                PackageClassifier.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<ClassifierSet> getAllClassifierSets() {
            List<ClassifierSet> list = Stream.concat(this.myPackageElements.values().stream(), this.myClassMap.values().stream()).collect(Collectors.toList());
            if (list == null) {
                PackageClassifier.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "captureObject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instance";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/adapters/classifiers/PackageSet$PackageClassifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/adapters/classifiers/PackageSet$PackageClassifier";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilteredClassifierSets";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllClassifierSets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getClassifierSet";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

