/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.memory.BaseMemoryProfilerStage;
import com.android.tools.profilers.memory.ClassGrouping;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeMemoryHeapSet;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorService;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NativeAllocationSampleCaptureObject
implements CaptureObject {
    private final ClassDb myClassDb;
    private final ProfilerClient myClient;
    private final Common.Session mySession;
    private final long myStartTimeNs;
    private final long myEndTimeNs;
    private final List<HeapSet> myHeapSets;
    private final NativeMemoryHeapSet myDefaultHeapSet;
    private final BaseMemoryProfilerStage myStage;
    boolean myIsLoadingError;
    boolean myIsDoneLoading;
    private final Memory.MemoryNativeSampleData myInfo;

    public NativeAllocationSampleCaptureObject(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.MemoryNativeSampleData info, @NotNull BaseMemoryProfilerStage stage) {
        if (client == null) {
            NativeAllocationSampleCaptureObject.$$$reportNull$$$0(0);
        }
        if (session == null) {
            NativeAllocationSampleCaptureObject.$$$reportNull$$$0(1);
        }
        if (info == null) {
            NativeAllocationSampleCaptureObject.$$$reportNull$$$0(2);
        }
        if (stage == null) {
            NativeAllocationSampleCaptureObject.$$$reportNull$$$0(3);
        }
        this.myIsLoadingError = false;
        this.myIsDoneLoading = false;
        this.myClassDb = new ClassDb();
        this.myClient = client;
        this.mySession = session;
        this.myInfo = info;
        this.myStartTimeNs = info.getStartTime();
        this.myEndTimeNs = info.getEndTime();
        this.myStage = stage;
        this.myDefaultHeapSet = new NativeMemoryHeapSet(this);
        this.myHeapSets = new ArrayList<HeapSet>();
        this.myHeapSets.add(this.myDefaultHeapSet);
    }

    @Override
    @NotNull
    public String getName() {
        return "Recorded Native Allocations";
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    @NotNull
    public String getExportableExtension() {
        return "heapprofd";
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) {
        if (outputStream == null) {
            NativeAllocationSampleCaptureObject.$$$reportNull$$$0(4);
        }
        MemoryProfiler.saveHeapProfdSampleToFile(this.myClient, this.mySession, this.myInfo, outputStream);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        assert (this.isDoneLoading() && !this.isError());
        Stream<InstanceObject> stream = this.getHeapSets().stream().map(ClassifierSet::getInstancesStream).flatMap(Function.identity());
        if (stream == null) {
            NativeAllocationSampleCaptureObject.$$$reportNull$$$0(5);
        }
        return stream;
    }

    @Override
    public long getStartTimeNs() {
        return this.myStartTimeNs;
    }

    @Override
    public long getEndTimeNs() {
        return this.myEndTimeNs;
    }

    @Override
    @NotNull
    public ClassDb getClassDatabase() {
        ClassDb classDb = this.myClassDb;
        if (classDb == null) {
            NativeAllocationSampleCaptureObject.$$$reportNull$$$0(6);
        }
        return classDb;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        File trace;
        Transport.BytesResponse response = Transport.BytesResponse.getDefaultInstance();
        int retryCount = 100;
        while (response.getContents().isEmpty() && (response = this.myClient.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(Long.toString(this.myStartTimeNs)).build())).getContents().isEmpty()) {
            if (retryCount-- == 0) {
                this.myIsLoadingError = true;
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.myIsLoadingError = true;
                return false;
            }
        }
        try {
            trace = FileUtil.createTempFile((String)String.format(Locale.US, "heap_trace_%d", this.myStartTimeNs), (String)("." + this.getExportableExtension()), (boolean)true);
            try (FileOutputStream out = new FileOutputStream(trace);){
                out.write(response.getContents().toByteArray());
                out.flush();
            }
        }
        catch (IOException ex) {
            return false;
        }
        String abi = this.myStage.getStudioProfilers().getSessionsManager().getSelectedSessionMetaData().getProcessAbi();
        TraceProcessorService service = this.myStage.getStudioProfilers().getIdeServices().getTraceProcessorService();
        IdeProfilerServices profilerServices = this.myStage.getStudioProfilers().getIdeServices();
        long traceId = this.myStartTimeNs;
        service.loadTrace(traceId, trace.getAbsoluteFile(), profilerServices);
        service.loadMemoryData(traceId, abi, this.myDefaultHeapSet, profilerServices);
        this.myIsDoneLoading = true;
        return true;
    }

    @Override
    public boolean isDoneLoading() {
        return this.myIsDoneLoading || this.myIsLoadingError;
    }

    @Override
    public boolean isError() {
        return this.myIsLoadingError;
    }

    @Override
    public void unload() {
        this.myIsLoadingError = false;
        this.myIsDoneLoading = false;
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        List<CaptureObject.ClassifierAttribute> list = Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.MODULE, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.DEALLOCATIONS, CaptureObject.ClassifierAttribute.ALLOCATIONS_SIZE, CaptureObject.ClassifierAttribute.DEALLOCATIONS_SIZE, CaptureObject.ClassifierAttribute.TOTAL_COUNT, CaptureObject.ClassifierAttribute.REMAINING_SIZE);
        if (list == null) {
            NativeAllocationSampleCaptureObject.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        List<CaptureObject.InstanceAttribute> list = Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.NATIVE_SIZE);
        if (list == null) {
            NativeAllocationSampleCaptureObject.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        List<HeapSet> list = this.myHeapSets;
        if (list == null) {
            NativeAllocationSampleCaptureObject.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        assert (heapId == 0);
        return this.myHeapSets.get(heapId);
    }

    @Override
    public boolean isGroupingSupported(ClassGrouping grouping) {
        switch (grouping) {
            case NATIVE_ARRANGE_BY_ALLOCATION_METHOD: 
            case NATIVE_ARRANGE_BY_CALLSTACK: {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/NativeAllocationSampleCaptureObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/NativeAllocationSampleCaptureObject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstances";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDatabase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierAttributes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceAttributes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

