/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.formatter.NumberFormatter;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.AttributeColumn;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.ToLongFunction;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SortOrder;
import org.jetbrains.annotations.NotNull;

class SimpleColumnRenderer<T extends MemoryObject>
extends ColoredTreeCellRenderer {
    @NotNull
    private final Function<MemoryObjectTreeNode<T>, String> myTextGetter;
    @NotNull
    private final Function<MemoryObjectTreeNode<T>, Icon> myIconGetter;
    @NotNull
    private final Function<MemoryObjectTreeNode<T>, SimpleTextAttributes> myTextAttributesGetter;
    private final int myAlignment;
    public static final int DEFAULT_COLUMN_WIDTH = 80;

    public SimpleColumnRenderer(@NotNull Function<MemoryObjectTreeNode<T>, String> textGetter, @NotNull Function<MemoryObjectTreeNode<T>, Icon> iconGetter, int alignment) {
        if (textGetter == null) {
            SimpleColumnRenderer.$$$reportNull$$$0(0);
        }
        if (iconGetter == null) {
            SimpleColumnRenderer.$$$reportNull$$$0(1);
        }
        this(textGetter, iconGetter, value -> SimpleTextAttributes.REGULAR_ATTRIBUTES, alignment);
    }

    public SimpleColumnRenderer(@NotNull Function<MemoryObjectTreeNode<T>, String> textGetter, @NotNull Function<MemoryObjectTreeNode<T>, Icon> iconGetter, @NotNull Function<MemoryObjectTreeNode<T>, SimpleTextAttributes> textAttributesGetter, int alignment) {
        if (textGetter == null) {
            SimpleColumnRenderer.$$$reportNull$$$0(2);
        }
        if (iconGetter == null) {
            SimpleColumnRenderer.$$$reportNull$$$0(3);
        }
        if (textAttributesGetter == null) {
            SimpleColumnRenderer.$$$reportNull$$$0(4);
        }
        this.myTextGetter = textGetter;
        this.myIconGetter = iconGetter;
        this.myTextAttributesGetter = textAttributesGetter;
        this.myAlignment = alignment;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            SimpleColumnRenderer.$$$reportNull$$$0(5);
        }
        if (value instanceof MemoryObjectTreeNode) {
            String text = this.myTextGetter.apply((MemoryObjectTreeNode)value);
            this.append(text, this.myTextAttributesGetter.apply((MemoryObjectTreeNode)value), text);
            this.setTextAlign(this.myAlignment);
            Icon icon = this.myIconGetter.apply((MemoryObjectTreeNode)value);
            if (icon != null) {
                this.setIcon(icon);
            } else if (this.myAlignment == 2) {
                this.setIpad(ProfilerLayout.TABLE_COLUMN_CELL_INSETS);
            } else {
                this.setIpad(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_CELL_INSETS);
            }
        }
    }

    public static <T extends MemoryObject> AttributeColumn<MemoryObject> makeIntColumn(String name, int suggestedWidth, Class<T> subclass, ToLongFunction<T> prop, LongPredicate pred, LongFunction<String> formatter, SortOrder order2) {
        Function<MemoryObjectTreeNode<MemoryObject>, String> textGetter = SimpleColumnRenderer.makeConditionalTextGetter(subclass, prop, pred, formatter);
        int preferredWidth = Math.max(80, suggestedWidth);
        int maxWidth = preferredWidth * 4;
        return new AttributeColumn<MemoryObject>(name, () -> new SimpleColumnRenderer(textGetter, v -> null, 4), 4, preferredWidth, maxWidth, order2, SimpleColumnRenderer.compareOn(subclass, prop));
    }

    public static AttributeColumn<MemoryObject> makeSizeColumn(String name, int suggestedWidth, ToLongFunction<ValueObject> prop) {
        return SimpleColumnRenderer.makeIntColumn(name, suggestedWidth, ValueObject.class, prop, s -> s != -1L, NumberFormatter::formatInteger, SortOrder.DESCENDING);
    }

    public static <T extends MemoryObject> Function<MemoryObjectTreeNode<MemoryObject>, String> makeConditionalTextGetter(Class<T> subclass, ToLongFunction<T> prop, LongPredicate pred, LongFunction<String> formatter) {
        return SimpleColumnRenderer.makeConditionalGetter(subclass, prop, pred, formatter, "-");
    }

    public static <T extends MemoryObject, A> Function<MemoryObjectTreeNode<MemoryObject>, A> makeConditionalGetter(Class<T> subclass, ToLongFunction<T> prop, LongPredicate pred, LongFunction<A> result, A fallback) {
        return SimpleColumnRenderer.onSubclass(subclass, t -> {
            long v = prop.applyAsLong(t);
            return pred.test(v) ? result.apply(v) : fallback;
        }, s -> fallback);
    }

    public static <S extends MemoryObject, T extends S, A> Function<MemoryObjectTreeNode<S>, A> onSubclass(Class<T> c, Function<T, A> f, Function<S, A> fallback) {
        return o -> {
            Object s = o.getAdapter();
            return c.isInstance(s) ? f.apply((MemoryObject)c.cast(s)) : fallback.apply(s);
        };
    }

    public static <T extends MemoryObject> Comparator<MemoryObjectTreeNode<MemoryObject>> compareOn(Class<T> subclass, ToLongFunction<T> prop) {
        return Comparator.comparingLong(o -> prop.applyAsLong((MemoryObject)subclass.cast(o.getAdapter())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textGetter";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconGetter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributesGetter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/memory/SimpleColumnRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

