/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.AllocationSamplingRateDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryMonitor;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerKt;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import io.grpc.StatusRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J6\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142$\u0010\u001d\u001a \u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020!0\u001eH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u001fH\u0016J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u001fH\u0016J6\u0010'\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142$\u0010(\u001a \u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u001eH\u0002R\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lcom/android/tools/profilers/memory/MemoryProfiler;", "Lcom/android/tools/profilers/StudioProfiler;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "(Lcom/android/tools/profilers/StudioProfilers;)V", "featureTracker", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "Lorg/jetbrains/annotations/NotNull;", "getFeatureTracker", "()Lcom/android/tools/profilers/analytics/FeatureTracker;", "myAspectObserver", "Lcom/android/tools/adtui/model/AspectObserver;", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "getSessionsManager", "()Lcom/android/tools/profilers/sessions/SessionsManager;", "agentStatusChanged", "", "import", "file", "Ljava/io/File;", "makeEvent", "Lkotlin/Function2;", "", "Lcom/android/tools/profiler/proto/Common$Event;", "importHeapprofd", "importHprof", "importLegacyAllocations", "legacyImport", "execute", "Lkotlin/Function4;", "Lcom/android/tools/profiler/proto/Common$Session;", "", "", "newMonitor", "Lcom/android/tools/profilers/memory/MemoryMonitor;", "startProfiling", "session", "stopProfiling", "withFileImportedOnce", "handle", "Companion", "intellij.android.profilers"})
public final class MemoryProfiler
extends StudioProfiler {
    private final AspectObserver myAspectObserver;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final SessionsManager getSessionsManager() {
        StudioProfilers studioProfilers = this.myProfilers;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"myProfilers");
        SessionsManager sessionsManager = studioProfilers.getSessionsManager();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sessionsManager), (String)"myProfilers.sessionsManager");
        return sessionsManager;
    }

    private final FeatureTracker getFeatureTracker() {
        StudioProfilers studioProfilers = this.myProfilers;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"myProfilers");
        IdeProfilerServices ideProfilerServices = studioProfilers.getIdeServices();
        Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices, (String)"myProfilers.ideServices");
        FeatureTracker featureTracker = ideProfilerServices.getFeatureTracker();
        Intrinsics.checkNotNullExpressionValue((Object)featureTracker, (String)"myProfilers.ideServices.featureTracker");
        return featureTracker;
    }

    @Override
    @NotNull
    public MemoryMonitor newMonitor() {
        return new MemoryMonitor(this.myProfilers);
    }

    @Override
    public void startProfiling(@NotNull Common.Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
    }

    @Override
    public void stopProfiling(@NotNull Common.Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        try {
            StudioProfilers studioProfilers = this.myProfilers;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"myProfilers");
            Companion.trackAllocations(studioProfilers, session, false, null);
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.Companion.getLogger().info((Throwable)e);
        }
    }

    private final void agentStatusChanged() {
        StudioProfilers studioProfilers = this.myProfilers;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"myProfilers");
        Common.Session session = studioProfilers.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"myProfilers.session");
        Common.Session session2 = session;
        if (!Intrinsics.areEqual((Object)Common.Session.getDefaultInstance(), (Object)session2) && session2.getEndTimestamp() == Long.MAX_VALUE) {
            StudioProfilers studioProfilers2 = this.myProfilers;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers2), (String)"myProfilers");
            if (studioProfilers2.isAgentAttached()) {
                try {
                    StudioProfilers studioProfilers3 = this.myProfilers;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers3), (String)"myProfilers");
                    Companion.trackAllocations(studioProfilers3, session2, false, null);
                }
                catch (StatusRuntimeException e) {
                    MemoryProfiler.Companion.getLogger().info((Throwable)e);
                }
            }
        }
    }

    private final void importHprof(File file) {
        importHprof.1 $fun$makeInfo$1 = importHprof.1.INSTANCE;
        StudioProfilers studioProfilers = this.myProfilers;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"myProfilers");
        IdeProfilerServices ideProfilerServices = studioProfilers.getIdeServices();
        Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices, (String)"myProfilers.ideServices");
        FeatureConfig featureConfig = ideProfilerServices.getFeatureConfig();
        Intrinsics.checkNotNullExpressionValue((Object)featureConfig, (String)"myProfilers.ideServices.featureConfig");
        if (featureConfig.isUnifiedPipelineEnabled()) {
            this.import(file, (Function2<? super Long, ? super Long, Common.Event>)((Function2)importHprof.2.INSTANCE));
        } else {
            this.legacyImport(file, (Function4<? super Common.Session, ? super byte[], ? super Long, ? super Long, ? extends Object>)((Function4)new Function4<Common.Session, byte[], Long, Long, Object>(this){
                final /* synthetic */ MemoryProfiler this$0;

                @NotNull
                public final Object invoke(@NotNull Common.Session session, @NotNull byte[] bytes, long start, long end) {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                    StudioProfilers studioProfilers = MemoryProfiler.access$getMyProfilers$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"myProfilers");
                    ProfilerClient profilerClient = studioProfilers.getClient();
                    Intrinsics.checkNotNullExpressionValue((Object)profilerClient, (String)"myProfilers.client");
                    MemoryProfiler.ImportHeapDumpResponse importHeapDumpResponse = profilerClient.getMemoryClient().importHeapDump(MemoryProfiler.ImportHeapDumpRequest.newBuilder().setSession(session).setData(ByteString.copyFrom((byte[])bytes)).setInfo(importHprof.1.INSTANCE.invoke(start, end)).build());
                    Intrinsics.checkNotNullExpressionValue((Object)importHeapDumpResponse, (String)"myProfilers.client.memor\u2026d))\n            .build())");
                    return importHeapDumpResponse;
                }
                {
                    this.this$0 = memoryProfiler;
                    super(4);
                }
            }));
        }
        this.getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    private final void importHeapprofd(File file) {
        this.import(file, (Function2<? super Long, ? super Long, Common.Event>)((Function2)importHeapprofd.1.INSTANCE));
    }

    private final void importLegacyAllocations(File file) {
        importLegacyAllocations.1 $fun$makeInfo$1 = importLegacyAllocations.1.INSTANCE;
        StudioProfilers studioProfilers = this.myProfilers;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"myProfilers");
        IdeProfilerServices ideProfilerServices = studioProfilers.getIdeServices();
        Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices, (String)"myProfilers.ideServices");
        FeatureConfig featureConfig = ideProfilerServices.getFeatureConfig();
        Intrinsics.checkNotNullExpressionValue((Object)featureConfig, (String)"myProfilers.ideServices.featureConfig");
        if (featureConfig.isUnifiedPipelineEnabled()) {
            this.import(file, (Function2<? super Long, ? super Long, Common.Event>)((Function2)importLegacyAllocations.2.INSTANCE));
        } else {
            this.legacyImport(file, (Function4<? super Common.Session, ? super byte[], ? super Long, ? super Long, ? extends Object>)((Function4)new Function4<Common.Session, byte[], Long, Long, Object>(this){
                final /* synthetic */ MemoryProfiler this$0;

                @NotNull
                public final Object invoke(@NotNull Common.Session session, @NotNull byte[] bytes, long start, long end) {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                    StudioProfilers studioProfilers = MemoryProfiler.access$getMyProfilers$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"myProfilers");
                    ProfilerClient profilerClient = studioProfilers.getClient();
                    Intrinsics.checkNotNullExpressionValue((Object)profilerClient, (String)"myProfilers.client");
                    MemoryProfiler.ImportLegacyAllocationsResponse importLegacyAllocationsResponse = profilerClient.getMemoryClient().importLegacyAllocations(MemoryProfiler.ImportLegacyAllocationsRequest.newBuilder().setSession(session).setInfo(importLegacyAllocations.1.INSTANCE.invoke(start, end)).setData(ByteString.copyFrom((byte[])bytes)).build());
                    Intrinsics.checkNotNullExpressionValue((Object)importLegacyAllocationsResponse, (String)"myProfilers.client.memor\u2026s))\n            .build())");
                    return importLegacyAllocationsResponse;
                }
                {
                    this.this$0 = memoryProfiler;
                    super(4);
                }
            }));
        }
        this.getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    private final void import(File file, Function2<? super Long, ? super Long, Common.Event> makeEvent) {
        this.withFileImportedOnce(file, (Function4<? super byte[], ? super Long, ? super Long, ? super Long, Unit>)((Function4)new Function4<byte[], Long, Long, Long, Unit>(this, file, makeEvent){
            final /* synthetic */ MemoryProfiler this$0;
            final /* synthetic */ File $file;
            final /* synthetic */ Function2 $makeEvent;

            public final void invoke(@NotNull byte[] bytes, long startTimestampsEpochMs, long startTime, long endTime) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                MemoryProfiler.access$getSessionsManager$p(this.this$0).createImportedSession(this.$file.getName(), Common.SessionData.SessionStarted.SessionType.MEMORY_CAPTURE, startTime, endTime, startTimestampsEpochMs, MapsKt.mapOf((kotlin.Pair)TuplesKt.to((Object)String.valueOf(startTime), (Object)ByteString.copyFrom((byte[])bytes))), (Common.Event)this.$makeEvent.invoke((Object)startTime, (Object)endTime));
            }
            {
                this.this$0 = memoryProfiler;
                this.$file = file;
                this.$makeEvent = function2;
                super(4);
            }
        }));
    }

    private final void legacyImport(File file, Function4<? super Common.Session, ? super byte[], ? super Long, ? super Long, ? extends Object> execute) {
        this.withFileImportedOnce(file, (Function4<? super byte[], ? super Long, ? super Long, ? super Long, Unit>)((Function4)new Function4<byte[], Long, Long, Long, Unit>(this, file, execute){
            final /* synthetic */ MemoryProfiler this$0;
            final /* synthetic */ File $file;
            final /* synthetic */ Function4 $execute;

            public final void invoke(@NotNull byte[] bytes, long startTimestampEpochNs, long start, long end) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                Common.Session session = MemoryProfiler.access$getSessionsManager$p(this.this$0).createImportedSessionLegacy(this.$file.getName(), Common.SessionMetaData.SessionType.MEMORY_CAPTURE, start, end, startTimestampEpochNs);
                Intrinsics.checkNotNullExpressionValue((Object)session, (String)"sessionsManager\n        \u2026d, startTimestampEpochNs)");
                Common.Session session2 = session;
                this.$execute.invoke((Object)session2, (Object)bytes, (Object)start, (Object)end);
                MemoryProfiler.access$getSessionsManager$p(this.this$0).update();
                MemoryProfiler.access$getSessionsManager$p(this.this$0).setSession(session2);
            }
            {
                this.this$0 = memoryProfiler;
                this.$file = file;
                this.$execute = function4;
                super(4);
            }
        }));
    }

    private final void withFileImportedOnce(File file, Function4<? super byte[], ? super Long, ? super Long, ? super Long, Unit> handle) {
        block3: {
            byte[] byArray;
            long startTimestampEpochNs = System.currentTimeMillis();
            Pair<Long, Long> timestampsNs = StudioProfilers.computeImportedFileStartEndTimestampsNs(file);
            Long sessionStartTimeNs = (Long)timestampsNs.first;
            Long sessionEndTimeNs = (Long)timestampsNs.second;
            SessionsManager sessionsManager = this.getSessionsManager();
            Long l = sessionStartTimeNs;
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"sessionStartTimeNs");
            if (sessionsManager.setSessionById(l)) break block3;
            try {
                byArray = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
            }
            catch (IOException e) {
                MemoryProfiler.Companion.getLogger().error("Importing Session Failed: cannot read from " + file.getPath());
                byArray = null;
            }
            if (byArray != null) {
                byte[] bytes = byArray = byArray;
                boolean bl = false;
                Long l2 = startTimestampEpochNs;
                Long l3 = sessionEndTimeNs;
                Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"sessionEndTimeNs");
                handle.invoke((Object)bytes, (Object)l2, (Object)sessionStartTimeNs, (Object)l3);
            }
        }
    }

    public MemoryProfiler(@NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        super(profilers);
        this.myAspectObserver = new AspectObserver();
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((MemoryProfiler)this.receiver).agentStatusChanged();
            }
        };
        this.myProfilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        });
        function0 = (Function1)new Function1<File, Unit>(this){

            public final void invoke(@NotNull File p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((MemoryProfiler)this.receiver).importHprof(p1);
            }
        };
        this.getSessionsManager().registerImportHandler("hprof", new Consumer((Function1)function0){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ void accept(Object p0) {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
            }
        });
        function0 = (Function1)new Function1<File, Unit>(this){

            public final void invoke(@NotNull File p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((MemoryProfiler)this.receiver).importLegacyAllocations(p1);
            }
        };
        this.getSessionsManager().registerImportHandler("alloc", new /* invalid duplicate definition of identical inner class */);
        function0 = (Function1)new Function1<File, Unit>(this){

            public final void invoke(@NotNull File p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((MemoryProfiler)this.receiver).importHeapprofd(p1);
            }
        };
        this.getSessionsManager().registerImportHandler("heapprofd", new /* invalid duplicate definition of identical inner class */);
        this.myProfilers.registerSessionChangeListener(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, new Runnable(){

            @Override
            public final void run() {
                StreamingTimeline streamingTimeline;
                MainMemoryProfilerStage stage = new MainMemoryProfilerStage(myProfilers);
                StudioProfilers studioProfilers = myProfilers;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"myProfilers");
                studioProfilers.setStage(stage);
                StudioProfilers studioProfilers2 = myProfilers;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers2), (String)"myProfilers");
                Common.Session session = studioProfilers2.getSession();
                Intrinsics.checkNotNullExpressionValue((Object)session, (String)"myProfilers.session");
                stage.setPendingCaptureStartTimeGuarded(session.getStartTimestamp());
                StudioProfilers studioProfilers3 = myProfilers;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers3), (String)"myProfilers");
                StreamingTimeline $this$apply = streamingTimeline = studioProfilers3.getTimeline();
                boolean bl = false;
                StudioProfilers studioProfilers4 = myProfilers;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers4), (String)"myProfilers");
                Common.Session session2 = studioProfilers4.getSession();
                Intrinsics.checkNotNullExpressionValue((Object)session2, (String)"myProfilers.session");
                long l = session2.getStartTimestamp();
                StudioProfilers studioProfilers5 = myProfilers;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers5), (String)"myProfilers");
                Common.Session session3 = studioProfilers5.getSession();
                Intrinsics.checkNotNullExpressionValue((Object)session3, (String)"myProfilers.session");
                $this$apply.reset(l, session3.getEndTimestamp());
                $this$apply.getViewRange().set($this$apply.getDataRange());
                $this$apply.setIsPaused(true);
            }
        });
    }

    public static final /* synthetic */ SessionsManager access$getSessionsManager$p(MemoryProfiler $this) {
        return $this.getSessionsManager();
    }

    @JvmStatic
    public static final boolean isUsingLiveAllocation(@NotNull StudioProfilers profilers, @NotNull Common.Session session) {
        return Companion.isUsingLiveAllocation(profilers, session);
    }

    @JvmStatic
    public static final boolean hasOnlyFullAllocationTrackingWithinRegion(@NotNull StudioProfilers profilers, @NotNull Common.Session session, long startTimeUs, long endTimeUs) {
        return Companion.hasOnlyFullAllocationTrackingWithinRegion(profilers, session, startTimeUs, endTimeUs);
    }

    @JvmStatic
    public static final void saveHeapDumpToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.HeapDumpInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        Companion.saveHeapDumpToFile(client, session, info, outputStream, featureTracker);
    }

    @JvmStatic
    public static final void saveLegacyAllocationToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.AllocationsInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        Companion.saveLegacyAllocationToFile(client, session, info, outputStream, featureTracker);
    }

    @JvmStatic
    public static final void saveHeapProfdSampleToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.MemoryNativeSampleData info, @NotNull OutputStream outputStream) {
        Companion.saveHeapProfdSampleToFile(client, session, info, outputStream);
    }

    @JvmStatic
    @NotNull
    public static final String generateCaptureFileName() {
        return Companion.generateCaptureFileName();
    }

    @JvmStatic
    @NotNull
    public static final List<Memory.MemoryNativeSampleData> getNativeHeapSamplesForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        return Companion.getNativeHeapSamplesForSession(client, session, rangeUs);
    }

    @JvmStatic
    @NotNull
    public static final List<Memory.MemoryNativeTrackingData> getNativeHeapStatusForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        return Companion.getNativeHeapStatusForSession(client, session, rangeUs);
    }

    @JvmStatic
    @NotNull
    public static final List<Memory.HeapDumpInfo> getHeapDumpsForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs, @NotNull IdeProfilerServices profilerService) {
        return Companion.getHeapDumpsForSession(client, session, rangeUs, profilerService);
    }

    @JvmStatic
    @NotNull
    public static final List<Memory.AllocationsInfo> getAllocationInfosForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs, @NotNull IdeProfilerServices profilerService) {
        return Companion.getAllocationInfosForSession(client, session, rangeUs, profilerService);
    }

    @JvmStatic
    public static final void trackAllocations(@NotNull StudioProfilers profilers, @NotNull Common.Session session, boolean enable, @Nullable Consumer<Memory.TrackStatus> responseHandler) {
        Companion.trackAllocations(profilers, session, enable, responseHandler);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J.\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007JH\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\n\"\u0004\b\u0000\u0010\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00150\u0019H\u0002J.\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J.\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J.\u0010 \u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010!0!0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J(\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0007J\u0018\u0010)\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J0\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0007J(\u00101\u001a\u00020+2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.H\u0007J0\u00102\u001a\u00020+2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0007J>\u00103\u001a\u00020+2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00104\u001a\u00020'2\u0006\u0010-\u001a\u00020.2\f\u00105\u001a\b\u0012\u0004\u0012\u00020+062\u0006\u00107\u001a\u00020\bH\u0002J2\u00108\u001a\u00020+2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00109\u001a\u00020#2\u0010\u0010:\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010<\u0018\u00010;H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006="}, d2={"Lcom/android/tools/profilers/memory/MemoryProfiler$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "generateCaptureFileName", "", "getAllocationInfosForSession", "", "Lcom/android/tools/profiler/proto/Memory$AllocationsInfo;", "client", "Lcom/android/tools/profilers/ProfilerClient;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "rangeUs", "Lcom/android/tools/adtui/model/Range;", "profilerService", "Lcom/android/tools/profilers/IdeProfilerServices;", "getForSession", "T", "eventKind", "Lcom/android/tools/profiler/proto/Common$Event$Kind;", "mapper", "Lkotlin/Function1;", "Lcom/android/tools/profiler/proto/Transport$EventGroup;", "getHeapDumpsForSession", "Lcom/android/tools/profiler/proto/Memory$HeapDumpInfo;", "getNativeHeapSamplesForSession", "Lcom/android/tools/profiler/proto/Memory$MemoryNativeSampleData;", "kotlin.jvm.PlatformType", "getNativeHeapStatusForSession", "Lcom/android/tools/profiler/proto/Memory$MemoryNativeTrackingData;", "hasOnlyFullAllocationTrackingWithinRegion", "", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "startTimeUs", "", "endTimeUs", "isUsingLiveAllocation", "saveHeapDumpToFile", "", "info", "outputStream", "Ljava/io/OutputStream;", "featureTracker", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "saveHeapProfdSampleToFile", "saveLegacyAllocationToFile", "saveToFile", "startTime", "onFinished", "Lkotlin/Function0;", "errorMsg", "trackAllocations", "enable", "responseHandler", "Ljava/util/function/Consumer;", "Lcom/android/tools/profiler/proto/Memory$TrackStatus;", "intellij.android.profilers"})
    public static final class Companion {
        private final Logger getLogger() {
            Logger logger = Logger.getInstance(MemoryProfiler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(MemoryProfiler::class.java)");
            return logger;
        }

        @JvmStatic
        public final boolean isUsingLiveAllocation(@NotNull StudioProfilers profilers, @NotNull Common.Session session) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ProfilerClient profilerClient = profilers.getClient();
            IdeProfilerServices ideProfilerServices = profilers.getIdeServices();
            Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices, (String)"profilers.ideServices");
            FeatureConfig featureConfig = ideProfilerServices.getFeatureConfig();
            Intrinsics.checkNotNullExpressionValue((Object)featureConfig, (String)"profilers.ideServices.featureConfig");
            AllocationSamplingRateDataSeries allocationSamplingRateDataSeries = new AllocationSamplingRateDataSeries(profilerClient, session, featureConfig.isUnifiedPipelineEnabled());
            StreamingTimeline streamingTimeline = profilers.getTimeline();
            Intrinsics.checkNotNullExpressionValue((Object)streamingTimeline, (String)"profilers.timeline");
            List<SeriesData<AllocationSamplingRateDurationData>> list = allocationSamplingRateDataSeries.getDataForRange(streamingTimeline.getDataRange());
            Intrinsics.checkNotNullExpressionValue(list, (String)"AllocationSamplingRateDa\u2026ilers.timeline.dataRange)");
            Collection collection = list;
            return !collection.isEmpty();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean hasOnlyFullAllocationTrackingWithinRegion(@NotNull StudioProfilers profilers, @NotNull Common.Session session, long startTimeUs, long endTimeUs) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ProfilerClient profilerClient = profilers.getClient();
            IdeProfilerServices ideProfilerServices = profilers.getIdeServices();
            Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices, (String)"profilers.ideServices");
            FeatureConfig featureConfig = ideProfilerServices.getFeatureConfig();
            Intrinsics.checkNotNullExpressionValue((Object)featureConfig, (String)"profilers.ideServices.featureConfig");
            AllocationSamplingRateDataSeries series = new AllocationSamplingRateDataSeries(profilerClient, session, featureConfig.isUnifiedPipelineEnabled());
            List<SeriesData<AllocationSamplingRateDurationData>> samplingModes = series.getDataForRange(new Range((double)startTimeUs, (double)endTimeUs));
            if (samplingModes.size() != 1) return false;
            Object object = samplingModes.get((int)0).value;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"samplingModes[0].value");
            Memory.MemoryAllocSamplingData memoryAllocSamplingData = ((AllocationSamplingRateDurationData)object).getCurrentRate();
            Intrinsics.checkNotNullExpressionValue((Object)memoryAllocSamplingData, (String)"samplingModes[0].value.currentRate");
            if (memoryAllocSamplingData.getSamplingNumInterval() != BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.FULL.getValue()) return false;
            return true;
        }

        @JvmStatic
        public final void saveHeapDumpToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.HeapDumpInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)featureTracker, (String)"featureTracker");
            this.saveToFile(client, session, info.getStartTime(), outputStream, (Function0<Unit>)((Function0)new Function0<Unit>(featureTracker){

                public final void invoke() {
                    ((FeatureTracker)this.receiver).trackExportHeap();
                }
            }), "Failed to export heap dump file");
        }

        @JvmStatic
        public final void saveLegacyAllocationToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.AllocationsInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)featureTracker, (String)"featureTracker");
            this.saveToFile(client, session, info.getStartTime(), outputStream, (Function0<Unit>)((Function0)new Function0<Unit>(featureTracker){

                public final void invoke() {
                    ((FeatureTracker)this.receiver).trackExportAllocation();
                }
            }), "Failed to export allocation records");
        }

        @JvmStatic
        public final void saveHeapProfdSampleToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.MemoryNativeSampleData info, @NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            this.saveToFile(client, session, info.getStartTime(), outputStream, (Function0<Unit>)((Function0)saveHeapProfdSampleToFile.1.INSTANCE), "Failed to export native allocation records");
        }

        private final void saveToFile(ProfilerClient client, Common.Session session, long startTime, OutputStream outputStream, Function0<Unit> onFinished, String errorMsg) {
            Transport.BytesResponse response;
            Transport.BytesResponse bytesResponse = response = client.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(session.getStreamId()).setId(String.valueOf(startTime)).build());
            Intrinsics.checkNotNullExpressionValue((Object)bytesResponse, (String)"response");
            if (bytesResponse.getContents() != ByteString.EMPTY) {
                try {
                    response.getContents().writeTo(outputStream);
                    onFinished.invoke();
                }
                catch (IOException exception) {
                    this.getLogger().warn(errorMsg + ":\n" + exception);
                }
            }
        }

        @JvmStatic
        @NotNull
        public final String generateCaptureFileName() {
            return "memory-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss"));
        }

        @JvmStatic
        @NotNull
        public final List<Memory.MemoryNativeSampleData> getNativeHeapSamplesForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)rangeUs, (String)"rangeUs");
            return this.getForSession(client, session, rangeUs, Common.Event.Kind.MEMORY_NATIVE_SAMPLE_CAPTURE, getNativeHeapSamplesForSession.1.INSTANCE);
        }

        @JvmStatic
        @NotNull
        public final List<Memory.MemoryNativeTrackingData> getNativeHeapStatusForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)rangeUs, (String)"rangeUs");
            return this.getForSession(client, session, rangeUs, Common.Event.Kind.MEMORY_NATIVE_SAMPLE_STATUS, getNativeHeapStatusForSession.1.INSTANCE);
        }

        @JvmStatic
        @NotNull
        public final List<Memory.HeapDumpInfo> getHeapDumpsForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs, @NotNull IdeProfilerServices profilerService) {
            List list;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)rangeUs, (String)"rangeUs");
            Intrinsics.checkNotNullParameter((Object)profilerService, (String)"profilerService");
            FeatureConfig featureConfig = profilerService.getFeatureConfig();
            Intrinsics.checkNotNullExpressionValue((Object)featureConfig, (String)"profilerService.featureConfig");
            if (featureConfig.isUnifiedPipelineEnabled()) {
                list = this.getForSession(client, session, rangeUs, Common.Event.Kind.MEMORY_HEAP_DUMP, getHeapDumpsForSession.1.INSTANCE);
            } else {
                MemoryProfiler.ListHeapDumpInfosResponse listHeapDumpInfosResponse = client.getMemoryClient().listHeapDumpInfos(MemoryProfiler.ListDumpInfosRequest.newBuilder().setSession(session).setStartTime(MemoryProfilerKt.access$microsToNanos(rangeUs.getMin())).setEndTime(MemoryProfilerKt.access$microsToNanos(rangeUs.getMax())).build());
                Intrinsics.checkNotNullExpressionValue((Object)listHeapDumpInfosResponse, (String)"client.memoryClient.list\u2026                .build())");
                List list2 = listHeapDumpInfosResponse.getInfosList();
                list = list2;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"client.memoryClient.list\u2026d())\n          .infosList");
            }
            return list;
        }

        @JvmStatic
        @NotNull
        public final List<Memory.AllocationsInfo> getAllocationInfosForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs, @NotNull IdeProfilerServices profilerService) {
            List list;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)rangeUs, (String)"rangeUs");
            Intrinsics.checkNotNullParameter((Object)profilerService, (String)"profilerService");
            FeatureConfig featureConfig = profilerService.getFeatureConfig();
            Intrinsics.checkNotNullExpressionValue((Object)featureConfig, (String)"profilerService.featureConfig");
            if (featureConfig.isUnifiedPipelineEnabled()) {
                list = this.getForSession(client, session, rangeUs, Common.Event.Kind.MEMORY_ALLOC_TRACKING, (Function1)new Function1<Transport.EventGroup, Memory.AllocationsInfo>(session){
                    final /* synthetic */ Common.Session $session;

                    /*
                     * WARNING - void declaration
                     */
                    public final Memory.AllocationsInfo invoke(@NotNull Transport.EventGroup it) {
                        void var2_2;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Common.Event event = MemoryProfilerKt.access$last(it);
                        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"it.last()");
                        Memory.MemoryAllocTrackingData memoryAllocTrackingData = event.getMemoryAllocTracking();
                        Intrinsics.checkNotNullExpressionValue((Object)memoryAllocTrackingData, (String)"it.last().memoryAllocTracking");
                        Memory.AllocationsInfo info = memoryAllocTrackingData.getInfo();
                        if (Intrinsics.areEqual((Object)info, (Object)Memory.AllocationsInfo.getDefaultInstance())) {
                            boolean bl;
                            boolean bl2 = bl = it.getEventsCount() > 1;
                            if (_Assertions.ENABLED && !bl) {
                                String string = "Assertion failed";
                                throw new AssertionError((Object)string);
                            }
                            Common.Event event2 = it.getEvents(0);
                            Intrinsics.checkNotNullExpressionValue((Object)event2, (String)"it.getEvents(0)");
                            Memory.MemoryAllocTrackingData memoryAllocTrackingData2 = event2.getMemoryAllocTracking();
                            Intrinsics.checkNotNullExpressionValue((Object)memoryAllocTrackingData2, (String)"it.getEvents(0).memoryAllocTracking");
                            Memory.AllocationsInfo allocationsInfo = info = memoryAllocTrackingData2.getInfo();
                            Intrinsics.checkNotNullExpressionValue((Object)allocationsInfo, (String)"info");
                            if (allocationsInfo.getLegacy() && info.getEndTime() == Long.MAX_VALUE) {
                                info = info.toBuilder().setEndTime(this.$session.getEndTimestamp()).setSuccess(false).build();
                            }
                        }
                        return var2_2;
                    }
                    {
                        this.$session = session;
                        super(1);
                    }
                });
            } else {
                MemoryProfiler.MemoryData memoryData = client.getMemoryClient().getData(MemoryProfiler.MemoryRequest.newBuilder().setSession(session).setStartTime(MemoryProfilerKt.access$microsToNanos(rangeUs.getMin())).setEndTime(MemoryProfilerKt.access$microsToNanos(rangeUs.getMax())).build());
                Intrinsics.checkNotNullExpressionValue((Object)memoryData, (String)"client.memoryClient.getD\u2026                .build())");
                List list2 = memoryData.getAllocationsInfoList();
                list = list2;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"client.memoryClient.getD\u2026     .allocationsInfoList");
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        private final <T> List<T> getForSession(ProfilerClient client, Common.Session session, Range rangeUs, Common.Event.Kind eventKind, Function1<? super Transport.EventGroup, ? extends T> mapper) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Transport.GetEventGroupsRequest getEventGroupsRequest;
            Transport.GetEventGroupsRequest it = getEventGroupsRequest = Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(eventKind).setFromTimestamp(MemoryProfilerKt.access$microsToNanos(rangeUs.getMin())).setToTimestamp(MemoryProfilerKt.access$microsToNanos(rangeUs.getMax())).build();
            boolean bl = false;
            Transport.GetEventGroupsResponse getEventGroupsResponse = client.getTransportClient().getEventGroups(it);
            Intrinsics.checkNotNullExpressionValue((Object)getEventGroupsResponse, (String)"client.transportClient.getEventGroups(it)");
            List list = getEventGroupsResponse.getGroupsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"client.transportClient.g\u2026ventGroups(it).groupsList");
            Iterable iterable = list;
            Function1<? super Transport.EventGroup, ? extends T> transform$iv = mapper;
            boolean $i$f$map = false;
            void var12_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(transform$iv.invoke(item$iv$iv));
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        public final void trackAllocations(@NotNull StudioProfilers profilers, @NotNull Common.Session session, boolean enable, @Nullable Consumer<Memory.TrackStatus> responseHandler) {
            block3: {
                long timeNs;
                block2: {
                    Commands.Command.Builder builder;
                    Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    ProfilerClient profilerClient = profilers.getClient();
                    Intrinsics.checkNotNullExpressionValue((Object)profilerClient, (String)"profilers.client");
                    Transport.TimeResponse timeResponse = profilerClient.getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(session.getStreamId()).build());
                    Intrinsics.checkNotNullExpressionValue((Object)timeResponse, (String)"profilers.client.transpo\u2026ession.streamId).build())");
                    timeNs = timeResponse.getTimestampNs();
                    IdeProfilerServices ideProfilerServices = profilers.getIdeServices();
                    Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices, (String)"profilers.ideServices");
                    FeatureConfig featureConfig = ideProfilerServices.getFeatureConfig();
                    Intrinsics.checkNotNullExpressionValue((Object)featureConfig, (String)"profilers.ideServices.featureConfig");
                    if (!featureConfig.isUnifiedPipelineEnabled()) break block2;
                    Commands.Command.Builder $this$apply = builder = Commands.Command.newBuilder();
                    boolean bl = false;
                    $this$apply.setStreamId(session.getStreamId());
                    $this$apply.setPid(session.getPid());
                    if (enable) {
                        $this$apply.setType(Commands.Command.CommandType.START_ALLOC_TRACKING);
                        $this$apply.setStartAllocTracking(Memory.StartAllocTracking.newBuilder().setRequestTime(timeNs));
                    } else {
                        $this$apply.setType(Commands.Command.CommandType.STOP_ALLOC_TRACKING);
                        $this$apply.setStopAllocTracking(Memory.StopAllocTracking.newBuilder().setRequestTime(timeNs));
                    }
                    Commands.Command.Builder trackCommand = builder;
                    ProfilerClient profilerClient2 = profilers.getClient();
                    Intrinsics.checkNotNullExpressionValue((Object)profilerClient2, (String)"profilers.client");
                    Transport.ExecuteResponse response = profilerClient2.getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(trackCommand).build());
                    if (responseHandler == null) break block3;
                    IdeProfilerServices ideProfilerServices2 = profilers.getIdeServices();
                    Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices2, (String)"profilers.ideServices");
                    Executor executor = ideProfilerServices2.getMainExecutor();
                    Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"profilers.ideServices.mainExecutor");
                    TransportEventListener statusListener2 = new TransportEventListener(Common.Event.Kind.MEMORY_ALLOC_TRACKING_STATUS, executor, (Function1)new Function1<Common.Event, Boolean>(response){
                        final /* synthetic */ Transport.ExecuteResponse $response;

                        public final boolean invoke(@NotNull Common.Event event) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            int n = event.getCommandId();
                            Transport.ExecuteResponse executeResponse = this.$response;
                            Intrinsics.checkNotNullExpressionValue((Object)executeResponse, (String)"response");
                            return n == executeResponse.getCommandId();
                        }
                        {
                            this.$response = executeResponse;
                            super(1);
                        }
                    }, (Function0)new Function0<Long>(session){
                        final /* synthetic */ Common.Session $session;

                        public final long invoke() {
                            return this.$session.getStreamId();
                        }
                        {
                            this.$session = session;
                            super(0);
                        }
                    }, (Function0)new Function0<Integer>(session){
                        final /* synthetic */ Common.Session $session;

                        public final int invoke() {
                            return this.$session.getPid();
                        }
                        {
                            this.$session = session;
                            super(0);
                        }
                    }, null, null, null, (Function1)new Function1<Common.Event, Boolean>(responseHandler){
                        final /* synthetic */ Consumer $responseHandler;

                        public final boolean invoke(@NotNull Common.Event event) {
                            boolean bl;
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            boolean it = bl = true;
                            boolean bl2 = false;
                            Memory.MemoryAllocTrackingStatusData memoryAllocTrackingStatusData = event.getMemoryAllocTrackingStatus();
                            Intrinsics.checkNotNullExpressionValue((Object)memoryAllocTrackingStatusData, (String)"event.memoryAllocTrackingStatus");
                            this.$responseHandler.accept(memoryAllocTrackingStatusData.getStatus());
                            return bl;
                        }
                        {
                            this.$responseHandler = consumer;
                            super(1);
                        }
                    }, 224, null);
                    profilers.getTransportPoller().registerListener(statusListener2);
                    break block3;
                }
                ProfilerClient profilerClient = profilers.getClient();
                Intrinsics.checkNotNullExpressionValue((Object)profilerClient, (String)"profilers.client");
                MemoryProfiler.TrackAllocationsResponse response = profilerClient.getMemoryClient().trackAllocations(MemoryProfiler.TrackAllocationsRequest.newBuilder().setSession(session).setRequestTime(timeNs).setEnabled(enable).build());
                Consumer<Memory.TrackStatus> consumer = responseHandler;
                if (consumer == null) break block3;
                MemoryProfiler.TrackAllocationsResponse trackAllocationsResponse = response;
                Intrinsics.checkNotNullExpressionValue((Object)trackAllocationsResponse, (String)"response");
                consumer.accept(trackAllocationsResponse.getStatus());
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

