/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class MemoryInstanceFilterView
extends AspectModel<MemoryProfilerAspect> {
    @NotNull
    private final MemoryCaptureSelection mySelection;
    @NotNull
    private JPanel myFilterToolbar;
    @NotNull
    private JPanel myFilterDescriptionPanel;

    MemoryInstanceFilterView(@NotNull MemoryCaptureSelection selection2) {
        if (selection2 == null) {
            MemoryInstanceFilterView.$$$reportNull$$$0(0);
        }
        this.myFilterToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myFilterDescriptionPanel = new JPanel((LayoutManager)new TabularLayout("Fit,*"));
        this.mySelection = selection2;
        this.myFilterDescriptionPanel.setBorder(JBUI.Borders.merge((Border)ProfilerLayout.TOOLBAR_LABEL_BORDER, (Border)AdtUiUtils.DEFAULT_TOP_BORDER, (boolean)true));
        this.myFilterDescriptionPanel.setBackground(ProfilerColors.WARNING_BAR_COLOR);
        this.myFilterDescriptionPanel.setVisible(false);
        this.mySelection.getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE, this::updateFilters);
    }

    @NotNull
    JComponent getFilterToolbar() {
        JPanel jPanel = this.myFilterToolbar;
        if (jPanel == null) {
            MemoryInstanceFilterView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    JComponent getFilterDescription() {
        return this.myFilterDescriptionPanel;
    }

    private void updateFilters() {
        this.myFilterToolbar.removeAll();
        CaptureObject captureObject = this.mySelection.getSelectedCapture();
        if (captureObject == null) {
            return;
        }
        for (CaptureObjectInstanceFilter supportedFilter : captureObject.getSupportedInstanceFilters()) {
            JBCheckBox filterCheckBox = new JBCheckBox(supportedFilter.getDisplayName());
            filterCheckBox.setBorder((Border)new JBEmptyBorder(0, 4, 0, 4));
            filterCheckBox.setToolTipText(supportedFilter.getSummaryDescription());
            filterCheckBox.addActionListener(l -> {
                if (filterCheckBox.isSelected()) {
                    this.mySelection.addInstanceFilter(supportedFilter, SwingUtilities::invokeLater);
                    this.mySelection.getIdeServices().getFeatureTracker().trackMemoryProfilerInstanceFilter(supportedFilter);
                } else {
                    this.mySelection.removeInstanceFilter(supportedFilter, SwingUtilities::invokeLater);
                }
                boolean hasFilterDescription = false;
                this.myFilterDescriptionPanel.removeAll();
                Set<CaptureObjectInstanceFilter> selectedFilters = captureObject.getSelectedInstanceFilters();
                int i = 0;
                for (CaptureObjectInstanceFilter filter : selectedFilters) {
                    String description = filter.getDetailedDescription();
                    if (description == null) continue;
                    HyperlinkLabel label = new HyperlinkLabel();
                    String docLink = filter.getDocumentationLink();
                    if (docLink != null) {
                        label.setHyperlinkText(description + " Please see the ", "documentation", " for details.");
                        label.setHyperlinkTarget(docLink);
                    } else {
                        label.setHyperlinkText(description, "", "");
                    }
                    this.myFilterDescriptionPanel.add((Component)label, new TabularLayout.Constraint(i++, 0));
                    hasFilterDescription = true;
                }
                this.myFilterDescriptionPanel.setVisible(hasFilterDescription);
            });
            this.myFilterToolbar.add((Component)filterCheckBox);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryInstanceFilterView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryInstanceFilterView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

