/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.formatter.NumberFormatter;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.AttributeColumn;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.InstanceNodeKt;
import com.android.tools.profilers.memory.LazyMemoryObjectTreeNode;
import com.android.tools.profilers.memory.LeafNode;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.SimpleColumnRenderer;
import com.android.tools.profilers.memory.ValueColumnRenderer;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassSet;
import com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryClassSetView
extends AspectObserver {
    private static final int LABEL_COLUMN_WIDTH = 500;
    @NotNull
    private final MemoryCaptureSelection mySelection;
    @NotNull
    private final ContextMenuInstaller myContextMenuInstaller;
    @NotNull
    private final Map<CaptureObject.InstanceAttribute, AttributeColumn<MemoryObject>> myAttributeColumns;
    @NotNull
    private final JPanel myInstancesPanel;
    @Nullable
    private JComponent myColumnTree;
    @Nullable
    private JTree myTree;
    @Nullable
    private DefaultTreeModel myTreeModel;
    @Nullable
    private LazyMemoryObjectTreeNode<MemoryObject> myTreeRoot;
    @Nullable
    private Comparator<MemoryObjectTreeNode<MemoryObject>> myInitialComparator;
    @Nullable
    private CaptureObject myCaptureObject;
    @Nullable
    private ClassSet myClassSet;
    @Nullable
    private InstanceObject myInstanceObject;

    MemoryClassSetView(@NotNull MemoryCaptureSelection selection2, @NotNull IdeProfilerComponents ideProfilerComponents, @NotNull Range selectionRange, @NotNull StreamingTimeline timeline) {
        if (selection2 == null) {
            MemoryClassSetView.$$$reportNull$$$0(0);
        }
        if (ideProfilerComponents == null) {
            MemoryClassSetView.$$$reportNull$$$0(1);
        }
        if (selectionRange == null) {
            MemoryClassSetView.$$$reportNull$$$0(2);
        }
        if (timeline == null) {
            MemoryClassSetView.$$$reportNull$$$0(3);
        }
        this.myAttributeColumns = new HashMap<CaptureObject.InstanceAttribute, AttributeColumn<MemoryObject>>();
        this.myInstancesPanel = new JPanel(new BorderLayout());
        this.mySelection = selection2;
        this.myContextMenuInstaller = ideProfilerComponents.createContextMenuInstaller();
        this.mySelection.getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE, this::refreshCaptureObject).onChange((Enum)CaptureSelectionAspect.CURRENT_CLASS, this::refreshClassSet).onChange((Enum)CaptureSelectionAspect.CURRENT_INSTANCE, this::refreshSelectedInstance).onChange((Enum)CaptureSelectionAspect.CURRENT_HEAP_CONTENTS, this::refreshAllInstances);
        LongFunction<String> timeFormatter = t -> TimeFormatter.getSemiSimplifiedClockString((long)timeline.convertToRelativeTimeUs(t));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.LABEL, new AttributeColumn("Instance", this::makeNameColumnRenderer, 2, 500, SortOrder.ASCENDING, Comparator.comparing(SimpleColumnRenderer.onSubclass(ValueObject.class, o -> o.getName().isEmpty() ? o.getValueText() : o.getName(), o -> ""))));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.DEPTH, SimpleColumnRenderer.makeIntColumn("Depth", 50, ValueObject.class, ValueObject::getDepth, d -> 0L <= d && d < Integer.MAX_VALUE, NumberFormatter::formatInteger, SortOrder.ASCENDING));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.ALLOCATION_TIME, new AttributeColumn("Alloc Time", () -> new SimpleColumnRenderer(SimpleColumnRenderer.makeConditionalTextGetter(InstanceObject.class, InstanceObject::getAllocTime, t -> t > Long.MIN_VALUE, timeFormatter), value -> null, SimpleColumnRenderer.makeConditionalGetter(InstanceObject.class, InstanceObject::getAllocTime, t -> t >= TimeUnit.MICROSECONDS.toNanos((long)selectionRange.getMin()) && t < TimeUnit.MICROSECONDS.toNanos((long)selectionRange.getMax()), t -> SimpleTextAttributes.REGULAR_ATTRIBUTES, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES), 4), 4, 80, SortOrder.ASCENDING, SimpleColumnRenderer.compareOn(InstanceObject.class, InstanceObject::getAllocTime)));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.DEALLOCATION_TIME, SimpleColumnRenderer.makeIntColumn("Dealloc Time", 120, InstanceObject.class, InstanceObject::getDeallocTime, t -> t < Long.MAX_VALUE, timeFormatter, SortOrder.DESCENDING));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.NATIVE_SIZE, SimpleColumnRenderer.makeSizeColumn("Native Size", 110, ValueObject::getNativeSize));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.SHALLOW_SIZE, SimpleColumnRenderer.makeSizeColumn("Shallow Size", 120, ValueObject::getShallowSize));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.RETAINED_SIZE, SimpleColumnRenderer.makeSizeColumn("Retained Size", 130, ValueObject::getRetainedSize));
        this.myInstancesPanel.setVisible(false);
    }

    public void reset() {
        if (this.myColumnTree != null) {
            this.myInstancesPanel.remove(this.myColumnTree);
        }
        this.myColumnTree = null;
        this.myTree = null;
        this.myTreeRoot = null;
        this.myTreeModel = null;
        this.myClassSet = null;
        this.myInstanceObject = null;
        this.myInstancesPanel.setVisible(false);
        this.mySelection.selectInstanceObject(null);
    }

    @NotNull
    JComponent getComponent() {
        JPanel jPanel = this.myInstancesPanel;
        if (jPanel == null) {
            MemoryClassSetView.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @VisibleForTesting
    @Nullable
    JTree getTree() {
        return this.myTree;
    }

    @VisibleForTesting
    @Nullable
    JComponent getColumnTree() {
        return this.myColumnTree;
    }

    private void initializeTree() {
        assert (this.myTree == null && this.myColumnTree == null && this.myTreeModel == null && this.myTreeRoot == null && this.myCaptureObject != null && this.myClassSet != null);
        this.myTree = new JTree();
        int defaultFontHeight = this.myTree.getFontMetrics(this.myTree.getFont()).getHeight();
        this.myTree.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        this.myTree.setBorder(ProfilerLayout.TABLE_ROW_BORDER);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.addTreeSelectionListener(e -> {
            TreePath path = e.getPath();
            if (!e.isAddedPath()) {
                return;
            }
            assert (path.getLastPathComponent() instanceof MemoryObjectTreeNode);
            MemoryObjectTreeNode valueNode = (MemoryObjectTreeNode)path.getLastPathComponent();
            valueNode.select();
            Object memoryObject = valueNode.getAdapter();
            if (memoryObject instanceof InstanceObject) {
                this.myInstanceObject = (InstanceObject)valueNode.getAdapter();
                this.mySelection.selectFieldObjectPath(Collections.emptyList());
                this.mySelection.selectInstanceObject(this.myInstanceObject);
            }
        });
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                assert (path.getLastPathComponent() instanceof LazyMemoryObjectTreeNode);
                LazyMemoryObjectTreeNode treeNode = (LazyMemoryObjectTreeNode)path.getLastPathComponent();
                if (treeNode == MemoryClassSetView.this.myTreeRoot) {
                    return;
                }
                treeNode.expandNode();
                MemoryClassSetView.this.myTreeModel.nodeStructureChanged(treeNode);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.installTreeContextMenus();
        List<CaptureObject.InstanceAttribute> supportedAttributes = this.myCaptureObject.getInstanceAttributes();
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.myTree);
        CaptureObject.InstanceAttribute sortAttribute = Collections.max(supportedAttributes, Comparator.comparingInt(CaptureObject.InstanceAttribute::getWeight));
        for (CaptureObject.InstanceAttribute attribute : supportedAttributes) {
            AttributeColumn<MemoryObject> column = this.myAttributeColumns.get((Object)attribute);
            ColumnTreeBuilder.ColumnBuilder columnBuilder = column.getBuilder();
            if (sortAttribute == attribute) {
                columnBuilder.setInitialOrder(attribute.getSortOrder());
                this.myInitialComparator = attribute.getSortOrder() == SortOrder.ASCENDING ? column.getComparator() : Collections.reverseOrder(column.getComparator());
            }
            builder.addColumn(columnBuilder);
        }
        builder.setTreeSorter((comparator, sortOrder) -> {
            if (this.myTreeRoot != null) {
                TreePath selectionPath = this.myTree.getSelectionPath();
                this.myTreeRoot.sort(comparator);
                this.myTreeModel.nodeStructureChanged(this.myTreeRoot);
                if (selectionPath != null) {
                    this.myTree.expandPath(selectionPath.getParentPath());
                    this.myTree.setSelectionPath(selectionPath);
                    this.myTree.scrollPathToVisible(selectionPath);
                }
            }
        });
        this.myTree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (MemoryClassSetView.this.myTree.getSelectionCount() == 0 && MemoryClassSetView.this.myTree.getRowCount() != 0) {
                    MemoryClassSetView.this.myTree.setSelectionRow(0);
                }
            }
        });
        builder.setHoverColor(StandardColors.HOVER_COLOR);
        builder.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        builder.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
        builder.setShowVerticalLines(true);
        builder.setTableIntercellSpacing(new Dimension());
        builder.setShowHeaderTooltips(true);
        this.myColumnTree = builder.build();
        this.myInstancesPanel.add((Component)this.myColumnTree, "Center");
    }

    private void installTreeContextMenus() {
        assert (this.myTree != null);
        this.myContextMenuInstaller.installNavigationContextMenu((JComponent)this.myTree, this.mySelection.getIdeServices().getCodeNavigator(), () -> {
            TreePath selection2 = this.myTree.getSelectionPath();
            if (selection2 == null || !(selection2.getLastPathComponent() instanceof MemoryObjectTreeNode)) {
                return null;
            }
            Object selectedObject = ((MemoryObjectTreeNode)selection2.getLastPathComponent()).getAdapter();
            return selectedObject instanceof InstanceObject ? new CodeLocation.Builder(((InstanceObject)selectedObject).getClassEntry().getClassName()).build() : null;
        });
    }

    private void populateTreeContents() {
        assert (this.myTree != null && this.myCaptureObject != null && this.myClassSet != null);
        Comparator comparator = this.myTreeRoot == null ? this.myInitialComparator : this.myTreeRoot.getComparator();
        this.myTreeRoot = new LazyMemoryObjectTreeNode<MemoryObject>((MemoryObject)this.myClassSet, true){

            @Override
            public int computeChildrenCount() {
                return MemoryClassSetView.this.myClassSet.getInstancesCount();
            }

            @Override
            public void expandNode() {
                if (this.myMemoizedChildrenCount == this.myChildren.size()) {
                    return;
                }
                this.myMemoizedChildrenCount = MemoryClassSetView.this.myClassSet.getInstancesCount();
                MemoryClassSetView.this.myClassSet.getInstancesStream().forEach(subAdapter -> InstanceNodeKt.addChild(this, subAdapter, LeafNode::new));
                if (MemoryClassSetView.this.myTreeModel != null) {
                    MemoryClassSetView.this.myTreeModel.nodeChanged(this);
                }
            }
        };
        if (comparator != null) {
            this.myTreeRoot.sort(comparator);
        }
        this.myTreeModel = new DefaultTreeModel(this.myTreeRoot);
        this.myTreeRoot.setTreeModel(this.myTreeModel);
        this.myTree.setModel(this.myTreeModel);
        this.myTreeRoot.expandNode();
    }

    private void refreshCaptureObject() {
        this.myCaptureObject = this.mySelection.getSelectedCapture();
        this.reset();
    }

    private void refreshClassSet() {
        ClassSet classSet = this.mySelection.getSelectedClassSet();
        if (classSet == this.myClassSet) {
            return;
        }
        if (classSet == null) {
            this.reset();
            return;
        }
        if (this.myClassSet == null) {
            this.myClassSet = classSet;
            this.initializeTree();
        } else {
            this.myClassSet = classSet;
        }
        this.populateTreeContents();
        this.myInstancesPanel.setVisible(true);
    }

    private void refreshSelectedInstance() {
        InstanceObject instanceObject = this.mySelection.getSelectedInstanceObject();
        if (this.myInstanceObject == instanceObject) {
            return;
        }
        assert (this.myTree != null);
        this.myInstanceObject = instanceObject;
        if (this.myInstanceObject == null) {
            this.myTree.clearSelection();
            return;
        }
        assert (this.myTreeRoot != null && this.myTreeModel != null);
        for (MemoryObjectTreeNode node : this.myTreeRoot.getChildren()) {
            if (node.getAdapter() != this.myInstanceObject) continue;
            this.selectPath(node);
            break;
        }
    }

    private void refreshAllInstances() {
        if (this.myClassSet == null) {
            return;
        }
        if (this.myClassSet.isEmpty()) {
            this.mySelection.selectClassSet(ClassSet.EMPTY_SET);
            return;
        }
        this.populateTreeContents();
        if (this.myInstanceObject == null) {
            return;
        }
        assert (this.myTreeRoot != null);
        for (MemoryObjectTreeNode node : this.myTreeRoot.getChildren()) {
            if (node.getAdapter() != this.myInstanceObject) continue;
            this.selectPath(node);
            return;
        }
        this.mySelection.selectInstanceObject(null);
    }

    @Nullable
    private MemoryObjectTreeNode<MemoryObject> findSelectedInstanceNode() {
        assert (this.myTree != null && this.myTreeModel != null && this.myTreeRoot != null && this.myInstanceObject != null);
        for (MemoryObjectTreeNode node : this.myTreeRoot.getChildren()) {
            if (node.getAdapter() != this.myInstanceObject) continue;
            return node;
        }
        return null;
    }

    private void selectPath(@NotNull MemoryObjectTreeNode<MemoryObject> targetNode) {
        if (targetNode == null) {
            MemoryClassSetView.$$$reportNull$$$0(5);
        }
        assert (this.myTree != null && this.myTreeModel != null);
        TreePath path = new TreePath(this.myTreeModel.getPathToRoot(targetNode));
        this.myTree.expandPath(path.getParentPath());
        this.myTree.setSelectionPath(path);
        this.myTree.scrollPathToVisible(path);
    }

    @NotNull
    private static List<MemoryObjectTreeNode<MemoryObject>> findLeafNodesForFieldPath(@NotNull MemoryObjectTreeNode<MemoryObject> parentNode, @NotNull List<FieldObject> fieldPath) {
        if (parentNode == null) {
            MemoryClassSetView.$$$reportNull$$$0(6);
        }
        if (fieldPath == null) {
            MemoryClassSetView.$$$reportNull$$$0(7);
        }
        assert (!fieldPath.isEmpty());
        FieldObject currentField = fieldPath.get(0);
        ArrayList<MemoryObjectTreeNode<MemoryObject>> results = new ArrayList<MemoryObjectTreeNode<MemoryObject>>(1);
        if (fieldPath.size() == 1) {
            parentNode.getChildren().stream().filter(child -> child.getAdapter().equals(currentField)).forEach(results::add);
        } else {
            List<FieldObject> slice = fieldPath.subList(1, fieldPath.size());
            parentNode.getChildren().stream().filter(child -> child.getAdapter().equals(currentField)).forEach(child -> results.addAll(MemoryClassSetView.findLeafNodesForFieldPath(child, slice)));
        }
        ArrayList<MemoryObjectTreeNode<MemoryObject>> arrayList = results;
        if (arrayList == null) {
            MemoryClassSetView.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private ColoredTreeCellRenderer makeNameColumnRenderer() {
        return new ValueColumnRenderer(){
            private boolean myIsLeaked = false;

            protected void paintComponent(Graphics g) {
                if (this.myIsLeaked) {
                    int width = this.getWidth();
                    int height = this.getHeight();
                    Icon i = this.mySelected && this.isFocused() ? ColoredIconGenerator.generateWhiteIcon((Icon)StudioIcons.Common.WARNING) : StudioIcons.Common.WARNING;
                    int iconWidth = i.getIconWidth();
                    int iconHeight = i.getIconHeight();
                    i.paintIcon((Component)((Object)this), g, width - iconWidth - 4, (height - iconHeight) / 2);
                }
                super.paintComponent(g);
            }

            @Override
            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof MemoryObjectTreeNode && ((MemoryObjectTreeNode)value).getAdapter() instanceof InstanceObject) {
                    ActivityFragmentLeakInstanceFilter leakFilter = MemoryClassSetView.this.myCaptureObject.getActivityFragmentLeakFilter();
                    this.myIsLeaked = leakFilter != null && (Boolean)leakFilter.getInstanceTest().invoke((Object)((InstanceObject)((MemoryObjectTreeNode)value).getAdapter())) != false;
                    String msg = "To investigate leak, select instance and see \"References\"";
                    this.setToolTipText(this.myIsLeaked ? msg : null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/profilers/memory/MemoryClassSetView$4", "customizeCellRenderer"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerComponents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeline";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryClassSetView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryClassSetView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findLeafNodesForFieldPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findLeafNodesForFieldPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

