/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.idea.transport.TransportFileManager;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.RecordingOption;
import com.android.tools.profilers.RecordingOptionsModel;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.SupportLevel;
import com.android.tools.profilers.memory.AllocationDurationData;
import com.android.tools.profilers.memory.AllocationStage;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.CaptureDataSeries;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureObjectLoader;
import com.android.tools.profilers.memory.MemoryCaptureStage;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.HeapDumpCaptureObject;
import com.android.tools.profilers.memory.adapters.NativeAllocationSampleCaptureObject;
import com.android.tools.profilers.sessions.SessionAspect;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainMemoryProfilerStage
extends BaseStreamingMemoryProfilerStage {
    private static final String HEAP_DUMP_TOOLTIP = "View objects in your app that are using memory at a specific point in time";
    private static final String CAPTURE_HEAP_DUMP_TEXT = "Capture heap dump";
    private static final String RECORD_JAVA_TEXT = "Record Java / Kotlin allocations";
    private static final String RECORD_JAVA_TOOLTIP = "View how each Java / Kotlin object was allocated over a period of time";
    @VisibleForTesting
    static final String RECORD_NATIVE_TEXT = "Record native allocations";
    @VisibleForTesting
    static final String X86_RECORD_NATIVE_TOOLTIP = "Native memory recording is unavailable on x86 or x86_64 devices";
    private static final String RECORD_NATIVE_DESC = "View how each C / C++ object was allocated over a period of time";
    public static final int MEMORY_HPROF_SAFE_FACTOR = Math.max(1, Math.min(Integer.getInteger("profiler.memory.hprof.safeFactor", 10), 1000));
    private final boolean myIsMemoryCaptureOnly;
    private final DurationDataModel<CaptureDurationData<? extends CaptureObject>> myHeapDumpDurations;
    private final DurationDataModel<CaptureDurationData<? extends CaptureObject>> myAllocationDurations;
    private final DurationDataModel<CaptureDurationData<? extends CaptureObject>> myNativeAllocationDurations;
    private long myPendingLegacyAllocationStartTimeNs;
    private boolean myNativeAllocationTracking;
    private final RecordingOptionsModel myRecordingOptionsModel;

    public MainMemoryProfilerStage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            MainMemoryProfilerStage.$$$reportNull$$$0(0);
        }
        this(profilers, new CaptureObjectLoader());
    }

    public MainMemoryProfilerStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader) {
        if (profilers == null) {
            MainMemoryProfilerStage.$$$reportNull$$$0(1);
        }
        if (loader == null) {
            MainMemoryProfilerStage.$$$reportNull$$$0(2);
        }
        super(profilers, loader);
        this.myPendingLegacyAllocationStartTimeNs = -1L;
        this.myNativeAllocationTracking = false;
        this.myIsMemoryCaptureOnly = profilers.getSessionsManager().getSelectedSessionMetaData().getType() == Common.SessionMetaData.SessionType.MEMORY_CAPTURE;
        this.myHeapDumpDurations = this.makeModel(CaptureDataSeries::ofHeapDumpSamples);
        this.myAllocationDurations = this.isLiveAllocationTrackingSupported() ? AllocationDurationData.makeModel(this.getTimeline().getViewRange(), this.getTimeline().getDataRange(), this.applyDataSeriesConstructor(CaptureDataSeries::ofAllocationInfos), this.getAllocationSamplingRateDataSeries()) : this.makeModel(CaptureDataSeries::ofAllocationInfos);
        this.myNativeAllocationDurations = this.makeModel(CaptureDataSeries::ofNativeAllocationSamples);
        this.myHeapDumpDurations.setRenderSeriesPredicate((data, series) -> !series.getName().equals(this.getDetailedMemoryUsage().getObjectsSeries().getName()));
        this.getRangeSelectionModel().addConstraint(this.myAllocationDurations);
        this.getRangeSelectionModel().addConstraint(this.myNativeAllocationDurations);
        this.getRangeSelectionModel().addConstraint(this.myHeapDumpDurations);
        this.getStudioProfilers().getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::stopRecordingOnSessionStop);
        this.myRecordingOptionsModel = new RecordingOptionsModel();
    }

    public RecordingOptionsModel getRecordingOptionsModel() {
        return this.myRecordingOptionsModel;
    }

    void stopRecordingOnSessionStop() {
        boolean isAlive = this.getStudioProfilers().getSessionsManager().isSessionAlive();
        if (!isAlive && this.myNativeAllocationTracking) {
            this.toggleNativeAllocationTracking();
        }
    }

    public boolean hasUserUsedMemoryCapture() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean("memory.used.capture", false);
    }

    @Override
    public void enter() {
        super.enter();
        BiConsumer<SupportLevel.Feature, RecordingOption> adder = (feature, option) -> {
            this.myRecordingOptionsModel.addBuiltInOptions((RecordingOption)option);
            if (!this.getStudioProfilers().getSelectedSessionSupportLevel().isFeatureSupported((SupportLevel.Feature)((Object)feature))) {
                this.myRecordingOptionsModel.setOptionNotReady((RecordingOption)option, feature.getTitle() + " is not supported for profileable processes");
            }
        };
        adder.accept(SupportLevel.Feature.MEMORY_HEAP_DUMP, this.makeHeapDumpOption());
        if (this.isNativeAllocationSamplingEnabled()) {
            adder.accept(SupportLevel.Feature.MEMORY_NATIVE_RECORDING, this.makeNativeRecordingOption());
        }
        RecordingOption javaRecordingOption = this.makeJavaRecodingOption();
        adder.accept(SupportLevel.Feature.MEMORY_JVM_RECORDING, javaRecordingOption);
        this.updateAllocationTrackingStatus();
        this.updateNativeAllocationTrackingStatus();
    }

    @Override
    public void exit() {
        super.exit();
        this.enableSelectLatestCapture(false, null);
        this.selectCaptureDuration(null, null);
    }

    @Override
    @NotNull
    public List<DurationDataModel<CaptureDurationData<? extends CaptureObject>>> getCaptureSeries() {
        List<DurationDataModel<CaptureDurationData<? extends CaptureObject>>> list = Arrays.asList(this.myAllocationDurations, this.myHeapDumpDurations, this.myNativeAllocationDurations);
        if (list == null) {
            MainMemoryProfilerStage.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    protected void selectCaptureFromSelectionRange() {
        if (!this.getUpdateCaptureOnSelection()) {
            return;
        }
        this.setUpdateCaptureOnSelection(false);
        Range selectionRange = this.getTimeline().getSelectionRange();
        this.selectCaptureDuration(this.getIntersectingCaptureDuration(selectionRange), SwingUtilities::invokeLater);
        this.setUpdateCaptureOnSelection(true);
    }

    public boolean isMemoryCaptureOnly() {
        return this.myIsMemoryCaptureOnly;
    }

    @Override
    protected void onCaptureToSelect(SeriesData<CaptureDurationData<? extends CaptureObject>> captureToSelect, @NotNull Executor loadJoiner) {
        if (loadJoiner == null) {
            MainMemoryProfilerStage.$$$reportNull$$$0(4);
        }
        long x = captureToSelect.x;
        if (this.getHeapDumpSampleDurations().getSeries().getSeriesForRange(this.getTimeline().getDataRange()).stream().anyMatch(s -> s.x == x)) {
            this.getAspect().changed((Enum)MemoryProfilerAspect.HEAP_DUMP_FINISHED);
        }
        this.selectCaptureDuration((CaptureDurationData)((Object)captureToSelect.value), loadJoiner);
    }

    public void setPendingCaptureStartTimeGuarded(long pendingCaptureStartTime) {
        assert (this.myIsMemoryCaptureOnly);
        super.setPendingCaptureStartTime(pendingCaptureStartTime);
    }

    private Transport.ExecuteResponse startNativeAllocationTracking() {
        IdeProfilerServices ide = this.getStudioProfilers().getIdeServices();
        ide.getFeatureTracker().trackRecordAllocations();
        Common.Process process = this.getStudioProfilers().getProcess();
        String traceFilePath = String.format(Locale.getDefault(), "%s/%s.trace", "/data/local/tmp/perfd", process.getName());
        Commands.Command dumpCommand = Commands.Command.newBuilder().setStreamId(this.getSessionData().getStreamId()).setPid(this.getSessionData().getPid()).setType(Commands.Command.CommandType.START_NATIVE_HEAP_SAMPLE).setStartNativeSample(Memory.StartNativeSample.newBuilder().setSamplingIntervalBytes(ide.getNativeMemorySamplingRateForCurrentConfig()).setSharedMemoryBufferBytes(0x4000000).setAbiCpuArch(TransportFileManager.getShortAbiName((String)this.getStudioProfilers().getDevice().getCpuAbi())).setTempPath(traceFilePath).setAppName(process.getName())).build();
        return this.getStudioProfilers().getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(dumpCommand).build());
    }

    private Transport.ExecuteResponse stopNativeAllocationTracking(long startTime) {
        Commands.Command dumpCommand = Commands.Command.newBuilder().setStreamId(this.getSessionData().getStreamId()).setPid(this.getSessionData().getPid()).setType(Commands.Command.CommandType.STOP_NATIVE_HEAP_SAMPLE).setStopNativeSample(Memory.StopNativeSample.newBuilder().setStartTime(startTime)).build();
        return this.getStudioProfilers().getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(dumpCommand).build());
    }

    public void toggleNativeAllocationTracking() {
        assert (this.getStudioProfilers().getProcess() != null);
        Transport.ExecuteResponse response = !this.myNativeAllocationTracking ? this.startNativeAllocationTracking() : this.stopNativeAllocationTracking(this.getPendingCaptureStartTime());
        TransportEventListener statusListener2 = new TransportEventListener(Common.Event.Kind.MEMORY_NATIVE_SAMPLE_STATUS, this.getStudioProfilers().getIdeServices().getMainExecutor(), event -> event.getCommandId() == response.getCommandId(), () -> this.getSessionData().getStreamId(), () -> this.getSessionData().getPid(), event -> {
            this.nativeAllocationTrackingStart(event.getMemoryNativeTrackingStatus());
            return true;
        });
        this.getStudioProfilers().getTransportPoller().registerListener(statusListener2);
    }

    @VisibleForTesting
    void nativeAllocationTrackingStart(@NotNull Memory.MemoryNativeTrackingData status) {
        if (status == null) {
            MainMemoryProfilerStage.$$$reportNull$$$0(5);
        }
        switch (status.getStatus()) {
            case SUCCESS: {
                this.myNativeAllocationTracking = true;
                this.setModelToRecordingNative();
                this.setPendingCaptureStartTime(status.getStartTime());
                this.setTrackingAllocations(true);
                this.myPendingLegacyAllocationStartTimeNs = status.getStartTime();
                this.getTimeline().setStreaming(true);
                break;
            }
            case IN_PROGRESS: {
                this.myNativeAllocationTracking = true;
                this.setModelToRecordingNative();
                this.setTrackingAllocations(true);
                this.getLogger().debug(String.format(Locale.getDefault(), "A heap dump for %d is already in progress.", this.getSessionData().getPid()));
                break;
            }
            case FAILURE: {
                this.getLogger().error(status.getFailureMessage());
            }
            case NOT_RECORDING: 
            case UNSPECIFIED: 
            case UNRECOGNIZED: {
                this.myNativeAllocationTracking = false;
                this.setTrackingAllocations(false);
            }
        }
        this.getAspect().changed((Enum)MemoryProfilerAspect.TRACKING_ENABLED);
    }

    private void setModelToRecordingNative() {
        RecordingOption option = this.getRecordingOptionsModel().getBuiltInOptions().stream().filter(opt -> opt.getTitle().equals(RECORD_NATIVE_TEXT)).findFirst().orElse(null);
        if (option != null) {
            this.getRecordingOptionsModel().selectBuiltInOption(option);
            this.getRecordingOptionsModel().setRecording();
        }
    }

    public void requestHeapDump() {
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            assert (this.getStudioProfilers().getProcess() != null);
            Commands.Command dumpCommand = Commands.Command.newBuilder().setStreamId(this.getSessionData().getStreamId()).setPid(this.getSessionData().getPid()).setType(Commands.Command.CommandType.HEAP_DUMP).build();
            CompletableFuture.runAsync(() -> {
                Transport.ExecuteResponse response = this.getStudioProfilers().getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(dumpCommand).build());
                TransportEventListener statusListener2 = new TransportEventListener(Common.Event.Kind.MEMORY_HEAP_DUMP_STATUS, this.getStudioProfilers().getIdeServices().getMainExecutor(), event -> event.getCommandId() == response.getCommandId(), () -> this.getSessionData().getStreamId(), () -> this.getSessionData().getPid(), event -> {
                    this.handleHeapDumpStart(event.getMemoryHeapdumpStatus().getStatus());
                    return true;
                });
                this.getStudioProfilers().getTransportPoller().registerListener(statusListener2);
            }, this.getStudioProfilers().getIdeServices().getPoolExecutor());
        } else {
            MemoryProfiler.TriggerHeapDumpResponse response = this.getClient().triggerHeapDump(MemoryProfiler.TriggerHeapDumpRequest.newBuilder().setSession(this.getSessionData()).build());
            this.handleHeapDumpStart(response.getStatus());
        }
        this.getTimeline().setStreaming(true);
        this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean("memory.used.capture", true);
    }

    private void handleHeapDumpStart(@NotNull Memory.HeapDumpStatus status) {
        if (status == null) {
            MainMemoryProfilerStage.$$$reportNull$$$0(6);
        }
        switch (status.getStatus()) {
            case SUCCESS: {
                this.setPendingCaptureStartTime(status.getStartTime());
                this.getAspect().changed((Enum)MemoryProfilerAspect.HEAP_DUMP_STARTED);
                break;
            }
            case IN_PROGRESS: {
                this.getLogger().debug(String.format(Locale.getDefault(), "A heap dump for %d is already in progress.", this.getSessionData().getPid()));
                break;
            }
        }
    }

    public DurationDataModel<CaptureDurationData<? extends CaptureObject>> getHeapDumpSampleDurations() {
        return this.myHeapDumpDurations;
    }

    public void trackAllocations(boolean enable) {
        MemoryProfiler.trackAllocations(this.getStudioProfilers(), this.getSessionData(), enable, status -> {
            switch (status.getStatus()) {
                case SUCCESS: {
                    this.setTrackingAllocations(enable);
                    this.setPendingCaptureStartTime(status.getStartTime());
                    this.myPendingLegacyAllocationStartTimeNs = enable ? status.getStartTime() : -1L;
                    break;
                }
                case IN_PROGRESS: {
                    this.setTrackingAllocations(true);
                    break;
                }
                case NOT_ENABLED: {
                    this.setTrackingAllocations(false);
                    break;
                }
            }
            this.getAspect().changed((Enum)MemoryProfilerAspect.TRACKING_ENABLED);
            if (this.isTrackingAllocations()) {
                this.getTimeline().setStreaming(true);
                this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean("memory.used.capture", true);
            }
        });
    }

    public long getAllocationTrackingElapsedTimeNs() {
        if (this.isTrackingAllocations()) {
            try {
                Transport.TimeResponse timeResponse = this.getStudioProfilers().getClient().getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(this.getSessionData().getStreamId()).build());
                return timeResponse.getTimestampNs() - this.myPendingLegacyAllocationStartTimeNs;
            }
            catch (StatusRuntimeException exception) {
                this.getLogger().warn((Throwable)exception);
            }
        }
        return -1L;
    }

    public boolean isNativeAllocationSamplingEnabled() {
        Common.Device device = this.getDeviceForSelectedSession();
        return device != null && device.getFeatureLevel() >= 29;
    }

    @NotNull
    public DurationDataModel<CaptureDurationData<? extends CaptureObject>> getAllocationInfosDurations() {
        DurationDataModel<CaptureDurationData<? extends CaptureObject>> durationDataModel = this.myAllocationDurations;
        if (durationDataModel == null) {
            MainMemoryProfilerStage.$$$reportNull$$$0(7);
        }
        return durationDataModel;
    }

    @NotNull
    public DurationDataModel<CaptureDurationData<? extends CaptureObject>> getNativeAllocationInfosDurations() {
        DurationDataModel<CaptureDurationData<? extends CaptureObject>> durationDataModel = this.myNativeAllocationDurations;
        if (durationDataModel == null) {
            MainMemoryProfilerStage.$$$reportNull$$$0(8);
        }
        return durationDataModel;
    }

    @VisibleForTesting
    public void selectCaptureDuration(@Nullable CaptureDurationData<? extends CaptureObject> durationData, @Nullable Executor joiner) {
        StudioProfilers profilers = this.getStudioProfilers();
        if (durationData instanceof AllocationDurationData) {
            profilers.setStage(AllocationStage.makeStaticStage(profilers, ((AllocationDurationData)durationData).getStart(), ((AllocationDurationData)durationData).getEnd()));
        } else if (durationData != null && (HeapDumpCaptureObject.class.isAssignableFrom(durationData.getCaptureObjectType()) || NativeAllocationSampleCaptureObject.class.isAssignableFrom(durationData.getCaptureObjectType()))) {
            profilers.setStage(new MemoryCaptureStage(profilers, this.getLoader(), durationData, joiner));
        } else {
            this.doSelectCaptureDuration(durationData, joiner);
        }
    }

    private void updateAllocationTrackingStatus() {
        List<Memory.AllocationsInfo> allocationsInfos = MemoryProfiler.getAllocationInfosForSession(this.getStudioProfilers().getClient(), this.getSessionData(), new Range(-9.223372036854776E18, 9.223372036854776E18), this.getStudioProfilers().getIdeServices());
        Memory.AllocationsInfo lastInfo = allocationsInfos.isEmpty() ? null : allocationsInfos.get(allocationsInfos.size() - 1);
        this.setTrackingAllocations(lastInfo != null && lastInfo.getLegacy() && lastInfo.getEndTime() == Long.MAX_VALUE);
        if (this.isTrackingAllocations()) {
            this.setPendingCaptureStartTime(lastInfo.getStartTime());
            this.myPendingLegacyAllocationStartTimeNs = lastInfo.getStartTime();
        } else {
            this.setPendingCaptureStartTime(-1L);
            this.myPendingLegacyAllocationStartTimeNs = -1L;
        }
    }

    private void updateNativeAllocationTrackingStatus() {
        List<Memory.MemoryNativeTrackingData> samples = MemoryProfiler.getNativeHeapStatusForSession(this.getStudioProfilers().getClient(), this.getSessionData(), new Range(-9.223372036854776E18, 9.223372036854776E18));
        if (samples.isEmpty()) {
            return;
        }
        Memory.MemoryNativeTrackingData last = samples.get(samples.size() - 1);
        if (last.getStatus() == Memory.MemoryNativeTrackingData.Status.SUCCESS) {
            this.nativeAllocationTrackingStart(last);
        }
    }

    private RecordingOption makeHeapDumpOption() {
        return new RecordingOption(CAPTURE_HEAP_DUMP_TEXT, HEAP_DUMP_TOOLTIP, () -> {
            this.requestHeapDump();
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackDumpHeap();
        });
    }

    private RecordingOption makeNativeRecordingOption() {
        return MainMemoryProfilerStage.makeToggleOption(RECORD_NATIVE_TEXT, RECORD_NATIVE_DESC, this::toggleNativeAllocationTracking);
    }

    private RecordingOption makeJavaRecodingOption() {
        Runnable toggle = this.isLiveAllocationTrackingSupported() ? () -> this.getStudioProfilers().setStage(AllocationStage.makeLiveStage(this.getStudioProfilers())) : () -> {
            if (this.isTrackingAllocations()) {
                this.getStudioProfilers().getIdeServices().getFeatureTracker().trackRecordAllocations();
            }
            this.trackAllocations(!this.isTrackingAllocations());
        };
        return MainMemoryProfilerStage.makeToggleOption(RECORD_JAVA_TEXT, RECORD_JAVA_TOOLTIP, toggle);
    }

    private static RecordingOption makeToggleOption(String title, String desc, Runnable toggle) {
        return new RecordingOption(title, desc, toggle, toggle);
    }

    public static boolean canSafelyLoadHprof(long fileSize) {
        System.gc();
        long leeway = 314572800L;
        long requestableMemory = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
        return requestableMemory >= (long)MEMORY_HPROF_SAFE_FACTOR * fileSize + leeway;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MainMemoryProfilerStage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadJoiner";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MainMemoryProfilerStage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureSeries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationInfosDurations";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeAllocationInfosDurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onCaptureToSelect";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nativeAllocationTrackingStart";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleHeapDumpStart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

