/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.chart.linechart.AbstractDurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.intellij.ui.JBColor;
import gnu.trove.TDoubleArrayList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B#\u0012\u0014\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ \u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001bH\u0002J4\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\r2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\rH\u0016J\u0018\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/profilers/memory/HeapDumpRenderer;", "Lcom/android/tools/adtui/model/AspectObserver;", "Lcom/android/tools/adtui/chart/linechart/AbstractDurationDataRenderer;", "model", "Lcom/android/tools/adtui/model/DurationDataModel;", "Lcom/android/tools/profilers/memory/CaptureDurationData;", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "viewRange", "Lcom/android/tools/adtui/model/Range;", "(Lcom/android/tools/adtui/model/DurationDataModel;Lcom/android/tools/adtui/model/Range;)V", "durationsCache", "Lgnu/trove/TDoubleArrayList;", "heapDumpHoveredListener", "", "Ljava/util/function/Consumer;", "", "mouseOverHeapDump", "isMouseOverHeapDump", "()Z", "setMouseOverHeapDump", "(Z)V", "labelCache", "Ljavax/swing/JLabel;", "mousePosition", "Ljava/awt/Point;", "startsCache", "addHeapDumpHoverListener", "", "listener", "handleMouseEvent", "overlayComponent", "Ljava/awt/Component;", "selectionComponent", "event", "Ljava/awt/event/MouseEvent;", "modelChanged", "renderLines", "lineChart", "Lcom/android/tools/adtui/chart/linechart/LineChart;", "g2d", "Ljava/awt/Graphics2D;", "transformedPaths", "Ljava/awt/geom/Path2D;", "transformedSeries", "Lcom/android/tools/adtui/model/RangedContinuousSeries;", "renderOverlay", "host", "Companion", "intellij.android.profilers.ui"})
public final class HeapDumpRenderer
extends AspectObserver
implements AbstractDurationDataRenderer {
    private final TDoubleArrayList startsCache;
    private final TDoubleArrayList durationsCache;
    private final List<JLabel> labelCache;
    private Point mousePosition;
    private final List<Consumer<Boolean>> heapDumpHoveredListener;
    private boolean isMouseOverHeapDump;
    private final DurationDataModel<CaptureDurationData<? extends CaptureObject>> model;
    private final Range viewRange;
    @Deprecated
    public static final double labelXPadding = 4.0;
    @Deprecated
    public static final double labelYPadding = 4.0;
    @Deprecated
    private static final JBColor labelBgColor;
    @Deprecated
    private static final JBColor labelColor;
    @NotNull
    private static final Companion Companion;

    public final boolean isMouseOverHeapDump() {
        return this.isMouseOverHeapDump;
    }

    private final void setMouseOverHeapDump(boolean mouseOverHeapDump) {
        this.isMouseOverHeapDump = mouseOverHeapDump;
        Iterable $this$forEach$iv = this.heapDumpHoveredListener;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Consumer it = (Consumer)element$iv;
            boolean bl = false;
            it.accept(mouseOverHeapDump);
        }
    }

    public final void addHeapDumpHoverListener(@NotNull Consumer<Boolean> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        listener2.accept(this.isMouseOverHeapDump);
        this.heapDumpHoveredListener.add(listener2);
    }

    /*
     * WARNING - void declaration
     */
    public void renderLines(@NotNull LineChart lineChart, @NotNull Graphics2D g2d, @NotNull List<Path2D> transformedPaths, @NotNull List<RangedContinuousSeries> transformedSeries) {
        Shape origClip;
        Intrinsics.checkNotNullParameter((Object)lineChart, (String)"lineChart");
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
        Intrinsics.checkNotNullParameter(transformedPaths, (String)"transformedPaths");
        Intrinsics.checkNotNullParameter(transformedSeries, (String)"transformedSeries");
        Shape shape = origClip = g2d.getClip();
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"origClip");
        double origX = shape.getBounds().x;
        int origY = origClip.getBounds().y;
        int origWidth = origClip.getBounds().width;
        int origHeight = origClip.getBounds().height;
        Dimension dim = lineChart.getSize();
        int dimWidth = dim.width;
        int dimHeight = dim.height;
        double height = Math.min(origHeight, dimHeight);
        Rectangle2D.Float clipRect = new Rectangle2D.Float();
        int n = 0;
        int n2 = this.startsCache.size();
        while (n < n2) {
            void i;
            double xStart = this.startsCache.get((int)i);
            double xLen = this.durationsCache.get((int)i);
            double scaledXStart = xStart * (double)dimWidth;
            double scaledDuration = xLen * (double)dimWidth;
            double newX = Math.max(scaledXStart, origX);
            clipRect.setRect(newX, (double)origY, Math.min(scaledDuration + scaledXStart - newX, origX + (double)origWidth - newX), height);
            Object object = g2d;
            Graphics2D $this$apply = object;
            boolean bl = false;
            $this$apply.setColor(ProfilerColors.MEMORY_HEAP_DUMP_BG);
            $this$apply.setClip(clipRect);
            $this$apply.fill(clipRect);
            int left = (int)clipRect.x;
            int right = (int)(clipRect.x + clipRect.width);
            int height2 = (int)clipRect.height;
            int top = (int)clipRect.y;
            int bottom = (int)clipRect.y + height2;
            int midY = top + height2 / 2;
            $this$apply.setColor(scaledXStart < (double)this.mousePosition.x && (double)this.mousePosition.x < scaledXStart + scaledDuration ? (Color)StudioColorsKt.getSelectionOverlayBackground() : (Color)StudioColorsKt.getPrimaryContentBackground());
            $this$apply.fill(clipRect);
            $this$apply.setColor(StudioColorsKt.getLinkForeground());
            $this$apply.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{8.0f, 8.0f}, 0.0f));
            $this$apply.drawLine(left, midY, right, midY);
            $this$apply.setStroke(new BasicStroke(4.0f));
            $this$apply.drawLine(left, top, left, bottom);
            $this$apply.drawLine(right, top, right, bottom);
            object = this.labelCache.get((int)i);
            JLabel label = (JLabel)object;
            boolean bl2 = false;
            g2d.setColor((Color)labelBgColor);
            g2d.fillRect((int)clipRect.x, (int)((double)clipRect.height - 8.0 - (double)label.getHeight()), (int)((double)label.getWidth() + 8.0), (int)((double)label.getHeight() + 8.0));
            double labelXOffset = scaledXStart + 4.0;
            double labelYOffset = (double)(clipRect.height - (float)label.getHeight()) - 4.0;
            g2d.translate(labelXOffset, labelYOffset);
            label.paint(g2d);
            g2d.translate(-labelXOffset, -labelYOffset);
            ++i;
        }
        g2d.setClip(origClip);
    }

    public void renderOverlay(@NotNull Component host, @NotNull Graphics2D g2d) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
    }

    /*
     * WARNING - void declaration
     */
    public boolean handleMouseEvent(@NotNull Component overlayComponent, @NotNull Component selectionComponent, @NotNull MouseEvent event) {
        boolean bl;
        HeapDumpRenderer heapDumpRenderer;
        boolean bl2;
        block3: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)overlayComponent, (String)"overlayComponent");
            Intrinsics.checkNotNullParameter((Object)selectionComponent, (String)"selectionComponent");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            boolean it = bl2 = false;
            boolean bl3 = false;
            Point point = event.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"event.point");
            this.mousePosition = point;
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this.startsCache.size());
            heapDumpRenderer = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl4 = false;
                    double xStart = this.startsCache.get(i);
                    double xLen = this.durationsCache.get(i);
                    double scaledStartX = xStart * (double)overlayComponent.getWidth();
                    double scaledDur = xLen * (double)overlayComponent.getWidth();
                    if (!(scaledStartX < (double)this.mousePosition.x && (double)this.mousePosition.x < scaledStartX + scaledDur && overlayComponent.getY() < this.mousePosition.y && this.mousePosition.y < overlayComponent.getY() + overlayComponent.getHeight())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean bl5 = bl;
        heapDumpRenderer.setMouseOverHeapDump(bl5);
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    private final void modelChanged() {
        this.startsCache.clear();
        this.durationsCache.clear();
        this.labelCache.clear();
        RangedSeries rangedSeries = this.model.getSeries();
        Intrinsics.checkNotNullExpressionValue((Object)rangedSeries, (String)"model.series");
        RangedSeries series = rangedSeries;
        double xMin = series.getXRange().getMin();
        double xLen = series.getXRange().getLength();
        for (SeriesData data : series.getSeries()) {
            void $this$apply;
            JLabel jLabel;
            String string;
            this.startsCache.add(((double)data.x - xMin) / xLen);
            Object object = data.value;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"data.value");
            this.durationsCache.add((double)((CaptureDurationData)((Object)object)).getDurationUs() / xLen);
            Object object2 = data.value;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"data.value");
            if (((CaptureDurationData)((Object)object2)).getDurationUs() == Long.MAX_VALUE) {
                string = "in progress";
            } else {
                double d = this.viewRange.getLength();
                Object object3 = data.value;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"data.value");
                String string2 = TimeAxisFormatter.DEFAULT.getFormattedString(d, (double)((CaptureDurationData)((Object)object3)).getDurationUs(), true);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TimeAxisFormatter.DEFAUL\u2026ationUs.toDouble(), true)");
            }
            String text = string;
            JLabel jLabel2 = jLabel = new JLabel("Dump (" + text + ")");
            List<JLabel> list = this.labelCache;
            boolean bl = false;
            $this$apply.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(9.0f));
            $this$apply.setForeground((Color)labelColor);
            $this$apply.setBackground((Color)JBColor.DARK_GRAY);
            Dimension size = $this$apply.getPreferredSize();
            $this$apply.setBounds(0, 0, size.width, size.height);
            Unit unit = Unit.INSTANCE;
            list.add(jLabel);
        }
    }

    public HeapDumpRenderer(@NotNull DurationDataModel<CaptureDurationData<? extends CaptureObject>> model, @NotNull Range viewRange) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)viewRange, (String)"viewRange");
        this.model = model;
        this.viewRange = viewRange;
        this.startsCache = new TDoubleArrayList();
        this.durationsCache = new TDoubleArrayList();
        this.labelCache = new ArrayList();
        this.mousePosition = new Point();
        this.heapDumpHoveredListener = new ArrayList();
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((HeapDumpRenderer)((Object)this.receiver)).modelChanged();
            }
        };
        this.model.addDependency((AspectObserver)this).onChange((Enum)DurationDataModel.Aspect.DURATION_DATA, new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        });
    }

    static {
        Companion = new Companion(null);
        labelBgColor = JBColor.DARK_GRAY;
        labelColor = JBColor.WHITE;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/profilers/memory/HeapDumpRenderer$Companion;", "", "()V", "labelBgColor", "Lcom/intellij/ui/JBColor;", "kotlin.jvm.PlatformType", "getLabelBgColor", "()Lcom/intellij/ui/JBColor;", "labelColor", "getLabelColor", "labelXPadding", "", "labelYPadding", "intellij.android.profilers.ui"})
    private static final class Companion {
        public final JBColor getLabelBgColor() {
            return labelBgColor;
        }

        public final JBColor getLabelColor() {
            return labelColor;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

