/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.MemoryStageLegends;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/profilers/memory/FlexibleLegendPanel;", "Lcom/intellij/ui/components/JBPanel;", "stage", "Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;", "lineChart", "Lcom/android/tools/adtui/chart/linechart/LineChart;", "(Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;Lcom/android/tools/adtui/chart/linechart/LineChart;)V", "compactLegend", "Lcom/android/tools/adtui/LegendComponent;", "fullLegend", "adapt", "", "width", "", "Companion", "intellij.android.profilers.ui"})
final class FlexibleLegendPanel
extends JBPanel<FlexibleLegendPanel> {
    private final LegendComponent fullLegend;
    private final LegendComponent compactLegend;
    @NotNull
    private static final Companion Companion = new Companion(null);

    public final void adapt(int width) {
        this.remove((Component)this.fullLegend);
        this.remove((Component)this.compactLegend);
        this.add((Component)(this.fullLegend.getPreferredSize().width + 60 < width ? this.fullLegend : this.compactLegend), "East");
    }

    public FlexibleLegendPanel(@NotNull BaseStreamingMemoryProfilerStage stage, @NotNull LineChart lineChart) {
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)lineChart, (String)"lineChart");
        super((LayoutManager)new BorderLayout());
        this.fullLegend = FlexibleLegendPanel.Companion.makeLegendComponent(stage, lineChart, true);
        this.compactLegend = FlexibleLegendPanel.Companion.makeLegendComponent(stage, lineChart, false);
        JLabel $this$apply = jLabel = new JLabel("MEMORY");
        boolean bl = false;
        $this$apply.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        $this$apply.setVerticalAlignment(1);
        JLabel label = jLabel;
        this.setOpaque(false);
        this.add(label, "West");
        this.add((Component)this.fullLegend, "East");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/profilers/memory/FlexibleLegendPanel$Companion;", "", "()V", "makeLegendComponent", "Lcom/android/tools/adtui/LegendComponent;", "stage", "Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;", "lineChart", "Lcom/android/tools/adtui/chart/linechart/LineChart;", "full", "", "intellij.android.profilers.ui"})
    private static final class Companion {
        private final LegendComponent makeLegendComponent(BaseStreamingMemoryProfilerStage stage, LineChart lineChart, boolean full) {
            LegendComponent legendComponent;
            String[] stringArray;
            MemoryStageLegends legends = stage.getLegends();
            DetailedMemoryUsage memoryUsage = stage.getDetailedMemoryUsage();
            LegendComponent.Builder builder = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).setShowValues(full);
            if (full) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "Total";
            }
            LegendComponent legendComponent2 = builder.setExcludedLegends(Arrays.copyOf(stringArray, stringArray.length)).build();
            Intrinsics.checkNotNullExpressionValue((Object)legendComponent2, (String)"LegendComponent.Builder(\u2026otal\")))\n        .build()");
            LegendComponent $this$apply = legendComponent = legendComponent2;
            boolean bl = false;
            $this$apply.configure((Legend)legends.getJavaLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getJavaSeries())));
            $this$apply.configure((Legend)legends.getNativeLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getNativeSeries())));
            $this$apply.configure((Legend)legends.getGraphicsLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getGraphicsSeries())));
            $this$apply.configure((Legend)legends.getStackLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getStackSeries())));
            $this$apply.configure((Legend)legends.getCodeLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getCodeSeries())));
            $this$apply.configure((Legend)legends.getOtherLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getOtherSeries())));
            $this$apply.configure((Legend)legends.getTotalLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getTotalMemorySeries())));
            $this$apply.configure((Legend)legends.getObjectsLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getObjectsSeries())));
            return legendComponent;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

