/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.BaseMemoryProfilerStage;
import com.android.tools.profilers.memory.BaseMemoryProfilerStageKt;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureObjectLoader;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001e\u0018\u00010\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0004J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lcom/android/tools/profilers/memory/BaseMemoryProfilerStage;", "Lcom/android/tools/profilers/StreamingStage;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "loader", "Lcom/android/tools/profilers/memory/CaptureObjectLoader;", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profilers/memory/CaptureObjectLoader;)V", "captureSelection", "Lcom/android/tools/profilers/memory/MemoryCaptureSelection;", "getCaptureSelection", "()Lcom/android/tools/profilers/memory/MemoryCaptureSelection;", "isPendingCapture", "", "()Z", "getLoader", "()Lcom/android/tools/profilers/memory/CaptureObjectLoader;", "pendingCaptureStartTime", "", "getPendingCaptureStartTime", "()J", "setPendingCaptureStartTime", "(J)V", "updateCaptureOnSelection", "getUpdateCaptureOnSelection", "setUpdateCaptureOnSelection", "(Z)V", "doSelectCaptureDuration", "", "durationData", "Lcom/android/tools/profilers/memory/CaptureDurationData;", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "joiner", "Ljava/util/concurrent/Executor;", "getStageType", "Lcom/google/wireless/android/sdk/stats/AndroidProfilerEvent$Stage;", "Companion", "intellij.android.profilers"})
public abstract class BaseMemoryProfilerStage
extends StreamingStage {
    @NotNull
    private final MemoryCaptureSelection captureSelection;
    private long pendingCaptureStartTime;
    private boolean updateCaptureOnSelection;
    @NotNull
    private final CaptureObjectLoader loader;
    public static final long INVALID_START_TIME = -1L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final MemoryCaptureSelection getCaptureSelection() {
        return this.captureSelection;
    }

    protected final long getPendingCaptureStartTime() {
        return this.pendingCaptureStartTime;
    }

    protected final void setPendingCaptureStartTime(long l) {
        this.pendingCaptureStartTime = l;
    }

    protected final boolean getUpdateCaptureOnSelection() {
        return this.updateCaptureOnSelection;
    }

    protected final void setUpdateCaptureOnSelection(boolean bl) {
        this.updateCaptureOnSelection = bl;
    }

    public final boolean isPendingCapture() {
        return this.pendingCaptureStartTime != -1L;
    }

    @Override
    @NotNull
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.MEMORY_STAGE;
    }

    protected final void doSelectCaptureDuration(@Nullable CaptureDurationData<? extends CaptureObject> durationData, @Nullable Executor joiner) {
        this.pendingCaptureStartTime = -1L;
        CaptureDurationData<? extends CaptureObject> captureDurationData = durationData;
        if (!this.captureSelection.selectCaptureEntry(captureDurationData != null ? captureDurationData.getCaptureEntry() : null)) {
            return;
        }
        this.updateCaptureOnSelection = false;
        CaptureObject captureObject = this.captureSelection.getSelectedCapture();
        Runnable clear2 = new Runnable(this){
            final /* synthetic */ BaseMemoryProfilerStage this$0;

            public final void run() {
                this.this$0.getCaptureSelection().selectCaptureEntry(null);
                StreamingTimeline streamingTimeline = this.this$0.getTimeline();
                Intrinsics.checkNotNullExpressionValue((Object)streamingTimeline, (String)"timeline");
                streamingTimeline.getSelectionRange().clear();
                this.this$0.getCaptureSelection().getAspect().changed((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE);
                BaseMemoryProfilerStage.access$setProfilerMode(this.this$0, ProfilerMode.NORMAL);
            }
            {
                this.this$0 = baseMemoryProfilerStage;
            }
        };
        if (captureObject == null) {
            clear2.run();
            return;
        }
        this.captureSelection.getClassGroupingModel().update();
        if (durationData != null && durationData.getDurationUs() != Long.MAX_VALUE) {
            StreamingTimeline streamingTimeline = this.getTimeline();
            Intrinsics.checkNotNullExpressionValue((Object)streamingTimeline, (String)"timeline");
            streamingTimeline.getSelectionRange().clear();
            double startTimeUs = TimeUnit.NANOSECONDS.toMicros(captureObject.getStartTimeNs());
            double endTimeUs = TimeUnit.NANOSECONDS.toMicros(captureObject.getEndTimeNs());
            StreamingTimeline streamingTimeline2 = this.getTimeline();
            Intrinsics.checkNotNullExpressionValue((Object)streamingTimeline2, (String)"timeline");
            streamingTimeline2.getSelectionRange().set(startTimeUs, endTimeUs);
        }
        this.updateCaptureOnSelection = true;
        StreamingTimeline streamingTimeline = this.getTimeline();
        Intrinsics.checkNotNullExpressionValue((Object)streamingTimeline, (String)"timeline");
        Range range = streamingTimeline.getSelectionRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"timeline.selectionRange");
        Range queryRange = range;
        Runnable load2 = new Runnable(this, captureObject, queryRange, joiner){
            final /* synthetic */ BaseMemoryProfilerStage this$0;
            final /* synthetic */ CaptureObject $captureObject;
            final /* synthetic */ Range $queryRange;
            final /* synthetic */ Executor $joiner;

            public final void run() {
                ListenableFuture<CaptureObject> listenableFuture = this.this$0.getLoader().loadCapture(this.$captureObject, this.$queryRange, this.$joiner);
                Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"loader.loadCapture(captu\u2026ject, queryRange, joiner)");
                ListenableFuture<CaptureObject> future = listenableFuture;
                Runnable runnable = new Runnable(this, future){
                    final /* synthetic */ doSelectCaptureDuration.load.1 this$0;
                    final /* synthetic */ ListenableFuture $future;

                    public final void run() {
                        try {
                            CaptureObject loadedCaptureObject = (CaptureObject)this.$future.get();
                            if (this.this$0.this$0.getCaptureSelection().finishSelectingCaptureObject(loadedCaptureObject)) {
                                MemoryCaptureSelection memoryCaptureSelection = this.this$0.this$0.getCaptureSelection();
                                CaptureObject captureObject = loadedCaptureObject;
                                Intrinsics.checkNotNullExpressionValue((Object)captureObject, (String)"loadedCaptureObject");
                                Collection<HeapSet> collection = captureObject.getHeapSets();
                                Intrinsics.checkNotNullExpressionValue(collection, (String)"(loadedCaptureObject.heapSets)");
                                memoryCaptureSelection.selectHeapSet(BaseMemoryProfilerStageKt.access$getDefault(collection));
                            } else {
                                this.this$0.this$0.doSelectCaptureDuration(null, null);
                            }
                            this.this$0.this$0.getCaptureSelection().refreshSelectedHeap();
                        }
                        catch (InterruptedException exception) {
                            Thread.currentThread().interrupt();
                            this.this$0.this$0.doSelectCaptureDuration(null, null);
                        }
                        catch (ExecutionException exception) {
                            this.this$0.this$0.doSelectCaptureDuration(null, null);
                            com.android.tools.profilers.memory.BaseMemoryProfilerStage$Companion.access$getLogger$p(BaseMemoryProfilerStage.Companion).error((Throwable)exception);
                        }
                        catch (CancellationException cancellationException) {
                            // empty catch block
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$future = listenableFuture;
                    }
                };
                Executor executor = this.$joiner;
                if (executor == null) {
                    executor = MoreExecutors.directExecutor();
                }
                future.addListener(runnable, executor);
                BaseMemoryProfilerStage.access$setProfilerMode(this.this$0, ProfilerMode.EXPANDED);
            }
            {
                this.this$0 = baseMemoryProfilerStage;
                this.$captureObject = captureObject;
                this.$queryRange = range;
                this.$joiner = executor;
            }
        };
        Function0 function0 = (Function0)new Function0<Boolean>(captureObject){

            public final boolean invoke() {
                return ((CaptureObject)this.receiver).canSafelyLoad();
            }
        };
        Supplier supplier = new Supplier(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ Object get() {
                return this.function.invoke();
            }
        };
        StudioProfilers studioProfilers = this.getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"studioProfilers");
        IdeProfilerServices ideProfilerServices = studioProfilers.getIdeServices();
        Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices, (String)"studioProfilers.ideServices");
        CompletableFuture.supplyAsync(supplier, ideProfilerServices.getPoolExecutor()).whenComplete(new BiConsumer(this, load2, clear2){
            final /* synthetic */ BaseMemoryProfilerStage this$0;
            final /* synthetic */ Runnable $load;
            final /* synthetic */ Runnable $clear;

            public final void accept(Boolean canSafelyLoad, Throwable $noName_1) {
                Boolean bl = canSafelyLoad;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"canSafelyLoad");
                if (bl.booleanValue()) {
                    this.$load.run();
                } else {
                    ApplicationManager.getApplication().invokeAndWait(new Runnable(this){
                        final /* synthetic */ doSelectCaptureDuration.2 this$0;

                        public final void run() {
                            StudioProfilers studioProfilers = this.this$0.this$0.getStudioProfilers();
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"studioProfilers");
                            studioProfilers.getIdeServices().openYesNoDialog("The hprof file is large, and " + ApplicationNamesInfo.getInstance().getFullProductName() + " may become unresponsive while it parses the data and afterwards. Do you want to continue?", "Heap Dump File Too Large", this.this$0.$load, this.this$0.$clear);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = baseMemoryProfilerStage;
                this.$load = runnable;
                this.$clear = runnable2;
            }
        });
    }

    @NotNull
    protected final CaptureObjectLoader getLoader() {
        return this.loader;
    }

    public BaseMemoryProfilerStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        super(profilers);
        this.loader = loader;
        IdeProfilerServices ideProfilerServices = profilers.getIdeServices();
        Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices, (String)"profilers.ideServices");
        this.captureSelection = new MemoryCaptureSelection(ideProfilerServices);
        this.pendingCaptureStartTime = -1L;
        this.updateCaptureOnSelection = true;
    }

    public static final /* synthetic */ void access$setProfilerMode(BaseMemoryProfilerStage $this, ProfilerMode profilerMode) {
        $this.setProfilerMode(profilerMode);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/profilers/memory/BaseMemoryProfilerStage$Companion;", "", "()V", "INVALID_START_TIME", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.android.profilers"})
    public static final class Companion {
        private final Logger getLogger() {
            Logger logger = Logger.getInstance(BaseMemoryProfilerStage.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(BaseM\u2026rofilerStage::class.java)");
            return logger;
        }

        private Companion() {
        }

        public static final /* synthetic */ Logger access$getLogger$p(Companion $this) {
            return $this.getLogger();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

