/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.AllocationDurationData;
import com.android.tools.profilers.memory.AllocationSamplingRateDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.AllocationSessionArtifactKt;
import com.android.tools.profilers.memory.AllocationStage;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.sessions.SessionArtifact;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/android/tools/profilers/memory/AllocationSessionArtifact;", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "Lcom/android/tools/profiler/proto/Memory$AllocationsInfo;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "sessionMetadata", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "info", "startUs", "", "endUs", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profiler/proto/Common$Session;Lcom/android/tools/profiler/proto/Common$SessionMetaData;Lcom/android/tools/profiler/proto/Memory$AllocationsInfo;DD)V", "getEndUs", "()D", "getStartUs", "subtitle", "", "getSubtitle", "()Ljava/lang/String;", "canExport", "", "getArtifactProto", "getName", "getProfilers", "getSession", "getSessionMetaData", "getTimestampNs", "", "isOngoing", "onSelect", "", "Companion", "intellij.android.profilers"})
public final class AllocationSessionArtifact
implements SessionArtifact<Memory.AllocationsInfo> {
    private final StudioProfilers profilers;
    private final Common.Session session;
    private final Common.SessionMetaData sessionMetadata;
    private final Memory.AllocationsInfo info;
    private final double startUs;
    private final double endUs;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getSubtitle() {
        String string = TimeFormatter.getFullClockString((long)AllocationSessionArtifactKt.access$nanosToMicros(this.getTimestampNs()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TimeFormatter.getFullClo\u2026estampNs.nanosToMicros())");
        return string;
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        return this.profilers;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public Memory.AllocationsInfo getArtifactProto() {
        return this.info;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        return this.sessionMetadata;
    }

    @Override
    @NotNull
    public String getName() {
        return "Allocation Records";
    }

    @Override
    public long getTimestampNs() {
        return TimeUnit.MICROSECONDS.toNanos((long)this.startUs) - this.session.getStartTimestamp();
    }

    @Override
    public boolean isOngoing() {
        return false;
    }

    @Override
    public void onSelect() {
        if (this.session != this.profilers.getSession()) {
            this.profilers.getSessionsManager().setSession(this.session);
        }
        this.profilers.setStage(AllocationStage.Companion.makeStaticStage$default(AllocationStage.Companion, this.profilers, null, this.startUs, this.endUs, 2, null));
    }

    @Override
    public boolean canExport() {
        return false;
    }

    public final double getStartUs() {
        return this.startUs;
    }

    public final double getEndUs() {
        return this.endUs;
    }

    public AllocationSessionArtifact(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetadata, @NotNull Memory.AllocationsInfo info, double startUs, double endUs) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)sessionMetadata, (String)"sessionMetadata");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.profilers = profilers;
        this.session = session;
        this.sessionMetadata = sessionMetadata;
        this.info = info;
        this.startUs = startUs;
        this.endUs = endUs;
    }

    @JvmStatic
    @NotNull
    public static final List<SessionArtifact<?>> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetadata) {
        return Companion.getSessionArtifacts(profilers, session, sessionMetadata);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/android/tools/profilers/memory/AllocationSessionArtifact$Companion;", "", "()V", "getSessionArtifacts", "", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "sessionMetadata", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "intellij.android.profilers"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<SessionArtifact<?>> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetadata) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)sessionMetadata, (String)"sessionMetadata");
            Range rangeUs = new Range((double)AllocationSessionArtifactKt.access$nanosToMicros(session.getStartTimestamp()), (double)AllocationSessionArtifactKt.access$nanosToMicros(session.getEndTimestamp()));
            ProfilerClient profilerClient = profilers.getClient();
            IdeProfilerServices ideProfilerServices = profilers.getIdeServices();
            Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices, (String)"profilers.ideServices");
            FeatureConfig featureConfig = ideProfilerServices.getFeatureConfig();
            Intrinsics.checkNotNullExpressionValue((Object)featureConfig, (String)"profilers.ideServices.featureConfig");
            AllocationSamplingRateDataSeries samplingSeries = new AllocationSamplingRateDataSeries(profilerClient, session, featureConfig.isUnifiedPipelineEnabled());
            List<SeriesData<AllocationSamplingRateDurationData>> list = samplingSeries.getDataForRange(rangeUs);
            Intrinsics.checkNotNullExpressionValue(list, (String)"samplingSeries.getDataForRange(rangeUs)");
            Iterable $this$mapNotNull$iv = AllocationDurationData.Companion.consecutiveAllocRanges$intellij_android_profilers(list);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AllocationSessionArtifact allocationSessionArtifact;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Range r = (Range)element$iv$iv;
                boolean bl2 = false;
                ProfilerClient profilerClient2 = profilers.getClient();
                Intrinsics.checkNotNullExpressionValue((Object)profilerClient2, (String)"profilers.client");
                IdeProfilerServices ideProfilerServices2 = profilers.getIdeServices();
                Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices2, (String)"profilers.ideServices");
                List<Memory.AllocationsInfo> infos = MemoryProfiler.Companion.getAllocationInfosForSession(profilerClient2, session, r, ideProfilerServices2);
                AllocationSessionArtifact allocationSessionArtifact2 = infos.isEmpty() ? null : new AllocationSessionArtifact(profilers, session, sessionMetadata, infos.get(0), r.getMin(), r.getMax());
                if (allocationSessionArtifact2 == null) continue;
                AllocationSessionArtifact it$iv$iv = allocationSessionArtifact = allocationSessionArtifact2;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

