/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.KeyboardAction;
import com.android.tools.adtui.model.event.KeyboardData;
import com.android.tools.adtui.model.event.UserEvent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.StudioProfilers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class UserEventDataSeries
implements DataSeries<EventAction<UserEvent>> {
    @NotNull
    private StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;

    public UserEventDataSeries(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            UserEventDataSeries.$$$reportNull$$$0(0);
        }
        this.myProfilers = profilers;
        this.mySession = profilers.getSession();
    }

    public List<SeriesData<EventAction<UserEvent>>> getDataForRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            UserEventDataSeries.$$$reportNull$$$0(1);
        }
        if (this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            return this.getTransportData(timeCurrentRangeUs);
        }
        return this.getLegacyData(timeCurrentRangeUs);
    }

    @NotNull
    private List<SeriesData<EventAction<UserEvent>>> getTransportData(@NotNull Range rangeUs) {
        if (rangeUs == null) {
            UserEventDataSeries.$$$reportNull$$$0(2);
        }
        ArrayList<SeriesData<EventAction<UserEvent>>> series = new ArrayList<SeriesData<EventAction<UserEvent>>>();
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setKind(Common.Event.Kind.INTERACTION).setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax())).build();
        Transport.GetEventGroupsResponse response = this.myProfilers.getClient().getTransportClient().getEventGroups(request);
        for (Transport.EventGroup group : response.getGroupsList()) {
            Common.Event startEvent = group.getEvents(0);
            long actionStart = TimeUnit.NANOSECONDS.toMicros(startEvent.getTimestamp());
            switch (startEvent.getInteraction().getType()) {
                case ROTATION: {
                    series.add((SeriesData<EventAction<UserEvent>>)new SeriesData(actionStart, (Object)new EventAction(actionStart, actionStart, (Object)UserEvent.ROTATION)));
                    break;
                }
                case KEY: {
                    series.add((SeriesData<EventAction<UserEvent>>)new SeriesData(actionStart, (Object)new KeyboardAction(actionStart, actionStart, new KeyboardData(startEvent.getInteraction().getEventData()))));
                    break;
                }
                case TOUCH: {
                    long actionEnd = group.getEventsCount() == 1 ? (long)rangeUs.getMax() : TimeUnit.NANOSECONDS.toMicros(group.getEvents(group.getEventsCount() - 1).getTimestamp());
                    series.add((SeriesData<EventAction<UserEvent>>)new SeriesData(actionStart, (Object)new EventAction(actionStart, actionEnd, (Object)UserEvent.TOUCH)));
                    break;
                }
            }
        }
        series.sort(Comparator.comparingLong(data -> data.x));
        ArrayList<SeriesData<EventAction<UserEvent>>> arrayList = series;
        if (arrayList == null) {
            UserEventDataSeries.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private List<SeriesData<EventAction<UserEvent>>> getLegacyData(@NotNull Range rangeUs) {
        if (rangeUs == null) {
            UserEventDataSeries.$$$reportNull$$$0(4);
        }
        ArrayList<SeriesData<EventAction<UserEvent>>> seriesData = new ArrayList<SeriesData<EventAction<UserEvent>>>();
        EventServiceGrpc.EventServiceBlockingStub eventService = this.myProfilers.getClient().getEventClient();
        EventProfiler.EventDataRequest.Builder dataRequestBuilder = EventProfiler.EventDataRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax()));
        EventProfiler.SystemDataResponse response = eventService.getSystemData(dataRequestBuilder.build());
        for (EventProfiler.SystemData data : response.getDataList()) {
            long actionStart = TimeUnit.NANOSECONDS.toMicros(data.getStartTimestamp());
            long actionEnd = TimeUnit.NANOSECONDS.toMicros(data.getEndTimestamp());
            switch (data.getType()) {
                case ROTATION: {
                    seriesData.add((SeriesData<EventAction<UserEvent>>)new SeriesData(actionStart, (Object)new EventAction(actionStart, actionEnd, (Object)UserEvent.ROTATION)));
                    break;
                }
                case UNSPECIFIED: {
                    break;
                }
                case TOUCH: {
                    seriesData.add((SeriesData<EventAction<UserEvent>>)new SeriesData(actionStart, (Object)new EventAction(actionStart, actionEnd, (Object)UserEvent.TOUCH)));
                    break;
                }
                case KEY: {
                    seriesData.add((SeriesData<EventAction<UserEvent>>)new SeriesData(actionStart, (Object)new KeyboardAction(actionStart, actionEnd, new KeyboardData(data.getEventData()))));
                    break;
                }
            }
        }
        ArrayList<SeriesData<EventAction<UserEvent>>> arrayList = seriesData;
        if (arrayList == null) {
            UserEventDataSeries.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeUs";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/event/UserEventDataSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/event/UserEventDataSeries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransportData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDataForRange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTransportData";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

