/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.profiler.proto.Energy;
import com.android.tools.profilers.energy.EnergyDuration;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

final class UiHtmlText {
    @NotNull
    private final StringBuilder myStringBuilder = new StringBuilder();

    public UiHtmlText() {
        this.myStringBuilder.append("<html>");
    }

    public void appendTitle(@NotNull String title) {
        if (title == null) {
            UiHtmlText.$$$reportNull$$$0(0);
        }
        this.myStringBuilder.append("<p><b>").append(title).append("</b></p>");
    }

    public void appendTitleAndValues(@NotNull String title, @NotNull Iterable<String> values) {
        if (title == null) {
            UiHtmlText.$$$reportNull$$$0(1);
        }
        if (values == null) {
            UiHtmlText.$$$reportNull$$$0(2);
        }
        this.appendTitleAndValue(title, StringUtil.join(values, (String)", "));
    }

    public void appendTitleAndValue(@NotNull String title, @NotNull String value) {
        if (title == null) {
            UiHtmlText.$$$reportNull$$$0(3);
        }
        if (value == null) {
            UiHtmlText.$$$reportNull$$$0(4);
        }
        this.myStringBuilder.append("<p><b>").append(title).append("</b>:&nbsp;<span>");
        this.myStringBuilder.append(value).append("</span></p>");
    }

    public void appendValueWithIndentation(String value, int intendation) {
        this.myStringBuilder.append("<p>").append(StringUtil.repeat((String)"&nbsp;", (int)intendation)).append(value).append("</p>");
    }

    public void appendNewLine() {
        this.myStringBuilder.append("<br>");
    }

    @NotNull
    public String toString() {
        String string = this.myStringBuilder.append("</html>").toString();
        if (string == null) {
            UiHtmlText.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void renderAlarmSet(@NotNull Energy.AlarmSet alarmSet) {
        if (alarmSet == null) {
            UiHtmlText.$$$reportNull$$$0(6);
        }
        this.appendTitleAndValue("Type", EnergyDuration.getAlarmTypeName(alarmSet.getType()));
        switch (alarmSet.getType()) {
            case RTC: 
            case RTC_WAKEUP: {
                this.appendTitleAndValue("Trigger Time", new Date(alarmSet.getTriggerMs()).toString());
                break;
            }
            case ELAPSED_REALTIME: 
            case ELAPSED_REALTIME_WAKEUP: {
                this.appendTitleAndValue("Trigger Time since boot", StringUtil.formatDuration((long)alarmSet.getTriggerMs()));
                break;
            }
        }
        if (alarmSet.getIntervalMs() > 0L) {
            this.appendTitleAndValue("Interval Time", StringUtil.formatDuration((long)alarmSet.getIntervalMs()));
        }
        if (alarmSet.getWindowMs() > 0L) {
            this.appendTitleAndValue("Window Time", StringUtil.formatDuration((long)alarmSet.getWindowMs()));
        }
        switch (alarmSet.getSetActionCase()) {
            case OPERATION: {
                this.renderPendingIntent(alarmSet.getOperation());
                break;
            }
            case LISTENER: {
                this.appendTitleAndValue("Listener tag", alarmSet.getListener().getTag());
                break;
            }
        }
    }

    private void renderPendingIntent(@NotNull Energy.PendingIntent operation) {
        if (operation == null) {
            UiHtmlText.$$$reportNull$$$0(7);
        }
        if (!operation.getCreatorPackage().isEmpty()) {
            String value = String.format("%s&nbsp;(UID:&nbsp;%d)", operation.getCreatorPackage(), operation.getCreatorUid());
            this.appendTitleAndValue("Creator", value);
        }
    }

    public void renderWakeLockAcquired(@NotNull Energy.WakeLockAcquired wakeLockAcquired) {
        if (wakeLockAcquired == null) {
            UiHtmlText.$$$reportNull$$$0(8);
        }
        this.appendTitleAndValue("Tag", wakeLockAcquired.getTag());
        this.appendTitleAndValue("Level", EnergyDuration.getWakeLockLevelName(wakeLockAcquired.getLevel()));
    }

    public void renderJobScheduled(@NotNull Energy.JobScheduled jobScheduled) {
        if (jobScheduled == null) {
            UiHtmlText.$$$reportNull$$$0(9);
        }
        this.appendTitleAndValue("Result", UiHtmlText.getJobResult(jobScheduled.getResult()));
        if (jobScheduled.hasJob()) {
            this.renderJobInfo(jobScheduled.getJob());
        }
    }

    @NotNull
    private static String getJobResult(@NotNull Energy.JobScheduled.Result result) {
        if (result == null) {
            UiHtmlText.$$$reportNull$$$0(10);
        }
        switch (result) {
            case RESULT_SUCCESS: {
                return "SUCCESS";
            }
            case RESULT_FAILURE: {
                return "FAILURE";
            }
        }
        return "N/A";
    }

    private void renderJobInfo(@NotNull Energy.JobInfo job) {
        if (job == null) {
            UiHtmlText.$$$reportNull$$$0(11);
        }
        this.appendTitleAndValue("Job ID", String.valueOf(job.getJobId()));
        this.appendTitleAndValue("Service", job.getServiceName());
        String backoffPolicy = UiHtmlText.getBackoffPolicyName(job.getBackoffPolicy());
        if (!backoffPolicy.isEmpty()) {
            this.appendTitleAndValue("Backoff Criteria", String.join((CharSequence)" ", StringUtil.formatDuration((long)job.getInitialBackoffMs()), backoffPolicy));
        }
        if (job.getIsPeriodic()) {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("%s interval", StringUtil.formatDuration((long)job.getIntervalMs())));
            if (job.getFlexMs() > 0L) {
                builder.append(String.format(", %s flex", StringUtil.formatDuration((long)job.getFlexMs())));
            }
            this.appendTitleAndValue("Periodic", builder.toString());
        } else {
            if (job.getMinLatencyMs() > 0L) {
                this.appendTitleAndValue("Minimum Latency", StringUtil.formatDuration((long)job.getMinLatencyMs()));
            }
            if (job.getMaxExecutionDelayMs() > 0L) {
                this.appendTitleAndValue("Override Deadline", StringUtil.formatDuration((long)job.getMaxExecutionDelayMs()));
            }
        }
        if (job.getIsPersisted()) {
            this.appendTitleAndValue("Is Persisted", String.valueOf(job.getIsPersisted()));
        }
        ArrayList<Object> requiredList = new ArrayList<Object>();
        String networkType = UiHtmlText.getRequiredNetworkType(job.getNetworkType());
        if (!networkType.isEmpty()) {
            requiredList.add("- Network Type: " + networkType);
        }
        if (job.getIsRequireBatteryNotLow()) {
            requiredList.add("- Battery Not Low");
        }
        if (job.getIsRequireCharging()) {
            requiredList.add("- Charging");
        }
        if (job.getIsRequireDeviceIdle()) {
            requiredList.add("- Device Idle");
        }
        if (job.getIsRequireStorageNotLow()) {
            requiredList.add("- Storage Not Low");
        }
        if (!requiredList.isEmpty()) {
            this.appendTitle("Requires:");
            requiredList.forEach(s -> this.appendValueWithIndentation((String)s, 5));
        }
        if (job.getTriggerContentUrisCount() != 0) {
            this.appendTitleAndValues("Trigger Content URIs", (Iterable<String>)job.getTriggerContentUrisList());
        }
        if (job.getTriggerContentMaxDelay() > 0L) {
            this.appendTitleAndValue("Trigger Content Max Delay", StringUtil.formatDuration((long)job.getTriggerContentMaxDelay()));
        }
        if (job.getTriggerContentUpdateDelay() > 0L) {
            this.appendTitleAndValue("Trigger Content Update Delay", StringUtil.formatDuration((long)job.getTriggerContentUpdateDelay()));
        }
    }

    @NotNull
    private static String getBackoffPolicyName(Energy.JobInfo.BackoffPolicy policy) {
        switch (policy) {
            case BACKOFF_POLICY_LINEAR: {
                return "Linear";
            }
            case BACKOFF_POLICY_EXPONENTIAL: {
                return "Exponential";
            }
        }
        return "";
    }

    @NotNull
    private static String getRequiredNetworkType(Energy.JobInfo.NetworkType networkType) {
        switch (networkType) {
            case NETWORK_TYPE_ANY: {
                return "Any";
            }
            case NETWORK_TYPE_METERED: {
                return "Metered";
            }
            case NETWORK_TYPE_UNMETERED: {
                return "Unmetered";
            }
            case NETWORK_TYPE_NOT_ROAMING: {
                return "Not Roaming";
            }
        }
        return "";
    }

    public void renderJobFinished(@NotNull Energy.JobFinished jobFinished) {
        if (jobFinished == null) {
            UiHtmlText.$$$reportNull$$$0(12);
        }
        this.appendTitleAndValue("Needs Reschedule", String.valueOf(jobFinished.getNeedsReschedule()));
        this.renderJobParams(jobFinished.getParams());
    }

    private void renderJobParams(@NotNull Energy.JobParameters jobParams) {
        if (jobParams == null) {
            UiHtmlText.$$$reportNull$$$0(13);
        }
        if (jobParams.getTriggeredContentAuthoritiesCount() != 0) {
            this.appendTitleAndValues("Triggered Content Authorities", (Iterable<String>)jobParams.getTriggeredContentAuthoritiesList());
        }
        if (jobParams.getTriggeredContentUrisCount() != 0) {
            this.appendTitleAndValues("Triggered Content URIs", (Iterable<String>)jobParams.getTriggeredContentUrisList());
        }
        if (jobParams.getIsOverrideDeadlineExpired()) {
            this.appendTitleAndValue("Is Override Deadline Expired", String.valueOf(jobParams.getIsOverrideDeadlineExpired()));
        }
    }

    public void renderLocationUpdateRequested(@NotNull Energy.LocationUpdateRequested locationRequested) {
        if (locationRequested == null) {
            UiHtmlText.$$$reportNull$$$0(14);
        }
        Energy.LocationRequest request = locationRequested.getRequest();
        this.appendTitleAndValue("Priority", UiHtmlText.getLocationPriority(request.getPriority()));
        if (request.getIntervalMs() > 0L) {
            this.appendTitleAndValue("Min Interval Time", StringUtil.formatDuration((long)request.getIntervalMs()));
        }
        if (request.getFastestIntervalMs() > 0L) {
            this.appendTitleAndValue("Fastest Interval Time", StringUtil.formatDuration((long)request.getFastestIntervalMs()));
        }
        if (!request.getProvider().isEmpty()) {
            this.appendTitleAndValue("Provider", request.getProvider());
        }
        if (request.getSmallestDisplacementMeters() > 0.0f) {
            this.appendTitleAndValue("Min Distance", request.getSmallestDisplacementMeters() + "m");
        }
        if (locationRequested.hasIntent()) {
            this.renderPendingIntent(locationRequested.getIntent());
        }
    }

    @NotNull
    private static String getLocationPriority(@NotNull Energy.LocationRequest.Priority priority) {
        if (priority == null) {
            UiHtmlText.$$$reportNull$$$0(15);
        }
        switch (priority) {
            case NO_POWER: {
                return "No Power";
            }
            case LOW_POWER: {
                return "Low Power";
            }
            case BALANCED: {
                return "Balanced";
            }
            case HIGH_ACCURACY: {
                return "High Accuracy";
            }
        }
        return "N/A";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/energy/UiHtmlText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alarmSet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wakeLockAcquired";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jobScheduled";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jobFinished";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jobParams";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationRequested";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/energy/UiHtmlText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendTitle";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendTitleAndValues";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendTitleAndValue";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderAlarmSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renderPendingIntent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renderWakeLockAcquired";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renderJobScheduled";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getJobResult";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "renderJobInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "renderJobFinished";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "renderJobParams";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "renderLocationUpdateRequested";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLocationPriority";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

