/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeSelectionComponent;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.RangeSelectionListener;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.stdui.StreamingScrollbar;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.appinspection.AppInspectionMigrationKt;
import com.android.tools.profilers.appinspection.AppInspectionMigrationServices;
import com.android.tools.profilers.energy.DetailedEnergyUsage;
import com.android.tools.profilers.energy.EnergyDetailsView;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyEventMinibar;
import com.android.tools.profilers.energy.EnergyEventOrigin;
import com.android.tools.profilers.energy.EnergyEventsView;
import com.android.tools.profilers.energy.EnergyMonitorView;
import com.android.tools.profilers.energy.EnergyProfilerAspect;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyStageTooltip;
import com.android.tools.profilers.energy.EnergyStageTooltipView;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.LifecycleTooltipView;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.event.UserEventTooltipView;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class EnergyProfilerStageView
extends StageView<EnergyProfilerStage> {
    private static final String BTI_INSPECTOR = "Background Task Inspector";
    @NotNull
    private final JPanel myEventsPanel;
    @NotNull
    private final EnergyDetailsView myDetailsView;

    public EnergyProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull EnergyProfilerStage energyProfilerStage) {
        if (profilersView == null) {
            EnergyProfilerStageView.$$$reportNull$$$0(0);
        }
        if (energyProfilerStage == null) {
            EnergyProfilerStageView.$$$reportNull$$$0(1);
        }
        super(profilersView, energyProfilerStage);
        this.getTooltipBinder().bind(EnergyStageTooltip.class, EnergyStageTooltipView::new);
        this.getTooltipBinder().bind(LifecycleTooltip.class, (stageView, tooltip2) -> new LifecycleTooltipView(stageView.getComponent(), (LifecycleTooltip)tooltip2));
        this.getTooltipBinder().bind(UserEventTooltip.class, (stageView, tooltip2) -> new UserEventTooltipView(stageView.getComponent(), (UserEventTooltip)tooltip2));
        JBSplitter verticalSplitter = new JBSplitter(true);
        verticalSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        verticalSplitter.setFirstComponent((JComponent)this.buildMonitorUi());
        this.myEventsPanel = new JPanel((LayoutManager)new TabularLayout("Fit-,Fit-,*,Fit-", "Fit-,*"));
        this.myEventsPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        JLabel showLabel = new JLabel("Show");
        showLabel.setBorder((Border)new JBEmptyBorder(0, 11, 0, 8));
        showLabel.setFont(ProfilerFonts.STANDARD_FONT);
        this.myEventsPanel.add((Component)showLabel, new TabularLayout.Constraint(0, 0));
        JComponent configurationComponent = this.getConfigurationComponent();
        configurationComponent.setFont(ProfilerFonts.STANDARD_FONT);
        this.myEventsPanel.add((Component)configurationComponent, new TabularLayout.Constraint(0, 1));
        JLabel selectionTimeLabel = this.getSelectionTimeLabel();
        selectionTimeLabel.setBorder((Border)new JBEmptyBorder(0, 0, 0, 8));
        this.myEventsPanel.add((Component)selectionTimeLabel, new TabularLayout.Constraint(0, 3));
        AppInspectionMigrationServices migrationServices = ((EnergyProfilerStage)((Object)this.getStage())).getStudioProfilers().getIdeServices().getAppInspectionMigrationServices();
        if (migrationServices.isSystemEventsMigrationDialogEnabled()) {
            JPanel migrationPanel = new JPanel(new BorderLayout());
            migrationPanel.setOpaque(true);
            migrationPanel.setBorder(ProfilerLayout.MONITOR_BORDER);
            migrationPanel.setMinimumSize(new Dimension(0, JBUIScale.scale((int)50)));
            migrationPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
            AppInspectionMigrationKt.addMigrationPanel(migrationPanel, "System Events has moved.", "system events", BTI_INSPECTOR, () -> migrationServices.openAppInspectionToolWindow(BTI_INSPECTOR), () -> {
                migrationServices.setSystemEventsMigrationDialogEnabled(false);
                this.myEventsPanel.setVisible(false);
            }, null);
            this.myEventsPanel.add((Component)migrationPanel, new TabularLayout.Constraint(1, 0, 1, 4));
        } else {
            JComponent eventsView = new EnergyEventsView(this).getComponent();
            this.myEventsPanel.add((Component)new JBScrollPane((Component)eventsView), new TabularLayout.Constraint(1, 0, 1, 4));
        }
        this.myEventsPanel.setVisible(false);
        verticalSplitter.setSecondComponent((JComponent)this.myEventsPanel);
        this.myDetailsView = new EnergyDetailsView(this);
        this.myDetailsView.setMinimumSize(new Dimension(JBUIScale.scale((int)450), (int)this.myDetailsView.getMinimumSize().getHeight()));
        this.myDetailsView.setVisible(false);
        JBSplitter splitter = new JBSplitter(false, 0.6f);
        splitter.setFirstComponent((JComponent)verticalSplitter);
        splitter.setSecondComponent((JComponent)this.myDetailsView);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.getDivider().setBorder(AdtUiUtils.DEFAULT_VERTICAL_BORDERS);
        this.getComponent().add((Component)splitter, "Center");
        if (!migrationServices.isMigrationEnabled()) {
            ((EnergyProfilerStage)((Object)this.getStage())).getAspect().addDependency((AspectObserver)this).onChange((Enum)EnergyProfilerAspect.SELECTED_EVENT_DURATION, this::updateSelectedDurationView);
        }
    }

    @NotNull
    private JPanel buildMonitorUi() {
        RangeTooltipComponent tooltip2;
        StudioProfilers profilers = ((EnergyProfilerStage)((Object)this.getStage())).getStudioProfilers();
        StreamingTimeline timeline = ((EnergyProfilerStage)((Object)this.getStage())).getTimeline();
        RangeSelectionComponent selection2 = null;
        final AppInspectionMigrationServices migrationServices = ((EnergyProfilerStage)((Object)this.getStage())).getStudioProfilers().getIdeServices().getAppInspectionMigrationServices();
        if (migrationServices.isMigrationEnabled() && !migrationServices.isSystemEventsMigrationDialogEnabled()) {
            tooltip2 = new RangeTooltipComponent((Timeline)((EnergyProfilerStage)((Object)this.getStage())).getTimeline(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), () -> true);
        } else {
            selection2 = new RangeSelectionComponent(((EnergyProfilerStage)((Object)this.getStage())).getRangeSelectionModel());
            selection2.setCursorSetter(AdtUiUtils::setTooltipCursor);
            selection2.addSelectionUpdatedListener(selectionRange -> {
                if (((EnergyProfilerStage)((Object)((Object)this.getStage()))).getSelectedDuration() != null) {
                    EnergyDuration selectedDuration = ((EnergyProfilerStage)((Object)((Object)this.getStage()))).getSelectedDuration();
                    long detailsStartUs = TimeUnit.NANOSECONDS.toMicros(((Common.Event)selectedDuration.getEventList().get(0)).getTimestamp());
                    long detailsEndUs = detailsStartUs;
                    if ((double)detailsEndUs < selectionRange.getMin()) {
                        selectedDuration = ((EnergyProfilerStage)((Object)((Object)this.getStage()))).updateDuration(selectedDuration);
                        Common.Event lastEvent = (Common.Event)selectedDuration.getEventList().get(selectedDuration.getEventList().size() - 1);
                        long l = detailsEndUs = lastEvent.getIsEnded() ? TimeUnit.NANOSECONDS.toMicros(lastEvent.getTimestamp()) : Long.MAX_VALUE;
                    }
                    if (selectionRange.getMax() < (double)detailsStartUs || selectionRange.getMin() > (double)detailsEndUs) {
                        ((EnergyProfilerStage)((Object)((Object)this.getStage()))).setSelectedDuration(null);
                    }
                }
            });
            tooltip2 = new RangeTooltipComponent((Timeline)((EnergyProfilerStage)((Object)this.getStage())).getTimeline(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), () -> ((RangeSelectionComponent)selection2).shouldShowSeekComponent());
        }
        TabularLayout layout = new TabularLayout("*");
        JBPanel panel = new JBPanel((LayoutManager)layout);
        panel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        panel.add((Component)tooltip2, new TabularLayout.Constraint(0, 0, 2, 1));
        StreamingScrollbar scrollbar = new StreamingScrollbar(timeline, (JComponent)panel);
        panel.add((Component)scrollbar, new TabularLayout.Constraint(4, 0));
        JComponent timeAxis = this.buildTimeAxis(profilers);
        panel.add((Component)timeAxis, new TabularLayout.Constraint(3, 0));
        EventMonitorView eventsView = new EventMonitorView(this.getProfilersView(), ((EnergyProfilerStage)((Object)this.getStage())).getEventMonitor());
        JComponent eventsComponent = eventsView.getComponent();
        panel.add((Component)eventsComponent, new TabularLayout.Constraint(0, 0));
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(ProfilerLayout.MONITOR_BORDER);
        JLabel label = new JLabel(((EnergyProfilerStage)((Object)this.getStage())).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        lineChartPanel.setBorder(BorderFactory.createEmptyBorder(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0));
        DetailedEnergyUsage usage = ((EnergyProfilerStage)((Object)this.getStage())).getDetailedUsage();
        LineChart lineChart = new LineChart((LineChartModel)usage);
        LineConfig cpuConfig = new LineConfig(ProfilerColors.ENERGY_CPU).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX).setDataBucketInterval(EnergyMonitorView.CHART_INTERVAL_US);
        lineChart.configure(usage.getCpuUsageSeries(), cpuConfig);
        LineConfig networkConfig = new LineConfig(ProfilerColors.ENERGY_NETWORK).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX).setDataBucketInterval(EnergyMonitorView.CHART_INTERVAL_US);
        lineChart.configure(usage.getNetworkUsageSeries(), networkConfig);
        LineConfig locationConfig = new LineConfig(ProfilerColors.ENERGY_LOCATION).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX).setDataBucketInterval(EnergyMonitorView.CHART_INTERVAL_US);
        lineChart.configure(usage.getLocationUsageSeries(), locationConfig);
        lineChart.configure(usage.getTotalUsageDataSeries(), new LineConfig(UIUtil.TRANSPARENT_COLOR));
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, "Center");
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(((EnergyProfilerStage)((Object)this.getStage())).getAxis(), AxisComponent.AxisOrientation.RIGHT);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowUnitAtMax(true);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        EnergyProfilerStage.EnergyUsageLegends legends = ((EnergyProfilerStage)((Object)this.getStage())).getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.configure(legends.getCpuLegend(), new LegendConfig(lineChart.getLineConfig(usage.getCpuUsageSeries())));
        legend.configure(legends.getNetworkLegend(), new LegendConfig(lineChart.getLineConfig(usage.getNetworkUsageSeries())));
        legend.configure((Legend)legends.getLocationLegend(), new LegendConfig(lineChart.getLineConfig(usage.getLocationUsageSeries())));
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, "West");
        legendPanel.add((Component)legend, "East");
        ((EnergyProfilerStage)((Object)this.getStage())).getRangeSelectionModel().addListener(new RangeSelectionListener(){

            public void selectionCreated() {
                if (!migrationServices.isMigrationEnabled() || migrationServices.isSystemEventsMigrationDialogEnabled()) {
                    EnergyProfilerStageView.this.myEventsPanel.setVisible(true);
                }
            }

            public void selectionCleared() {
                EnergyProfilerStageView.this.myEventsPanel.setVisible(false);
            }

            public void selectionCreationFailure() {
                EnergyProfilerStageView.this.myEventsPanel.setVisible(false);
            }
        });
        JComponent minibar = new EnergyEventMinibar(this).getComponent();
        eventsView.registerTooltip(tooltip2, (Stage)((Object)this.getStage()));
        if (!migrationServices.isMigrationEnabled() && !((EnergyProfilerStage)((Object)this.getStage())).hasUserUsedEnergySelection()) {
            this.installProfilingInstructions((JPanel)monitorPanel);
        }
        monitorPanel.add((Component)axisPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)legendPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
        JPanel stagePanel = new JPanel((LayoutManager)new TabularLayout("*", "*,Fit"));
        stagePanel.add((Component)monitorPanel, new TabularLayout.Constraint(0, 0));
        stagePanel.add((Component)minibar, new TabularLayout.Constraint(1, 0));
        layout.setRowSizing(1, "*");
        stagePanel.setBackground(null);
        if (selection2 == null) {
            this.installListeners(stagePanel, tooltip2);
        } else {
            this.installListeners((JComponent)selection2, tooltip2);
            panel.add((Component)selection2, new TabularLayout.Constraint(1, 0));
        }
        panel.add((Component)stagePanel, new TabularLayout.Constraint(1, 0));
        JBPanel jBPanel = panel;
        if (jBPanel == null) {
            EnergyProfilerStageView.$$$reportNull$$$0(2);
        }
        return jBPanel;
    }

    private void installListeners(@NotNull JComponent component, @NotNull RangeTooltipComponent tooltip2) {
        if (component == null) {
            EnergyProfilerStageView.$$$reportNull$$$0(3);
        }
        if (tooltip2 == null) {
            EnergyProfilerStageView.$$$reportNull$$$0(4);
        }
        this.getProfilersView().installCommonMenuItems(component);
        tooltip2.registerListenersOn(component);
        component.addMouseListener(new ProfilerTooltipMouseAdapter((Stage)((Object)this.getStage()), () -> new EnergyStageTooltip((EnergyProfilerStage)((Object)((Object)this.getStage())))));
    }

    @Override
    public JComponent getToolbar() {
        JPanel toolBar = new JPanel(ProfilerLayout.createToolbarLayout());
        JLabel textLabel = new JLabel();
        textLabel.setText("Modeled");
        textLabel.setFont(ProfilerFonts.H4_FONT);
        textLabel.setBorder((Border)new JBEmptyBorder(4, 8, 4, 7));
        toolBar.add(textLabel);
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(StudioIcons.Common.HELP);
        toolBar.add(iconLabel);
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setBorder(ProfilerLayout.TOOLTIP_BORDER);
        textPane.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        textPane.setForeground(ProfilerColors.TOOLTIP_TEXT);
        textPane.setFont(TooltipView.TOOLTIP_BODY_FONT);
        textPane.setText("The Energy Profiler models your app's estimated energy usage of CPU, Network, and GPS resources of your device. It also highlights background events that may contribute to battery drain, such as wake locks, alarms, jobs, and location requests.");
        textPane.setPreferredSize(new Dimension(350, 0));
        TooltipComponent tooltip2 = new TooltipComponent.Builder((JComponent)textPane, (JComponent)iconLabel, this.getProfilersView().getComponent()).build();
        tooltip2.registerListenersOn((Component)iconLabel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolBar, "West");
        return panel;
    }

    private void updateSelectedDurationView() {
        this.myDetailsView.setDuration(((EnergyProfilerStage)((Object)this.getStage())).getSelectedDuration());
    }

    private void installProfilingInstructions(@NotNull JPanel parent) {
        if (parent == null) {
            EnergyProfilerStageView.$$$reportNull$$$0(5);
        }
        assert (parent.getLayout().getClass() == TabularLayout.class);
        InstructionsPanel panel = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(UIUtilities.getFontMetrics((JComponent)parent, (Font)ProfilerFonts.H2_FONT), "Select a range to inspect energy events")}).setEaseOut(((EnergyProfilerStage)((Object)this.getStage())).getInstructionsEaseOutModel(), instructionPanel -> parent.remove((Component)instructionPanel)).setBackgroundCornerRadius(ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER, ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER).build();
        parent.add((Component)panel, new TabularLayout.Constraint(0, 0));
    }

    private JComponent getConfigurationComponent() {
        ComboBox comboBox = new ComboBox((ComboBoxModel)new EnumComboBoxModel(EnergyEventOrigin.class));
        comboBox.getModel().setSelectedItem((Object)((EnergyProfilerStage)((Object)this.getStage())).getEventOrigin());
        comboBox.setRenderer(SimpleListCellRenderer.create((String)"", EnergyEventOrigin::getLabelString));
        comboBox.addActionListener(arg_0 -> this.lambda$getConfigurationComponent$8((JComboBox)comboBox, arg_0));
        return comboBox;
    }

    private /* synthetic */ void lambda$getConfigurationComponent$8(JComboBox comboBox, ActionEvent e) {
        Object origin = comboBox.getSelectedItem();
        if (origin instanceof EnergyEventOrigin) {
            ((EnergyProfilerStage)((Object)this.getStage())).setEventOrigin((EnergyEventOrigin)((Object)origin));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "energyProfilerStage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/energy/EnergyProfilerStageView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/energy/EnergyProfilerStageView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMonitorUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installListeners";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installProfilingInstructions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

