/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Energy;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.energy.EnergyUsage;
import com.android.tools.profilers.energy.EnergyUsageDataSeries;
import org.jetbrains.annotations.NotNull;

public class DetailedEnergyUsage
extends EnergyUsage {
    @NotNull
    private final RangedContinuousSeries myCpuUsageSeries;
    @NotNull
    private final RangedContinuousSeries myNetworkUsageSeries;
    @NotNull
    private final RangedContinuousSeries myLocationUsageSeries;

    public DetailedEnergyUsage(@NotNull StudioProfilers profilers) {
        Object locationDataSeries;
        Object networkDataSeries;
        Object cpuDataSeries;
        if (profilers == null) {
            DetailedEnergyUsage.$$$reportNull$$$0(0);
        }
        super(profilers);
        if (profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            long streamId = profilers.getSession().getStreamId();
            int pid = profilers.getSession().getPid();
            cpuDataSeries = new UnifiedEventDataSeries(profilers.getClient().getTransportClient(), streamId, pid, Common.Event.Kind.ENERGY_USAGE, 0, UnifiedEventDataSeries.fromFieldToDataExtractor(event -> event.getEnergyUsage().getCpuUsage()));
            networkDataSeries = new UnifiedEventDataSeries(profilers.getClient().getTransportClient(), streamId, pid, Common.Event.Kind.ENERGY_USAGE, 0, UnifiedEventDataSeries.fromFieldToDataExtractor(event -> event.getEnergyUsage().getNetworkUsage()));
            locationDataSeries = new UnifiedEventDataSeries(profilers.getClient().getTransportClient(), streamId, pid, Common.Event.Kind.ENERGY_USAGE, 0, UnifiedEventDataSeries.fromFieldToDataExtractor(event -> event.getEnergyUsage().getLocationUsage()));
        } else {
            cpuDataSeries = new EnergyUsageDataSeries(profilers.getClient(), profilers.getSession(), Energy.EnergyUsageData::getCpuUsage);
            networkDataSeries = new EnergyUsageDataSeries(profilers.getClient(), profilers.getSession(), Energy.EnergyUsageData::getNetworkUsage);
            locationDataSeries = new EnergyUsageDataSeries(profilers.getClient(), profilers.getSession(), Energy.EnergyUsageData::getLocationUsage);
        }
        this.myLocationUsageSeries = new RangedContinuousSeries("Location", profilers.getTimeline().getViewRange(), this.getUsageRange(), (DataSeries)locationDataSeries);
        this.add(this.myLocationUsageSeries);
        this.myNetworkUsageSeries = new RangedContinuousSeries("Network", profilers.getTimeline().getViewRange(), this.getUsageRange(), (DataSeries)networkDataSeries);
        this.add(this.myNetworkUsageSeries);
        this.myCpuUsageSeries = new RangedContinuousSeries("CPU", profilers.getTimeline().getViewRange(), this.getUsageRange(), (DataSeries)cpuDataSeries);
        this.add(this.myCpuUsageSeries);
    }

    @NotNull
    public RangedContinuousSeries getCpuUsageSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myCpuUsageSeries;
        if (rangedContinuousSeries == null) {
            DetailedEnergyUsage.$$$reportNull$$$0(1);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getNetworkUsageSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myNetworkUsageSeries;
        if (rangedContinuousSeries == null) {
            DetailedEnergyUsage.$$$reportNull$$$0(2);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getLocationUsageSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myLocationUsageSeries;
        if (rangedContinuousSeries == null) {
            DetailedEnergyUsage.$$$reportNull$$$0(3);
        }
        return rangedContinuousSeries;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/energy/DetailedEnergyUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/energy/DetailedEnergyUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuUsageSeries";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNetworkUsageSeries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationUsageSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

