/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.systemtrace.CounterModel;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerEvent;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapterKt;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceSurfaceflingerManager;
import com.android.tools.profilers.cpu.systemtrace.ThreadModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000b0\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001d\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceSurfaceflingerManager;", "", "systemTraceModel", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;", "mainProcessName", "", "(Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;Ljava/lang/String;)V", "bufferQueueRegex", "Lkotlin/text/Regex;", "bufferQueueValues", "", "Lcom/android/tools/adtui/model/SeriesData;", "", "getBufferQueueValues", "()Ljava/util/List;", "surfaceflingerEvents", "Lcom/android/tools/profilers/cpu/systemtrace/SurfaceflingerEvent;", "getSurfaceflingerEvents", "vsyncCounterValues", "getVsyncCounterValues", "buildBufferQueueCounter", "surfaceflingerProcess", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "buildSfEvents", "buildSfEventsFromThread", "mainThread", "Lcom/android/tools/profilers/cpu/systemtrace/ThreadModel;", "buildVsyncCounter", "Companion", "intellij.android.profilers"})
public final class SystemTraceSurfaceflingerManager {
    @NotNull
    private final List<SeriesData<SurfaceflingerEvent>> surfaceflingerEvents;
    @NotNull
    private final List<SeriesData<Long>> vsyncCounterValues;
    @NotNull
    private final List<SeriesData<Long>> bufferQueueValues;
    private final Regex bufferQueueRegex;
    @NotNull
    public static final String SURFACEFLINGER_PROCESS_NAME = "surfaceflinger";
    private static final String VSYNC_COUNTER_NAME = "VSYNC-app";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<SeriesData<SurfaceflingerEvent>> getSurfaceflingerEvents() {
        return this.surfaceflingerEvents;
    }

    @NotNull
    public final List<SeriesData<Long>> getVsyncCounterValues() {
        return this.vsyncCounterValues;
    }

    @NotNull
    public final List<SeriesData<Long>> getBufferQueueValues() {
        return this.bufferQueueValues;
    }

    private final List<SeriesData<SurfaceflingerEvent>> buildSfEvents(ProcessModel surfaceflingerProcess) {
        ThreadModel threadModel = surfaceflingerProcess.getMainThread();
        if (threadModel == null) {
            return CollectionsKt.emptyList();
        }
        ThreadModel mainThread = threadModel;
        return this.buildSfEventsFromThread(mainThread);
    }

    private final List<SeriesData<SurfaceflingerEvent>> buildSfEventsFromThread(ThreadModel mainThread) {
        return SystemTraceModelAdapterKt.padded((Iterable)mainThread.getTraceEvents(), buildSfEventsFromThread.1.INSTANCE, buildSfEventsFromThread.2.INSTANCE, buildSfEventsFromThread.3.INSTANCE, buildSfEventsFromThread.4.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SeriesData<Long>> buildVsyncCounter(ProcessModel surfaceflingerProcess) {
        void $this$mapTo$iv$iv;
        CounterModel counterModel = surfaceflingerProcess.getCounterByName().get(VSYNC_COUNTER_NAME);
        if (counterModel == null) {
            return CollectionsKt.emptyList();
        }
        CounterModel counter = counterModel;
        Map $this$map$iv = counter.getValuesByTimestampUs();
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            SeriesData seriesData = new SeriesData(((Number)k).longValue(), (Object)((long)((Number)it.getValue()).doubleValue()));
            collection.add(seriesData);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<SeriesData<Long>> buildBufferQueueCounter(ProcessModel surfaceflingerProcess) {
        void $this$mapTo$iv$iv;
        Map<String, CounterModel> $this$filterKeys$iv = surfaceflingerProcess.getCounterByName();
        boolean $i$f$filterKeys = false;
        Map<String, CounterModel> result$iv = new LinkedHashMap<String, CounterModel>();
        for (Map.Entry<String, CounterModel> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            if (!this.bufferQueueRegex.matches((CharSequence)it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        CounterModel counterModel = (CounterModel)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).values());
        if (counterModel == null) {
            return CollectionsKt.emptyList();
        }
        CounterModel counter = counterModel;
        Map $this$map$iv = counter.getValuesByTimestampUs();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            SeriesData seriesData = new SeriesData(((Number)k).longValue(), (Object)((long)((Number)it.getValue()).doubleValue()));
            collection.add(seriesData);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public SystemTraceSurfaceflingerManager(@NotNull SystemTraceModelAdapter systemTraceModel, @NotNull String mainProcessName) {
        List<Object> list;
        block13: {
            block12: {
                List<Object> list2;
                List<Object> list3;
                Object it;
                SystemTraceSurfaceflingerManager systemTraceSurfaceflingerManager;
                ProcessModel sfProcess;
                Object object;
                block11: {
                    block10: {
                        List<Object> list4;
                        block9: {
                            block8: {
                                Object v0;
                                Object object2;
                                block7: {
                                    Intrinsics.checkNotNullParameter((Object)systemTraceModel, (String)"systemTraceModel");
                                    Intrinsics.checkNotNullParameter((Object)mainProcessName, (String)"mainProcessName");
                                    this.bufferQueueRegex = new Regex("(SurfaceView - )?" + mainProcessName + "/.+#\\d");
                                    object2 = object = (Iterable)systemTraceModel.getProcesses();
                                    Iterator iterator = object2.iterator();
                                    while (iterator.hasNext()) {
                                        Object t = iterator.next();
                                        ProcessModel it2 = (ProcessModel)t;
                                        boolean bl = false;
                                        if (!StringsKt.endsWith$default((String)it2.getSafeProcessName(), (String)SURFACEFLINGER_PROCESS_NAME, (boolean)false, (int)2, null)) continue;
                                        v0 = t;
                                        break block7;
                                    }
                                    v0 = null;
                                }
                                sfProcess = v0;
                                SystemTraceSurfaceflingerManager systemTraceSurfaceflingerManager2 = this;
                                list4 = sfProcess;
                                if (list4 == null) break block8;
                                object2 = object = list4;
                                systemTraceSurfaceflingerManager = systemTraceSurfaceflingerManager2;
                                boolean bl = false;
                                list3 = this.buildSfEvents((ProcessModel)it);
                                systemTraceSurfaceflingerManager2 = systemTraceSurfaceflingerManager;
                                list4 = list3;
                                if (list4 != null) break block9;
                            }
                            list4 = CollectionsKt.emptyList();
                        }
                        systemTraceSurfaceflingerManager2.surfaceflingerEvents = list4;
                        SystemTraceSurfaceflingerManager systemTraceSurfaceflingerManager3 = this;
                        list2 = sfProcess;
                        if (list2 == null) break block10;
                        it = object = list2;
                        systemTraceSurfaceflingerManager = systemTraceSurfaceflingerManager3;
                        boolean bl = false;
                        list3 = this.buildVsyncCounter((ProcessModel)it);
                        systemTraceSurfaceflingerManager3 = systemTraceSurfaceflingerManager;
                        list2 = list3;
                        if (list2 != null) break block11;
                    }
                    list2 = CollectionsKt.emptyList();
                }
                systemTraceSurfaceflingerManager3.vsyncCounterValues = list2;
                SystemTraceSurfaceflingerManager systemTraceSurfaceflingerManager4 = this;
                list = sfProcess;
                if (list == null) break block12;
                it = object = list;
                systemTraceSurfaceflingerManager = systemTraceSurfaceflingerManager4;
                boolean bl = false;
                list3 = this.buildBufferQueueCounter((ProcessModel)it);
                systemTraceSurfaceflingerManager4 = systemTraceSurfaceflingerManager;
                list = list3;
                if (list != null) break block13;
            }
            list = CollectionsKt.emptyList();
        }
        systemTraceSurfaceflingerManager4.bufferQueueValues = list;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceSurfaceflingerManager$Companion;", "", "()V", "SURFACEFLINGER_PROCESS_NAME", "", "VSYNC_COUNTER_NAME", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

