/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrame;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/FrameState;", "", "threadType", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceFrame$FrameThread;", "systemTraceData", "Lcom/android/tools/profilers/cpu/systemtrace/CpuSystemTraceData;", "range", "Lcom/android/tools/adtui/model/Range;", "(Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceFrame$FrameThread;Lcom/android/tools/profilers/cpu/systemtrace/CpuSystemTraceData;Lcom/android/tools/adtui/model/Range;)V", "model", "Lcom/android/tools/adtui/model/StateChartModel;", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceFrame;", "getModel", "()Lcom/android/tools/adtui/model/StateChartModel;", "series", "Lcom/android/tools/adtui/model/DataSeries;", "getSeries", "()Lcom/android/tools/adtui/model/DataSeries;", "vsyncSeries", "Lcom/android/tools/adtui/model/RangedSeries;", "", "getVsyncSeries", "()Lcom/android/tools/adtui/model/RangedSeries;", "Companion", "intellij.android.profilers"})
public final class FrameState {
    @NotNull
    private final DataSeries<SystemTraceFrame> series;
    @NotNull
    private final StateChartModel<SystemTraceFrame> model;
    @NotNull
    private final RangedSeries<Long> vsyncSeries;
    private static final long slowFrameRateUs;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final DataSeries<SystemTraceFrame> getSeries() {
        return this.series;
    }

    @NotNull
    public final StateChartModel<SystemTraceFrame> getModel() {
        return this.model;
    }

    @NotNull
    public final RangedSeries<Long> getVsyncSeries() {
        return this.vsyncSeries;
    }

    public FrameState(final @NotNull SystemTraceFrame.FrameThread threadType, final @NotNull CpuSystemTraceData systemTraceData, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)((Object)threadType), (String)"threadType");
        Intrinsics.checkNotNullParameter((Object)systemTraceData, (String)"systemTraceData");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.model = new StateChartModel();
        this.series = new LazyDataSeries(new Supplier(){

            public final List<SeriesData<SystemTraceFrame>> get() {
                return systemTraceData.getFrames(threadType);
            }
        });
        this.model.addSeries(new RangedSeries(range, this.series, null, 4, null));
        this.vsyncSeries = new RangedSeries(range, (DataSeries)new LazyDataSeries(new Supplier(){

            public final List<SeriesData<Long>> get() {
                return systemTraceData.getVsyncCounterValues();
            }
        }), null, 4, null);
    }

    static {
        Companion = new Companion(null);
        slowFrameRateUs = TimeUnit.MILLISECONDS.toMicros(17L);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/FrameState$Companion;", "", "()V", "slowFrameRateUs", "", "getSlowFrameRateUs", "()J", "intellij.android.profilers"})
    public static final class Companion {
        public final long getSlowFrameRateUs() {
            return slowFrameRateUs;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

