/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.common.ColorPaletteManager;
import com.android.tools.profilers.DataVisualizationColors;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.SystemTraceNodeModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

class SystemTraceNodeModelHChartColors {
    SystemTraceNodeModelHChartColors() {
    }

    private static void validateModel(@NotNull CaptureNodeModel model) {
        if (model == null) {
            SystemTraceNodeModelHChartColors.$$$reportNull$$$0(0);
        }
        if (!(model instanceof SystemTraceNodeModel)) {
            throw new IllegalStateException("Model must be an instance of SystemTraceNodeModel.");
        }
    }

    static Color getIdleCpuColor(@NotNull ColorPaletteManager colorPaletteManager, @NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isUnmatched, boolean isFocused, boolean isDeselected) {
        Color color;
        if (colorPaletteManager == null) {
            SystemTraceNodeModelHChartColors.$$$reportNull$$$0(1);
        }
        if (model == null) {
            SystemTraceNodeModelHChartColors.$$$reportNull$$$0(2);
        }
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            int index = model.getFullName().hashCode();
            color = JBColor.isBright() ? ColorUtil.darker((Color)colorPaletteManager.getBackgroundColor(index, isFocused), (int)5) : ColorUtil.brighter((Color)colorPaletteManager.getBackgroundColor(index, isFocused), (int)5);
            if (isDeselected && !isFocused) {
                color = colorPaletteManager.toGrayscale(color);
            }
        } else {
            color = isFocused ? ProfilerColors.CPU_FLAMECHART_APP_HOVER_IDLE : ProfilerColors.CPU_FLAMECHART_APP_IDLE;
        }
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    static Color getFillColor(@NotNull ColorPaletteManager colorPaletteManager, @NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isUnmatched, boolean isFocused, boolean isDeselected) {
        Color color;
        if (colorPaletteManager == null) {
            SystemTraceNodeModelHChartColors.$$$reportNull$$$0(3);
        }
        if (model == null) {
            SystemTraceNodeModelHChartColors.$$$reportNull$$$0(4);
        }
        SystemTraceNodeModelHChartColors.validateModel(model);
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            int index = model.getFullName().hashCode();
            color = colorPaletteManager.getBackgroundColor(index, isFocused);
            if (isDeselected && !isFocused) {
                color = colorPaletteManager.toGrayscale(color);
            }
        } else {
            color = isFocused ? ProfilerColors.CPU_FLAMECHART_APP_HOVER : ProfilerColors.CPU_FLAMECHART_APP;
        }
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    static Color getTextColor(@NotNull ColorPaletteManager colorPaletteManager, @NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isDeselected) {
        if (colorPaletteManager == null) {
            SystemTraceNodeModelHChartColors.$$$reportNull$$$0(5);
        }
        if (model == null) {
            SystemTraceNodeModelHChartColors.$$$reportNull$$$0(6);
        }
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            int index = model.getFullName().hashCode();
            return isDeselected ? colorPaletteManager.getForegroundColor("Gray") : colorPaletteManager.getForegroundColor(index);
        }
        return DataVisualizationColors.DEFAULT_DARK_TEXT_COLOR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorPaletteManager";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/SystemTraceNodeModelHChartColors";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validateModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdleCpuColor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getFillColor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

