/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeNode;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class CpuTreeModel<T extends CpuTreeNode<T>>
extends DefaultTreeModel {
    private final ClockType myClockType;
    private final Range myRange;
    private final Range myCurrentRange;
    private final AspectObserver myAspectObserver;
    private final AspectModel<Aspect> myAspectModel;
    private final boolean myIsRootNodeIdValid;

    public CpuTreeModel(@NotNull ClockType clockType, @NotNull Range range, @NotNull T node) {
        if (clockType == null) {
            CpuTreeModel.$$$reportNull$$$0(0);
        }
        if (range == null) {
            CpuTreeModel.$$$reportNull$$$0(1);
        }
        if (node == null) {
            CpuTreeModel.$$$reportNull$$$0(2);
        }
        super(new DefaultMutableTreeNode(node));
        this.myClockType = clockType;
        this.myIsRootNodeIdValid = !((CpuTreeNode)node).getId().isEmpty();
        this.myRange = range;
        this.myCurrentRange = new Range();
        this.myAspectModel = new AspectModel();
        this.myAspectObserver = new AspectObserver();
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::rangeChanged);
        this.rangeChanged();
    }

    @NotNull
    public AspectModel<Aspect> getAspect() {
        AspectModel<Aspect> aspectModel = this.myAspectModel;
        if (aspectModel == null) {
            CpuTreeModel.$$$reportNull$$$0(3);
        }
        return aspectModel;
    }

    public boolean isRootNodeIdValid() {
        return this.myIsRootNodeIdValid;
    }

    public void rangeChanged() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        LinkedList<Range> diffs = new LinkedList<Range>();
        diffs.addAll(this.myRange.subtract(this.myCurrentRange));
        diffs.addAll(this.myCurrentRange.subtract(this.myRange));
        this.update(root, this.myRange, diffs);
        this.myCurrentRange.set(this.myRange);
        this.myAspectModel.changed((Enum)Aspect.TREE_MODEL);
    }

    public boolean changes(T data, List<Range> ranges) {
        for (Range diff : ranges) {
            if (!((CpuTreeNode)data).inRange(diff)) continue;
            return true;
        }
        return false;
    }

    private void update(DefaultMutableTreeNode node, Range range, List<Range> ranges) {
        CpuTreeNode data = (CpuTreeNode)node.getUserObject();
        if (this.changes(data, ranges)) {
            Enumeration<TreeNode> e = node.children();
            HashMap<CpuTreeNode, DefaultMutableTreeNode> children2 = new HashMap<CpuTreeNode, DefaultMutableTreeNode>();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
                children2.put((CpuTreeNode)child.getUserObject(), child);
            }
            HashSet<CpuTreeNode> actual = new HashSet<CpuTreeNode>();
            for (CpuTreeNode cpuTreeNode : data.getChildren()) {
                if (cpuTreeNode.inRange(range)) {
                    actual.add(cpuTreeNode);
                    DefaultMutableTreeNode existing = (DefaultMutableTreeNode)children2.get(cpuTreeNode);
                    if (existing == null) {
                        existing = new DefaultMutableTreeNode(cpuTreeNode);
                        this.insertNodeInto(existing, node, node.getChildCount());
                    }
                    this.update(existing, range, ranges);
                    continue;
                }
                cpuTreeNode.reset();
            }
            for (Map.Entry entry : children2.entrySet()) {
                if (actual.contains(entry.getKey())) continue;
                this.removeNodeFromParent((MutableTreeNode)entry.getValue());
            }
            data.update(this.myClockType, range);
            this.nodeChanged(node);
        }
    }

    @NotNull
    public Range getRange() {
        Range range = this.myRange;
        if (range == null) {
            CpuTreeModel.$$$reportNull$$$0(4);
        }
        return range;
    }

    @NotNull
    public ClockType getClockType() {
        ClockType clockType = this.myClockType;
        if (clockType == null) {
            CpuTreeModel.$$$reportNull$$$0(5);
        }
        return clockType;
    }

    public boolean isEmpty() {
        CpuTreeNode data = (CpuTreeNode)((DefaultMutableTreeNode)this.getRoot()).getUserObject();
        return data.getGlobalTotal() == 0.0;
    }

    abstract void expand(@NotNull DefaultMutableTreeNode var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CpuTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CpuTreeModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Aspect {
        TREE_MODEL;

    }
}

