/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.VisualNodeCaptureNode;
import com.android.tools.profilers.cpu.capturedetails.BottomUpNode;
import com.android.tools.profilers.cpu.capturedetails.BottomUpTreeModel;
import com.android.tools.profilers.cpu.capturedetails.TopDownNode;
import com.android.tools.profilers.cpu.capturedetails.TopDownTreeModel;
import com.android.tools.profilers.cpu.nodemodel.SingleNameModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CaptureDetails {
    @NotNull
    final ClockType myClockType;
    @NotNull
    private final CpuCapture myCapture;

    protected CaptureDetails(@NotNull ClockType clockType, @NotNull CpuCapture cpuCapture) {
        if (clockType == null) {
            CaptureDetails.$$$reportNull$$$0(0);
        }
        if (cpuCapture == null) {
            CaptureDetails.$$$reportNull$$$0(1);
        }
        this.myClockType = clockType;
        this.myCapture = cpuCapture;
    }

    @NotNull
    public CpuCapture getCapture() {
        CpuCapture cpuCapture = this.myCapture;
        if (cpuCapture == null) {
            CaptureDetails.$$$reportNull$$$0(2);
        }
        return cpuCapture;
    }

    @NotNull
    public abstract Type getType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuCapture";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FlameChart
    extends ChartDetails {
        @NotNull
        private final Range myFlameRange;
        @Nullable
        private CaptureNode myFlameNode;
        @Nullable
        private final TopDownNode myTopDownNode;
        @NotNull
        private final Range mySelectionRange;
        @NotNull
        private final AspectModel<Aspect> myAspectModel;

        FlameChart(@NotNull ClockType clockType, @NotNull Range selectionRange, @NotNull List<CaptureNode> captureNodes, @NotNull CpuCapture cpuCapture) {
            if (clockType == null) {
                FlameChart.$$$reportNull$$$0(0);
            }
            if (selectionRange == null) {
                FlameChart.$$$reportNull$$$0(1);
            }
            if (captureNodes == null) {
                FlameChart.$$$reportNull$$$0(2);
            }
            if (cpuCapture == null) {
                FlameChart.$$$reportNull$$$0(3);
            }
            super(clockType, cpuCapture);
            this.mySelectionRange = selectionRange;
            this.myFlameRange = new Range();
            this.myAspectModel = new AspectModel();
            if (captureNodes.isEmpty()) {
                this.myFlameNode = null;
                this.myTopDownNode = null;
                return;
            }
            VisualNodeCaptureNode visual = new VisualNodeCaptureNode(new SingleNameModel(""), clockType);
            captureNodes.sort(Comparator.comparingLong(CaptureNode::getStartGlobal));
            captureNodes.forEach(visual::addChild);
            visual.setStartGlobal(captureNodes.get(0).getStartGlobal());
            visual.setStartThread(captureNodes.get(0).getStartThread());
            this.myTopDownNode = new TopDownNode(visual);
            this.myTopDownNode.update(this.myClockType, new Range(0.0, Double.MAX_VALUE));
            visual.setEndGlobal(visual.getStartGlobal() + (long)this.myTopDownNode.getGlobalChildrenTotal());
            visual.setEndThread(visual.getStartThread() + (long)this.myTopDownNode.getThreadChildrenTotal());
            selectionRange.addDependency(this.myAspectModel).onChange((Enum)Range.Aspect.RANGE, this::selectionRangeChanged);
            this.selectionRangeChanged();
        }

        private void selectionRangeChanged() {
            assert (this.myTopDownNode != null);
            this.myTopDownNode.update(this.myClockType, this.mySelectionRange);
            if (this.myTopDownNode.getTotal(this.myClockType) > 0.0) {
                double start = Math.max((double)this.myTopDownNode.getNodes().get(0).getStart(), this.mySelectionRange.getMin());
                this.myFlameNode = this.convertToFlameChart(this.myTopDownNode, start, 0);
                if (this.myFlameNode.getLastChild() != null) {
                    this.myFlameNode.setEndGlobal(((CaptureNode)this.myFlameNode.getLastChild()).getEndGlobal());
                    this.myFlameRange.set((double)this.myFlameNode.getStart(), (double)this.myFlameNode.getEnd());
                } else {
                    this.myFlameNode = null;
                }
            } else {
                this.myFlameNode = null;
            }
            this.myAspectModel.changed((Enum)Aspect.NODE);
        }

        @NotNull
        public Range getRange() {
            Range range = this.myFlameRange;
            if (range == null) {
                FlameChart.$$$reportNull$$$0(4);
            }
            return range;
        }

        @Override
        @Nullable
        public CaptureNode getNode() {
            return this.myFlameNode;
        }

        @NotNull
        public AspectModel<Aspect> getAspect() {
            AspectModel<Aspect> aspectModel = this.myAspectModel;
            if (aspectModel == null) {
                FlameChart.$$$reportNull$$$0(5);
            }
            return aspectModel;
        }

        @Override
        @NotNull
        public Type getType() {
            Type type = Type.FLAME_CHART;
            if (type == null) {
                FlameChart.$$$reportNull$$$0(6);
            }
            return type;
        }

        /*
         * WARNING - void declaration
         */
        private CaptureNode convertToFlameChart(@NotNull TopDownNode topDown, double start, int n) {
            void depth;
            if (topDown == null) {
                FlameChart.$$$reportNull$$$0(7);
            }
            assert (topDown.getTotal(this.myClockType) > 0.0);
            CaptureNode node = new CaptureNode(topDown.getNodes().get(0).getData(), this.myClockType);
            node.setFilterType(topDown.getNodes().get(0).getFilterType());
            node.setStartGlobal((long)start);
            node.setStartThread((long)start);
            node.setEndGlobal((long)(start + topDown.getGlobalTotal()));
            node.setEndThread((long)(start + topDown.getThreadTotal()));
            node.setDepth((int)depth);
            for (TopDownNode child : topDown.getChildren()) {
                child.update(this.myClockType, this.mySelectionRange);
            }
            ArrayList sortedChildren = new ArrayList(topDown.getChildren());
            sortedChildren.sort((o1, o2) -> {
                int cmp = Boolean.compare(o1.isUnmatched(), o2.isUnmatched());
                return cmp == 0 ? Double.compare(o2.getTotal(this.myClockType), o1.getTotal(this.myClockType)) : cmp;
            });
            for (TopDownNode child : sortedChildren) {
                if (child.getTotal(this.myClockType) == 0.0) continue;
                node.addChild(this.convertToFlameChart(child, start, (int)(depth + true)));
                start += child.getTotal(this.myClockType);
            }
            return node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clockType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectionRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "captureNodes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuCapture";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$FlameChart";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topDown";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$FlameChart";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAspect";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToFlameChart";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Aspect {
            NODE;

        }
    }

    public static class CallChart
    extends ChartDetails {
        @NotNull
        private final Range myRange;
        @Nullable
        private CaptureNode myNode;

        public CallChart(@NotNull ClockType clockType, @NotNull Range range, @NotNull List<CaptureNode> nodes, @NotNull CpuCapture cpuCapture) {
            if (clockType == null) {
                CallChart.$$$reportNull$$$0(0);
            }
            if (range == null) {
                CallChart.$$$reportNull$$$0(1);
            }
            if (nodes == null) {
                CallChart.$$$reportNull$$$0(2);
            }
            if (cpuCapture == null) {
                CallChart.$$$reportNull$$$0(3);
            }
            super(clockType, cpuCapture);
            this.myRange = range;
            if (nodes.isEmpty()) {
                this.myNode = null;
                return;
            }
            this.myNode = nodes.get(0);
        }

        @NotNull
        public Range getRange() {
            Range range = this.myRange;
            if (range == null) {
                CallChart.$$$reportNull$$$0(4);
            }
            return range;
        }

        @Override
        @Nullable
        public CaptureNode getNode() {
            return this.myNode;
        }

        @Override
        @NotNull
        public Type getType() {
            Type type = Type.CALL_CHART;
            if (type == null) {
                CallChart.$$$reportNull$$$0(5);
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clockType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuCapture";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$CallChart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$CallChart";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BottomUp
    extends CaptureDetails {
        @Nullable
        private BottomUpTreeModel myModel;

        BottomUp(@NotNull ClockType clockType, @NotNull Range range, @NotNull List<CaptureNode> nodes, @NotNull CpuCapture cpuCapture) {
            if (clockType == null) {
                BottomUp.$$$reportNull$$$0(0);
            }
            if (range == null) {
                BottomUp.$$$reportNull$$$0(1);
            }
            if (nodes == null) {
                BottomUp.$$$reportNull$$$0(2);
            }
            if (cpuCapture == null) {
                BottomUp.$$$reportNull$$$0(3);
            }
            super(clockType, cpuCapture);
            if (nodes.isEmpty()) {
                this.myModel = null;
                return;
            }
            Range captureRange = cpuCapture.getRange();
            VisualNodeCaptureNode visual = new VisualNodeCaptureNode(new SingleNameModel(""), clockType);
            nodes.forEach(visual::addChild);
            Long minGlobal = nodes.stream().mapToLong(n -> n.getStartGlobal()).min().orElse((long)captureRange.getMin());
            Long maxGlobal = nodes.stream().mapToLong(n -> n.getEndGlobal()).max().orElse((long)captureRange.getMax());
            Long minThread = nodes.stream().mapToLong(n -> n.getStartThread()).min().orElse((long)captureRange.getMin());
            Long maxThread = nodes.stream().mapToLong(n -> n.getEndThread()).max().orElse((long)captureRange.getMax());
            visual.setStartGlobal(minGlobal);
            visual.setEndGlobal(maxGlobal);
            visual.setStartThread(minThread);
            visual.setEndThread(maxThread);
            BottomUpNode buNode = new BottomUpNode(visual);
            buNode.update(clockType, range);
            this.myModel = new BottomUpTreeModel(clockType, range, buNode);
        }

        @Nullable
        public BottomUpTreeModel getModel() {
            return this.myModel;
        }

        @Override
        @NotNull
        public Type getType() {
            Type type = Type.BOTTOM_UP;
            if (type == null) {
                BottomUp.$$$reportNull$$$0(4);
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clockType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuCapture";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$BottomUp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$BottomUp";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TopDown
    extends CaptureDetails {
        @Nullable
        private final TopDownTreeModel myModel;

        TopDown(@NotNull ClockType clockType, @NotNull Range range, @NotNull List<CaptureNode> nodes, @NotNull CpuCapture cpuCapture) {
            if (clockType == null) {
                TopDown.$$$reportNull$$$0(0);
            }
            if (range == null) {
                TopDown.$$$reportNull$$$0(1);
            }
            if (nodes == null) {
                TopDown.$$$reportNull$$$0(2);
            }
            if (cpuCapture == null) {
                TopDown.$$$reportNull$$$0(3);
            }
            super(clockType, cpuCapture);
            if (nodes.isEmpty()) {
                this.myModel = null;
                return;
            }
            Range captureRange = cpuCapture.getRange();
            VisualNodeCaptureNode visual = new VisualNodeCaptureNode(new SingleNameModel(""), clockType);
            nodes.forEach(visual::addChild);
            Long minGlobal = nodes.stream().mapToLong(n -> n.getStartGlobal()).min().orElse((long)captureRange.getMin());
            Long maxGlobal = nodes.stream().mapToLong(n -> n.getEndGlobal()).max().orElse((long)captureRange.getMax());
            Long minThread = nodes.stream().mapToLong(n -> n.getStartThread()).min().orElse((long)captureRange.getMin());
            Long maxThread = nodes.stream().mapToLong(n -> n.getEndThread()).max().orElse((long)captureRange.getMax());
            visual.setStartGlobal(minGlobal);
            visual.setEndGlobal(maxGlobal);
            visual.setStartThread(minThread);
            visual.setEndThread(maxThread);
            this.myModel = new TopDownTreeModel(clockType, range, new TopDownNode(visual));
        }

        @Nullable
        public TopDownTreeModel getModel() {
            return this.myModel;
        }

        @Override
        @NotNull
        public Type getType() {
            Type type = Type.TOP_DOWN;
            if (type == null) {
                TopDown.$$$reportNull$$$0(4);
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clockType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuCapture";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$TopDown";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$TopDown";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class ChartDetails
    extends CaptureDetails {
        protected ChartDetails(@NotNull ClockType clockType, @NotNull CpuCapture cpuCapture) {
            if (clockType == null) {
                ChartDetails.$$$reportNull$$$0(0);
            }
            if (cpuCapture == null) {
                ChartDetails.$$$reportNull$$$0(1);
            }
            super(clockType, cpuCapture);
        }

        @Nullable
        abstract CaptureNode getNode();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clockType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cpuCapture";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$ChartDetails";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface CaptureDetailsBuilder {
        public CaptureDetails build(@NotNull ClockType var1, Range var2, List<CaptureNode> var3, CpuCapture var4);
    }

    public static enum Type {
        TOP_DOWN(TopDown::new),
        BOTTOM_UP(BottomUp::new),
        CALL_CHART(CallChart::new),
        FLAME_CHART(FlameChart::new);

        @NotNull
        private final CaptureDetailsBuilder myBuilder;

        private Type(CaptureDetailsBuilder builder) {
            if (builder == null) {
                Type.$$$reportNull$$$0(0);
            }
            this.myBuilder = builder;
        }

        public CaptureDetails build(@NotNull ClockType clockType, @NotNull Range range, @NotNull List<CaptureNode> node, @NotNull CpuCapture cpuCapture) {
            if (clockType == null) {
                Type.$$$reportNull$$$0(1);
            }
            if (range == null) {
                Type.$$$reportNull$$$0(2);
            }
            if (node == null) {
                Type.$$$reportNull$$$0(3);
            }
            if (cpuCapture == null) {
                Type.$$$reportNull$$$0(4);
            }
            return this.myBuilder.build(clockType, range, node, cpuCapture);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clockType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuCapture";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$Type";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "build";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

