/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadTrackModel;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.analysis.CaptureNodeDetailTable;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CpuThreadAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CpuThreadStateTable;
import com.android.tools.profilers.cpu.analysis.CpuThreadSummaryDetailsView;
import com.android.tools.profilers.cpu.analysis.SummaryDetailsViewBase;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002R\u0013\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0013\u0010\u0011\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadSummaryDetailsView;", "Lcom/android/tools/profilers/cpu/analysis/SummaryDetailsViewBase;", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadAnalysisSummaryTabModel;", "parentView", "Lcom/android/tools/profilers/StudioProfilersView;", "tabModel", "(Lcom/android/tools/profilers/StudioProfilersView;Lcom/android/tools/profilers/cpu/analysis/CpuThreadAnalysisSummaryTabModel;)V", "dataTypeLabel", "Ljavax/swing/JLabel;", "getDataTypeLabel", "()Ljavax/swing/JLabel;", "durationLabel", "getDurationLabel", "nodesTablePanel", "Ljavax/swing/JPanel;", "threadIdLabel", "getThreadIdLabel", "timeRangeLabel", "getTimeRangeLabel", "onSelectionRangeChanged", "", "populateNodesTable", "Companion", "intellij.android.profilers.ui"})
public final class CpuThreadSummaryDetailsView
extends SummaryDetailsViewBase<CpuThreadAnalysisSummaryTabModel> {
    @NotNull
    private final JLabel timeRangeLabel;
    @NotNull
    private final JLabel durationLabel;
    @NotNull
    private final JLabel dataTypeLabel;
    @NotNull
    private final JLabel threadIdLabel;
    private final JPanel nodesTablePanel;
    private static final int NUMBER_OF_TABLE_NODES = 10;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    @NotNull
    public final JLabel getTimeRangeLabel() {
        return this.timeRangeLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getDurationLabel() {
        return this.durationLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getDataTypeLabel() {
        return this.dataTypeLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getThreadIdLabel() {
        return this.threadIdLabel;
    }

    private final void onSelectionRangeChanged() {
        Range range = ((CpuThreadAnalysisSummaryTabModel)this.getTabModel()).getSelectionRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"tabModel.selectionRange");
        Range range2 = range;
        this.timeRangeLabel.setText(this.formatTimeRangeAsString(range2));
        this.durationLabel.setText(TimeFormatter.getSingleUnitDurationString((long)((long)range2.getLength())));
        this.populateNodesTable();
    }

    private final void populateNodesTable() {
        StudioProfilers studioProfilers = this.getProfilersView().getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"profilersView.studioProfilers");
        IdeProfilerServices ideProfilerServices = studioProfilers.getIdeServices();
        Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices, (String)"profilersView.studioProfilers.ideServices");
        ideProfilerServices.getPoolExecutor().execute(new Runnable(this){
            final /* synthetic */ CpuThreadSummaryDetailsView this$0;

            public final void run() {
                List<CaptureNode> list = ((CpuThreadAnalysisSummaryTabModel)this.this$0.getTabModel()).getTopNodesInSelectionRange(10);
                Intrinsics.checkNotNullExpressionValue(list, (String)"tabModel.getTopNodesInSe\u2026ge(NUMBER_OF_TABLE_NODES)");
                List<CaptureNode> nodesInRange = list;
                StudioProfilers studioProfilers = this.this$0.getProfilersView().getStudioProfilers();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"profilersView.studioProfilers");
                IdeProfilerServices ideProfilerServices = studioProfilers.getIdeServices();
                Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices, (String)"profilersView.studioProfilers.ideServices");
                ideProfilerServices.getMainExecutor().execute(new Runnable(this, nodesInRange){
                    final /* synthetic */ populateNodesTable.1 this$0;
                    final /* synthetic */ List $nodesInRange;

                    public final void run() {
                        CpuThreadSummaryDetailsView.access$getNodesTablePanel$p(this.this$0.this$0).removeAll();
                        Collection collection = this.$nodesInRange;
                        if (!collection.isEmpty()) {
                            HideablePanel hideablePanel;
                            Range range = ((CpuThreadAnalysisSummaryTabModel)this.this$0.this$0.getTabModel()).getCaptureRange();
                            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"tabModel.captureRange");
                            StudioProfilers studioProfilers = this.this$0.this$0.getProfilersView().getStudioProfilers();
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"profilersView.studioProfilers");
                            Stage stage = studioProfilers.getStage();
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)stage), (String)"profilersView.studioProfilers.stage");
                            T t = stage.getTimeline();
                            Intrinsics.checkNotNullExpressionValue(t, (String)"profilersView.studioProfilers.stage.timeline");
                            CaptureNodeDetailTable nodesTable = new CaptureNodeDetailTable(this.$nodesInRange, range, t.getViewRange(), 0, 8, null);
                            String sizeText = this.$nodesInRange.size() == 10 ? "top 10" : String.valueOf(this.$nodesInRange.size());
                            Border border = JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)1), (Border)((Border)JBUI.Borders.empty((int)8, (int)0, (int)0, (int)0)), (boolean)true);
                            Intrinsics.checkNotNullExpressionValue((Object)border, (String)"JBUI.Borders.merge(JBUI.\u2026.empty(8, 0, 0, 0), true)");
                            Border contentBorder = border;
                            HideablePanel $this$apply = hideablePanel = new HideablePanel.Builder("Longest running events (" + sizeText + ")", nodesTable.getComponent()).setPanelBorder((Border)JBUI.Borders.empty()).setContentBorder(contentBorder).build();
                            boolean bl = false;
                            $this$apply.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
                            HideablePanel hideablePanel2 = hideablePanel;
                            Intrinsics.checkNotNullExpressionValue((Object)hideablePanel2, (String)"HideablePanel.Builder(\"L\u2026tBackground\n            }");
                            HideablePanel hideablePanel3 = hideablePanel2;
                            CpuThreadSummaryDetailsView.access$getNodesTablePanel$p(this.this$0.this$0).add((Component)hideablePanel3);
                        }
                        CpuThreadSummaryDetailsView.access$getNodesTablePanel$p(this.this$0.this$0).invalidate();
                        CpuThreadSummaryDetailsView.access$getNodesTablePanel$p(this.this$0.this$0).repaint();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$nodesInRange = list;
                    }
                });
            }
            {
                this.this$0 = cpuThreadSummaryDetailsView;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public CpuThreadSummaryDetailsView(@NotNull StudioProfilersView parentView, @NotNull CpuThreadAnalysisSummaryTabModel tabModel) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)parentView), (String)"parentView");
        Intrinsics.checkNotNullParameter((Object)tabModel, (String)"tabModel");
        super(parentView, (CpuAnalysisSummaryTabModel)tabModel);
        this.timeRangeLabel = new JLabel();
        this.durationLabel = new JLabel();
        this.dataTypeLabel = new JLabel(tabModel.getLabel());
        this.threadIdLabel = new JLabel();
        this.nodesTablePanel = new JPanel(new BorderLayout());
        this.addRowToCommonSection("Time Range", this.timeRangeLabel);
        this.addRowToCommonSection("Duration", this.durationLabel);
        this.addRowToCommonSection("Data Type", this.dataTypeLabel);
        if (tabModel.getDataSeries().size() == 1) {
            void $this$apply;
            object = this.threadIdLabel;
            JLabel jLabel = object;
            String string = "ID";
            CpuThreadSummaryDetailsView cpuThreadSummaryDetailsView = this;
            boolean bl = false;
            Object t = tabModel.getDataSeries().get(0);
            Intrinsics.checkNotNullExpressionValue(t, (String)"tabModel.dataSeries[0]");
            CpuThreadInfo cpuThreadInfo = ((CpuThreadTrackModel)t).getThreadInfo();
            Intrinsics.checkNotNullExpressionValue((Object)cpuThreadInfo, (String)"tabModel.dataSeries[0].threadInfo");
            $this$apply.setText(String.valueOf(cpuThreadInfo.getId()));
            Unit unit = Unit.INSTANCE;
            cpuThreadSummaryDetailsView.addRowToCommonSection(string, (JComponent)object);
        }
        tabModel.getSelectionRange().addDependency(this.getObserver()).onChange((Enum)Range.Aspect.RANGE, new Runnable(){

            @Override
            public final void run() {
                this.onSelectionRangeChanged();
            }
        });
        this.onSelectionRangeChanged();
        List list = tabModel.getDataSeries();
        Intrinsics.checkNotNullExpressionValue(list, (String)"tabModel.dataSeries");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DataSeries<ThreadState> dataSeries;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            CpuThreadTrackModel it = (CpuThreadTrackModel)element$iv$iv;
            boolean bl3 = false;
            CpuThreadTrackModel cpuThreadTrackModel = it;
            Intrinsics.checkNotNullExpressionValue((Object)cpuThreadTrackModel, (String)"it");
            if (cpuThreadTrackModel.getThreadStateSeries() == null) continue;
            DataSeries<ThreadState> it$iv$iv = dataSeries;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Object threadStateSeriesList = object = (List)destination$iv$iv;
        boolean bl5 = false;
        Collection collection = (Collection)threadStateSeriesList;
        if (!collection.isEmpty()) {
            StudioProfilers studioProfilers = parentView.getStudioProfilers();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"parentView.studioProfilers");
            Range range = tabModel.getSelectionRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"tabModel.selectionRange");
            this.addSection(new CpuThreadStateTable(studioProfilers, (List)threadStateSeriesList, range, null, 8, null).getComponent());
        }
        this.addSection(this.nodesTablePanel);
    }

    public static final /* synthetic */ JPanel access$getNodesTablePanel$p(CpuThreadSummaryDetailsView $this) {
        return $this.nodesTablePanel;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadSummaryDetailsView$Companion;", "", "()V", "NUMBER_OF_TABLE_NODES", "", "intellij.android.profilers.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

