/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.perfetto.proto.TraceProcessor;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.FrameEventRow;
import com.android.tools.profilers.cpu.analysis.FrameEventTableColumn;
import com.android.tools.profilers.cpu.analysis.PaginatedTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R'\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisFramesTabModel;", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisTabModel;", "Lcom/android/tools/profilers/cpu/CpuCapture;", "captureRange", "Lcom/android/tools/adtui/model/Range;", "(Lcom/android/tools/adtui/model/Range;)V", "getCaptureRange", "()Lcom/android/tools/adtui/model/Range;", "tableModels", "", "Lcom/android/tools/profilers/cpu/analysis/PaginatedTableModel;", "Lcom/android/tools/profilers/cpu/analysis/FrameEventRow;", "getTableModels", "()Ljava/util/List;", "tableModels$delegate", "Lkotlin/Lazy;", "intellij.android.profilers"})
public final class CpuAnalysisFramesTabModel
extends CpuAnalysisTabModel<CpuCapture> {
    @NotNull
    private final Lazy tableModels$delegate;
    @NotNull
    private final Range captureRange;

    @NotNull
    public final List<PaginatedTableModel<FrameEventRow>> getTableModels() {
        Lazy lazy = this.tableModels$delegate;
        CpuAnalysisFramesTabModel cpuAnalysisFramesTabModel = this;
        Object var3_3 = null;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Range getCaptureRange() {
        return this.captureRange;
    }

    public CpuAnalysisFramesTabModel(@NotNull Range captureRange) {
        Intrinsics.checkNotNullParameter((Object)captureRange, (String)"captureRange");
        super(CpuAnalysisTabModel.Type.FRAMES);
        this.captureRange = captureRange;
        this.tableModels$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends PaginatedTableModel<FrameEventRow>>>(this){
            final /* synthetic */ CpuAnalysisFramesTabModel this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<PaginatedTableModel<FrameEventRow>> invoke() {
                void $this$mapTo$iv$iv;
                Iterable list$iv$iv;
                Iterable $this$flatMapTo$iv$iv;
                List<T> list = this.this$0.getDataSeries();
                Intrinsics.checkNotNullExpressionValue(list, (String)"dataSeries");
                Iterable $this$flatMap$iv = list;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    CpuCapture it = (CpuCapture)element$iv$iv;
                    boolean bl = false;
                    CpuCapture cpuCapture = it;
                    Intrinsics.checkNotNullExpressionValue((Object)cpuCapture, (String)"it");
                    Object object = cpuCapture.getSystemTraceData();
                    if (object == null || (object = object.getAndroidFrameLayers()) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    list$iv$iv = (Iterable)object;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List layers = (List)destination$iv$iv;
                Iterable $this$map$iv = layers;
                boolean $i$f$map = false;
                $this$flatMapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void name$iv;
                    void $this$asTableModel$iv;
                    Object object;
                    void layer;
                    Object object2;
                    list$iv$iv = (TraceProcessor.AndroidFrameEventsResult.Layer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object it = object2 = (Map)new LinkedHashMap<K, V>();
                    boolean bl2 = false;
                    List list2 = layer.getPhaseList();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"layer.phaseList");
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        TraceProcessor.AndroidFrameEventsResult.Phase phase = (TraceProcessor.AndroidFrameEventsResult.Phase)element$iv;
                        boolean bl3 = false;
                        TraceProcessor.AndroidFrameEventsResult.Phase phase2 = phase;
                        Intrinsics.checkNotNullExpressionValue((Object)phase2, (String)"phase");
                        List list3 = phase2.getFrameEventList();
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"phase.frameEventList");
                        Iterable $this$forEach$iv2 = list3;
                        boolean $i$f$forEach2 = false;
                        for (T element$iv2 : $this$forEach$iv2) {
                            String string;
                            Object object3;
                            void $this$getOrPut$iv;
                            TraceProcessor.AndroidFrameEventsResult.FrameEvent frameEvent = (TraceProcessor.AndroidFrameEventsResult.FrameEvent)element$iv2;
                            boolean bl4 = false;
                            Object object4 = it;
                            TraceProcessor.AndroidFrameEventsResult.FrameEvent frameEvent2 = frameEvent;
                            Intrinsics.checkNotNullExpressionValue((Object)frameEvent2, (String)"frameEvent");
                            Integer key$iv = frameEvent2.getFrameNumber();
                            boolean $i$f$getOrPut = false;
                            V value$iv = $this$getOrPut$iv.get(key$iv);
                            if (value$iv == null) {
                                boolean bl5 = false;
                                FrameEventRow answer$iv = new FrameEventRow(frameEvent.getFrameNumber(), (long)this.this$0.getCaptureRange().getMin(), (long)this.this$0.getCaptureRange().getMax(), 0L, 0L, 0L, 56, null);
                                $this$getOrPut$iv.put(key$iv, answer$iv);
                                object3 = answer$iv;
                            } else {
                                object3 = value$iv;
                            }
                            FrameEventRow frameEventRow = (FrameEventRow)object3;
                            long timestampUs = TimeUnit.NANOSECONDS.toMicros(frameEvent.getTimestampNanoseconds());
                            long durationUs = TimeUnit.NANOSECONDS.toMicros(frameEvent.getDurationNanoseconds());
                            if (phase.getPhaseName() == null) continue;
                            int n = -1;
                            switch (string.hashCode()) {
                                case 66049: {
                                    if (!string.equals("App")) break;
                                    n = 1;
                                    break;
                                }
                                case 828944778: {
                                    if (!string.equals("Composition")) break;
                                    n = 2;
                                    break;
                                }
                                case 70796: {
                                    if (!string.equals("GPU")) break;
                                    n = 3;
                                    break;
                                }
                                case -958549854: {
                                    if (!string.equals("Display")) break;
                                    n = 4;
                                    break;
                                }
                            }
                            switch (n) {
                                case 1: {
                                    frameEventRow.setStartTimeUs(timestampUs);
                                    frameEventRow.setAppDurationUs(durationUs);
                                    break;
                                }
                                case 3: {
                                    frameEventRow.setGpuDurationUs(durationUs);
                                    break;
                                }
                                case 2: {
                                    frameEventRow.setCompositionDurationUs(durationUs);
                                    break;
                                }
                                case 4: {
                                    frameEventRow.setEndTimeUs(timestampUs);
                                }
                            }
                        }
                    }
                    Map frameNumberToRow = object2;
                    object2 = CollectionsKt.toMutableList(frameNumberToRow.values());
                    Object it2 = it = layer.getLayerName();
                    boolean bl6 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    int n = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)it2), (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
                    String string = ((String)object).substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    it = string;
                    int pageSize$iv = 25;
                    boolean $i$f$asTableModel = false;
                    PaginatedTableModel paginatedTableModel = new PaginatedTableModel<FrameEventRow>((List)$this$asTableModel$iv, (String)name$iv, pageSize$iv, pageSize$iv){
                        final /* synthetic */ List $this_asTableModel;
                        final /* synthetic */ String $name;
                        final /* synthetic */ int $pageSize;
                        {
                            this.$this_asTableModel = $receiver;
                            this.$name = $captured_local_variable$4;
                            this.$pageSize = $captured_local_variable$5;
                            super($super_call_param$6);
                        }

                        @NotNull
                        public List<FrameEventRow> getRows() {
                            return this.$this_asTableModel;
                        }

                        public int getDataSize() {
                            return this.getRows().size();
                        }

                        @NotNull
                        protected Comparable<?> getDataValueAt(int dataIndex, int columnIndex) {
                            Enum receiver = ((Enum[])FrameEventTableColumn.values())[columnIndex];
                            boolean bl = false;
                            return (Comparable)((FrameEventTableColumn)receiver).getGetValueFrom().invoke((Object)this.getRows().get(dataIndex));
                        }

                        public int getColumnCount() {
                            return ((Enum[])FrameEventTableColumn.values()).length;
                        }

                        @NotNull
                        public Class<?> getColumnClass(int columnIndex) {
                            Enum receiver = ((Enum[])FrameEventTableColumn.values())[columnIndex];
                            boolean bl = false;
                            return ((FrameEventTableColumn)receiver).getType();
                        }

                        @NotNull
                        public String getColumnName(int column) {
                            Enum receiver = ((Enum[])FrameEventTableColumn.values())[column];
                            boolean bl = false;
                            return ((FrameEventTableColumn)receiver).getDisplayName();
                        }

                        @NotNull
                        public String toString() {
                            return this.$name;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void sortData(@NotNull List<? extends RowSorter.SortKey> sortKeys) {
                            Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
                            Collection collection = sortKeys;
                            if (!collection.isEmpty()) {
                                Collection<Object> collection2;
                                void $this$mapTo$iv$iv;
                                Iterable $this$map$iv = sortKeys;
                                List<FrameEventRow> list = this.getRows();
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo2 = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void key;
                                    RowSorter.SortKey sortKey = (RowSorter.SortKey)item$iv$iv;
                                    collection2 = destination$iv$iv;
                                    boolean bl = false;
                                    Enum receiver = ((Enum[])FrameEventTableColumn.values())[key.getColumn()];
                                    boolean bl2 = false;
                                    Function1<FrameEventRow, Comparable<?>> function1 = ((FrameEventTableColumn)receiver).getGetValueFrom();
                                    Comparator<T> cmp = new Comparator(function1){
                                        final /* synthetic */ Function1 $selector;
                                        {
                                            this.$selector = $selector;
                                        }

                                        public final int compare(T a, T b) {
                                            Function1 function1 = this.$selector;
                                            return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
                                        }
                                    };
                                    Comparator<T> comparator = key.getSortOrder() == SortOrder.ASCENDING ? cmp : cmp.reversed();
                                    collection2.add(comparator);
                                }
                                collection2 = (List)destination$iv$iv;
                                Iterable $this$reduce$iv = collection2;
                                boolean $i$f$reduce = false;
                                Iterator<T> iterator$iv = $this$reduce$iv.iterator();
                                if (!iterator$iv.hasNext()) {
                                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                                }
                                Object accumulator$iv = iterator$iv.next();
                                while (iterator$iv.hasNext()) {
                                    void p2;
                                    Comparator $i$f$mapTo2 = (Comparator)iterator$iv.next();
                                    Comparator p1 = (Comparator)accumulator$iv;
                                    boolean bl = false;
                                    accumulator$iv = ComparisonsKt.then((Comparator)p1, (Comparator)p2);
                                }
                                collection2 = accumulator$iv;
                                CollectionsKt.sortWith(list, (Comparator)((Comparator)((Object)collection2)));
                            }
                        }
                    };
                    collection.add(paginatedTableModel);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = cpuAnalysisFramesTabModel;
                super(0);
            }
        }));
    }
}

