/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.PercentAxisFormatter;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel$WhenMappings;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModelKt;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002GHB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\u0002\u0010\rJ\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\f0#H\u0002J\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u00020\fH\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010=\u001a\u00020<H\u0002J\b\u0010>\u001a\u00020<H\u0002J\b\u0010?\u001a\u00020<H\u0002JQ\u0010@\u001a\u00020<*\u00020\u00062\u0006\u0010A\u001a\u00020\u00062\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020C0\n2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020E0\n2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020E0\nH\u0082\bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0013\u0010*\u001a\u0004\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b.\u00100R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisChartModel;", "T", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisTabModel;", "tabType", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisTabModel$Type;", "selectionRange", "Lcom/android/tools/adtui/model/Range;", "capture", "Lcom/android/tools/profilers/cpu/CpuCapture;", "extractNodes", "Lkotlin/Function1;", "", "Lcom/android/tools/profilers/cpu/CaptureNode;", "(Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisTabModel$Type;Lcom/android/tools/adtui/model/Range;Lcom/android/tools/profilers/cpu/CpuCapture;Lkotlin/jvm/functions/Function1;)V", "aspectModel", "Lcom/android/tools/adtui/model/AspectModel;", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisChartModel$Aspect;", "getAspectModel", "()Lcom/android/tools/adtui/model/AspectModel;", "axisComponentModel", "Lcom/android/tools/adtui/model/axis/ClampedAxisComponentModel;", "Lorg/jetbrains/annotations/NotNull;", "getAxisComponentModel", "()Lcom/android/tools/adtui/model/axis/ClampedAxisComponentModel;", "captureConvertedRange", "getCaptureConvertedRange", "()Lcom/android/tools/adtui/model/Range;", "clampedSelectionRange", "clockType", "Lcom/android/tools/perflib/vmtrace/ClockType;", "getClockType", "()Lcom/android/tools/perflib/vmtrace/ClockType;", "setClockType", "(Lcom/android/tools/perflib/vmtrace/ClockType;)V", "clockTypes", "", "getClockTypes", "()Ljava/util/List;", "detailsType", "Lcom/android/tools/profilers/cpu/capturedetails/CaptureDetails$Type;", "getDetailsType", "()Lcom/android/tools/profilers/cpu/capturedetails/CaptureDetails$Type;", "dualClockDisabledMessage", "", "getDualClockDisabledMessage", "()Ljava/lang/String;", "isCaptureDualClock", "", "()Z", "observer", "Lcom/android/tools/adtui/model/AspectObserver;", "applyFilterAndCreateDetails", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisChartModel$CaptureDetailsWithFilterResult;", "filter", "Lcom/android/tools/adtui/model/filter/Filter;", "collectCaptureNodes", "createDetails", "Lcom/android/tools/profilers/cpu/capturedetails/CaptureDetails;", "findScalingNode", "onClockTypeUpdated", "", "selectionRangeSync", "updateCaptureConvertedRange", "updateSelectionRange", "update", "that", "ratio", "", "myStart", "", "theirStart", "Aspect", "CaptureDetailsWithFilterResult", "intellij.android.profilers"})
public final class CpuAnalysisChartModel<T>
extends CpuAnalysisTabModel<T> {
    private final AspectObserver observer;
    @NotNull
    private final AspectModel<Aspect> aspectModel;
    @NotNull
    private final CaptureDetails.Type detailsType;
    @NotNull
    private final Range captureConvertedRange;
    private final Range clampedSelectionRange;
    @NotNull
    private final ClampedAxisComponentModel axisComponentModel;
    @NotNull
    private ClockType clockType;
    private final Range selectionRange;
    private final CpuCapture capture;
    private final Function1<T, Collection<CaptureNode>> extractNodes;

    @NotNull
    public final AspectModel<Aspect> getAspectModel() {
        return this.aspectModel;
    }

    @NotNull
    public final CaptureDetails.Type getDetailsType() {
        return this.detailsType;
    }

    @VisibleForTesting
    @NotNull
    public final Range getCaptureConvertedRange() {
        return this.captureConvertedRange;
    }

    @NotNull
    public final ClampedAxisComponentModel getAxisComponentModel() {
        return this.axisComponentModel;
    }

    public final boolean isCaptureDualClock() {
        return this.capture.isDualClock();
    }

    @Nullable
    public final String getDualClockDisabledMessage() {
        return this.capture.getDualClockDisabledMessage();
    }

    @NotNull
    public final List<ClockType> getClockTypes() {
        return CollectionsKt.listOf((Object[])new ClockType[]{ClockType.GLOBAL, ClockType.THREAD});
    }

    @NotNull
    public final ClockType getClockType() {
        return this.clockType;
    }

    public final void setClockType(@NotNull ClockType clockType) {
        Intrinsics.checkNotNullParameter((Object)clockType, (String)"clockType");
        if (this.clockType != clockType && (this.isCaptureDualClock() || clockType != ClockType.THREAD)) {
            this.clockType = clockType;
            this.onClockTypeUpdated(clockType);
        }
    }

    private final void selectionRangeSync() {
        this.clampedSelectionRange.set(this.selectionRange);
    }

    @NotNull
    public final CaptureDetails createDetails() {
        Filter filter = Filter.EMPTY_FILTER;
        Intrinsics.checkNotNullExpressionValue((Object)filter, (String)"Filter.EMPTY_FILTER");
        return this.applyFilterAndCreateDetails(filter).getCaptureDetails();
    }

    private final void onClockTypeUpdated(ClockType clockType) {
        this.capture.updateClockType(clockType);
        this.updateCaptureConvertedRange();
        this.aspectModel.changed((Enum)Aspect.CLOCK_TYPE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CaptureDetailsWithFilterResult applyFilterAndCreateDetails(@NotNull Filter filter) {
        void $this$fold$iv;
        List<CaptureNode> list;
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        List<CaptureNode> nodes = list = this.collectCaptureNodes();
        boolean bl = false;
        Iterable iterable = nodes;
        FilterResult initial$iv = FilterResult.EMPTY_RESULT;
        boolean $i$f$fold = false;
        FilterResult accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void node;
            CaptureNode captureNode = (CaptureNode)element$iv;
            FilterResult res = accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = res.combine(node.applyFilter(filter));
        }
        FilterResult combinedResult = accumulator$iv;
        CaptureDetails captureDetails = this.detailsType.build(this.clockType, this.captureConvertedRange, nodes, this.capture);
        Intrinsics.checkNotNullExpressionValue((Object)captureDetails, (String)"detailsType.build(clockT\u2026tedRange, nodes, capture)");
        FilterResult filterResult = combinedResult;
        Intrinsics.checkNotNullExpressionValue((Object)filterResult, (String)"combinedResult");
        return new CaptureDetailsWithFilterResult(captureDetails, filterResult);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateCaptureConvertedRange() {
        Range range;
        void this_$iv;
        void $this$update$iv;
        Range range2 = this.captureConvertedRange;
        CpuAnalysisChartModel cpuAnalysisChartModel = this;
        Range that$iv = this.clampedSelectionRange;
        boolean $i$f$update = false;
        void v0 = $this$update$iv;
        if (this_$iv.getClockType() == ClockType.GLOBAL || this_$iv.getDataSeries().isEmpty()) {
            range = that$iv;
        } else {
            void node$iv;
            CaptureNode captureNode;
            CaptureNode captureNode2 = captureNode = ((CpuAnalysisChartModel)this_$iv).findScalingNode();
            void var7_7 = v0;
            boolean bl = false;
            void it = node$iv;
            boolean bl2 = false;
            double r$iv = it.threadGlobalRatio();
            it = node$iv;
            boolean bl3 = false;
            double d = it.getStartThread();
            it = node$iv;
            double d2 = that$iv.getMin();
            double d3 = r$iv;
            double d4 = d;
            boolean bl4 = false;
            long l = it.getStartGlobal();
            double convertedMin$iv = d4 + d3 * (d2 - (double)l);
            double convertedMax$iv = convertedMin$iv + r$iv * that$iv.getMin();
            Range range3 = new Range(convertedMin$iv, convertedMax$iv);
            v0 = var7_7;
            range = range3;
        }
        CpuAnalysisChartModelKt.access$setUnlessSameAs((Range)v0, range);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelectionRange() {
        Range range;
        void this_$iv;
        void $this$update$iv;
        Range range2 = this.clampedSelectionRange;
        CpuAnalysisChartModel cpuAnalysisChartModel = this;
        Range that$iv = this.captureConvertedRange;
        boolean $i$f$update = false;
        void v0 = $this$update$iv;
        if (this_$iv.getClockType() == ClockType.GLOBAL || this_$iv.getDataSeries().isEmpty()) {
            range = that$iv;
        } else {
            void node$iv;
            CaptureNode captureNode;
            CaptureNode captureNode2 = captureNode = ((CpuAnalysisChartModel)this_$iv).findScalingNode();
            void var7_7 = v0;
            boolean bl = false;
            void it = node$iv;
            boolean bl2 = false;
            double r$iv = 1.0 / it.threadGlobalRatio();
            it = node$iv;
            boolean bl3 = false;
            double d = it.getStartGlobal();
            it = node$iv;
            double d2 = that$iv.getMin();
            double d3 = r$iv;
            double d4 = d;
            boolean bl4 = false;
            long l = it.getStartThread();
            double convertedMin$iv = d4 + d3 * (d2 - (double)l);
            double convertedMax$iv = convertedMin$iv + r$iv * that$iv.getMin();
            Range range3 = new Range(convertedMin$iv, convertedMax$iv);
            v0 = var7_7;
            range = range3;
        }
        CpuAnalysisChartModelKt.access$setUnlessSameAs((Range)v0, range);
    }

    /*
     * WARNING - void declaration
     */
    private final void update(Range $this$update, Range that, Function1<? super CaptureNode, Double> ratio, Function1<? super CaptureNode, Long> myStart, Function1<? super CaptureNode, Long> theirStart) {
        Range range;
        int $i$f$update = 0;
        Range range2 = $this$update;
        if (this.getClockType() == ClockType.GLOBAL || this.getDataSeries().isEmpty()) {
            range = that;
        } else {
            void node;
            CaptureNode captureNode;
            CaptureNode captureNode2 = captureNode = this.findScalingNode();
            Range range3 = range2;
            boolean bl = false;
            double r = ((Number)ratio.invoke((Object)node)).doubleValue();
            double convertedMin = ((Number)myStart.invoke((Object)node)).doubleValue() + r * (that.getMin() - ((Number)theirStart.invoke((Object)node)).doubleValue());
            double convertedMax = convertedMin + r * that.getMin();
            Range range4 = new Range(convertedMin, convertedMax);
            range2 = range3;
            range = range4;
        }
        CpuAnalysisChartModelKt.access$setUnlessSameAs(range2, range);
    }

    private final CaptureNode findScalingNode() {
        Object v0;
        Iterable $this$maxByOrNull$iv = (Iterable)this.extractNodes.invoke(this.getDataSeries().get(0));
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                CaptureNode p1 = (CaptureNode)maxElem$iv;
                boolean bl = false;
                double maxValue$iv = p1.threadGlobalRatio();
                do {
                    Object e$iv = iterator$iv.next();
                    CaptureNode p12 = (CaptureNode)e$iv;
                    $i$a$-unknown-CpuAnalysisChartModel$findScalingNode$1 = false;
                    double v$iv = p12.threadGlobalRatio();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CaptureNode> collectCaptureNodes() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        List list = this.getDataSeries();
        Intrinsics.checkNotNullExpressionValue(list, (String)"dataSeries");
        Iterable iterable = list;
        Function1<T, Collection<CaptureNode>> transform$iv = this.extractNodes;
        boolean $i$f$flatMap = false;
        void var4_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable list$iv$iv = (Iterable)transform$iv.invoke(element$iv$iv);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public CpuAnalysisChartModel(@NotNull CpuAnalysisTabModel.Type tabType, @NotNull Range selectionRange, @NotNull CpuCapture capture, @NotNull Function1<? super T, ? extends Collection<? extends CaptureNode>> extractNodes) {
        CaptureDetails.Type type;
        Intrinsics.checkNotNullParameter((Object)((Object)tabType), (String)"tabType");
        Intrinsics.checkNotNullParameter((Object)selectionRange, (String)"selectionRange");
        Intrinsics.checkNotNullParameter((Object)capture, (String)"capture");
        Intrinsics.checkNotNullParameter(extractNodes, (String)"extractNodes");
        super(tabType);
        this.selectionRange = selectionRange;
        this.capture = capture;
        this.extractNodes = extractNodes;
        this.observer = new AspectObserver();
        this.aspectModel = new AspectModel();
        switch (CpuAnalysisChartModel$WhenMappings.$EnumSwitchMapping$0[tabType.ordinal()]) {
            case 1: {
                type = CaptureDetails.Type.FLAME_CHART;
                break;
            }
            case 2: {
                type = CaptureDetails.Type.TOP_DOWN;
                break;
            }
            case 3: {
                type = CaptureDetails.Type.BOTTOM_UP;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException();
            }
        }
        this.detailsType = type;
        this.captureConvertedRange = new Range();
        this.clampedSelectionRange = new Range(this.selectionRange);
        ClampedAxisComponentModel clampedAxisComponentModel = new ClampedAxisComponentModel.Builder(this.clampedSelectionRange, (BaseAxisFormatter)new PercentAxisFormatter(5, 10)).build();
        Intrinsics.checkNotNullExpressionValue((Object)clampedAxisComponentModel, (String)"ClampedAxisComponentMode\u2026Formatter(5, 10)).build()");
        this.axisComponentModel = clampedAxisComponentModel;
        this.clockType = ClockType.GLOBAL;
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((CpuAnalysisChartModel)this.receiver).selectionRangeSync();
            }
        };
        this.selectionRange.addDependency(this.observer).onChange((Enum)Range.Aspect.RANGE, new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        });
        function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((CpuAnalysisChartModel)this.receiver).updateCaptureConvertedRange();
            }
        };
        this.clampedSelectionRange.addDependency(this.observer).onChange((Enum)Range.Aspect.RANGE, new /* invalid duplicate definition of identical inner class */);
        function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((CpuAnalysisChartModel)this.receiver).updateSelectionRange();
            }
        };
        this.captureConvertedRange.addDependency(this.observer).onChange((Enum)Range.Aspect.RANGE, new /* invalid duplicate definition of identical inner class */);
        this.onClockTypeUpdated(ClockType.GLOBAL);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisChartModel$CaptureDetailsWithFilterResult;", "", "captureDetails", "Lcom/android/tools/profilers/cpu/capturedetails/CaptureDetails;", "filterResult", "Lcom/android/tools/adtui/model/filter/FilterResult;", "(Lcom/android/tools/profilers/cpu/capturedetails/CaptureDetails;Lcom/android/tools/adtui/model/filter/FilterResult;)V", "getCaptureDetails", "()Lcom/android/tools/profilers/cpu/capturedetails/CaptureDetails;", "getFilterResult", "()Lcom/android/tools/adtui/model/filter/FilterResult;", "intellij.android.profilers"})
    public static final class CaptureDetailsWithFilterResult {
        @NotNull
        private final CaptureDetails captureDetails;
        @NotNull
        private final FilterResult filterResult;

        @NotNull
        public final CaptureDetails getCaptureDetails() {
            return this.captureDetails;
        }

        @NotNull
        public final FilterResult getFilterResult() {
            return this.filterResult;
        }

        public CaptureDetailsWithFilterResult(@NotNull CaptureDetails captureDetails, @NotNull FilterResult filterResult) {
            Intrinsics.checkNotNullParameter((Object)captureDetails, (String)"captureDetails");
            Intrinsics.checkNotNullParameter((Object)filterResult, (String)"filterResult");
            this.captureDetails = captureDetails;
            this.filterResult = filterResult;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisChartModel$Aspect;", "", "(Ljava/lang/String;I)V", "CLOCK_TYPE", "intellij.android.profilers"})
    public static final class Aspect
    extends Enum<Aspect> {
        public static final /* enum */ Aspect CLOCK_TYPE;
        private static final /* synthetic */ Aspect[] $VALUES;

        static {
            Aspect[] aspectArray = new Aspect[1];
            Aspect[] aspectArray2 = aspectArray;
            aspectArray[0] = CLOCK_TYPE = new Aspect();
            $VALUES = aspectArray;
        }

        public static Aspect[] values() {
            return (Aspect[])$VALUES.clone();
        }

        public static Aspect valueOf(String string) {
            return Enum.valueOf(Aspect.class, string);
        }
    }
}

