/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.FilterComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterHandler;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTab;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetailsView;
import com.android.tools.profilers.cpu.capturedetails.ChartDetailsView;
import com.android.tools.profilers.cpu.capturedetails.TreeDetailsView;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.SimpleListCellRenderer;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CpuAnalysisChart
extends CpuAnalysisTab<CpuAnalysisChartModel<?>> {
    private final JPanel myCaptureDetailsPanel;
    private CaptureDetailsView myActiveDetailsView;
    @NotNull
    private final FilterComponent myFilterComponent;
    @NotNull
    private final ViewBinder<StudioProfilersView, CaptureDetails, CaptureDetailsView> myBinder;
    @NotNull
    private final AspectObserver myObserver;

    public CpuAnalysisChart(@NotNull StudioProfilersView view, @NotNull CpuAnalysisTabModel<?> model) {
        if (view == null) {
            CpuAnalysisChart.$$$reportNull$$$0(0);
        }
        if (model == null) {
            CpuAnalysisChart.$$$reportNull$$$0(1);
        }
        super(view, (CpuAnalysisChartModel)model);
        this.myCaptureDetailsPanel = new JPanel(new BorderLayout());
        this.myFilterComponent = this.buildFilterComponent();
        this.myObserver = new AspectObserver();
        this.myBinder = new ViewBinder();
        this.myBinder.bind(CaptureDetails.TopDown.class, TreeDetailsView.TopDownDetailsView::new);
        this.myBinder.bind(CaptureDetails.BottomUp.class, TreeDetailsView.BottomUpDetailsView::new);
        this.myBinder.bind(CaptureDetails.CallChart.class, ChartDetailsView.CallChartDetailsView::new);
        this.myBinder.bind(CaptureDetails.FlameChart.class, ChartDetailsView.FlameChartDetailsView::new);
        ((CpuAnalysisChartModel)this.getModel()).getAspectModel().addDependency(this.myObserver).onChange((Enum)CpuAnalysisChartModel.Aspect.CLOCK_TYPE, () -> this.updateDetailsView(((CpuAnalysisChartModel)this.getModel()).createDetails()));
        this.buildComponents();
    }

    private void buildComponents() {
        boolean hasAxisComponent;
        this.setLayout((LayoutManager)new TabularLayout("*", "Fit,*"));
        JPanel toolbar = new JPanel(new BorderLayout());
        toolbar.add((Component)this.myFilterComponent, "West");
        toolbar.add((Component)this.buildClockTypeSelector(), "East");
        this.updateDetailsView(((CpuAnalysisChartModel)this.getModel()).createDetails());
        this.add((Component)toolbar, new TabularLayout.Constraint(0, 0));
        this.add((Component)this.myCaptureDetailsPanel, new TabularLayout.Constraint(1, 0));
        boolean bl = hasAxisComponent = ((CpuAnalysisChartModel)this.getModel()).getDetailsType() == CaptureDetails.Type.FLAME_CHART;
        if (hasAxisComponent) {
            AxisComponent percentAxis = new AxisComponent((AxisComponentModel)((CpuAnalysisChartModel)this.getModel()).getAxisComponentModel(), AxisComponent.AxisOrientation.BOTTOM);
            percentAxis.setShowAxisLine(true);
            percentAxis.setMinimumSize(new Dimension(0, ProfilerLayout.TIME_AXIS_HEIGHT));
            this.add((Component)percentAxis, new TabularLayout.Constraint(3, 0));
        }
    }

    private FilterComponent buildFilterComponent() {
        FilterComponent filterComponent = new FilterComponent(Filter.EMPTY_FILTER, ProfilerLayout.FILTER_TEXT_FIELD_WIDTH, 5, 250).setMatchCountVisibility(false);
        filterComponent.getModel().setFilterHandler(new FilterHandler(){

            @NotNull
            protected FilterResult applyFilter(@NotNull Filter filter) {
                if (filter == null) {
                    1.$$$reportNull$$$0(0);
                }
                CpuAnalysisChartModel.CaptureDetailsWithFilterResult results = ((CpuAnalysisChartModel)CpuAnalysisChart.this.getModel()).applyFilterAndCreateDetails(filter);
                CpuAnalysisChart.this.updateDetailsView(results.getCaptureDetails());
                FilterResult filterResult = results.getFilterResult();
                if (filterResult == null) {
                    1.$$$reportNull$$$0(1);
                }
                return filterResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filter";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/profilers/cpu/analysis/CpuAnalysisChart$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/profilers/cpu/analysis/CpuAnalysisChart$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "applyFilter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFilter";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        filterComponent.setVisible(true);
        return filterComponent;
    }

    private JComponent buildClockTypeSelector() {
        ComboBox clockTypeSelector = new ComboBox();
        JComboBoxView<ClockType, CpuAnalysisChartModel.Aspect> clockTypes = new JComboBoxView<ClockType, CpuAnalysisChartModel.Aspect>((JComboBox<ClockType>)clockTypeSelector, ((CpuAnalysisChartModel)this.getModel()).getAspectModel(), CpuAnalysisChartModel.Aspect.CLOCK_TYPE, ((CpuAnalysisChartModel)this.getModel())::getClockTypes, ((CpuAnalysisChartModel)this.getModel())::getClockType, ((CpuAnalysisChartModel)this.getModel())::setClockType);
        clockTypes.bind();
        clockTypeSelector.setRenderer(SimpleListCellRenderer.create((String)"", value -> value == ClockType.GLOBAL ? "Wall Clock Time" : (value == ClockType.THREAD ? "Thread Time" : "")));
        clockTypeSelector.setEnabled(((CpuAnalysisChartModel)this.getModel()).isCaptureDualClock());
        if (!((CpuAnalysisChartModel)this.getModel()).isCaptureDualClock()) {
            clockTypeSelector.setToolTipText(((CpuAnalysisChartModel)this.getModel()).getDualClockDisabledMessage());
        }
        JLabel helpIcon = new JLabel(StudioIcons.Common.HELP);
        HelpTooltip helpTooltip = new HelpTooltip().setDescription("Select how timing information is measured (only supported in Sample/Trace Java Methods):<p><dl><dt><b>Wall clock time</b></dt><dd>Represents actual elapsed time.</dd><dt><b>Thread time</b></dt><dd>Represents actual elapsed time minus any portion of that time when the thread is not consuming CPU resources.</dd></dl></p>");
        helpTooltip.installOn((JComponent)helpIcon);
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("Fit,Fit,6px", "Fit"));
        panel.add((Component)clockTypeSelector, new TabularLayout.Constraint(0, 0));
        panel.add((Component)helpIcon, new TabularLayout.Constraint(0, 1));
        return panel;
    }

    private void updateDetailsView(@NotNull CaptureDetails captureDetails) {
        if (captureDetails == null) {
            CpuAnalysisChart.$$$reportNull$$$0(2);
        }
        this.myCaptureDetailsPanel.removeAll();
        this.myActiveDetailsView = (CaptureDetailsView)this.myBinder.build((Object)this.getProfilersView(), (Object)captureDetails);
        this.myCaptureDetailsPanel.add((Component)this.myActiveDetailsView.getComponent(), "Center");
    }

    @VisibleForTesting
    @NotNull
    FilterComponent getFilterComponent() {
        FilterComponent filterComponent = this.myFilterComponent;
        if (filterComponent == null) {
            CpuAnalysisChart.$$$reportNull$$$0(3);
        }
        return filterComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureDetails";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/analysis/CpuAnalysisChart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/analysis/CpuAnalysisChart";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateDetailsView";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

