/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisEventsTabModel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisStats;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019H\u0016J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\t\u0010\u001e\u001a\u00020\u001dH\u00d6\u0001J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0003H\u0002J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisModel;", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalyzable;", "node", "Lcom/android/tools/profilers/cpu/CaptureNode;", "capture", "Lcom/android/tools/profilers/cpu/CpuCapture;", "(Lcom/android/tools/profilers/cpu/CaptureNode;Lcom/android/tools/profilers/cpu/CpuCapture;)V", "allOccurrenceStats", "Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisStats;", "getAllOccurrenceStats", "()Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisStats;", "getNode", "()Lcom/android/tools/profilers/cpu/CaptureNode;", "nodeRange", "Lcom/android/tools/adtui/model/Range;", "getNodeRange", "()Lcom/android/tools/adtui/model/Range;", "component1", "component2", "copy", "equals", "", "other", "", "getAnalysisModel", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisModel;", "getLongestRunningOccurrences", "", "k", "", "hashCode", "matchesFullName", "otherNode", "toString", "", "intellij.android.profilers"})
public final class CaptureNodeAnalysisModel
implements CpuAnalyzable<CaptureNodeAnalysisModel> {
    @NotNull
    private final CaptureNode node;
    private final CpuCapture capture;

    @NotNull
    public final Range getNodeRange() {
        return new Range((double)this.node.getStart(), (double)this.node.getEnd());
    }

    @NotNull
    public final CaptureNodeAnalysisStats getAllOccurrenceStats() {
        Function1 function1 = (Function1)new Function1<CaptureNode, Boolean>(this){

            public final boolean invoke(@NotNull CaptureNode p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return CaptureNodeAnalysisModel.access$matchesFullName((CaptureNodeAnalysisModel)this.receiver, p1);
            }
        };
        Stream<CaptureNode> stream = this.node.findRootNode().getDescendantsStream().filter(new Predicate(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ boolean test(Object p0) {
                Object object = this.function.invoke(p0);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                return (Boolean)object;
            }
        });
        Intrinsics.checkNotNullExpressionValue(stream, (String)"node.findRootNode().desc\u2026filter(::matchesFullName)");
        List allOccurrences2 = StreamsKt.toList(stream);
        return CaptureNodeAnalysisStats.Companion.fromNodes(allOccurrences2);
    }

    @NotNull
    public final List<CaptureNode> getLongestRunningOccurrences(int k) {
        Function1 function1 = (Function1)new Function1<CaptureNode, Boolean>(this){

            public final boolean invoke(@NotNull CaptureNode p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return CaptureNodeAnalysisModel.access$matchesFullName((CaptureNodeAnalysisModel)this.receiver, p1);
            }
        };
        return this.node.findRootNode().getTopKNodes(k, new /* invalid duplicate definition of identical inner class */, new Comparator(){

            public final int compare(T a, T b) {
                CaptureNode p1 = (CaptureNode)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(p1.getDuration());
                p1 = (CaptureNode)b;
                Comparable comparable2 = comparable;
                bl = false;
                Long l = p1.getDuration();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        });
    }

    private final boolean matchesFullName(CaptureNode otherNode) {
        return Intrinsics.areEqual((Object)this.node.getData().getFullName(), (Object)otherNode.getData().getFullName());
    }

    @Override
    @NotNull
    public CpuAnalysisModel<CaptureNodeAnalysisModel> getAnalysisModel() {
        CpuAnalysisModel<CaptureNodeAnalysisModel> cpuAnalysisModel;
        Range nodeRange = this.getNodeRange();
        Set nodes = SetsKt.setOf((Object)this.node);
        CpuAnalysisModel<CaptureNodeAnalysisModel> model = cpuAnalysisModel = new CpuAnalysisModel<CaptureNodeAnalysisModel>(this.node.getData().getNameWithSuffix(), "%d events");
        boolean bl = false;
        var $fun$add$1 = new Function1<CpuAnalysisTabModel<CaptureNodeAnalysisModel>, Unit>(model, this, nodeRange, nodes){
            final /* synthetic */ CpuAnalysisModel $model;
            final /* synthetic */ CaptureNodeAnalysisModel this$0;
            final /* synthetic */ Range $nodeRange$inlined;
            final /* synthetic */ Set $nodes$inlined;
            {
                this.$model = cpuAnalysisModel;
                this.this$0 = captureNodeAnalysisModel;
                this.$nodeRange$inlined = range;
                this.$nodes$inlined = set;
                super(1);
            }

            public final void invoke(@NotNull CpuAnalysisTabModel<CaptureNodeAnalysisModel> tab) {
                Intrinsics.checkNotNullParameter(tab, (String)"tab");
                tab.getDataSeries().add(this.this$0);
                this.$model.addTabModel(tab);
            }
        };
        Range range = this.capture.getRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"capture.range");
        Cpu.CpuTraceType cpuTraceType = this.capture.getType();
        Intrinsics.checkNotNullExpressionValue((Object)cpuTraceType, (String)"capture.type");
        $fun$add$1.invoke(new CaptureNodeAnalysisSummaryTabModel(range, cpuTraceType));
        $fun$add$1.invoke(new CpuAnalysisChartModel(CpuAnalysisTabModel.Type.FLAME_CHART, nodeRange, this.capture, (Function1)new Function1<CaptureNodeAnalysisModel, Collection<? extends CaptureNode>>(this, nodeRange, nodes){
            final /* synthetic */ CaptureNodeAnalysisModel this$0;
            final /* synthetic */ Range $nodeRange$inlined;
            final /* synthetic */ Set $nodes$inlined;
            {
                this.this$0 = captureNodeAnalysisModel;
                this.$nodeRange$inlined = range;
                this.$nodes$inlined = set;
                super(1);
            }

            @NotNull
            public final Collection<CaptureNode> invoke(@NotNull CaptureNodeAnalysisModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$nodes$inlined;
            }
        }));
        $fun$add$1.invoke(new CpuAnalysisChartModel(CpuAnalysisTabModel.Type.TOP_DOWN, nodeRange, this.capture, (Function1)new Function1<CaptureNodeAnalysisModel, Collection<? extends CaptureNode>>(this, nodeRange, nodes){
            final /* synthetic */ CaptureNodeAnalysisModel this$0;
            final /* synthetic */ Range $nodeRange$inlined;
            final /* synthetic */ Set $nodes$inlined;
            {
                this.this$0 = captureNodeAnalysisModel;
                this.$nodeRange$inlined = range;
                this.$nodes$inlined = set;
                super(1);
            }

            @NotNull
            public final Collection<CaptureNode> invoke(@NotNull CaptureNodeAnalysisModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$nodes$inlined;
            }
        }));
        $fun$add$1.invoke(new CpuAnalysisChartModel(CpuAnalysisTabModel.Type.BOTTOM_UP, nodeRange, this.capture, (Function1)new Function1<CaptureNodeAnalysisModel, Collection<? extends CaptureNode>>(this, nodeRange, nodes){
            final /* synthetic */ CaptureNodeAnalysisModel this$0;
            final /* synthetic */ Range $nodeRange$inlined;
            final /* synthetic */ Set $nodes$inlined;
            {
                this.this$0 = captureNodeAnalysisModel;
                this.$nodeRange$inlined = range;
                this.$nodes$inlined = set;
                super(1);
            }

            @NotNull
            public final Collection<CaptureNode> invoke(@NotNull CaptureNodeAnalysisModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$nodes$inlined;
            }
        }));
        Range range2 = this.capture.getRange();
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"capture.range");
        $fun$add$1.invoke(new CaptureNodeAnalysisEventsTabModel(range2));
        return cpuAnalysisModel;
    }

    @NotNull
    public final CaptureNode getNode() {
        return this.node;
    }

    public CaptureNodeAnalysisModel(@NotNull CaptureNode node, @NotNull CpuCapture capture) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)capture, (String)"capture");
        this.node = node;
        this.capture = capture;
    }

    public static final /* synthetic */ boolean access$matchesFullName(CaptureNodeAnalysisModel $this, CaptureNode otherNode) {
        return $this.matchesFullName(otherNode);
    }

    @NotNull
    public final CaptureNode component1() {
        return this.node;
    }

    private final CpuCapture component2() {
        return this.capture;
    }

    @NotNull
    public final CaptureNodeAnalysisModel copy(@NotNull CaptureNode node, @NotNull CpuCapture capture) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)capture, (String)"capture");
        return new CaptureNodeAnalysisModel(node, capture);
    }

    public static /* synthetic */ CaptureNodeAnalysisModel copy$default(CaptureNodeAnalysisModel captureNodeAnalysisModel, CaptureNode captureNode, CpuCapture cpuCapture, int n, Object object) {
        if ((n & 1) != 0) {
            captureNode = captureNodeAnalysisModel.node;
        }
        if ((n & 2) != 0) {
            cpuCapture = captureNodeAnalysisModel.capture;
        }
        return captureNodeAnalysisModel.copy(captureNode, cpuCapture);
    }

    @NotNull
    public String toString() {
        return "CaptureNodeAnalysisModel(node=" + this.node + ", capture=" + this.capture + ")";
    }

    public int hashCode() {
        CaptureNode captureNode = this.node;
        CpuCapture cpuCapture = this.capture;
        return (captureNode != null ? captureNode.hashCode() : 0) * 31 + (cpuCapture != null ? cpuCapture.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CaptureNodeAnalysisModel)) break block3;
                CaptureNodeAnalysisModel captureNodeAnalysisModel = (CaptureNodeAnalysisModel)object;
                if (!Intrinsics.areEqual((Object)this.node, (Object)captureNodeAnalysisModel.node) || !Intrinsics.areEqual((Object)this.capture, (Object)captureNodeAnalysisModel.capture)) break block3;
            }
            return true;
        }
        return false;
    }
}

